import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface ApigeeEnvgroupConfig extends cdktf.TerraformMetaArguments {
    /**
     * Hostnames of the environment group.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apigee_envgroup.html#hostnames ApigeeEnvgroup#hostnames}
     *
     * @stability stable
     */
    readonly hostnames?: string[];
    /**
     * The resource ID of the environment group.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apigee_envgroup.html#name ApigeeEnvgroup#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * The Apigee Organization associated with the Apigee environment group, in the format 'organizations/{{org_name}}'.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apigee_envgroup.html#org_id ApigeeEnvgroup#org_id}
     *
     * @stability stable
     */
    readonly orgId: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apigee_envgroup.html#timeouts ApigeeEnvgroup#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: ApigeeEnvgroupTimeouts;
}
/**
 * @stability stable
 */
export interface ApigeeEnvgroupTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apigee_envgroup.html#create ApigeeEnvgroup#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apigee_envgroup.html#delete ApigeeEnvgroup#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apigee_envgroup.html#update ApigeeEnvgroup#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/apigee_envgroup.html google_apigee_envgroup}.
 *
 * @stability stable
 */
export declare class ApigeeEnvgroup extends cdktf.TerraformResource {
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/apigee_envgroup.html google_apigee_envgroup} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: ApigeeEnvgroupConfig);
    private _hostnames?;
    /**
     * @stability stable
     */
    get hostnames(): string[];
    /**
     * @stability stable
     */
    set hostnames(value: string[]);
    /**
     * @stability stable
     */
    resetHostnames(): void;
    /**
     * @stability stable
     */
    get hostnamesInput(): string[] | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _name;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string;
    private _orgId;
    /**
     * @stability stable
     */
    get orgId(): string;
    /**
     * @stability stable
     */
    set orgId(value: string);
    /**
     * @stability stable
     */
    get orgIdInput(): string;
    private _timeouts?;
    /**
     * @stability stable
     */
    get timeouts(): ApigeeEnvgroupTimeouts;
    /**
     * @stability stable
     */
    set timeouts(value: ApigeeEnvgroupTimeouts);
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): ApigeeEnvgroupTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
