import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface AppEngineFlexibleAppVersionConfig extends cdktf.TerraformMetaArguments {
    /**
     * Metadata settings that are supplied to this version to enable beta runtime features.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version.html#beta_settings AppEngineFlexibleAppVersion#beta_settings}
     *
     * @stability stable
     */
    readonly betaSettings?: {
        [key: string]: string;
    };
    /**
     * Duration that static files should be cached by web proxies and browsers.
     *
     * Only applicable if the corresponding StaticFilesHandler does not specify its own expiration time.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version.html#default_expiration AppEngineFlexibleAppVersion#default_expiration}
     *
     * @stability stable
     */
    readonly defaultExpiration?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version.html#delete_service_on_destroy AppEngineFlexibleAppVersion#delete_service_on_destroy}.
     *
     * @stability stable
     */
    readonly deleteServiceOnDestroy?: boolean;
    /**
     * Environment variables available to the application.
     *
     * As these are not returned in the API request, Terraform will not detect any changes made outside of the Terraform config.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version.html#env_variables AppEngineFlexibleAppVersion#env_variables}
     *
     * @stability stable
     */
    readonly envVariables?: {
        [key: string]: string;
    };
    /**
     * A list of the types of messages that this application is able to receive.
     *
     * Possible values: ["INBOUND_SERVICE_MAIL", "INBOUND_SERVICE_MAIL_BOUNCE", "INBOUND_SERVICE_XMPP_ERROR", "INBOUND_SERVICE_XMPP_MESSAGE", "INBOUND_SERVICE_XMPP_SUBSCRIBE", "INBOUND_SERVICE_XMPP_PRESENCE", "INBOUND_SERVICE_CHANNEL_PRESENCE", "INBOUND_SERVICE_WARMUP"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version.html#inbound_services AppEngineFlexibleAppVersion#inbound_services}
     *
     * @stability stable
     */
    readonly inboundServices?: string[];
    /**
     * Instance class that is used to run this version.
     *
     * Valid values are
     * AutomaticScaling: F1, F2, F4, F4_1G
     * ManualScaling: B1, B2, B4, B8, B4_1G
     * Defaults to F1 for AutomaticScaling and B1 for ManualScaling.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version.html#instance_class AppEngineFlexibleAppVersion#instance_class}
     *
     * @stability stable
     */
    readonly instanceClass?: string;
    /**
     * Files that match this pattern will not be built into this version. Only applicable for Go runtimes.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version.html#nobuild_files_regex AppEngineFlexibleAppVersion#nobuild_files_regex}
     *
     * @stability stable
     */
    readonly nobuildFilesRegex?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version.html#noop_on_destroy AppEngineFlexibleAppVersion#noop_on_destroy}.
     *
     * @stability stable
     */
    readonly noopOnDestroy?: boolean;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version.html#project AppEngineFlexibleAppVersion#project}.
     *
     * @stability stable
     */
    readonly project?: string;
    /**
     * Desired runtime. Example python27.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version.html#runtime AppEngineFlexibleAppVersion#runtime}
     *
     * @stability stable
     */
    readonly runtime: string;
    /**
     * The version of the API in the given runtime environment. Please see the app.yaml reference for valid values at https://cloud.google.com/appengine/docs/standard//config/appref.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version.html#runtime_api_version AppEngineFlexibleAppVersion#runtime_api_version}
     *
     * @stability stable
     */
    readonly runtimeApiVersion?: string;
    /**
     * The channel of the runtime to use. Only available for some runtimes.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version.html#runtime_channel AppEngineFlexibleAppVersion#runtime_channel}
     *
     * @stability stable
     */
    readonly runtimeChannel?: string;
    /**
     * The path or name of the app's main executable.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version.html#runtime_main_executable_path AppEngineFlexibleAppVersion#runtime_main_executable_path}
     *
     * @stability stable
     */
    readonly runtimeMainExecutablePath?: string;
    /**
     * AppEngine service resource. Can contain numbers, letters, and hyphens.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version.html#service AppEngineFlexibleAppVersion#service}
     *
     * @stability stable
     */
    readonly service: string;
    /**
     * Current serving status of this version.
     *
     * Only the versions with a SERVING status create instances and can be billed. Default value: "SERVING" Possible values: ["SERVING", "STOPPED"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version.html#serving_status AppEngineFlexibleAppVersion#serving_status}
     *
     * @stability stable
     */
    readonly servingStatus?: string;
    /**
     * Relative name of the version within the service.
     *
     * For example, 'v1'. Version names can contain only lowercase letters, numbers, or hyphens.
     * Reserved names,"default", "latest", and any name with the prefix "ah-".
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version.html#version_id AppEngineFlexibleAppVersion#version_id}
     *
     * @stability stable
     */
    readonly versionId?: string;
    /**
     * api_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version.html#api_config AppEngineFlexibleAppVersion#api_config}
     *
     * @stability stable
     */
    readonly apiConfig?: AppEngineFlexibleAppVersionApiConfig[];
    /**
     * automatic_scaling block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version.html#automatic_scaling AppEngineFlexibleAppVersion#automatic_scaling}
     *
     * @stability stable
     */
    readonly automaticScaling?: AppEngineFlexibleAppVersionAutomaticScaling[];
    /**
     * deployment block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version.html#deployment AppEngineFlexibleAppVersion#deployment}
     *
     * @stability stable
     */
    readonly deployment?: AppEngineFlexibleAppVersionDeployment[];
    /**
     * endpoints_api_service block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version.html#endpoints_api_service AppEngineFlexibleAppVersion#endpoints_api_service}
     *
     * @stability stable
     */
    readonly endpointsApiService?: AppEngineFlexibleAppVersionEndpointsApiService[];
    /**
     * entrypoint block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version.html#entrypoint AppEngineFlexibleAppVersion#entrypoint}
     *
     * @stability stable
     */
    readonly entrypoint?: AppEngineFlexibleAppVersionEntrypoint[];
    /**
     * handlers block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version.html#handlers AppEngineFlexibleAppVersion#handlers}
     *
     * @stability stable
     */
    readonly handlers?: AppEngineFlexibleAppVersionHandlers[];
    /**
     * liveness_check block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version.html#liveness_check AppEngineFlexibleAppVersion#liveness_check}
     *
     * @stability stable
     */
    readonly livenessCheck: AppEngineFlexibleAppVersionLivenessCheck[];
    /**
     * manual_scaling block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version.html#manual_scaling AppEngineFlexibleAppVersion#manual_scaling}
     *
     * @stability stable
     */
    readonly manualScaling?: AppEngineFlexibleAppVersionManualScaling[];
    /**
     * network block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version.html#network AppEngineFlexibleAppVersion#network}
     *
     * @stability stable
     */
    readonly network?: AppEngineFlexibleAppVersionNetwork[];
    /**
     * readiness_check block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version.html#readiness_check AppEngineFlexibleAppVersion#readiness_check}
     *
     * @stability stable
     */
    readonly readinessCheck: AppEngineFlexibleAppVersionReadinessCheck[];
    /**
     * resources block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version.html#resources AppEngineFlexibleAppVersion#resources}
     *
     * @stability stable
     */
    readonly resources?: AppEngineFlexibleAppVersionResources[];
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version.html#timeouts AppEngineFlexibleAppVersion#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: AppEngineFlexibleAppVersionTimeouts;
    /**
     * vpc_access_connector block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version.html#vpc_access_connector AppEngineFlexibleAppVersion#vpc_access_connector}
     *
     * @stability stable
     */
    readonly vpcAccessConnector?: AppEngineFlexibleAppVersionVpcAccessConnector[];
}
/**
 * @stability stable
 */
export interface AppEngineFlexibleAppVersionApiConfig {
    /**
     * Action to take when users access resources that require authentication. Default value: "AUTH_FAIL_ACTION_REDIRECT" Possible values: ["AUTH_FAIL_ACTION_REDIRECT", "AUTH_FAIL_ACTION_UNAUTHORIZED"].
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version.html#auth_fail_action AppEngineFlexibleAppVersion#auth_fail_action}
     *
     * @stability stable
     */
    readonly authFailAction?: string;
    /**
     * Level of login required to access this resource. Default value: "LOGIN_OPTIONAL" Possible values: ["LOGIN_OPTIONAL", "LOGIN_ADMIN", "LOGIN_REQUIRED"].
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version.html#login AppEngineFlexibleAppVersion#login}
     *
     * @stability stable
     */
    readonly login?: string;
    /**
     * Path to the script from the application root directory.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version.html#script AppEngineFlexibleAppVersion#script}
     *
     * @stability stable
     */
    readonly script: string;
    /**
     * Security (HTTPS) enforcement for this URL. Possible values: ["SECURE_DEFAULT", "SECURE_NEVER", "SECURE_OPTIONAL", "SECURE_ALWAYS"].
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version.html#security_level AppEngineFlexibleAppVersion#security_level}
     *
     * @stability stable
     */
    readonly securityLevel?: string;
    /**
     * URL to serve the endpoint at.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version.html#url AppEngineFlexibleAppVersion#url}
     *
     * @stability stable
     */
    readonly url?: string;
}
/**
 * @stability stable
 */
export interface AppEngineFlexibleAppVersionAutomaticScalingCpuUtilization {
    /**
     * Period of time over which CPU utilization is calculated.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version.html#aggregation_window_length AppEngineFlexibleAppVersion#aggregation_window_length}
     *
     * @stability stable
     */
    readonly aggregationWindowLength?: string;
    /**
     * Target CPU utilization ratio to maintain when scaling. Must be between 0 and 1.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version.html#target_utilization AppEngineFlexibleAppVersion#target_utilization}
     *
     * @stability stable
     */
    readonly targetUtilization: number;
}
/**
 * @stability stable
 */
export interface AppEngineFlexibleAppVersionAutomaticScalingDiskUtilization {
    /**
     * Target bytes read per second.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version.html#target_read_bytes_per_second AppEngineFlexibleAppVersion#target_read_bytes_per_second}
     *
     * @stability stable
     */
    readonly targetReadBytesPerSecond?: number;
    /**
     * Target ops read per seconds.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version.html#target_read_ops_per_second AppEngineFlexibleAppVersion#target_read_ops_per_second}
     *
     * @stability stable
     */
    readonly targetReadOpsPerSecond?: number;
    /**
     * Target bytes written per second.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version.html#target_write_bytes_per_second AppEngineFlexibleAppVersion#target_write_bytes_per_second}
     *
     * @stability stable
     */
    readonly targetWriteBytesPerSecond?: number;
    /**
     * Target ops written per second.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version.html#target_write_ops_per_second AppEngineFlexibleAppVersion#target_write_ops_per_second}
     *
     * @stability stable
     */
    readonly targetWriteOpsPerSecond?: number;
}
/**
 * @stability stable
 */
export interface AppEngineFlexibleAppVersionAutomaticScalingNetworkUtilization {
    /**
     * Target bytes received per second.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version.html#target_received_bytes_per_second AppEngineFlexibleAppVersion#target_received_bytes_per_second}
     *
     * @stability stable
     */
    readonly targetReceivedBytesPerSecond?: number;
    /**
     * Target packets received per second.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version.html#target_received_packets_per_second AppEngineFlexibleAppVersion#target_received_packets_per_second}
     *
     * @stability stable
     */
    readonly targetReceivedPacketsPerSecond?: number;
    /**
     * Target bytes sent per second.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version.html#target_sent_bytes_per_second AppEngineFlexibleAppVersion#target_sent_bytes_per_second}
     *
     * @stability stable
     */
    readonly targetSentBytesPerSecond?: number;
    /**
     * Target packets sent per second.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version.html#target_sent_packets_per_second AppEngineFlexibleAppVersion#target_sent_packets_per_second}
     *
     * @stability stable
     */
    readonly targetSentPacketsPerSecond?: number;
}
/**
 * @stability stable
 */
export interface AppEngineFlexibleAppVersionAutomaticScalingRequestUtilization {
    /**
     * Target number of concurrent requests.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version.html#target_concurrent_requests AppEngineFlexibleAppVersion#target_concurrent_requests}
     *
     * @stability stable
     */
    readonly targetConcurrentRequests?: number;
    /**
     * Target requests per second.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version.html#target_request_count_per_second AppEngineFlexibleAppVersion#target_request_count_per_second}
     *
     * @stability stable
     */
    readonly targetRequestCountPerSecond?: string;
}
/**
 * @stability stable
 */
export interface AppEngineFlexibleAppVersionAutomaticScaling {
    /**
     * The time period that the Autoscaler should wait before it starts collecting information from a new instance.
     *
     * This prevents the autoscaler from collecting information when the instance is initializing,
     * during which the collected usage would not be reliable. Default: 120s
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version.html#cool_down_period AppEngineFlexibleAppVersion#cool_down_period}
     *
     * @stability stable
     */
    readonly coolDownPeriod?: string;
    /**
     * Number of concurrent requests an automatic scaling instance can accept before the scheduler spawns a new instance.
     *
     * Defaults to a runtime-specific value.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version.html#max_concurrent_requests AppEngineFlexibleAppVersion#max_concurrent_requests}
     *
     * @stability stable
     */
    readonly maxConcurrentRequests?: number;
    /**
     * Maximum number of idle instances that should be maintained for this version.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version.html#max_idle_instances AppEngineFlexibleAppVersion#max_idle_instances}
     *
     * @stability stable
     */
    readonly maxIdleInstances?: number;
    /**
     * Maximum amount of time that a request should wait in the pending queue before starting a new instance to handle it.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version.html#max_pending_latency AppEngineFlexibleAppVersion#max_pending_latency}
     *
     * @stability stable
     */
    readonly maxPendingLatency?: string;
    /**
     * Maximum number of instances that should be started to handle requests for this version. Default: 20.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version.html#max_total_instances AppEngineFlexibleAppVersion#max_total_instances}
     *
     * @stability stable
     */
    readonly maxTotalInstances?: number;
    /**
     * Minimum number of idle instances that should be maintained for this version.
     *
     * Only applicable for the default version of a service.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version.html#min_idle_instances AppEngineFlexibleAppVersion#min_idle_instances}
     *
     * @stability stable
     */
    readonly minIdleInstances?: number;
    /**
     * Minimum amount of time a request should wait in the pending queue before starting a new instance to handle it.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version.html#min_pending_latency AppEngineFlexibleAppVersion#min_pending_latency}
     *
     * @stability stable
     */
    readonly minPendingLatency?: string;
    /**
     * Minimum number of running instances that should be maintained for this version. Default: 2.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version.html#min_total_instances AppEngineFlexibleAppVersion#min_total_instances}
     *
     * @stability stable
     */
    readonly minTotalInstances?: number;
    /**
     * cpu_utilization block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version.html#cpu_utilization AppEngineFlexibleAppVersion#cpu_utilization}
     *
     * @stability stable
     */
    readonly cpuUtilization: AppEngineFlexibleAppVersionAutomaticScalingCpuUtilization[];
    /**
     * disk_utilization block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version.html#disk_utilization AppEngineFlexibleAppVersion#disk_utilization}
     *
     * @stability stable
     */
    readonly diskUtilization?: AppEngineFlexibleAppVersionAutomaticScalingDiskUtilization[];
    /**
     * network_utilization block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version.html#network_utilization AppEngineFlexibleAppVersion#network_utilization}
     *
     * @stability stable
     */
    readonly networkUtilization?: AppEngineFlexibleAppVersionAutomaticScalingNetworkUtilization[];
    /**
     * request_utilization block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version.html#request_utilization AppEngineFlexibleAppVersion#request_utilization}
     *
     * @stability stable
     */
    readonly requestUtilization?: AppEngineFlexibleAppVersionAutomaticScalingRequestUtilization[];
}
/**
 * @stability stable
 */
export interface AppEngineFlexibleAppVersionDeploymentCloudBuildOptions {
    /**
     * Path to the yaml file used in deployment, used to determine runtime configuration details.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version.html#app_yaml_path AppEngineFlexibleAppVersion#app_yaml_path}
     *
     * @stability stable
     */
    readonly appYamlPath: string;
    /**
     * The Cloud Build timeout used as part of any dependent builds performed by version creation. Defaults to 10 minutes.
     *
     * A duration in seconds with up to nine fractional digits, terminated by 's'. Example: "3.5s".
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version.html#cloud_build_timeout AppEngineFlexibleAppVersion#cloud_build_timeout}
     *
     * @stability stable
     */
    readonly cloudBuildTimeout?: string;
}
/**
 * @stability stable
 */
export interface AppEngineFlexibleAppVersionDeploymentContainer {
    /**
     * URI to the hosted container image in Google Container Registry.
     *
     * The URI must be fully qualified and include a tag or digest.
     * Examples: "gcr.io/my-project/image:tag" or "gcr.io/my-project/image@digest"
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version.html#image AppEngineFlexibleAppVersion#image}
     *
     * @stability stable
     */
    readonly image: string;
}
/**
 * @stability stable
 */
export interface AppEngineFlexibleAppVersionDeploymentFiles {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version.html#name AppEngineFlexibleAppVersion#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * SHA1 checksum of the file.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version.html#sha1_sum AppEngineFlexibleAppVersion#sha1_sum}
     *
     * @stability stable
     */
    readonly sha1Sum?: string;
    /**
     * Source URL.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version.html#source_url AppEngineFlexibleAppVersion#source_url}
     *
     * @stability stable
     */
    readonly sourceUrl: string;
}
/**
 * @stability stable
 */
export interface AppEngineFlexibleAppVersionDeploymentZip {
    /**
     * files count.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version.html#files_count AppEngineFlexibleAppVersion#files_count}
     *
     * @stability stable
     */
    readonly filesCount?: number;
    /**
     * Source URL.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version.html#source_url AppEngineFlexibleAppVersion#source_url}
     *
     * @stability stable
     */
    readonly sourceUrl: string;
}
/**
 * @stability stable
 */
export interface AppEngineFlexibleAppVersionDeployment {
    /**
     * cloud_build_options block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version.html#cloud_build_options AppEngineFlexibleAppVersion#cloud_build_options}
     *
     * @stability stable
     */
    readonly cloudBuildOptions?: AppEngineFlexibleAppVersionDeploymentCloudBuildOptions[];
    /**
     * container block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version.html#container AppEngineFlexibleAppVersion#container}
     *
     * @stability stable
     */
    readonly container?: AppEngineFlexibleAppVersionDeploymentContainer[];
    /**
     * files block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version.html#files AppEngineFlexibleAppVersion#files}
     *
     * @stability stable
     */
    readonly files?: AppEngineFlexibleAppVersionDeploymentFiles[];
    /**
     * zip block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version.html#zip AppEngineFlexibleAppVersion#zip}
     *
     * @stability stable
     */
    readonly zip?: AppEngineFlexibleAppVersionDeploymentZip[];
}
/**
 * @stability stable
 */
export interface AppEngineFlexibleAppVersionEndpointsApiService {
    /**
     * Endpoints service configuration ID as specified by the Service Management API. For example "2016-09-19r1".
     *
     * By default, the rollout strategy for Endpoints is "FIXED". This means that Endpoints starts up with a particular configuration ID.
     * When a new configuration is rolled out, Endpoints must be given the new configuration ID. The configId field is used to give the configuration ID
     * and is required in this case.
     *
     * Endpoints also has a rollout strategy called "MANAGED". When using this, Endpoints fetches the latest configuration and does not need
     * the configuration ID. In this case, configId must be omitted.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version.html#config_id AppEngineFlexibleAppVersion#config_id}
     *
     * @stability stable
     */
    readonly configId?: string;
    /**
     * Enable or disable trace sampling. By default, this is set to false for enabled.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version.html#disable_trace_sampling AppEngineFlexibleAppVersion#disable_trace_sampling}
     *
     * @stability stable
     */
    readonly disableTraceSampling?: boolean;
    /**
     * Endpoints service name which is the name of the "service" resource in the Service Management API. For example "myapi.endpoints.myproject.cloud.goog".
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version.html#name AppEngineFlexibleAppVersion#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Endpoints rollout strategy.
     *
     * If FIXED, configId must be specified. If MANAGED, configId must be omitted. Default value: "FIXED" Possible values: ["FIXED", "MANAGED"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version.html#rollout_strategy AppEngineFlexibleAppVersion#rollout_strategy}
     *
     * @stability stable
     */
    readonly rolloutStrategy?: string;
}
/**
 * @stability stable
 */
export interface AppEngineFlexibleAppVersionEntrypoint {
    /**
     * The format should be a shell command that can be fed to bash -c.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version.html#shell AppEngineFlexibleAppVersion#shell}
     *
     * @stability stable
     */
    readonly shell: string;
}
/**
 * @stability stable
 */
export interface AppEngineFlexibleAppVersionHandlersScript {
    /**
     * Path to the script from the application root directory.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version.html#script_path AppEngineFlexibleAppVersion#script_path}
     *
     * @stability stable
     */
    readonly scriptPath: string;
}
/**
 * @stability stable
 */
export interface AppEngineFlexibleAppVersionHandlersStaticFiles {
    /**
     * Whether files should also be uploaded as code data.
     *
     * By default, files declared in static file handlers are
     * uploaded as static data and are only served to end users; they cannot be read by the application. If enabled,
     * uploads are charged against both your code and static data storage resource quotas.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version.html#application_readable AppEngineFlexibleAppVersion#application_readable}
     *
     * @stability stable
     */
    readonly applicationReadable?: boolean;
    /**
     * Time a static file served by this handler should be cached by web proxies and browsers.
     *
     * A duration in seconds with up to nine fractional digits, terminated by 's'. Example "3.5s".
     * Default is '0s'
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version.html#expiration AppEngineFlexibleAppVersion#expiration}
     *
     * @stability stable
     */
    readonly expiration?: string;
    /**
     * HTTP headers to use for all responses from these URLs. An object containing a list of "key:value" value pairs.".
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version.html#http_headers AppEngineFlexibleAppVersion#http_headers}
     *
     * @stability stable
     */
    readonly httpHeaders?: {
        [key: string]: string;
    };
    /**
     * MIME type used to serve all files served by this handler.
     *
     * Defaults to file-specific MIME types, which are derived from each file's filename extension.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version.html#mime_type AppEngineFlexibleAppVersion#mime_type}
     *
     * @stability stable
     */
    readonly mimeType?: string;
    /**
     * Path to the static files matched by the URL pattern, from the application root directory.
     *
     * The path can refer to text matched in groupings in the URL pattern.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version.html#path AppEngineFlexibleAppVersion#path}
     *
     * @stability stable
     */
    readonly path?: string;
    /**
     * Whether this handler should match the request if the file referenced by the handler does not exist.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version.html#require_matching_file AppEngineFlexibleAppVersion#require_matching_file}
     *
     * @stability stable
     */
    readonly requireMatchingFile?: boolean;
    /**
     * Regular expression that matches the file paths for all files that should be referenced by this handler.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version.html#upload_path_regex AppEngineFlexibleAppVersion#upload_path_regex}
     *
     * @stability stable
     */
    readonly uploadPathRegex?: string;
}
/**
 * @stability stable
 */
export interface AppEngineFlexibleAppVersionHandlers {
    /**
     * Actions to take when the user is not logged in. Possible values: ["AUTH_FAIL_ACTION_REDIRECT", "AUTH_FAIL_ACTION_UNAUTHORIZED"].
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version.html#auth_fail_action AppEngineFlexibleAppVersion#auth_fail_action}
     *
     * @stability stable
     */
    readonly authFailAction?: string;
    /**
     * Methods to restrict access to a URL based on login status. Possible values: ["LOGIN_OPTIONAL", "LOGIN_ADMIN", "LOGIN_REQUIRED"].
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version.html#login AppEngineFlexibleAppVersion#login}
     *
     * @stability stable
     */
    readonly login?: string;
    /**
     * 30x code to use when performing redirects for the secure field. Possible values: ["REDIRECT_HTTP_RESPONSE_CODE_301", "REDIRECT_HTTP_RESPONSE_CODE_302", "REDIRECT_HTTP_RESPONSE_CODE_303", "REDIRECT_HTTP_RESPONSE_CODE_307"].
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version.html#redirect_http_response_code AppEngineFlexibleAppVersion#redirect_http_response_code}
     *
     * @stability stable
     */
    readonly redirectHttpResponseCode?: string;
    /**
     * Security (HTTPS) enforcement for this URL. Possible values: ["SECURE_DEFAULT", "SECURE_NEVER", "SECURE_OPTIONAL", "SECURE_ALWAYS"].
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version.html#security_level AppEngineFlexibleAppVersion#security_level}
     *
     * @stability stable
     */
    readonly securityLevel?: string;
    /**
     * URL prefix.
     *
     * Uses regular expression syntax, which means regexp special characters must be escaped, but should not contain groupings.
     * All URLs that begin with this prefix are handled by this handler, using the portion of the URL after the prefix as part of the file path.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version.html#url_regex AppEngineFlexibleAppVersion#url_regex}
     *
     * @stability stable
     */
    readonly urlRegex?: string;
    /**
     * script block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version.html#script AppEngineFlexibleAppVersion#script}
     *
     * @stability stable
     */
    readonly script?: AppEngineFlexibleAppVersionHandlersScript[];
    /**
     * static_files block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version.html#static_files AppEngineFlexibleAppVersion#static_files}
     *
     * @stability stable
     */
    readonly staticFiles?: AppEngineFlexibleAppVersionHandlersStaticFiles[];
}
/**
 * @stability stable
 */
export interface AppEngineFlexibleAppVersionLivenessCheck {
    /**
     * Interval between health checks.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version.html#check_interval AppEngineFlexibleAppVersion#check_interval}
     *
     * @stability stable
     */
    readonly checkInterval?: string;
    /**
     * Number of consecutive failed checks required before considering the VM unhealthy. Default: 4.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version.html#failure_threshold AppEngineFlexibleAppVersion#failure_threshold}
     *
     * @stability stable
     */
    readonly failureThreshold?: number;
    /**
     * Host header to send when performing a HTTP Readiness check. Example: "myapp.appspot.com".
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version.html#host AppEngineFlexibleAppVersion#host}
     *
     * @stability stable
     */
    readonly host?: string;
    /**
     * The initial delay before starting to execute the checks. Default: "300s".
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version.html#initial_delay AppEngineFlexibleAppVersion#initial_delay}
     *
     * @stability stable
     */
    readonly initialDelay?: string;
    /**
     * The request path.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version.html#path AppEngineFlexibleAppVersion#path}
     *
     * @stability stable
     */
    readonly path: string;
    /**
     * Number of consecutive successful checks required before considering the VM healthy. Default: 2.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version.html#success_threshold AppEngineFlexibleAppVersion#success_threshold}
     *
     * @stability stable
     */
    readonly successThreshold?: number;
    /**
     * Time before the check is considered failed. Default: "4s".
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version.html#timeout AppEngineFlexibleAppVersion#timeout}
     *
     * @stability stable
     */
    readonly timeout?: string;
}
/**
 * @stability stable
 */
export interface AppEngineFlexibleAppVersionManualScaling {
    /**
     * Number of instances to assign to the service at the start.
     *
     * *Note:** When managing the number of instances at runtime through the App Engine Admin API or the (now deprecated) Python 2
     * Modules API set_num_instances() you must use 'lifecycle.ignore_changes = ["manual_scaling"[0].instances]' to prevent drift detection.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version.html#instances AppEngineFlexibleAppVersion#instances}
     *
     * @stability stable
     */
    readonly instances: number;
}
/**
 * @stability stable
 */
export interface AppEngineFlexibleAppVersionNetwork {
    /**
     * List of ports, or port pairs, to forward from the virtual machine to the application container.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version.html#forwarded_ports AppEngineFlexibleAppVersion#forwarded_ports}
     *
     * @stability stable
     */
    readonly forwardedPorts?: string[];
    /**
     * Tag to apply to the instance during creation.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version.html#instance_tag AppEngineFlexibleAppVersion#instance_tag}
     *
     * @stability stable
     */
    readonly instanceTag?: string;
    /**
     * Google Compute Engine network where the virtual machines are created. Specify the short name, not the resource path.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version.html#name AppEngineFlexibleAppVersion#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Enable session affinity.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version.html#session_affinity AppEngineFlexibleAppVersion#session_affinity}
     *
     * @stability stable
     */
    readonly sessionAffinity?: boolean;
    /**
     * Google Cloud Platform sub-network where the virtual machines are created. Specify the short name, not the resource path.
     *
     * If the network that the instance is being created in is a Legacy network, then the IP address is allocated from the IPv4Range.
     * If the network that the instance is being created in is an auto Subnet Mode Network, then only network name should be specified (not the subnetworkName) and the IP address is created from the IPCidrRange of the subnetwork that exists in that zone for that network.
     * If the network that the instance is being created in is a custom Subnet Mode Network, then the subnetworkName must be specified and the IP address is created from the IPCidrRange of the subnetwork.
     * If specified, the subnetwork must exist in the same region as the App Engine flexible environment application.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version.html#subnetwork AppEngineFlexibleAppVersion#subnetwork}
     *
     * @stability stable
     */
    readonly subnetwork?: string;
}
/**
 * @stability stable
 */
export interface AppEngineFlexibleAppVersionReadinessCheck {
    /**
     * A maximum time limit on application initialization, measured from moment the application successfully replies to a healthcheck until it is ready to serve traffic.
     *
     * Default: "300s"
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version.html#app_start_timeout AppEngineFlexibleAppVersion#app_start_timeout}
     *
     * @stability stable
     */
    readonly appStartTimeout?: string;
    /**
     * Interval between health checks.  Default: "5s".
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version.html#check_interval AppEngineFlexibleAppVersion#check_interval}
     *
     * @stability stable
     */
    readonly checkInterval?: string;
    /**
     * Number of consecutive failed checks required before removing traffic. Default: 2.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version.html#failure_threshold AppEngineFlexibleAppVersion#failure_threshold}
     *
     * @stability stable
     */
    readonly failureThreshold?: number;
    /**
     * Host header to send when performing a HTTP Readiness check. Example: "myapp.appspot.com".
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version.html#host AppEngineFlexibleAppVersion#host}
     *
     * @stability stable
     */
    readonly host?: string;
    /**
     * The request path.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version.html#path AppEngineFlexibleAppVersion#path}
     *
     * @stability stable
     */
    readonly path: string;
    /**
     * Number of consecutive successful checks required before receiving traffic. Default: 2.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version.html#success_threshold AppEngineFlexibleAppVersion#success_threshold}
     *
     * @stability stable
     */
    readonly successThreshold?: number;
    /**
     * Time before the check is considered failed. Default: "4s".
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version.html#timeout AppEngineFlexibleAppVersion#timeout}
     *
     * @stability stable
     */
    readonly timeout?: string;
}
/**
 * @stability stable
 */
export interface AppEngineFlexibleAppVersionResourcesVolumes {
    /**
     * Unique name for the volume.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version.html#name AppEngineFlexibleAppVersion#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Volume size in gigabytes.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version.html#size_gb AppEngineFlexibleAppVersion#size_gb}
     *
     * @stability stable
     */
    readonly sizeGb: number;
    /**
     * Underlying volume type, e.g. 'tmpfs'.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version.html#volume_type AppEngineFlexibleAppVersion#volume_type}
     *
     * @stability stable
     */
    readonly volumeType: string;
}
/**
 * @stability stable
 */
export interface AppEngineFlexibleAppVersionResources {
    /**
     * Number of CPU cores needed.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version.html#cpu AppEngineFlexibleAppVersion#cpu}
     *
     * @stability stable
     */
    readonly cpu?: number;
    /**
     * Disk size (GB) needed.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version.html#disk_gb AppEngineFlexibleAppVersion#disk_gb}
     *
     * @stability stable
     */
    readonly diskGb?: number;
    /**
     * Memory (GB) needed.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version.html#memory_gb AppEngineFlexibleAppVersion#memory_gb}
     *
     * @stability stable
     */
    readonly memoryGb?: number;
    /**
     * volumes block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version.html#volumes AppEngineFlexibleAppVersion#volumes}
     *
     * @stability stable
     */
    readonly volumes?: AppEngineFlexibleAppVersionResourcesVolumes[];
}
/**
 * @stability stable
 */
export interface AppEngineFlexibleAppVersionTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version.html#create AppEngineFlexibleAppVersion#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version.html#delete AppEngineFlexibleAppVersion#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version.html#update AppEngineFlexibleAppVersion#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
/**
 * @stability stable
 */
export interface AppEngineFlexibleAppVersionVpcAccessConnector {
    /**
     * Full Serverless VPC Access Connector name e.g. /projects/my-project/locations/us-central1/connectors/c1.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version.html#name AppEngineFlexibleAppVersion#name}
     *
     * @stability stable
     */
    readonly name: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version.html google_app_engine_flexible_app_version}.
 *
 * @stability stable
 */
export declare class AppEngineFlexibleAppVersion extends cdktf.TerraformResource {
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version.html google_app_engine_flexible_app_version} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: AppEngineFlexibleAppVersionConfig);
    private _betaSettings?;
    /**
     * @stability stable
     */
    get betaSettings(): {
        [key: string]: string;
    };
    /**
     * @stability stable
     */
    set betaSettings(value: {
        [key: string]: string;
    });
    /**
     * @stability stable
     */
    resetBetaSettings(): void;
    /**
     * @stability stable
     */
    get betaSettingsInput(): {
        [key: string]: string;
    } | undefined;
    private _defaultExpiration?;
    /**
     * @stability stable
     */
    get defaultExpiration(): string;
    /**
     * @stability stable
     */
    set defaultExpiration(value: string);
    /**
     * @stability stable
     */
    resetDefaultExpiration(): void;
    /**
     * @stability stable
     */
    get defaultExpirationInput(): string | undefined;
    private _deleteServiceOnDestroy?;
    /**
     * @stability stable
     */
    get deleteServiceOnDestroy(): boolean;
    /**
     * @stability stable
     */
    set deleteServiceOnDestroy(value: boolean);
    /**
     * @stability stable
     */
    resetDeleteServiceOnDestroy(): void;
    /**
     * @stability stable
     */
    get deleteServiceOnDestroyInput(): boolean | undefined;
    private _envVariables?;
    /**
     * @stability stable
     */
    get envVariables(): {
        [key: string]: string;
    };
    /**
     * @stability stable
     */
    set envVariables(value: {
        [key: string]: string;
    });
    /**
     * @stability stable
     */
    resetEnvVariables(): void;
    /**
     * @stability stable
     */
    get envVariablesInput(): {
        [key: string]: string;
    } | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _inboundServices?;
    /**
     * @stability stable
     */
    get inboundServices(): string[];
    /**
     * @stability stable
     */
    set inboundServices(value: string[]);
    /**
     * @stability stable
     */
    resetInboundServices(): void;
    /**
     * @stability stable
     */
    get inboundServicesInput(): string[] | undefined;
    private _instanceClass?;
    /**
     * @stability stable
     */
    get instanceClass(): string;
    /**
     * @stability stable
     */
    set instanceClass(value: string);
    /**
     * @stability stable
     */
    resetInstanceClass(): void;
    /**
     * @stability stable
     */
    get instanceClassInput(): string | undefined;
    /**
     * @stability stable
     */
    get name(): string;
    private _nobuildFilesRegex?;
    /**
     * @stability stable
     */
    get nobuildFilesRegex(): string;
    /**
     * @stability stable
     */
    set nobuildFilesRegex(value: string);
    /**
     * @stability stable
     */
    resetNobuildFilesRegex(): void;
    /**
     * @stability stable
     */
    get nobuildFilesRegexInput(): string | undefined;
    private _noopOnDestroy?;
    /**
     * @stability stable
     */
    get noopOnDestroy(): boolean;
    /**
     * @stability stable
     */
    set noopOnDestroy(value: boolean);
    /**
     * @stability stable
     */
    resetNoopOnDestroy(): void;
    /**
     * @stability stable
     */
    get noopOnDestroyInput(): boolean | undefined;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string;
    /**
     * @stability stable
     */
    set project(value: string);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    private _runtime;
    /**
     * @stability stable
     */
    get runtime(): string;
    /**
     * @stability stable
     */
    set runtime(value: string);
    /**
     * @stability stable
     */
    get runtimeInput(): string;
    private _runtimeApiVersion?;
    /**
     * @stability stable
     */
    get runtimeApiVersion(): string;
    /**
     * @stability stable
     */
    set runtimeApiVersion(value: string);
    /**
     * @stability stable
     */
    resetRuntimeApiVersion(): void;
    /**
     * @stability stable
     */
    get runtimeApiVersionInput(): string | undefined;
    private _runtimeChannel?;
    /**
     * @stability stable
     */
    get runtimeChannel(): string;
    /**
     * @stability stable
     */
    set runtimeChannel(value: string);
    /**
     * @stability stable
     */
    resetRuntimeChannel(): void;
    /**
     * @stability stable
     */
    get runtimeChannelInput(): string | undefined;
    private _runtimeMainExecutablePath?;
    /**
     * @stability stable
     */
    get runtimeMainExecutablePath(): string;
    /**
     * @stability stable
     */
    set runtimeMainExecutablePath(value: string);
    /**
     * @stability stable
     */
    resetRuntimeMainExecutablePath(): void;
    /**
     * @stability stable
     */
    get runtimeMainExecutablePathInput(): string | undefined;
    private _service;
    /**
     * @stability stable
     */
    get service(): string;
    /**
     * @stability stable
     */
    set service(value: string);
    /**
     * @stability stable
     */
    get serviceInput(): string;
    private _servingStatus?;
    /**
     * @stability stable
     */
    get servingStatus(): string;
    /**
     * @stability stable
     */
    set servingStatus(value: string);
    /**
     * @stability stable
     */
    resetServingStatus(): void;
    /**
     * @stability stable
     */
    get servingStatusInput(): string | undefined;
    private _versionId?;
    /**
     * @stability stable
     */
    get versionId(): string;
    /**
     * @stability stable
     */
    set versionId(value: string);
    /**
     * @stability stable
     */
    resetVersionId(): void;
    /**
     * @stability stable
     */
    get versionIdInput(): string | undefined;
    private _apiConfig?;
    /**
     * @stability stable
     */
    get apiConfig(): AppEngineFlexibleAppVersionApiConfig[];
    /**
     * @stability stable
     */
    set apiConfig(value: AppEngineFlexibleAppVersionApiConfig[]);
    /**
     * @stability stable
     */
    resetApiConfig(): void;
    /**
     * @stability stable
     */
    get apiConfigInput(): AppEngineFlexibleAppVersionApiConfig[] | undefined;
    private _automaticScaling?;
    /**
     * @stability stable
     */
    get automaticScaling(): AppEngineFlexibleAppVersionAutomaticScaling[];
    /**
     * @stability stable
     */
    set automaticScaling(value: AppEngineFlexibleAppVersionAutomaticScaling[]);
    /**
     * @stability stable
     */
    resetAutomaticScaling(): void;
    /**
     * @stability stable
     */
    get automaticScalingInput(): AppEngineFlexibleAppVersionAutomaticScaling[] | undefined;
    private _deployment?;
    /**
     * @stability stable
     */
    get deployment(): AppEngineFlexibleAppVersionDeployment[];
    /**
     * @stability stable
     */
    set deployment(value: AppEngineFlexibleAppVersionDeployment[]);
    /**
     * @stability stable
     */
    resetDeployment(): void;
    /**
     * @stability stable
     */
    get deploymentInput(): AppEngineFlexibleAppVersionDeployment[] | undefined;
    private _endpointsApiService?;
    /**
     * @stability stable
     */
    get endpointsApiService(): AppEngineFlexibleAppVersionEndpointsApiService[];
    /**
     * @stability stable
     */
    set endpointsApiService(value: AppEngineFlexibleAppVersionEndpointsApiService[]);
    /**
     * @stability stable
     */
    resetEndpointsApiService(): void;
    /**
     * @stability stable
     */
    get endpointsApiServiceInput(): AppEngineFlexibleAppVersionEndpointsApiService[] | undefined;
    private _entrypoint?;
    /**
     * @stability stable
     */
    get entrypoint(): AppEngineFlexibleAppVersionEntrypoint[];
    /**
     * @stability stable
     */
    set entrypoint(value: AppEngineFlexibleAppVersionEntrypoint[]);
    /**
     * @stability stable
     */
    resetEntrypoint(): void;
    /**
     * @stability stable
     */
    get entrypointInput(): AppEngineFlexibleAppVersionEntrypoint[] | undefined;
    private _handlers?;
    /**
     * @stability stable
     */
    get handlers(): AppEngineFlexibleAppVersionHandlers[];
    /**
     * @stability stable
     */
    set handlers(value: AppEngineFlexibleAppVersionHandlers[]);
    /**
     * @stability stable
     */
    resetHandlers(): void;
    /**
     * @stability stable
     */
    get handlersInput(): AppEngineFlexibleAppVersionHandlers[] | undefined;
    private _livenessCheck;
    /**
     * @stability stable
     */
    get livenessCheck(): AppEngineFlexibleAppVersionLivenessCheck[];
    /**
     * @stability stable
     */
    set livenessCheck(value: AppEngineFlexibleAppVersionLivenessCheck[]);
    /**
     * @stability stable
     */
    get livenessCheckInput(): AppEngineFlexibleAppVersionLivenessCheck[];
    private _manualScaling?;
    /**
     * @stability stable
     */
    get manualScaling(): AppEngineFlexibleAppVersionManualScaling[];
    /**
     * @stability stable
     */
    set manualScaling(value: AppEngineFlexibleAppVersionManualScaling[]);
    /**
     * @stability stable
     */
    resetManualScaling(): void;
    /**
     * @stability stable
     */
    get manualScalingInput(): AppEngineFlexibleAppVersionManualScaling[] | undefined;
    private _network?;
    /**
     * @stability stable
     */
    get network(): AppEngineFlexibleAppVersionNetwork[];
    /**
     * @stability stable
     */
    set network(value: AppEngineFlexibleAppVersionNetwork[]);
    /**
     * @stability stable
     */
    resetNetwork(): void;
    /**
     * @stability stable
     */
    get networkInput(): AppEngineFlexibleAppVersionNetwork[] | undefined;
    private _readinessCheck;
    /**
     * @stability stable
     */
    get readinessCheck(): AppEngineFlexibleAppVersionReadinessCheck[];
    /**
     * @stability stable
     */
    set readinessCheck(value: AppEngineFlexibleAppVersionReadinessCheck[]);
    /**
     * @stability stable
     */
    get readinessCheckInput(): AppEngineFlexibleAppVersionReadinessCheck[];
    private _resources?;
    /**
     * @stability stable
     */
    get resources(): AppEngineFlexibleAppVersionResources[];
    /**
     * @stability stable
     */
    set resources(value: AppEngineFlexibleAppVersionResources[]);
    /**
     * @stability stable
     */
    resetResources(): void;
    /**
     * @stability stable
     */
    get resourcesInput(): AppEngineFlexibleAppVersionResources[] | undefined;
    private _timeouts?;
    /**
     * @stability stable
     */
    get timeouts(): AppEngineFlexibleAppVersionTimeouts;
    /**
     * @stability stable
     */
    set timeouts(value: AppEngineFlexibleAppVersionTimeouts);
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): AppEngineFlexibleAppVersionTimeouts | undefined;
    private _vpcAccessConnector?;
    /**
     * @stability stable
     */
    get vpcAccessConnector(): AppEngineFlexibleAppVersionVpcAccessConnector[];
    /**
     * @stability stable
     */
    set vpcAccessConnector(value: AppEngineFlexibleAppVersionVpcAccessConnector[]);
    /**
     * @stability stable
     */
    resetVpcAccessConnector(): void;
    /**
     * @stability stable
     */
    get vpcAccessConnectorInput(): AppEngineFlexibleAppVersionVpcAccessConnector[] | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
