import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface AppEngineServiceSplitTrafficConfig extends cdktf.TerraformMetaArguments {
    /**
     * If set to true traffic will be migrated to this version.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_service_split_traffic.html#migrate_traffic AppEngineServiceSplitTraffic#migrate_traffic}
     *
     * @stability stable
     */
    readonly migrateTraffic?: boolean;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_service_split_traffic.html#project AppEngineServiceSplitTraffic#project}.
     *
     * @stability stable
     */
    readonly project?: string;
    /**
     * The name of the service these settings apply to.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_service_split_traffic.html#service AppEngineServiceSplitTraffic#service}
     *
     * @stability stable
     */
    readonly service: string;
    /**
     * split block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_service_split_traffic.html#split AppEngineServiceSplitTraffic#split}
     *
     * @stability stable
     */
    readonly split: AppEngineServiceSplitTrafficSplit[];
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_service_split_traffic.html#timeouts AppEngineServiceSplitTraffic#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: AppEngineServiceSplitTrafficTimeouts;
}
/**
 * @stability stable
 */
export interface AppEngineServiceSplitTrafficSplit {
    /**
     * Mapping from version IDs within the service to fractional (0.000, 1] allocations of traffic for that version. Each version can be specified only once, but some versions in the service may not have any traffic allocation. Services that have traffic allocated cannot be deleted until either the service is deleted or their traffic allocation is removed. Allocations must sum to 1. Up to two decimal place precision is supported for IP-based splits and up to three decimal places is supported for cookie-based splits.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_service_split_traffic.html#allocations AppEngineServiceSplitTraffic#allocations}
     *
     * @stability stable
     */
    readonly allocations: {
        [key: string]: string;
    };
    /**
     * Mechanism used to determine which version a request is sent to.
     *
     * The traffic selection algorithm will be stable for either type until allocations are changed. Possible values: ["UNSPECIFIED", "COOKIE", "IP", "RANDOM"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_service_split_traffic.html#shard_by AppEngineServiceSplitTraffic#shard_by}
     *
     * @stability stable
     */
    readonly shardBy?: string;
}
/**
 * @stability stable
 */
export interface AppEngineServiceSplitTrafficTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_service_split_traffic.html#create AppEngineServiceSplitTraffic#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_service_split_traffic.html#delete AppEngineServiceSplitTraffic#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_service_split_traffic.html#update AppEngineServiceSplitTraffic#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/app_engine_service_split_traffic.html google_app_engine_service_split_traffic}.
 *
 * @stability stable
 */
export declare class AppEngineServiceSplitTraffic extends cdktf.TerraformResource {
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/app_engine_service_split_traffic.html google_app_engine_service_split_traffic} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: AppEngineServiceSplitTrafficConfig);
    /**
     * @stability stable
     */
    get id(): string;
    private _migrateTraffic?;
    /**
     * @stability stable
     */
    get migrateTraffic(): boolean;
    /**
     * @stability stable
     */
    set migrateTraffic(value: boolean);
    /**
     * @stability stable
     */
    resetMigrateTraffic(): void;
    /**
     * @stability stable
     */
    get migrateTrafficInput(): boolean | undefined;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string;
    /**
     * @stability stable
     */
    set project(value: string);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    private _service;
    /**
     * @stability stable
     */
    get service(): string;
    /**
     * @stability stable
     */
    set service(value: string);
    /**
     * @stability stable
     */
    get serviceInput(): string;
    private _split;
    /**
     * @stability stable
     */
    get split(): AppEngineServiceSplitTrafficSplit[];
    /**
     * @stability stable
     */
    set split(value: AppEngineServiceSplitTrafficSplit[]);
    /**
     * @stability stable
     */
    get splitInput(): AppEngineServiceSplitTrafficSplit[];
    private _timeouts?;
    /**
     * @stability stable
     */
    get timeouts(): AppEngineServiceSplitTrafficTimeouts;
    /**
     * @stability stable
     */
    set timeouts(value: AppEngineServiceSplitTrafficTimeouts);
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): AppEngineServiceSplitTrafficTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
