import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface BigqueryDataTransferConfigConfig extends cdktf.TerraformMetaArguments {
    /**
     * The number of days to look back to automatically refresh the data.
     *
     * For example, if dataRefreshWindowDays = 10, then every day BigQuery
     * reingests data for [today-10, today-1], rather than ingesting data for
     * just [today-1]. Only valid if the data source supports the feature.
     * Set the value to 0 to use the default value.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_data_transfer_config.html#data_refresh_window_days BigqueryDataTransferConfig#data_refresh_window_days}
     *
     * @stability stable
     */
    readonly dataRefreshWindowDays?: number;
    /**
     * The data source id. Cannot be changed once the transfer config is created.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_data_transfer_config.html#data_source_id BigqueryDataTransferConfig#data_source_id}
     *
     * @stability stable
     */
    readonly dataSourceId: string;
    /**
     * The BigQuery target dataset id.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_data_transfer_config.html#destination_dataset_id BigqueryDataTransferConfig#destination_dataset_id}
     *
     * @stability stable
     */
    readonly destinationDatasetId: string;
    /**
     * When set to true, no runs are scheduled for a given transfer.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_data_transfer_config.html#disabled BigqueryDataTransferConfig#disabled}
     *
     * @stability stable
     */
    readonly disabled?: boolean;
    /**
     * The user specified display name for the transfer config.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_data_transfer_config.html#display_name BigqueryDataTransferConfig#display_name}
     *
     * @stability stable
     */
    readonly displayName: string;
    /**
     * The geographic location where the transfer config should reside. Examples: US, EU, asia-northeast1. The default value is US.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_data_transfer_config.html#location BigqueryDataTransferConfig#location}
     *
     * @stability stable
     */
    readonly location?: string;
    /**
     * Pub/Sub topic where notifications will be sent after transfer runs associated with this transfer config finish.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_data_transfer_config.html#notification_pubsub_topic BigqueryDataTransferConfig#notification_pubsub_topic}
     *
     * @stability stable
     */
    readonly notificationPubsubTopic?: string;
    /**
     * These parameters are specific to each data source.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_data_transfer_config.html#params BigqueryDataTransferConfig#params}
     *
     * @stability stable
     */
    readonly params: {
        [key: string]: string;
    };
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_data_transfer_config.html#project BigqueryDataTransferConfig#project}.
     *
     * @stability stable
     */
    readonly project?: string;
    /**
     * Data transfer schedule.
     *
     * If the data source does not support a custom
     * schedule, this should be empty. If it is empty, the default value for
     * the data source will be used. The specified times are in UTC. Examples
     * of valid format: 1st,3rd monday of month 15:30, every wed,fri of jan,
     * jun 13:15, and first sunday of quarter 00:00. See more explanation
     * about the format here:
     * https://cloud.google.com/appengine/docs/flexible/python/scheduling-jobs-with-cron-yaml#the_schedule_format
     * NOTE: the granularity should be at least 8 hours, or less frequent.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_data_transfer_config.html#schedule BigqueryDataTransferConfig#schedule}
     *
     * @stability stable
     */
    readonly schedule?: string;
    /**
     * Optional service account name.
     *
     * If this field is set, transfer config will
     * be created with this service account credentials. It requires that
     * requesting user calling this API has permissions to act as this service account.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_data_transfer_config.html#service_account_name BigqueryDataTransferConfig#service_account_name}
     *
     * @stability stable
     */
    readonly serviceAccountName?: string;
    /**
     * email_preferences block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_data_transfer_config.html#email_preferences BigqueryDataTransferConfig#email_preferences}
     *
     * @stability stable
     */
    readonly emailPreferences?: BigqueryDataTransferConfigEmailPreferences[];
    /**
     * schedule_options block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_data_transfer_config.html#schedule_options BigqueryDataTransferConfig#schedule_options}
     *
     * @stability stable
     */
    readonly scheduleOptions?: BigqueryDataTransferConfigScheduleOptions[];
    /**
     * sensitive_params block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_data_transfer_config.html#sensitive_params BigqueryDataTransferConfig#sensitive_params}
     *
     * @stability stable
     */
    readonly sensitiveParams?: BigqueryDataTransferConfigSensitiveParams[];
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_data_transfer_config.html#timeouts BigqueryDataTransferConfig#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: BigqueryDataTransferConfigTimeouts;
}
/**
 * @stability stable
 */
export interface BigqueryDataTransferConfigEmailPreferences {
    /**
     * If true, email notifications will be sent on transfer run failures.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_data_transfer_config.html#enable_failure_email BigqueryDataTransferConfig#enable_failure_email}
     *
     * @stability stable
     */
    readonly enableFailureEmail: boolean;
}
/**
 * @stability stable
 */
export interface BigqueryDataTransferConfigScheduleOptions {
    /**
     * If true, automatic scheduling of data transfer runs for this configuration will be disabled.
     *
     * The runs can be started on ad-hoc
     * basis using transferConfigs.startManualRuns API. When automatic
     * scheduling is disabled, the TransferConfig.schedule field will
     * be ignored.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_data_transfer_config.html#disable_auto_scheduling BigqueryDataTransferConfig#disable_auto_scheduling}
     *
     * @stability stable
     */
    readonly disableAutoScheduling?: boolean;
    /**
     * Defines time to stop scheduling transfer runs.
     *
     * A transfer run cannot be
     * scheduled at or after the end time. The end time can be changed at any
     * moment. The time when a data transfer can be triggered manually is not
     * limited by this option.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_data_transfer_config.html#end_time BigqueryDataTransferConfig#end_time}
     *
     * @stability stable
     */
    readonly endTime?: string;
    /**
     * Specifies time to start scheduling transfer runs.
     *
     * The first run will be
     * scheduled at or after the start time according to a recurrence pattern
     * defined in the schedule string. The start time can be changed at any
     * moment. The time when a data transfer can be triggered manually is not
     * limited by this option.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_data_transfer_config.html#start_time BigqueryDataTransferConfig#start_time}
     *
     * @stability stable
     */
    readonly startTime?: string;
}
/**
 * @stability stable
 */
export interface BigqueryDataTransferConfigSensitiveParams {
    /**
     * The Secret Access Key of the AWS account transferring data from.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_data_transfer_config.html#secret_access_key BigqueryDataTransferConfig#secret_access_key}
     *
     * @stability stable
     */
    readonly secretAccessKey: string;
}
/**
 * @stability stable
 */
export interface BigqueryDataTransferConfigTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_data_transfer_config.html#create BigqueryDataTransferConfig#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_data_transfer_config.html#delete BigqueryDataTransferConfig#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_data_transfer_config.html#update BigqueryDataTransferConfig#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/bigquery_data_transfer_config.html google_bigquery_data_transfer_config}.
 *
 * @stability stable
 */
export declare class BigqueryDataTransferConfig extends cdktf.TerraformResource {
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/bigquery_data_transfer_config.html google_bigquery_data_transfer_config} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: BigqueryDataTransferConfigConfig);
    private _dataRefreshWindowDays?;
    /**
     * @stability stable
     */
    get dataRefreshWindowDays(): number;
    /**
     * @stability stable
     */
    set dataRefreshWindowDays(value: number);
    /**
     * @stability stable
     */
    resetDataRefreshWindowDays(): void;
    /**
     * @stability stable
     */
    get dataRefreshWindowDaysInput(): number | undefined;
    private _dataSourceId;
    /**
     * @stability stable
     */
    get dataSourceId(): string;
    /**
     * @stability stable
     */
    set dataSourceId(value: string);
    /**
     * @stability stable
     */
    get dataSourceIdInput(): string;
    private _destinationDatasetId;
    /**
     * @stability stable
     */
    get destinationDatasetId(): string;
    /**
     * @stability stable
     */
    set destinationDatasetId(value: string);
    /**
     * @stability stable
     */
    get destinationDatasetIdInput(): string;
    private _disabled?;
    /**
     * @stability stable
     */
    get disabled(): boolean;
    /**
     * @stability stable
     */
    set disabled(value: boolean);
    /**
     * @stability stable
     */
    resetDisabled(): void;
    /**
     * @stability stable
     */
    get disabledInput(): boolean | undefined;
    private _displayName;
    /**
     * @stability stable
     */
    get displayName(): string;
    /**
     * @stability stable
     */
    set displayName(value: string);
    /**
     * @stability stable
     */
    get displayNameInput(): string;
    /**
     * @stability stable
     */
    get id(): string;
    private _location?;
    /**
     * @stability stable
     */
    get location(): string;
    /**
     * @stability stable
     */
    set location(value: string);
    /**
     * @stability stable
     */
    resetLocation(): void;
    /**
     * @stability stable
     */
    get locationInput(): string | undefined;
    /**
     * @stability stable
     */
    get name(): string;
    private _notificationPubsubTopic?;
    /**
     * @stability stable
     */
    get notificationPubsubTopic(): string;
    /**
     * @stability stable
     */
    set notificationPubsubTopic(value: string);
    /**
     * @stability stable
     */
    resetNotificationPubsubTopic(): void;
    /**
     * @stability stable
     */
    get notificationPubsubTopicInput(): string | undefined;
    private _params;
    /**
     * @stability stable
     */
    get params(): {
        [key: string]: string;
    };
    /**
     * @stability stable
     */
    set params(value: {
        [key: string]: string;
    });
    /**
     * @stability stable
     */
    get paramsInput(): {
        [key: string]: string;
    };
    private _project?;
    /**
     * @stability stable
     */
    get project(): string;
    /**
     * @stability stable
     */
    set project(value: string);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    private _schedule?;
    /**
     * @stability stable
     */
    get schedule(): string;
    /**
     * @stability stable
     */
    set schedule(value: string);
    /**
     * @stability stable
     */
    resetSchedule(): void;
    /**
     * @stability stable
     */
    get scheduleInput(): string | undefined;
    private _serviceAccountName?;
    /**
     * @stability stable
     */
    get serviceAccountName(): string;
    /**
     * @stability stable
     */
    set serviceAccountName(value: string);
    /**
     * @stability stable
     */
    resetServiceAccountName(): void;
    /**
     * @stability stable
     */
    get serviceAccountNameInput(): string | undefined;
    private _emailPreferences?;
    /**
     * @stability stable
     */
    get emailPreferences(): BigqueryDataTransferConfigEmailPreferences[];
    /**
     * @stability stable
     */
    set emailPreferences(value: BigqueryDataTransferConfigEmailPreferences[]);
    /**
     * @stability stable
     */
    resetEmailPreferences(): void;
    /**
     * @stability stable
     */
    get emailPreferencesInput(): BigqueryDataTransferConfigEmailPreferences[] | undefined;
    private _scheduleOptions?;
    /**
     * @stability stable
     */
    get scheduleOptions(): BigqueryDataTransferConfigScheduleOptions[];
    /**
     * @stability stable
     */
    set scheduleOptions(value: BigqueryDataTransferConfigScheduleOptions[]);
    /**
     * @stability stable
     */
    resetScheduleOptions(): void;
    /**
     * @stability stable
     */
    get scheduleOptionsInput(): BigqueryDataTransferConfigScheduleOptions[] | undefined;
    private _sensitiveParams?;
    /**
     * @stability stable
     */
    get sensitiveParams(): BigqueryDataTransferConfigSensitiveParams[];
    /**
     * @stability stable
     */
    set sensitiveParams(value: BigqueryDataTransferConfigSensitiveParams[]);
    /**
     * @stability stable
     */
    resetSensitiveParams(): void;
    /**
     * @stability stable
     */
    get sensitiveParamsInput(): BigqueryDataTransferConfigSensitiveParams[] | undefined;
    private _timeouts?;
    /**
     * @stability stable
     */
    get timeouts(): BigqueryDataTransferConfigTimeouts;
    /**
     * @stability stable
     */
    set timeouts(value: BigqueryDataTransferConfigTimeouts);
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): BigqueryDataTransferConfigTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
