import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface BigqueryDatasetAccessAConfig extends cdktf.TerraformMetaArguments {
    /**
     * A unique ID for this dataset, without the project name.
     *
     * The ID
     * must contain only letters (a-z, A-Z), numbers (0-9), or
     * underscores (_). The maximum length is 1,024 characters.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_dataset_access.html#dataset_id BigqueryDatasetAccessA#dataset_id}
     *
     * @stability stable
     */
    readonly datasetId: string;
    /**
     * A domain to grant access to. Any users signed in with the domain specified will be granted the specified access.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_dataset_access.html#domain BigqueryDatasetAccessA#domain}
     *
     * @stability stable
     */
    readonly domain?: string;
    /**
     * An email address of a Google Group to grant access to.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_dataset_access.html#group_by_email BigqueryDatasetAccessA#group_by_email}
     *
     * @stability stable
     */
    readonly groupByEmail?: string;
    /**
     * Some other type of member that appears in the IAM Policy but isn't a user, group, domain, or special group.
     *
     * For example: 'allUsers'
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_dataset_access.html#iam_member BigqueryDatasetAccessA#iam_member}
     *
     * @stability stable
     */
    readonly iamMember?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_dataset_access.html#project BigqueryDatasetAccessA#project}.
     *
     * @stability stable
     */
    readonly project?: string;
    /**
     * Describes the rights granted to the user specified by the other member of the access object.
     *
     * Basic, predefined, and custom roles are
     * supported. Predefined roles that have equivalent basic roles are
     * swapped by the API to their basic counterparts, and will show a diff
     * post-create. See
     * [official docs](https://cloud.google.com/bigquery/docs/access-control).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_dataset_access.html#role BigqueryDatasetAccessA#role}
     *
     * @stability stable
     */
    readonly role?: string;
    /**
     * A special group to grant access to. Possible values include:.
     *
     * 'projectOwners': Owners of the enclosing project.
     *
     *
     * 'projectReaders': Readers of the enclosing project.
     *
     *
     * 'projectWriters': Writers of the enclosing project.
     *
     *
     * 'allAuthenticatedUsers': All authenticated BigQuery users.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_dataset_access.html#special_group BigqueryDatasetAccessA#special_group}
     *
     * @stability stable
     */
    readonly specialGroup?: string;
    /**
     * An email address of a user to grant access to. For example: fred@example.com.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_dataset_access.html#user_by_email BigqueryDatasetAccessA#user_by_email}
     *
     * @stability stable
     */
    readonly userByEmail?: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_dataset_access.html#timeouts BigqueryDatasetAccessA#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: BigqueryDatasetAccessTimeouts;
    /**
     * view block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_dataset_access.html#view BigqueryDatasetAccessA#view}
     *
     * @stability stable
     */
    readonly view?: BigqueryDatasetAccessViewA[];
}
/**
 * @stability stable
 */
export interface BigqueryDatasetAccessTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_dataset_access.html#create BigqueryDatasetAccessA#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_dataset_access.html#delete BigqueryDatasetAccessA#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
}
/**
 * @stability stable
 */
export interface BigqueryDatasetAccessViewA {
    /**
     * The ID of the dataset containing this table.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_dataset_access.html#dataset_id BigqueryDatasetAccessA#dataset_id}
     *
     * @stability stable
     */
    readonly datasetId: string;
    /**
     * The ID of the project containing this table.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_dataset_access.html#project_id BigqueryDatasetAccessA#project_id}
     *
     * @stability stable
     */
    readonly projectId: string;
    /**
     * The ID of the table.
     *
     * The ID must contain only letters (a-z,
     * A-Z), numbers (0-9), or underscores (_). The maximum length
     * is 1,024 characters.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_dataset_access.html#table_id BigqueryDatasetAccessA#table_id}
     *
     * @stability stable
     */
    readonly tableId: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/bigquery_dataset_access.html google_bigquery_dataset_access}.
 *
 * @stability stable
 */
export declare class BigqueryDatasetAccessA extends cdktf.TerraformResource {
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/bigquery_dataset_access.html google_bigquery_dataset_access} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: BigqueryDatasetAccessAConfig);
    /**
     * @stability stable
     */
    get apiUpdatedMember(): boolean;
    private _datasetId;
    /**
     * @stability stable
     */
    get datasetId(): string;
    /**
     * @stability stable
     */
    set datasetId(value: string);
    /**
     * @stability stable
     */
    get datasetIdInput(): string;
    private _domain?;
    /**
     * @stability stable
     */
    get domain(): string;
    /**
     * @stability stable
     */
    set domain(value: string);
    /**
     * @stability stable
     */
    resetDomain(): void;
    /**
     * @stability stable
     */
    get domainInput(): string | undefined;
    private _groupByEmail?;
    /**
     * @stability stable
     */
    get groupByEmail(): string;
    /**
     * @stability stable
     */
    set groupByEmail(value: string);
    /**
     * @stability stable
     */
    resetGroupByEmail(): void;
    /**
     * @stability stable
     */
    get groupByEmailInput(): string | undefined;
    private _iamMember?;
    /**
     * @stability stable
     */
    get iamMember(): string;
    /**
     * @stability stable
     */
    set iamMember(value: string);
    /**
     * @stability stable
     */
    resetIamMember(): void;
    /**
     * @stability stable
     */
    get iamMemberInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string;
    /**
     * @stability stable
     */
    set project(value: string);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    private _role?;
    /**
     * @stability stable
     */
    get role(): string;
    /**
     * @stability stable
     */
    set role(value: string);
    /**
     * @stability stable
     */
    resetRole(): void;
    /**
     * @stability stable
     */
    get roleInput(): string | undefined;
    private _specialGroup?;
    /**
     * @stability stable
     */
    get specialGroup(): string;
    /**
     * @stability stable
     */
    set specialGroup(value: string);
    /**
     * @stability stable
     */
    resetSpecialGroup(): void;
    /**
     * @stability stable
     */
    get specialGroupInput(): string | undefined;
    private _userByEmail?;
    /**
     * @stability stable
     */
    get userByEmail(): string;
    /**
     * @stability stable
     */
    set userByEmail(value: string);
    /**
     * @stability stable
     */
    resetUserByEmail(): void;
    /**
     * @stability stable
     */
    get userByEmailInput(): string | undefined;
    private _timeouts?;
    /**
     * @stability stable
     */
    get timeouts(): BigqueryDatasetAccessTimeouts;
    /**
     * @stability stable
     */
    set timeouts(value: BigqueryDatasetAccessTimeouts);
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): BigqueryDatasetAccessTimeouts | undefined;
    private _view?;
    /**
     * @stability stable
     */
    get view(): BigqueryDatasetAccessViewA[];
    /**
     * @stability stable
     */
    set view(value: BigqueryDatasetAccessViewA[]);
    /**
     * @stability stable
     */
    resetView(): void;
    /**
     * @stability stable
     */
    get viewInput(): BigqueryDatasetAccessViewA[] | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
