import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface BigqueryJobConfig extends cdktf.TerraformMetaArguments {
    /**
     * The ID of the job.
     *
     * The ID must contain only letters (a-z, A-Z), numbers (0-9), underscores (_), or dashes (-). The maximum length is 1,024 characters.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job.html#job_id BigqueryJob#job_id}
     *
     * @stability stable
     */
    readonly jobId: string;
    /**
     * Job timeout in milliseconds. If this time limit is exceeded, BigQuery may attempt to terminate the job.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job.html#job_timeout_ms BigqueryJob#job_timeout_ms}
     *
     * @stability stable
     */
    readonly jobTimeoutMs?: string;
    /**
     * The labels associated with this job. You can use these to organize and group your jobs.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job.html#labels BigqueryJob#labels}
     *
     * @stability stable
     */
    readonly labels?: {
        [key: string]: string;
    };
    /**
     * The geographic location of the job. The default value is US.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job.html#location BigqueryJob#location}
     *
     * @stability stable
     */
    readonly location?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job.html#project BigqueryJob#project}.
     *
     * @stability stable
     */
    readonly project?: string;
    /**
     * copy block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job.html#copy BigqueryJob#copy}
     *
     * @stability stable
     */
    readonly copy?: BigqueryJobCopy[];
    /**
     * extract block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job.html#extract BigqueryJob#extract}
     *
     * @stability stable
     */
    readonly extract?: BigqueryJobExtract[];
    /**
     * load block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job.html#load BigqueryJob#load}
     *
     * @stability stable
     */
    readonly load?: BigqueryJobLoad[];
    /**
     * query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job.html#query BigqueryJob#query}
     *
     * @stability stable
     */
    readonly query?: BigqueryJobQuery[];
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job.html#timeouts BigqueryJob#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: BigqueryJobTimeouts;
}
/**
 * @stability stable
 */
export declare class BigqueryJobStatusErrorResult extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get location(): string;
    /**
     * @stability stable
     */
    get message(): string;
    /**
     * @stability stable
     */
    get reason(): string;
}
/**
 * @stability stable
 */
export declare class BigqueryJobStatusErrors extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get location(): string;
    /**
     * @stability stable
     */
    get message(): string;
    /**
     * @stability stable
     */
    get reason(): string;
}
/**
 * @stability stable
 */
export declare class BigqueryJobStatus extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get errorResult(): any;
    /**
     * @stability stable
     */
    get errors(): any;
    /**
     * @stability stable
     */
    get state(): string;
}
/**
 * @stability stable
 */
export interface BigqueryJobCopyDestinationEncryptionConfiguration {
    /**
     * Describes the Cloud KMS encryption key that will be used to protect destination BigQuery table.
     *
     * The BigQuery Service Account associated with your project requires access to this encryption key.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job.html#kms_key_name BigqueryJob#kms_key_name}
     *
     * @stability stable
     */
    readonly kmsKeyName: string;
}
/**
 * @stability stable
 */
export interface BigqueryJobCopyDestinationTable {
    /**
     * The ID of the dataset containing this table.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job.html#dataset_id BigqueryJob#dataset_id}
     *
     * @stability stable
     */
    readonly datasetId?: string;
    /**
     * The ID of the project containing this table.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job.html#project_id BigqueryJob#project_id}
     *
     * @stability stable
     */
    readonly projectId?: string;
    /**
     * The table. Can be specified '{{table_id}}' if 'project_id' and 'dataset_id' are also set, or of the form 'projects/{{project}}/datasets/{{dataset_id}}/tables/{{table_id}}' if not.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job.html#table_id BigqueryJob#table_id}
     *
     * @stability stable
     */
    readonly tableId: string;
}
/**
 * @stability stable
 */
export interface BigqueryJobCopySourceTables {
    /**
     * The ID of the dataset containing this table.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job.html#dataset_id BigqueryJob#dataset_id}
     *
     * @stability stable
     */
    readonly datasetId?: string;
    /**
     * The ID of the project containing this table.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job.html#project_id BigqueryJob#project_id}
     *
     * @stability stable
     */
    readonly projectId?: string;
    /**
     * The table. Can be specified '{{table_id}}' if 'project_id' and 'dataset_id' are also set, or of the form 'projects/{{project}}/datasets/{{dataset_id}}/tables/{{table_id}}' if not.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job.html#table_id BigqueryJob#table_id}
     *
     * @stability stable
     */
    readonly tableId: string;
}
/**
 * @stability stable
 */
export interface BigqueryJobCopy {
    /**
     * Specifies whether the job is allowed to create new tables.
     *
     * The following values are supported:
     * CREATE_IF_NEEDED: If the table does not exist, BigQuery creates the table.
     * CREATE_NEVER: The table must already exist. If it does not, a 'notFound' error is returned in the job result.
     * Creation, truncation and append actions occur as one atomic update upon job completion Default value: "CREATE_IF_NEEDED" Possible values: ["CREATE_IF_NEEDED", "CREATE_NEVER"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job.html#create_disposition BigqueryJob#create_disposition}
     *
     * @stability stable
     */
    readonly createDisposition?: string;
    /**
     * Specifies the action that occurs if the destination table already exists.
     *
     * The following values are supported:
     * WRITE_TRUNCATE: If the table already exists, BigQuery overwrites the table data and uses the schema from the query result.
     * WRITE_APPEND: If the table already exists, BigQuery appends the data to the table.
     * WRITE_EMPTY: If the table already exists and contains data, a 'duplicate' error is returned in the job result.
     * Each action is atomic and only occurs if BigQuery is able to complete the job successfully.
     * Creation, truncation and append actions occur as one atomic update upon job completion. Default value: "WRITE_EMPTY" Possible values: ["WRITE_TRUNCATE", "WRITE_APPEND", "WRITE_EMPTY"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job.html#write_disposition BigqueryJob#write_disposition}
     *
     * @stability stable
     */
    readonly writeDisposition?: string;
    /**
     * destination_encryption_configuration block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job.html#destination_encryption_configuration BigqueryJob#destination_encryption_configuration}
     *
     * @stability stable
     */
    readonly destinationEncryptionConfiguration?: BigqueryJobCopyDestinationEncryptionConfiguration[];
    /**
     * destination_table block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job.html#destination_table BigqueryJob#destination_table}
     *
     * @stability stable
     */
    readonly destinationTable?: BigqueryJobCopyDestinationTable[];
    /**
     * source_tables block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job.html#source_tables BigqueryJob#source_tables}
     *
     * @stability stable
     */
    readonly sourceTables: BigqueryJobCopySourceTables[];
}
/**
 * @stability stable
 */
export interface BigqueryJobExtractSourceModel {
    /**
     * The ID of the dataset containing this model.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job.html#dataset_id BigqueryJob#dataset_id}
     *
     * @stability stable
     */
    readonly datasetId: string;
    /**
     * The ID of the model.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job.html#model_id BigqueryJob#model_id}
     *
     * @stability stable
     */
    readonly modelId: string;
    /**
     * The ID of the project containing this model.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job.html#project_id BigqueryJob#project_id}
     *
     * @stability stable
     */
    readonly projectId: string;
}
/**
 * @stability stable
 */
export interface BigqueryJobExtractSourceTable {
    /**
     * The ID of the dataset containing this table.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job.html#dataset_id BigqueryJob#dataset_id}
     *
     * @stability stable
     */
    readonly datasetId?: string;
    /**
     * The ID of the project containing this table.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job.html#project_id BigqueryJob#project_id}
     *
     * @stability stable
     */
    readonly projectId?: string;
    /**
     * The table. Can be specified '{{table_id}}' if 'project_id' and 'dataset_id' are also set, or of the form 'projects/{{project}}/datasets/{{dataset_id}}/tables/{{table_id}}' if not.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job.html#table_id BigqueryJob#table_id}
     *
     * @stability stable
     */
    readonly tableId: string;
}
/**
 * @stability stable
 */
export interface BigqueryJobExtract {
    /**
     * The compression type to use for exported files.
     *
     * Possible values include GZIP, DEFLATE, SNAPPY, and NONE.
     * The default value is NONE. DEFLATE and SNAPPY are only supported for Avro.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job.html#compression BigqueryJob#compression}
     *
     * @stability stable
     */
    readonly compression?: string;
    /**
     * The exported file format.
     *
     * Possible values include CSV, NEWLINE_DELIMITED_JSON and AVRO for tables and SAVED_MODEL for models.
     * The default value for tables is CSV. Tables with nested or repeated fields cannot be exported as CSV.
     * The default value for models is SAVED_MODEL.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job.html#destination_format BigqueryJob#destination_format}
     *
     * @stability stable
     */
    readonly destinationFormat?: string;
    /**
     * A list of fully-qualified Google Cloud Storage URIs where the extracted table should be written.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job.html#destination_uris BigqueryJob#destination_uris}
     *
     * @stability stable
     */
    readonly destinationUris: string[];
    /**
     * When extracting data in CSV format, this defines the delimiter to use between fields in the exported data.
     *
     * Default is ','
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job.html#field_delimiter BigqueryJob#field_delimiter}
     *
     * @stability stable
     */
    readonly fieldDelimiter?: string;
    /**
     * Whether to print out a header row in the results. Default is true.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job.html#print_header BigqueryJob#print_header}
     *
     * @stability stable
     */
    readonly printHeader?: boolean;
    /**
     * Whether to use logical types when extracting to AVRO format.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job.html#use_avro_logical_types BigqueryJob#use_avro_logical_types}
     *
     * @stability stable
     */
    readonly useAvroLogicalTypes?: boolean;
    /**
     * source_model block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job.html#source_model BigqueryJob#source_model}
     *
     * @stability stable
     */
    readonly sourceModel?: BigqueryJobExtractSourceModel[];
    /**
     * source_table block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job.html#source_table BigqueryJob#source_table}
     *
     * @stability stable
     */
    readonly sourceTable?: BigqueryJobExtractSourceTable[];
}
/**
 * @stability stable
 */
export interface BigqueryJobLoadDestinationEncryptionConfiguration {
    /**
     * Describes the Cloud KMS encryption key that will be used to protect destination BigQuery table.
     *
     * The BigQuery Service Account associated with your project requires access to this encryption key.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job.html#kms_key_name BigqueryJob#kms_key_name}
     *
     * @stability stable
     */
    readonly kmsKeyName: string;
}
/**
 * @stability stable
 */
export interface BigqueryJobLoadDestinationTable {
    /**
     * The ID of the dataset containing this table.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job.html#dataset_id BigqueryJob#dataset_id}
     *
     * @stability stable
     */
    readonly datasetId?: string;
    /**
     * The ID of the project containing this table.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job.html#project_id BigqueryJob#project_id}
     *
     * @stability stable
     */
    readonly projectId?: string;
    /**
     * The table. Can be specified '{{table_id}}' if 'project_id' and 'dataset_id' are also set, or of the form 'projects/{{project}}/datasets/{{dataset_id}}/tables/{{table_id}}' if not.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job.html#table_id BigqueryJob#table_id}
     *
     * @stability stable
     */
    readonly tableId: string;
}
/**
 * @stability stable
 */
export interface BigqueryJobLoadTimePartitioning {
    /**
     * Number of milliseconds for which to keep the storage for a partition.
     *
     * A wrapper is used here because 0 is an invalid value.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job.html#expiration_ms BigqueryJob#expiration_ms}
     *
     * @stability stable
     */
    readonly expirationMs?: string;
    /**
     * If not set, the table is partitioned by pseudo column '_PARTITIONTIME';
     *
     * if set, the table is partitioned by this field.
     * The field must be a top-level TIMESTAMP or DATE field. Its mode must be NULLABLE or REQUIRED.
     * A wrapper is used here because an empty string is an invalid value.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job.html#field BigqueryJob#field}
     *
     * @stability stable
     */
    readonly field?: string;
    /**
     * The only type supported is DAY, which will generate one partition per day.
     *
     * Providing an empty string used to cause an error,
     * but in OnePlatform the field will be treated as unset.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job.html#type BigqueryJob#type}
     *
     * @stability stable
     */
    readonly type: string;
}
/**
 * @stability stable
 */
export interface BigqueryJobLoad {
    /**
     * Accept rows that are missing trailing optional columns.
     *
     * The missing values are treated as nulls.
     * If false, records with missing trailing columns are treated as bad records, and if there are too many bad records,
     * an invalid error is returned in the job result. The default value is false. Only applicable to CSV, ignored for other formats.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job.html#allow_jagged_rows BigqueryJob#allow_jagged_rows}
     *
     * @stability stable
     */
    readonly allowJaggedRows?: boolean;
    /**
     * Indicates if BigQuery should allow quoted data sections that contain newline characters in a CSV file.
     *
     * The default value is false.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job.html#allow_quoted_newlines BigqueryJob#allow_quoted_newlines}
     *
     * @stability stable
     */
    readonly allowQuotedNewlines?: boolean;
    /**
     * Indicates if we should automatically infer the options and schema for CSV and JSON sources.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job.html#autodetect BigqueryJob#autodetect}
     *
     * @stability stable
     */
    readonly autodetect?: boolean;
    /**
     * Specifies whether the job is allowed to create new tables.
     *
     * The following values are supported:
     * CREATE_IF_NEEDED: If the table does not exist, BigQuery creates the table.
     * CREATE_NEVER: The table must already exist. If it does not, a 'notFound' error is returned in the job result.
     * Creation, truncation and append actions occur as one atomic update upon job completion Default value: "CREATE_IF_NEEDED" Possible values: ["CREATE_IF_NEEDED", "CREATE_NEVER"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job.html#create_disposition BigqueryJob#create_disposition}
     *
     * @stability stable
     */
    readonly createDisposition?: string;
    /**
     * The character encoding of the data.
     *
     * The supported values are UTF-8 or ISO-8859-1.
     * The default value is UTF-8. BigQuery decodes the data after the raw, binary data
     * has been split using the values of the quote and fieldDelimiter properties.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job.html#encoding BigqueryJob#encoding}
     *
     * @stability stable
     */
    readonly encoding?: string;
    /**
     * The separator for fields in a CSV file.
     *
     * The separator can be any ISO-8859-1 single-byte character.
     * To use a character in the range 128-255, you must encode the character as UTF8. BigQuery converts
     * the string to ISO-8859-1 encoding, and then uses the first byte of the encoded string to split the
     * data in its raw, binary state. BigQuery also supports the escape sequence "\t" to specify a tab separator.
     * The default value is a comma (',').
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job.html#field_delimiter BigqueryJob#field_delimiter}
     *
     * @stability stable
     */
    readonly fieldDelimiter?: string;
    /**
     * Indicates if BigQuery should allow extra values that are not represented in the table schema.
     *
     * If true, the extra values are ignored. If false, records with extra columns are treated as bad records,
     * and if there are too many bad records, an invalid error is returned in the job result.
     * The default value is false. The sourceFormat property determines what BigQuery treats as an extra value:
     * CSV: Trailing columns
     * JSON: Named values that don't match any column names
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job.html#ignore_unknown_values BigqueryJob#ignore_unknown_values}
     *
     * @stability stable
     */
    readonly ignoreUnknownValues?: boolean;
    /**
     * The maximum number of bad records that BigQuery can ignore when running the job.
     *
     * If the number of bad records exceeds this value,
     * an invalid error is returned in the job result. The default value is 0, which requires that all records are valid.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job.html#max_bad_records BigqueryJob#max_bad_records}
     *
     * @stability stable
     */
    readonly maxBadRecords?: number;
    /**
     * Specifies a string that represents a null value in a CSV file.
     *
     * For example, if you specify "\N", BigQuery interprets "\N" as a null value
     * when loading a CSV file. The default value is the empty string. If you set this property to a custom value, BigQuery throws an error if an
     * empty string is present for all data types except for STRING and BYTE. For STRING and BYTE columns, BigQuery interprets the empty string as
     * an empty value.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job.html#null_marker BigqueryJob#null_marker}
     *
     * @stability stable
     */
    readonly nullMarker?: string;
    /**
     * If sourceFormat is set to "DATASTORE_BACKUP", indicates which entity properties to load into BigQuery from a Cloud Datastore backup.
     *
     * Property names are case sensitive and must be top-level properties. If no properties are specified, BigQuery loads all properties.
     * If any named property isn't found in the Cloud Datastore backup, an invalid error is returned in the job result.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job.html#projection_fields BigqueryJob#projection_fields}
     *
     * @stability stable
     */
    readonly projectionFields?: string[];
    /**
     * The value that is used to quote data sections in a CSV file.
     *
     * BigQuery converts the string to ISO-8859-1 encoding,
     * and then uses the first byte of the encoded string to split the data in its raw, binary state.
     * The default value is a double-quote ('"'). If your data does not contain quoted sections, set the property value to an empty string.
     * If your data contains quoted newline characters, you must also set the allowQuotedNewlines property to true.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job.html#quote BigqueryJob#quote}
     *
     * @stability stable
     */
    readonly quote?: string;
    /**
     * Allows the schema of the destination table to be updated as a side effect of the load job if a schema is autodetected or supplied in the job configuration.
     *
     * Schema update options are supported in two cases: when writeDisposition is WRITE_APPEND;
     * when writeDisposition is WRITE_TRUNCATE and the destination table is a partition of a table, specified by partition decorators.
     * For normal tables, WRITE_TRUNCATE will always overwrite the schema. One or more of the following values are specified:
     * ALLOW_FIELD_ADDITION: allow adding a nullable field to the schema.
     * ALLOW_FIELD_RELAXATION: allow relaxing a required field in the original schema to nullable.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job.html#schema_update_options BigqueryJob#schema_update_options}
     *
     * @stability stable
     */
    readonly schemaUpdateOptions?: string[];
    /**
     * The number of rows at the top of a CSV file that BigQuery will skip when loading the data.
     *
     * The default value is 0. This property is useful if you have header rows in the file that should be skipped.
     * When autodetect is on, the behavior is the following:
     * skipLeadingRows unspecified - Autodetect tries to detect headers in the first row. If they are not detected,
     * the row is read as data. Otherwise data is read starting from the second row.
     * skipLeadingRows is 0 - Instructs autodetect that there are no headers and data should be read starting from the first row.
     * skipLeadingRows = N > 0 - Autodetect skips N-1 rows and tries to detect headers in row N. If headers are not detected,
     * row N is just skipped. Otherwise row N is used to extract column names for the detected schema.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job.html#skip_leading_rows BigqueryJob#skip_leading_rows}
     *
     * @stability stable
     */
    readonly skipLeadingRows?: number;
    /**
     * The format of the data files.
     *
     * For CSV files, specify "CSV". For datastore backups, specify "DATASTORE_BACKUP".
     * For newline-delimited JSON, specify "NEWLINE_DELIMITED_JSON". For Avro, specify "AVRO". For parquet, specify "PARQUET".
     * For orc, specify "ORC". [Beta] For Bigtable, specify "BIGTABLE".
     * The default value is CSV.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job.html#source_format BigqueryJob#source_format}
     *
     * @stability stable
     */
    readonly sourceFormat?: string;
    /**
     * The fully-qualified URIs that point to your data in Google Cloud.
     *
     * For Google Cloud Storage URIs: Each URI can contain one '*' wildcard character
     * and it must come after the 'bucket' name. Size limits related to load jobs apply
     * to external data sources. For Google Cloud Bigtable URIs: Exactly one URI can be
     * specified and it has be a fully specified and valid HTTPS URL for a Google Cloud Bigtable table.
     * For Google Cloud Datastore backups: Exactly one URI can be specified. Also, the '*' wildcard character is not allowed.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job.html#source_uris BigqueryJob#source_uris}
     *
     * @stability stable
     */
    readonly sourceUris: string[];
    /**
     * Specifies the action that occurs if the destination table already exists.
     *
     * The following values are supported:
     * WRITE_TRUNCATE: If the table already exists, BigQuery overwrites the table data and uses the schema from the query result.
     * WRITE_APPEND: If the table already exists, BigQuery appends the data to the table.
     * WRITE_EMPTY: If the table already exists and contains data, a 'duplicate' error is returned in the job result.
     * Each action is atomic and only occurs if BigQuery is able to complete the job successfully.
     * Creation, truncation and append actions occur as one atomic update upon job completion. Default value: "WRITE_EMPTY" Possible values: ["WRITE_TRUNCATE", "WRITE_APPEND", "WRITE_EMPTY"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job.html#write_disposition BigqueryJob#write_disposition}
     *
     * @stability stable
     */
    readonly writeDisposition?: string;
    /**
     * destination_encryption_configuration block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job.html#destination_encryption_configuration BigqueryJob#destination_encryption_configuration}
     *
     * @stability stable
     */
    readonly destinationEncryptionConfiguration?: BigqueryJobLoadDestinationEncryptionConfiguration[];
    /**
     * destination_table block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job.html#destination_table BigqueryJob#destination_table}
     *
     * @stability stable
     */
    readonly destinationTable: BigqueryJobLoadDestinationTable[];
    /**
     * time_partitioning block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job.html#time_partitioning BigqueryJob#time_partitioning}
     *
     * @stability stable
     */
    readonly timePartitioning?: BigqueryJobLoadTimePartitioning[];
}
/**
 * @stability stable
 */
export interface BigqueryJobQueryDefaultDataset {
    /**
     * The dataset. Can be specified '{{dataset_id}}' if 'project_id' is also set, or of the form 'projects/{{project}}/datasets/{{dataset_id}}' if not.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job.html#dataset_id BigqueryJob#dataset_id}
     *
     * @stability stable
     */
    readonly datasetId: string;
    /**
     * The ID of the project containing this table.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job.html#project_id BigqueryJob#project_id}
     *
     * @stability stable
     */
    readonly projectId?: string;
}
/**
 * @stability stable
 */
export interface BigqueryJobQueryDestinationEncryptionConfiguration {
    /**
     * Describes the Cloud KMS encryption key that will be used to protect destination BigQuery table.
     *
     * The BigQuery Service Account associated with your project requires access to this encryption key.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job.html#kms_key_name BigqueryJob#kms_key_name}
     *
     * @stability stable
     */
    readonly kmsKeyName: string;
}
/**
 * @stability stable
 */
export interface BigqueryJobQueryDestinationTable {
    /**
     * The ID of the dataset containing this table.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job.html#dataset_id BigqueryJob#dataset_id}
     *
     * @stability stable
     */
    readonly datasetId?: string;
    /**
     * The ID of the project containing this table.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job.html#project_id BigqueryJob#project_id}
     *
     * @stability stable
     */
    readonly projectId?: string;
    /**
     * The table. Can be specified '{{table_id}}' if 'project_id' and 'dataset_id' are also set, or of the form 'projects/{{project}}/datasets/{{dataset_id}}/tables/{{table_id}}' if not.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job.html#table_id BigqueryJob#table_id}
     *
     * @stability stable
     */
    readonly tableId: string;
}
/**
 * @stability stable
 */
export interface BigqueryJobQueryScriptOptions {
    /**
     * Determines which statement in the script represents the "key result", used to populate the schema and query results of the script job.
     *
     * Possible values: ["LAST", "FIRST_SELECT"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job.html#key_result_statement BigqueryJob#key_result_statement}
     *
     * @stability stable
     */
    readonly keyResultStatement?: string;
    /**
     * Limit on the number of bytes billed per statement. Exceeding this budget results in an error.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job.html#statement_byte_budget BigqueryJob#statement_byte_budget}
     *
     * @stability stable
     */
    readonly statementByteBudget?: string;
    /**
     * Timeout period for each statement in a script.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job.html#statement_timeout_ms BigqueryJob#statement_timeout_ms}
     *
     * @stability stable
     */
    readonly statementTimeoutMs?: string;
}
/**
 * @stability stable
 */
export interface BigqueryJobQueryUserDefinedFunctionResources {
    /**
     * An inline resource that contains code for a user-defined function (UDF).
     *
     * Providing a inline code resource is equivalent to providing a URI for a file containing the same code.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job.html#inline_code BigqueryJob#inline_code}
     *
     * @stability stable
     */
    readonly inlineCode?: string;
    /**
     * A code resource to load from a Google Cloud Storage URI (gs://bucket/path).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job.html#resource_uri BigqueryJob#resource_uri}
     *
     * @stability stable
     */
    readonly resourceUri?: string;
}
/**
 * @stability stable
 */
export interface BigqueryJobQuery {
    /**
     * If true and query uses legacy SQL dialect, allows the query to produce arbitrarily large result tables at a slight cost in performance.
     *
     * Requires destinationTable to be set. For standard SQL queries, this flag is ignored and large results are always allowed.
     * However, you must still set destinationTable when result size exceeds the allowed maximum response size.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job.html#allow_large_results BigqueryJob#allow_large_results}
     *
     * @stability stable
     */
    readonly allowLargeResults?: boolean;
    /**
     * Specifies whether the job is allowed to create new tables.
     *
     * The following values are supported:
     * CREATE_IF_NEEDED: If the table does not exist, BigQuery creates the table.
     * CREATE_NEVER: The table must already exist. If it does not, a 'notFound' error is returned in the job result.
     * Creation, truncation and append actions occur as one atomic update upon job completion Default value: "CREATE_IF_NEEDED" Possible values: ["CREATE_IF_NEEDED", "CREATE_NEVER"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job.html#create_disposition BigqueryJob#create_disposition}
     *
     * @stability stable
     */
    readonly createDisposition?: string;
    /**
     * If true and query uses legacy SQL dialect, flattens all nested and repeated fields in the query results.
     *
     * allowLargeResults must be true if this is set to false. For standard SQL queries, this flag is ignored and results are never flattened.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job.html#flatten_results BigqueryJob#flatten_results}
     *
     * @stability stable
     */
    readonly flattenResults?: boolean;
    /**
     * Limits the billing tier for this job.
     *
     * Queries that have resource usage beyond this tier will fail (without incurring a charge).
     * If unspecified, this will be set to your project default.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job.html#maximum_billing_tier BigqueryJob#maximum_billing_tier}
     *
     * @stability stable
     */
    readonly maximumBillingTier?: number;
    /**
     * Limits the bytes billed for this job.
     *
     * Queries that will have bytes billed beyond this limit will fail (without incurring a charge).
     * If unspecified, this will be set to your project default.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job.html#maximum_bytes_billed BigqueryJob#maximum_bytes_billed}
     *
     * @stability stable
     */
    readonly maximumBytesBilled?: string;
    /**
     * Standard SQL only.
     *
     * Set to POSITIONAL to use positional (?) query parameters or to NAMED to use named (@myparam) query parameters in this query.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job.html#parameter_mode BigqueryJob#parameter_mode}
     *
     * @stability stable
     */
    readonly parameterMode?: string;
    /**
     * Specifies a priority for the query. Default value: "INTERACTIVE" Possible values: ["INTERACTIVE", "BATCH"].
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job.html#priority BigqueryJob#priority}
     *
     * @stability stable
     */
    readonly priority?: string;
    /**
     * SQL query text to execute.
     *
     * The useLegacySql field can be used to indicate whether the query uses legacy SQL or standard SQL.
     * NOTE*: queries containing [DML language](https://cloud.google.com/bigquery/docs/reference/standard-sql/data-manipulation-language)
     * ('DELETE', 'UPDATE', 'MERGE', 'INSERT') must specify 'create_disposition = ""' and 'write_disposition = ""'.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job.html#query BigqueryJob#query}
     *
     * @stability stable
     */
    readonly query: string;
    /**
     * Allows the schema of the destination table to be updated as a side effect of the query job.
     *
     * Schema update options are supported in two cases: when writeDisposition is WRITE_APPEND;
     * when writeDisposition is WRITE_TRUNCATE and the destination table is a partition of a table,
     * specified by partition decorators. For normal tables, WRITE_TRUNCATE will always overwrite the schema.
     * One or more of the following values are specified:
     * ALLOW_FIELD_ADDITION: allow adding a nullable field to the schema.
     * ALLOW_FIELD_RELAXATION: allow relaxing a required field in the original schema to nullable.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job.html#schema_update_options BigqueryJob#schema_update_options}
     *
     * @stability stable
     */
    readonly schemaUpdateOptions?: string[];
    /**
     * Specifies whether to use BigQuery's legacy SQL dialect for this query.
     *
     * The default value is true.
     * If set to false, the query will use BigQuery's standard SQL.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job.html#use_legacy_sql BigqueryJob#use_legacy_sql}
     *
     * @stability stable
     */
    readonly useLegacySql?: boolean;
    /**
     * Whether to look for the result in the query cache.
     *
     * The query cache is a best-effort cache that will be flushed whenever
     * tables in the query are modified. Moreover, the query cache is only available when a query does not have a destination table specified.
     * The default value is true.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job.html#use_query_cache BigqueryJob#use_query_cache}
     *
     * @stability stable
     */
    readonly useQueryCache?: boolean;
    /**
     * Specifies the action that occurs if the destination table already exists.
     *
     * The following values are supported:
     * WRITE_TRUNCATE: If the table already exists, BigQuery overwrites the table data and uses the schema from the query result.
     * WRITE_APPEND: If the table already exists, BigQuery appends the data to the table.
     * WRITE_EMPTY: If the table already exists and contains data, a 'duplicate' error is returned in the job result.
     * Each action is atomic and only occurs if BigQuery is able to complete the job successfully.
     * Creation, truncation and append actions occur as one atomic update upon job completion. Default value: "WRITE_EMPTY" Possible values: ["WRITE_TRUNCATE", "WRITE_APPEND", "WRITE_EMPTY"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job.html#write_disposition BigqueryJob#write_disposition}
     *
     * @stability stable
     */
    readonly writeDisposition?: string;
    /**
     * default_dataset block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job.html#default_dataset BigqueryJob#default_dataset}
     *
     * @stability stable
     */
    readonly defaultDataset?: BigqueryJobQueryDefaultDataset[];
    /**
     * destination_encryption_configuration block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job.html#destination_encryption_configuration BigqueryJob#destination_encryption_configuration}
     *
     * @stability stable
     */
    readonly destinationEncryptionConfiguration?: BigqueryJobQueryDestinationEncryptionConfiguration[];
    /**
     * destination_table block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job.html#destination_table BigqueryJob#destination_table}
     *
     * @stability stable
     */
    readonly destinationTable?: BigqueryJobQueryDestinationTable[];
    /**
     * script_options block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job.html#script_options BigqueryJob#script_options}
     *
     * @stability stable
     */
    readonly scriptOptions?: BigqueryJobQueryScriptOptions[];
    /**
     * user_defined_function_resources block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job.html#user_defined_function_resources BigqueryJob#user_defined_function_resources}
     *
     * @stability stable
     */
    readonly userDefinedFunctionResources?: BigqueryJobQueryUserDefinedFunctionResources[];
}
/**
 * @stability stable
 */
export interface BigqueryJobTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job.html#create BigqueryJob#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job.html#delete BigqueryJob#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/bigquery_job.html google_bigquery_job}.
 *
 * @stability stable
 */
export declare class BigqueryJob extends cdktf.TerraformResource {
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/bigquery_job.html google_bigquery_job} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: BigqueryJobConfig);
    /**
     * @stability stable
     */
    get id(): string;
    private _jobId;
    /**
     * @stability stable
     */
    get jobId(): string;
    /**
     * @stability stable
     */
    set jobId(value: string);
    /**
     * @stability stable
     */
    get jobIdInput(): string;
    private _jobTimeoutMs?;
    /**
     * @stability stable
     */
    get jobTimeoutMs(): string;
    /**
     * @stability stable
     */
    set jobTimeoutMs(value: string);
    /**
     * @stability stable
     */
    resetJobTimeoutMs(): void;
    /**
     * @stability stable
     */
    get jobTimeoutMsInput(): string | undefined;
    /**
     * @stability stable
     */
    get jobType(): string;
    private _labels?;
    /**
     * @stability stable
     */
    get labels(): {
        [key: string]: string;
    };
    /**
     * @stability stable
     */
    set labels(value: {
        [key: string]: string;
    });
    /**
     * @stability stable
     */
    resetLabels(): void;
    /**
     * @stability stable
     */
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _location?;
    /**
     * @stability stable
     */
    get location(): string;
    /**
     * @stability stable
     */
    set location(value: string);
    /**
     * @stability stable
     */
    resetLocation(): void;
    /**
     * @stability stable
     */
    get locationInput(): string | undefined;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string;
    /**
     * @stability stable
     */
    set project(value: string);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    /**
     * @stability stable
     */
    status(index: string): BigqueryJobStatus;
    /**
     * @stability stable
     */
    get userEmail(): string;
    private _copy?;
    /**
     * @stability stable
     */
    get copy(): BigqueryJobCopy[];
    /**
     * @stability stable
     */
    set copy(value: BigqueryJobCopy[]);
    /**
     * @stability stable
     */
    resetCopy(): void;
    /**
     * @stability stable
     */
    get copyInput(): BigqueryJobCopy[] | undefined;
    private _extract?;
    /**
     * @stability stable
     */
    get extract(): BigqueryJobExtract[];
    /**
     * @stability stable
     */
    set extract(value: BigqueryJobExtract[]);
    /**
     * @stability stable
     */
    resetExtract(): void;
    /**
     * @stability stable
     */
    get extractInput(): BigqueryJobExtract[] | undefined;
    private _load?;
    /**
     * @stability stable
     */
    get load(): BigqueryJobLoad[];
    /**
     * @stability stable
     */
    set load(value: BigqueryJobLoad[]);
    /**
     * @stability stable
     */
    resetLoad(): void;
    /**
     * @stability stable
     */
    get loadInput(): BigqueryJobLoad[] | undefined;
    private _query?;
    /**
     * @stability stable
     */
    get query(): BigqueryJobQuery[];
    /**
     * @stability stable
     */
    set query(value: BigqueryJobQuery[]);
    /**
     * @stability stable
     */
    resetQuery(): void;
    /**
     * @stability stable
     */
    get queryInput(): BigqueryJobQuery[] | undefined;
    private _timeouts?;
    /**
     * @stability stable
     */
    get timeouts(): BigqueryJobTimeouts;
    /**
     * @stability stable
     */
    set timeouts(value: BigqueryJobTimeouts);
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): BigqueryJobTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
