import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface BigtableAppProfileConfig extends cdktf.TerraformMetaArguments {
    /**
     * The unique name of the app profile in the form '[_a-zA-Z0-9][-_.a-zA-Z0-9]*'.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigtable_app_profile.html#app_profile_id BigtableAppProfile#app_profile_id}
     *
     * @stability stable
     */
    readonly appProfileId: string;
    /**
     * Long form description of the use case for this app profile.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigtable_app_profile.html#description BigtableAppProfile#description}
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * If true, ignore safety checks when deleting/updating the app profile.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigtable_app_profile.html#ignore_warnings BigtableAppProfile#ignore_warnings}
     *
     * @stability stable
     */
    readonly ignoreWarnings?: boolean;
    /**
     * The name of the instance to create the app profile within.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigtable_app_profile.html#instance BigtableAppProfile#instance}
     *
     * @stability stable
     */
    readonly instance?: string;
    /**
     * If true, read/write requests are routed to the nearest cluster in the instance, and will fail over to the nearest cluster that is available in the event of transient errors or delays.
     *
     * Clusters in a region are considered equidistant. Choosing this option sacrifices read-your-writes
     * consistency to improve availability.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigtable_app_profile.html#multi_cluster_routing_use_any BigtableAppProfile#multi_cluster_routing_use_any}
     *
     * @stability stable
     */
    readonly multiClusterRoutingUseAny?: boolean;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigtable_app_profile.html#project BigtableAppProfile#project}.
     *
     * @stability stable
     */
    readonly project?: string;
    /**
     * single_cluster_routing block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigtable_app_profile.html#single_cluster_routing BigtableAppProfile#single_cluster_routing}
     *
     * @stability stable
     */
    readonly singleClusterRouting?: BigtableAppProfileSingleClusterRouting[];
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigtable_app_profile.html#timeouts BigtableAppProfile#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: BigtableAppProfileTimeouts;
}
/**
 * @stability stable
 */
export interface BigtableAppProfileSingleClusterRouting {
    /**
     * If true, CheckAndMutateRow and ReadModifyWriteRow requests are allowed by this app profile.
     *
     * It is unsafe to send these requests to the same table/row/column in multiple clusters.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigtable_app_profile.html#allow_transactional_writes BigtableAppProfile#allow_transactional_writes}
     *
     * @stability stable
     */
    readonly allowTransactionalWrites?: boolean;
    /**
     * The cluster to which read/write requests should be routed.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigtable_app_profile.html#cluster_id BigtableAppProfile#cluster_id}
     *
     * @stability stable
     */
    readonly clusterId: string;
}
/**
 * @stability stable
 */
export interface BigtableAppProfileTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigtable_app_profile.html#create BigtableAppProfile#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigtable_app_profile.html#delete BigtableAppProfile#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigtable_app_profile.html#update BigtableAppProfile#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/bigtable_app_profile.html google_bigtable_app_profile}.
 *
 * @stability stable
 */
export declare class BigtableAppProfile extends cdktf.TerraformResource {
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/bigtable_app_profile.html google_bigtable_app_profile} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: BigtableAppProfileConfig);
    private _appProfileId;
    /**
     * @stability stable
     */
    get appProfileId(): string;
    /**
     * @stability stable
     */
    set appProfileId(value: string);
    /**
     * @stability stable
     */
    get appProfileIdInput(): string;
    private _description?;
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    set description(value: string);
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _ignoreWarnings?;
    /**
     * @stability stable
     */
    get ignoreWarnings(): boolean;
    /**
     * @stability stable
     */
    set ignoreWarnings(value: boolean);
    /**
     * @stability stable
     */
    resetIgnoreWarnings(): void;
    /**
     * @stability stable
     */
    get ignoreWarningsInput(): boolean | undefined;
    private _instance?;
    /**
     * @stability stable
     */
    get instance(): string;
    /**
     * @stability stable
     */
    set instance(value: string);
    /**
     * @stability stable
     */
    resetInstance(): void;
    /**
     * @stability stable
     */
    get instanceInput(): string | undefined;
    private _multiClusterRoutingUseAny?;
    /**
     * @stability stable
     */
    get multiClusterRoutingUseAny(): boolean;
    /**
     * @stability stable
     */
    set multiClusterRoutingUseAny(value: boolean);
    /**
     * @stability stable
     */
    resetMultiClusterRoutingUseAny(): void;
    /**
     * @stability stable
     */
    get multiClusterRoutingUseAnyInput(): boolean | undefined;
    /**
     * @stability stable
     */
    get name(): string;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string;
    /**
     * @stability stable
     */
    set project(value: string);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    private _singleClusterRouting?;
    /**
     * @stability stable
     */
    get singleClusterRouting(): BigtableAppProfileSingleClusterRouting[];
    /**
     * @stability stable
     */
    set singleClusterRouting(value: BigtableAppProfileSingleClusterRouting[]);
    /**
     * @stability stable
     */
    resetSingleClusterRouting(): void;
    /**
     * @stability stable
     */
    get singleClusterRoutingInput(): BigtableAppProfileSingleClusterRouting[] | undefined;
    private _timeouts?;
    /**
     * @stability stable
     */
    get timeouts(): BigtableAppProfileTimeouts;
    /**
     * @stability stable
     */
    set timeouts(value: BigtableAppProfileTimeouts);
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): BigtableAppProfileTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
