import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface BillingBudgetConfig extends cdktf.TerraformMetaArguments {
    /**
     * ID of the billing account to set a budget on.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/billing_budget.html#billing_account BillingBudget#billing_account}
     *
     * @stability stable
     */
    readonly billingAccount: string;
    /**
     * User data for display name in UI. Must be <= 60 chars.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/billing_budget.html#display_name BillingBudget#display_name}
     *
     * @stability stable
     */
    readonly displayName?: string;
    /**
     * all_updates_rule block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/billing_budget.html#all_updates_rule BillingBudget#all_updates_rule}
     *
     * @stability stable
     */
    readonly allUpdatesRule?: BillingBudgetAllUpdatesRule[];
    /**
     * amount block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/billing_budget.html#amount BillingBudget#amount}
     *
     * @stability stable
     */
    readonly amount: BillingBudgetAmount[];
    /**
     * budget_filter block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/billing_budget.html#budget_filter BillingBudget#budget_filter}
     *
     * @stability stable
     */
    readonly budgetFilter?: BillingBudgetBudgetFilter[];
    /**
     * threshold_rules block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/billing_budget.html#threshold_rules BillingBudget#threshold_rules}
     *
     * @stability stable
     */
    readonly thresholdRules: BillingBudgetThresholdRules[];
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/billing_budget.html#timeouts BillingBudget#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: BillingBudgetTimeouts;
}
/**
 * @stability stable
 */
export interface BillingBudgetAllUpdatesRule {
    /**
     * Boolean.
     *
     * When set to true, disables default notifications sent
     * when a threshold is exceeded. Default recipients are
     * those with Billing Account Administrators and Billing
     * Account Users IAM roles for the target account.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/billing_budget.html#disable_default_iam_recipients BillingBudget#disable_default_iam_recipients}
     *
     * @stability stable
     */
    readonly disableDefaultIamRecipients?: boolean;
    /**
     * The full resource name of a monitoring notification channel in the form projects/{project_id}/notificationChannels/{channel_id}. A maximum of 5 channels are allowed.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/billing_budget.html#monitoring_notification_channels BillingBudget#monitoring_notification_channels}
     *
     * @stability stable
     */
    readonly monitoringNotificationChannels?: string[];
    /**
     * The name of the Cloud Pub/Sub topic where budget related messages will be published, in the form projects/{project_id}/topics/{topic_id}.
     *
     * Updates are sent
     * at regular intervals to the topic.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/billing_budget.html#pubsub_topic BillingBudget#pubsub_topic}
     *
     * @stability stable
     */
    readonly pubsubTopic?: string;
    /**
     * The schema version of the notification. Only "1.0" is accepted. It represents the JSON schema as defined in https://cloud.google.com/billing/docs/how-to/budgets#notification_format.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/billing_budget.html#schema_version BillingBudget#schema_version}
     *
     * @stability stable
     */
    readonly schemaVersion?: string;
}
/**
 * @stability stable
 */
export interface BillingBudgetAmountSpecifiedAmount {
    /**
     * The 3-letter currency code defined in ISO 4217.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/billing_budget.html#currency_code BillingBudget#currency_code}
     *
     * @stability stable
     */
    readonly currencyCode?: string;
    /**
     * Number of nano (10^-9) units of the amount.
     *
     * The value must be between -999,999,999 and +999,999,999
     * inclusive. If units is positive, nanos must be positive or
     * zero. If units is zero, nanos can be positive, zero, or
     * negative. If units is negative, nanos must be negative or
     * zero. For example $-1.75 is represented as units=-1 and
     * nanos=-750,000,000.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/billing_budget.html#nanos BillingBudget#nanos}
     *
     * @stability stable
     */
    readonly nanos?: number;
    /**
     * The whole units of the amount. For example if currencyCode is "USD", then 1 unit is one US dollar.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/billing_budget.html#units BillingBudget#units}
     *
     * @stability stable
     */
    readonly units?: string;
}
/**
 * @stability stable
 */
export interface BillingBudgetAmount {
    /**
     * Configures a budget amount that is automatically set to 100% of last period's spend.
     *
     * Boolean. Set value to true to use. Do not set to false, instead
     * use the 'specified_amount' block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/billing_budget.html#last_period_amount BillingBudget#last_period_amount}
     *
     * @stability stable
     */
    readonly lastPeriodAmount?: boolean;
    /**
     * specified_amount block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/billing_budget.html#specified_amount BillingBudget#specified_amount}
     *
     * @stability stable
     */
    readonly specifiedAmount?: BillingBudgetAmountSpecifiedAmount[];
}
/**
 * @stability stable
 */
export interface BillingBudgetBudgetFilter {
    /**
     * A set of subaccounts of the form billingAccounts/{account_id}, specifying that usage from only this set of subaccounts should be included in the budget.
     *
     * If a subaccount is set to the name of
     * the parent account, usage from the parent account will be included.
     * If the field is omitted, the report will include usage from the parent
     * account and all subaccounts, if they exist.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/billing_budget.html#credit_types BillingBudget#credit_types}
     *
     * @stability stable
     */
    readonly creditTypes?: string[];
    /**
     * Specifies how credits should be treated when determining spend for threshold calculations. Default value: "INCLUDE_ALL_CREDITS" Possible values: ["INCLUDE_ALL_CREDITS", "EXCLUDE_ALL_CREDITS", "INCLUDE_SPECIFIED_CREDITS"].
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/billing_budget.html#credit_types_treatment BillingBudget#credit_types_treatment}
     *
     * @stability stable
     */
    readonly creditTypesTreatment?: string;
    /**
     * A single label and value pair specifying that usage from only this set of labeled resources should be included in the budget.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/billing_budget.html#labels BillingBudget#labels}
     *
     * @stability stable
     */
    readonly labels?: {
        [key: string]: string;
    };
    /**
     * A set of projects of the form projects/{project_number}, specifying that usage from only this set of projects should be included in the budget.
     *
     * If omitted, the report will include
     * all usage for the billing account, regardless of which project
     * the usage occurred on.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/billing_budget.html#projects BillingBudget#projects}
     *
     * @stability stable
     */
    readonly projects?: string[];
    /**
     * A set of services of the form services/{service_id}, specifying that usage from only this set of services should be included in the budget.
     *
     * If omitted, the report will include
     * usage for all the services. The service names are available
     * through the Catalog API:
     * https://cloud.google.com/billing/v1/how-tos/catalog-api.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/billing_budget.html#services BillingBudget#services}
     *
     * @stability stable
     */
    readonly services?: string[];
    /**
     * A set of subaccounts of the form billingAccounts/{account_id}, specifying that usage from only this set of subaccounts should be included in the budget.
     *
     * If a subaccount is set to the name of
     * the parent account, usage from the parent account will be included.
     * If the field is omitted, the report will include usage from the parent
     * account and all subaccounts, if they exist.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/billing_budget.html#subaccounts BillingBudget#subaccounts}
     *
     * @stability stable
     */
    readonly subaccounts?: string[];
}
/**
 * @stability stable
 */
export interface BillingBudgetThresholdRules {
    /**
     * The type of basis used to determine if spend has passed the threshold. Default value: "CURRENT_SPEND" Possible values: ["CURRENT_SPEND", "FORECASTED_SPEND"].
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/billing_budget.html#spend_basis BillingBudget#spend_basis}
     *
     * @stability stable
     */
    readonly spendBasis?: string;
    /**
     * Send an alert when this threshold is exceeded.
     *
     * This is a
     * 1.0-based percentage, so 0.5 = 50%. Must be >= 0.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/billing_budget.html#threshold_percent BillingBudget#threshold_percent}
     *
     * @stability stable
     */
    readonly thresholdPercent: number;
}
/**
 * @stability stable
 */
export interface BillingBudgetTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/billing_budget.html#create BillingBudget#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/billing_budget.html#delete BillingBudget#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/billing_budget.html#update BillingBudget#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/billing_budget.html google_billing_budget}.
 *
 * @stability stable
 */
export declare class BillingBudget extends cdktf.TerraformResource {
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/billing_budget.html google_billing_budget} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: BillingBudgetConfig);
    private _billingAccount;
    /**
     * @stability stable
     */
    get billingAccount(): string;
    /**
     * @stability stable
     */
    set billingAccount(value: string);
    /**
     * @stability stable
     */
    get billingAccountInput(): string;
    private _displayName?;
    /**
     * @stability stable
     */
    get displayName(): string;
    /**
     * @stability stable
     */
    set displayName(value: string);
    /**
     * @stability stable
     */
    resetDisplayName(): void;
    /**
     * @stability stable
     */
    get displayNameInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get name(): string;
    private _allUpdatesRule?;
    /**
     * @stability stable
     */
    get allUpdatesRule(): BillingBudgetAllUpdatesRule[];
    /**
     * @stability stable
     */
    set allUpdatesRule(value: BillingBudgetAllUpdatesRule[]);
    /**
     * @stability stable
     */
    resetAllUpdatesRule(): void;
    /**
     * @stability stable
     */
    get allUpdatesRuleInput(): BillingBudgetAllUpdatesRule[] | undefined;
    private _amount;
    /**
     * @stability stable
     */
    get amount(): BillingBudgetAmount[];
    /**
     * @stability stable
     */
    set amount(value: BillingBudgetAmount[]);
    /**
     * @stability stable
     */
    get amountInput(): BillingBudgetAmount[];
    private _budgetFilter?;
    /**
     * @stability stable
     */
    get budgetFilter(): BillingBudgetBudgetFilter[];
    /**
     * @stability stable
     */
    set budgetFilter(value: BillingBudgetBudgetFilter[]);
    /**
     * @stability stable
     */
    resetBudgetFilter(): void;
    /**
     * @stability stable
     */
    get budgetFilterInput(): BillingBudgetBudgetFilter[] | undefined;
    private _thresholdRules;
    /**
     * @stability stable
     */
    get thresholdRules(): BillingBudgetThresholdRules[];
    /**
     * @stability stable
     */
    set thresholdRules(value: BillingBudgetThresholdRules[]);
    /**
     * @stability stable
     */
    get thresholdRulesInput(): BillingBudgetThresholdRules[];
    private _timeouts?;
    /**
     * @stability stable
     */
    get timeouts(): BillingBudgetTimeouts;
    /**
     * @stability stable
     */
    set timeouts(value: BillingBudgetTimeouts);
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): BillingBudgetTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
