import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface BinaryAuthorizationPolicyConfig extends cdktf.TerraformMetaArguments {
    /**
     * A descriptive comment.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/binary_authorization_policy.html#description BinaryAuthorizationPolicy#description}
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * Controls the evaluation of a Google-maintained global admission policy for common system-level images.
     *
     * Images not covered by the global
     * policy will be subject to the project admission policy. Possible values: ["ENABLE", "DISABLE"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/binary_authorization_policy.html#global_policy_evaluation_mode BinaryAuthorizationPolicy#global_policy_evaluation_mode}
     *
     * @stability stable
     */
    readonly globalPolicyEvaluationMode?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/binary_authorization_policy.html#project BinaryAuthorizationPolicy#project}.
     *
     * @stability stable
     */
    readonly project?: string;
    /**
     * admission_whitelist_patterns block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/binary_authorization_policy.html#admission_whitelist_patterns BinaryAuthorizationPolicy#admission_whitelist_patterns}
     *
     * @stability stable
     */
    readonly admissionWhitelistPatterns?: BinaryAuthorizationPolicyAdmissionWhitelistPatterns[];
    /**
     * cluster_admission_rules block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/binary_authorization_policy.html#cluster_admission_rules BinaryAuthorizationPolicy#cluster_admission_rules}
     *
     * @stability stable
     */
    readonly clusterAdmissionRules?: BinaryAuthorizationPolicyClusterAdmissionRules[];
    /**
     * default_admission_rule block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/binary_authorization_policy.html#default_admission_rule BinaryAuthorizationPolicy#default_admission_rule}
     *
     * @stability stable
     */
    readonly defaultAdmissionRule: BinaryAuthorizationPolicyDefaultAdmissionRule[];
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/binary_authorization_policy.html#timeouts BinaryAuthorizationPolicy#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: BinaryAuthorizationPolicyTimeouts;
}
/**
 * @stability stable
 */
export interface BinaryAuthorizationPolicyAdmissionWhitelistPatterns {
    /**
     * An image name pattern to whitelist, in the form 'registry/path/to/image'.
     *
     * This supports a trailing * as a
     * wildcard, but this is allowed only in text after the registry/
     * part.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/binary_authorization_policy.html#name_pattern BinaryAuthorizationPolicy#name_pattern}
     *
     * @stability stable
     */
    readonly namePattern: string;
}
/**
 * @stability stable
 */
export interface BinaryAuthorizationPolicyClusterAdmissionRules {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/binary_authorization_policy.html#cluster BinaryAuthorizationPolicy#cluster}.
     *
     * @stability stable
     */
    readonly cluster: string;
    /**
     * The action when a pod creation is denied by the admission rule. Possible values: ["ENFORCED_BLOCK_AND_AUDIT_LOG", "DRYRUN_AUDIT_LOG_ONLY"].
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/binary_authorization_policy.html#enforcement_mode BinaryAuthorizationPolicy#enforcement_mode}
     *
     * @stability stable
     */
    readonly enforcementMode: string;
    /**
     * How this admission rule will be evaluated. Possible values: ["ALWAYS_ALLOW", "REQUIRE_ATTESTATION", "ALWAYS_DENY"].
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/binary_authorization_policy.html#evaluation_mode BinaryAuthorizationPolicy#evaluation_mode}
     *
     * @stability stable
     */
    readonly evaluationMode: string;
    /**
     * The resource names of the attestors that must attest to a container image.
     *
     * If the attestor is in a different project from the
     * policy, it should be specified in the format 'projects/*\/attestors/*'.
     * Each attestor must exist before a policy can reference it. To add an
     * attestor to a policy the principal issuing the policy change
     * request must be able to read the attestor resource.
     *
     * Note: this field must be non-empty when the evaluation_mode field
     * specifies REQUIRE_ATTESTATION, otherwise it must be empty.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/binary_authorization_policy.html#require_attestations_by BinaryAuthorizationPolicy#require_attestations_by}
     *
     * @stability stable
     */
    readonly requireAttestationsBy?: string[];
}
/**
 * @stability stable
 */
export interface BinaryAuthorizationPolicyDefaultAdmissionRule {
    /**
     * The action when a pod creation is denied by the admission rule. Possible values: ["ENFORCED_BLOCK_AND_AUDIT_LOG", "DRYRUN_AUDIT_LOG_ONLY"].
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/binary_authorization_policy.html#enforcement_mode BinaryAuthorizationPolicy#enforcement_mode}
     *
     * @stability stable
     */
    readonly enforcementMode: string;
    /**
     * How this admission rule will be evaluated. Possible values: ["ALWAYS_ALLOW", "REQUIRE_ATTESTATION", "ALWAYS_DENY"].
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/binary_authorization_policy.html#evaluation_mode BinaryAuthorizationPolicy#evaluation_mode}
     *
     * @stability stable
     */
    readonly evaluationMode: string;
    /**
     * The resource names of the attestors that must attest to a container image.
     *
     * If the attestor is in a different project from the
     * policy, it should be specified in the format 'projects/*\/attestors/*'.
     * Each attestor must exist before a policy can reference it. To add an
     * attestor to a policy the principal issuing the policy change
     * request must be able to read the attestor resource.
     *
     * Note: this field must be non-empty when the evaluation_mode field
     * specifies REQUIRE_ATTESTATION, otherwise it must be empty.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/binary_authorization_policy.html#require_attestations_by BinaryAuthorizationPolicy#require_attestations_by}
     *
     * @stability stable
     */
    readonly requireAttestationsBy?: string[];
}
/**
 * @stability stable
 */
export interface BinaryAuthorizationPolicyTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/binary_authorization_policy.html#create BinaryAuthorizationPolicy#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/binary_authorization_policy.html#delete BinaryAuthorizationPolicy#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/binary_authorization_policy.html#update BinaryAuthorizationPolicy#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/binary_authorization_policy.html google_binary_authorization_policy}.
 *
 * @stability stable
 */
export declare class BinaryAuthorizationPolicy extends cdktf.TerraformResource {
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/binary_authorization_policy.html google_binary_authorization_policy} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: BinaryAuthorizationPolicyConfig);
    private _description?;
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    set description(value: string);
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    private _globalPolicyEvaluationMode?;
    /**
     * @stability stable
     */
    get globalPolicyEvaluationMode(): string;
    /**
     * @stability stable
     */
    set globalPolicyEvaluationMode(value: string);
    /**
     * @stability stable
     */
    resetGlobalPolicyEvaluationMode(): void;
    /**
     * @stability stable
     */
    get globalPolicyEvaluationModeInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string;
    /**
     * @stability stable
     */
    set project(value: string);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    private _admissionWhitelistPatterns?;
    /**
     * @stability stable
     */
    get admissionWhitelistPatterns(): BinaryAuthorizationPolicyAdmissionWhitelistPatterns[];
    /**
     * @stability stable
     */
    set admissionWhitelistPatterns(value: BinaryAuthorizationPolicyAdmissionWhitelistPatterns[]);
    /**
     * @stability stable
     */
    resetAdmissionWhitelistPatterns(): void;
    /**
     * @stability stable
     */
    get admissionWhitelistPatternsInput(): BinaryAuthorizationPolicyAdmissionWhitelistPatterns[] | undefined;
    private _clusterAdmissionRules?;
    /**
     * @stability stable
     */
    get clusterAdmissionRules(): BinaryAuthorizationPolicyClusterAdmissionRules[];
    /**
     * @stability stable
     */
    set clusterAdmissionRules(value: BinaryAuthorizationPolicyClusterAdmissionRules[]);
    /**
     * @stability stable
     */
    resetClusterAdmissionRules(): void;
    /**
     * @stability stable
     */
    get clusterAdmissionRulesInput(): BinaryAuthorizationPolicyClusterAdmissionRules[] | undefined;
    private _defaultAdmissionRule;
    /**
     * @stability stable
     */
    get defaultAdmissionRule(): BinaryAuthorizationPolicyDefaultAdmissionRule[];
    /**
     * @stability stable
     */
    set defaultAdmissionRule(value: BinaryAuthorizationPolicyDefaultAdmissionRule[]);
    /**
     * @stability stable
     */
    get defaultAdmissionRuleInput(): BinaryAuthorizationPolicyDefaultAdmissionRule[];
    private _timeouts?;
    /**
     * @stability stable
     */
    get timeouts(): BinaryAuthorizationPolicyTimeouts;
    /**
     * @stability stable
     */
    set timeouts(value: BinaryAuthorizationPolicyTimeouts);
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): BinaryAuthorizationPolicyTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
