import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface CloudIdentityGroupMembershipConfig extends cdktf.TerraformMetaArguments {
    /**
     * The name of the Group to create this membership in.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_identity_group_membership.html#group CloudIdentityGroupMembership#group}
     *
     * @stability stable
     */
    readonly group: string;
    /**
     * preferred_member_key block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_identity_group_membership.html#preferred_member_key CloudIdentityGroupMembership#preferred_member_key}
     *
     * @stability stable
     */
    readonly preferredMemberKey?: CloudIdentityGroupMembershipPreferredMemberKey[];
    /**
     * roles block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_identity_group_membership.html#roles CloudIdentityGroupMembership#roles}
     *
     * @stability stable
     */
    readonly roles: CloudIdentityGroupMembershipRoles[];
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_identity_group_membership.html#timeouts CloudIdentityGroupMembership#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: CloudIdentityGroupMembershipTimeouts;
}
/**
 * @stability stable
 */
export interface CloudIdentityGroupMembershipPreferredMemberKey {
    /**
     * The ID of the entity.
     *
     * For Google-managed entities, the id must be the email address of an existing
     * group or user.
     *
     * For external-identity-mapped entities, the id must be a string conforming
     * to the Identity Source's requirements.
     *
     * Must be unique within a namespace.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_identity_group_membership.html#id CloudIdentityGroupMembership#id}
     *
     * @stability stable
     */
    readonly id: string;
    /**
     * The namespace in which the entity exists.
     *
     * If not specified, the EntityKey represents a Google-managed entity
     * such as a Google user or a Google Group.
     *
     * If specified, the EntityKey represents an external-identity-mapped group.
     * The namespace must correspond to an identity source created in Admin Console
     * and must be in the form of 'identitysources/{identity_source_id}'.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_identity_group_membership.html#namespace CloudIdentityGroupMembership#namespace}
     *
     * @stability stable
     */
    readonly namespace?: string;
}
/**
 * @stability stable
 */
export interface CloudIdentityGroupMembershipRoles {
    /**
     * The name of the MembershipRole. Must be one of OWNER, MANAGER, MEMBER. Possible values: ["OWNER", "MANAGER", "MEMBER"].
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_identity_group_membership.html#name CloudIdentityGroupMembership#name}
     *
     * @stability stable
     */
    readonly name: string;
}
/**
 * @stability stable
 */
export interface CloudIdentityGroupMembershipTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_identity_group_membership.html#create CloudIdentityGroupMembership#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_identity_group_membership.html#delete CloudIdentityGroupMembership#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_identity_group_membership.html#update CloudIdentityGroupMembership#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/cloud_identity_group_membership.html google_cloud_identity_group_membership}.
 *
 * @stability stable
 */
export declare class CloudIdentityGroupMembership extends cdktf.TerraformResource {
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/cloud_identity_group_membership.html google_cloud_identity_group_membership} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: CloudIdentityGroupMembershipConfig);
    /**
     * @stability stable
     */
    get createTime(): string;
    private _group;
    /**
     * @stability stable
     */
    get group(): string;
    /**
     * @stability stable
     */
    set group(value: string);
    /**
     * @stability stable
     */
    get groupInput(): string;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    get type(): string;
    /**
     * @stability stable
     */
    get updateTime(): string;
    private _preferredMemberKey?;
    /**
     * @stability stable
     */
    get preferredMemberKey(): CloudIdentityGroupMembershipPreferredMemberKey[];
    /**
     * @stability stable
     */
    set preferredMemberKey(value: CloudIdentityGroupMembershipPreferredMemberKey[]);
    /**
     * @stability stable
     */
    resetPreferredMemberKey(): void;
    /**
     * @stability stable
     */
    get preferredMemberKeyInput(): CloudIdentityGroupMembershipPreferredMemberKey[] | undefined;
    private _roles;
    /**
     * @stability stable
     */
    get roles(): CloudIdentityGroupMembershipRoles[];
    /**
     * @stability stable
     */
    set roles(value: CloudIdentityGroupMembershipRoles[]);
    /**
     * @stability stable
     */
    get rolesInput(): CloudIdentityGroupMembershipRoles[];
    private _timeouts?;
    /**
     * @stability stable
     */
    get timeouts(): CloudIdentityGroupMembershipTimeouts;
    /**
     * @stability stable
     */
    set timeouts(value: CloudIdentityGroupMembershipTimeouts);
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): CloudIdentityGroupMembershipTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
