import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface CloudRunDomainMappingConfig extends cdktf.TerraformMetaArguments {
    /**
     * The location of the cloud run instance. eg us-central1.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_domain_mapping.html#location CloudRunDomainMapping#location}
     *
     * @stability stable
     */
    readonly location: string;
    /**
     * Name should be a [verified](https://support.google.com/webmasters/answer/9008080) domain.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_domain_mapping.html#name CloudRunDomainMapping#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_domain_mapping.html#project CloudRunDomainMapping#project}.
     *
     * @stability stable
     */
    readonly project?: string;
    /**
     * metadata block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_domain_mapping.html#metadata CloudRunDomainMapping#metadata}
     *
     * @stability stable
     */
    readonly metadata: CloudRunDomainMappingMetadata[];
    /**
     * spec block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_domain_mapping.html#spec CloudRunDomainMapping#spec}
     *
     * @stability stable
     */
    readonly spec: CloudRunDomainMappingSpec[];
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_domain_mapping.html#timeouts CloudRunDomainMapping#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: CloudRunDomainMappingTimeouts;
}
/**
 * @stability stable
 */
export declare class CloudRunDomainMappingStatusConditions extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get message(): string;
    /**
     * @stability stable
     */
    get reason(): string;
    /**
     * @stability stable
     */
    get status(): string;
    /**
     * @stability stable
     */
    get type(): string;
}
/**
 * @stability stable
 */
export declare class CloudRunDomainMappingStatusResourceRecords extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    get rrdata(): string;
    /**
     * @stability stable
     */
    get type(): string;
}
/**
 * @stability stable
 */
export declare class CloudRunDomainMappingStatus extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get conditions(): any;
    /**
     * @stability stable
     */
    get mappedRouteName(): string;
    /**
     * @stability stable
     */
    get observedGeneration(): number;
    /**
     * @stability stable
     */
    get resourceRecords(): any;
}
/**
 * @stability stable
 */
export interface CloudRunDomainMappingMetadata {
    /**
     * Annotations is a key value map stored with a resource that may be set by external tools to store and retrieve arbitrary metadata.
     *
     * More
     * info: http://kubernetes.io/docs/user-guide/annotations
     *
     * *Note**: The Cloud Run API may add additional annotations that were not provided in your config.
     * If terraform plan shows a diff where a server-side annotation is added, you can add it to your config
     * or apply the lifecycle.ignore_changes rule to the metadata.0.annotations field.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_domain_mapping.html#annotations CloudRunDomainMapping#annotations}
     *
     * @stability stable
     */
    readonly annotations?: {
        [key: string]: string;
    };
    /**
     * Map of string keys and values that can be used to organize and categorize (scope and select) objects.
     *
     * May match selectors of replication controllers
     * and routes.
     * More info: http://kubernetes.io/docs/user-guide/labels
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_domain_mapping.html#labels CloudRunDomainMapping#labels}
     *
     * @stability stable
     */
    readonly labels?: {
        [key: string]: string;
    };
    /**
     * In Cloud Run the namespace must be equal to either the project ID or project number.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_domain_mapping.html#namespace CloudRunDomainMapping#namespace}
     *
     * @stability stable
     */
    readonly namespace: string;
}
/**
 * @stability stable
 */
export interface CloudRunDomainMappingSpec {
    /**
     * The mode of the certificate. Default value: "AUTOMATIC" Possible values: ["NONE", "AUTOMATIC"].
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_domain_mapping.html#certificate_mode CloudRunDomainMapping#certificate_mode}
     *
     * @stability stable
     */
    readonly certificateMode?: string;
    /**
     * If set, the mapping will override any mapping set before this spec was set.
     *
     * It is recommended that the user leaves this empty to receive an error
     * warning about a potential conflict and only set it once the respective UI
     * has given such a warning.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_domain_mapping.html#force_override CloudRunDomainMapping#force_override}
     *
     * @stability stable
     */
    readonly forceOverride?: boolean;
    /**
     * The name of the Cloud Run Service that this DomainMapping applies to. The route must exist.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_domain_mapping.html#route_name CloudRunDomainMapping#route_name}
     *
     * @stability stable
     */
    readonly routeName: string;
}
/**
 * @stability stable
 */
export interface CloudRunDomainMappingTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_domain_mapping.html#create CloudRunDomainMapping#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_domain_mapping.html#delete CloudRunDomainMapping#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/cloud_run_domain_mapping.html google_cloud_run_domain_mapping}.
 *
 * @stability stable
 */
export declare class CloudRunDomainMapping extends cdktf.TerraformResource {
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/cloud_run_domain_mapping.html google_cloud_run_domain_mapping} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: CloudRunDomainMappingConfig);
    /**
     * @stability stable
     */
    get id(): string;
    private _location;
    /**
     * @stability stable
     */
    get location(): string;
    /**
     * @stability stable
     */
    set location(value: string);
    /**
     * @stability stable
     */
    get locationInput(): string;
    private _name;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string;
    /**
     * @stability stable
     */
    set project(value: string);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    /**
     * @stability stable
     */
    status(index: string): CloudRunDomainMappingStatus;
    private _metadata;
    /**
     * @stability stable
     */
    get metadata(): CloudRunDomainMappingMetadata[];
    /**
     * @stability stable
     */
    set metadata(value: CloudRunDomainMappingMetadata[]);
    /**
     * @stability stable
     */
    get metadataInput(): CloudRunDomainMappingMetadata[];
    private _spec;
    /**
     * @stability stable
     */
    get spec(): CloudRunDomainMappingSpec[];
    /**
     * @stability stable
     */
    set spec(value: CloudRunDomainMappingSpec[]);
    /**
     * @stability stable
     */
    get specInput(): CloudRunDomainMappingSpec[];
    private _timeouts?;
    /**
     * @stability stable
     */
    get timeouts(): CloudRunDomainMappingTimeouts;
    /**
     * @stability stable
     */
    set timeouts(value: CloudRunDomainMappingTimeouts);
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): CloudRunDomainMappingTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
