import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface CloudTasksQueueConfig extends cdktf.TerraformMetaArguments {
    /**
     * The location of the queue.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_tasks_queue.html#location CloudTasksQueue#location}
     *
     * @stability stable
     */
    readonly location: string;
    /**
     * The queue name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_tasks_queue.html#name CloudTasksQueue#name}
     *
     * @stability stable
     */
    readonly name?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_tasks_queue.html#project CloudTasksQueue#project}.
     *
     * @stability stable
     */
    readonly project?: string;
    /**
     * app_engine_routing_override block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_tasks_queue.html#app_engine_routing_override CloudTasksQueue#app_engine_routing_override}
     *
     * @stability stable
     */
    readonly appEngineRoutingOverride?: CloudTasksQueueAppEngineRoutingOverride[];
    /**
     * rate_limits block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_tasks_queue.html#rate_limits CloudTasksQueue#rate_limits}
     *
     * @stability stable
     */
    readonly rateLimits?: CloudTasksQueueRateLimits[];
    /**
     * retry_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_tasks_queue.html#retry_config CloudTasksQueue#retry_config}
     *
     * @stability stable
     */
    readonly retryConfig?: CloudTasksQueueRetryConfig[];
    /**
     * stackdriver_logging_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_tasks_queue.html#stackdriver_logging_config CloudTasksQueue#stackdriver_logging_config}
     *
     * @stability stable
     */
    readonly stackdriverLoggingConfig?: CloudTasksQueueStackdriverLoggingConfig[];
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_tasks_queue.html#timeouts CloudTasksQueue#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: CloudTasksQueueTimeouts;
}
/**
 * @stability stable
 */
export interface CloudTasksQueueAppEngineRoutingOverride {
    /**
     * App instance.
     *
     * By default, the task is sent to an instance which is available when the task is attempted.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_tasks_queue.html#instance CloudTasksQueue#instance}
     *
     * @stability stable
     */
    readonly instance?: string;
    /**
     * App service.
     *
     * By default, the task is sent to the service which is the default service when the task is attempted.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_tasks_queue.html#service CloudTasksQueue#service}
     *
     * @stability stable
     */
    readonly service?: string;
    /**
     * App version.
     *
     * By default, the task is sent to the version which is the default version when the task is attempted.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_tasks_queue.html#version CloudTasksQueue#version}
     *
     * @stability stable
     */
    readonly version?: string;
}
/**
 * @stability stable
 */
export interface CloudTasksQueueRateLimits {
    /**
     * The maximum number of concurrent tasks that Cloud Tasks allows to be dispatched for this queue.
     *
     * After this threshold has been
     * reached, Cloud Tasks stops dispatching tasks until the number of
     * concurrent requests decreases.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_tasks_queue.html#max_concurrent_dispatches CloudTasksQueue#max_concurrent_dispatches}
     *
     * @stability stable
     */
    readonly maxConcurrentDispatches?: number;
    /**
     * The maximum rate at which tasks are dispatched from this queue.
     *
     * If unspecified when the queue is created, Cloud Tasks will pick the default.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_tasks_queue.html#max_dispatches_per_second CloudTasksQueue#max_dispatches_per_second}
     *
     * @stability stable
     */
    readonly maxDispatchesPerSecond?: number;
}
/**
 * @stability stable
 */
export interface CloudTasksQueueRetryConfig {
    /**
     * Number of attempts per task.
     *
     * Cloud Tasks will attempt the task maxAttempts times (that is, if
     * the first attempt fails, then there will be maxAttempts - 1
     * retries). Must be >= -1.
     *
     * If unspecified when the queue is created, Cloud Tasks will pick
     * the default.
     *
     * -1 indicates unlimited attempts.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_tasks_queue.html#max_attempts CloudTasksQueue#max_attempts}
     *
     * @stability stable
     */
    readonly maxAttempts?: number;
    /**
     * A task will be scheduled for retry between minBackoff and maxBackoff duration after it fails, if the queue's RetryConfig specifies that the task should be retried.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_tasks_queue.html#max_backoff CloudTasksQueue#max_backoff}
     *
     * @stability stable
     */
    readonly maxBackoff?: string;
    /**
     * The time between retries will double maxDoublings times.
     *
     * A task's retry interval starts at minBackoff, then doubles maxDoublings times,
     * then increases linearly, and finally retries retries at intervals of maxBackoff
     * up to maxAttempts times.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_tasks_queue.html#max_doublings CloudTasksQueue#max_doublings}
     *
     * @stability stable
     */
    readonly maxDoublings?: number;
    /**
     * If positive, maxRetryDuration specifies the time limit for retrying a failed task, measured from when the task was first attempted.
     *
     * Once maxRetryDuration time has passed and the task has
     * been attempted maxAttempts times, no further attempts will be
     * made and the task will be deleted.
     *
     * If zero, then the task age is unlimited.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_tasks_queue.html#max_retry_duration CloudTasksQueue#max_retry_duration}
     *
     * @stability stable
     */
    readonly maxRetryDuration?: string;
    /**
     * A task will be scheduled for retry between minBackoff and maxBackoff duration after it fails, if the queue's RetryConfig specifies that the task should be retried.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_tasks_queue.html#min_backoff CloudTasksQueue#min_backoff}
     *
     * @stability stable
     */
    readonly minBackoff?: string;
}
/**
 * @stability stable
 */
export interface CloudTasksQueueStackdriverLoggingConfig {
    /**
     * Specifies the fraction of operations to write to Stackdriver Logging.
     *
     * This field may contain any value between 0.0 and 1.0, inclusive. 0.0 is the
     * default and means that no operations are logged.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_tasks_queue.html#sampling_ratio CloudTasksQueue#sampling_ratio}
     *
     * @stability stable
     */
    readonly samplingRatio: number;
}
/**
 * @stability stable
 */
export interface CloudTasksQueueTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_tasks_queue.html#create CloudTasksQueue#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_tasks_queue.html#delete CloudTasksQueue#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_tasks_queue.html#update CloudTasksQueue#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/cloud_tasks_queue.html google_cloud_tasks_queue}.
 *
 * @stability stable
 */
export declare class CloudTasksQueue extends cdktf.TerraformResource {
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/cloud_tasks_queue.html google_cloud_tasks_queue} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: CloudTasksQueueConfig);
    /**
     * @stability stable
     */
    get id(): string;
    private _location;
    /**
     * @stability stable
     */
    get location(): string;
    /**
     * @stability stable
     */
    set location(value: string);
    /**
     * @stability stable
     */
    get locationInput(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    resetName(): void;
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string;
    /**
     * @stability stable
     */
    set project(value: string);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    private _appEngineRoutingOverride?;
    /**
     * @stability stable
     */
    get appEngineRoutingOverride(): CloudTasksQueueAppEngineRoutingOverride[];
    /**
     * @stability stable
     */
    set appEngineRoutingOverride(value: CloudTasksQueueAppEngineRoutingOverride[]);
    /**
     * @stability stable
     */
    resetAppEngineRoutingOverride(): void;
    /**
     * @stability stable
     */
    get appEngineRoutingOverrideInput(): CloudTasksQueueAppEngineRoutingOverride[] | undefined;
    private _rateLimits?;
    /**
     * @stability stable
     */
    get rateLimits(): CloudTasksQueueRateLimits[];
    /**
     * @stability stable
     */
    set rateLimits(value: CloudTasksQueueRateLimits[]);
    /**
     * @stability stable
     */
    resetRateLimits(): void;
    /**
     * @stability stable
     */
    get rateLimitsInput(): CloudTasksQueueRateLimits[] | undefined;
    private _retryConfig?;
    /**
     * @stability stable
     */
    get retryConfig(): CloudTasksQueueRetryConfig[];
    /**
     * @stability stable
     */
    set retryConfig(value: CloudTasksQueueRetryConfig[]);
    /**
     * @stability stable
     */
    resetRetryConfig(): void;
    /**
     * @stability stable
     */
    get retryConfigInput(): CloudTasksQueueRetryConfig[] | undefined;
    private _stackdriverLoggingConfig?;
    /**
     * @stability stable
     */
    get stackdriverLoggingConfig(): CloudTasksQueueStackdriverLoggingConfig[];
    /**
     * @stability stable
     */
    set stackdriverLoggingConfig(value: CloudTasksQueueStackdriverLoggingConfig[]);
    /**
     * @stability stable
     */
    resetStackdriverLoggingConfig(): void;
    /**
     * @stability stable
     */
    get stackdriverLoggingConfigInput(): CloudTasksQueueStackdriverLoggingConfig[] | undefined;
    private _timeouts?;
    /**
     * @stability stable
     */
    get timeouts(): CloudTasksQueueTimeouts;
    /**
     * @stability stable
     */
    set timeouts(value: CloudTasksQueueTimeouts);
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): CloudTasksQueueTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
