import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface CloudfunctionsFunctionConfig extends cdktf.TerraformMetaArguments {
    /**
     * Memory (in MB), available to the function. Default value is 256. Possible values include 128, 256, 512, 1024, etc.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudfunctions_function.html#available_memory_mb CloudfunctionsFunction#available_memory_mb}
     *
     * @stability stable
     */
    readonly availableMemoryMb?: number;
    /**
     * A set of key/value environment variable pairs available during build time.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudfunctions_function.html#build_environment_variables CloudfunctionsFunction#build_environment_variables}
     *
     * @stability stable
     */
    readonly buildEnvironmentVariables?: {
        [key: string]: string;
    };
    /**
     * Description of the function.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudfunctions_function.html#description CloudfunctionsFunction#description}
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * Name of the function that will be executed when the Google Cloud Function is triggered.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudfunctions_function.html#entry_point CloudfunctionsFunction#entry_point}
     *
     * @stability stable
     */
    readonly entryPoint?: string;
    /**
     * A set of key/value environment variable pairs to assign to the function.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudfunctions_function.html#environment_variables CloudfunctionsFunction#environment_variables}
     *
     * @stability stable
     */
    readonly environmentVariables?: {
        [key: string]: string;
    };
    /**
     * URL which triggers function execution. Returned only if trigger_http is used.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudfunctions_function.html#https_trigger_url CloudfunctionsFunction#https_trigger_url}
     *
     * @stability stable
     */
    readonly httpsTriggerUrl?: string;
    /**
     * String value that controls what traffic can reach the function.
     *
     * Allowed values are ALLOW_ALL and ALLOW_INTERNAL_ONLY. Changes to this field will recreate the cloud function.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudfunctions_function.html#ingress_settings CloudfunctionsFunction#ingress_settings}
     *
     * @stability stable
     */
    readonly ingressSettings?: string;
    /**
     * A set of key/value label pairs to assign to the function. Label keys must follow the requirements at https://cloud.google.com/resource-manager/docs/creating-managing-labels#requirements.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudfunctions_function.html#labels CloudfunctionsFunction#labels}
     *
     * @stability stable
     */
    readonly labels?: {
        [key: string]: string;
    };
    /**
     * The limit on the maximum number of function instances that may coexist at a given time.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudfunctions_function.html#max_instances CloudfunctionsFunction#max_instances}
     *
     * @stability stable
     */
    readonly maxInstances?: number;
    /**
     * A user-defined name of the function. Function names must be unique globally.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudfunctions_function.html#name CloudfunctionsFunction#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Project of the function. If it is not provided, the provider project is used.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudfunctions_function.html#project CloudfunctionsFunction#project}
     *
     * @stability stable
     */
    readonly project?: string;
    /**
     * Region of function. Currently can be only "us-central1". If it is not provided, the provider region is used.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudfunctions_function.html#region CloudfunctionsFunction#region}
     *
     * @stability stable
     */
    readonly region?: string;
    /**
     * The runtime in which the function is going to run. Eg. "nodejs8", "nodejs10", "python37", "go111".
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudfunctions_function.html#runtime CloudfunctionsFunction#runtime}
     *
     * @stability stable
     */
    readonly runtime: string;
    /**
     * If provided, the self-provided service account to run the function with.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudfunctions_function.html#service_account_email CloudfunctionsFunction#service_account_email}
     *
     * @stability stable
     */
    readonly serviceAccountEmail?: string;
    /**
     * The GCS bucket containing the zip archive which contains the function.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudfunctions_function.html#source_archive_bucket CloudfunctionsFunction#source_archive_bucket}
     *
     * @stability stable
     */
    readonly sourceArchiveBucket?: string;
    /**
     * The source archive object (file) in archive bucket.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudfunctions_function.html#source_archive_object CloudfunctionsFunction#source_archive_object}
     *
     * @stability stable
     */
    readonly sourceArchiveObject?: string;
    /**
     * Timeout (in seconds) for the function. Default value is 60 seconds. Cannot be more than 540 seconds.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudfunctions_function.html#timeout CloudfunctionsFunction#timeout}
     *
     * @stability stable
     */
    readonly timeout?: number;
    /**
     * Boolean variable.
     *
     * Any HTTP request (of a supported type) to the endpoint will trigger function execution. Supported HTTP request types are: POST, PUT, GET, DELETE, and OPTIONS. Endpoint is returned as https_trigger_url. Cannot be used with trigger_bucket and trigger_topic.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudfunctions_function.html#trigger_http CloudfunctionsFunction#trigger_http}
     *
     * @stability stable
     */
    readonly triggerHttp?: boolean;
    /**
     * The VPC Network Connector that this cloud function can connect to.
     *
     * It can be either the fully-qualified URI, or the short name of the network connector resource. The format of this field is projects/*\/locations/*\/connectors/*.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudfunctions_function.html#vpc_connector CloudfunctionsFunction#vpc_connector}
     *
     * @stability stable
     */
    readonly vpcConnector?: string;
    /**
     * The egress settings for the connector, controlling what traffic is diverted through it.
     *
     * Allowed values are ALL_TRAFFIC and PRIVATE_RANGES_ONLY. Defaults to PRIVATE_RANGES_ONLY. If unset, this field preserves the previously set value.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudfunctions_function.html#vpc_connector_egress_settings CloudfunctionsFunction#vpc_connector_egress_settings}
     *
     * @stability stable
     */
    readonly vpcConnectorEgressSettings?: string;
    /**
     * event_trigger block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudfunctions_function.html#event_trigger CloudfunctionsFunction#event_trigger}
     *
     * @stability stable
     */
    readonly eventTrigger?: CloudfunctionsFunctionEventTrigger[];
    /**
     * source_repository block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudfunctions_function.html#source_repository CloudfunctionsFunction#source_repository}
     *
     * @stability stable
     */
    readonly sourceRepository?: CloudfunctionsFunctionSourceRepository[];
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudfunctions_function.html#timeouts CloudfunctionsFunction#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: CloudfunctionsFunctionTimeouts;
}
/**
 * @stability stable
 */
export interface CloudfunctionsFunctionEventTriggerFailurePolicy {
    /**
     * Whether the function should be retried on failure. Defaults to false.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudfunctions_function.html#retry CloudfunctionsFunction#retry}
     *
     * @stability stable
     */
    readonly retry: boolean;
}
/**
 * @stability stable
 */
export interface CloudfunctionsFunctionEventTrigger {
    /**
     * The type of event to observe.
     *
     * For example: "google.storage.object.finalize". See the documentation on calling Cloud Functions for a full reference of accepted triggers.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudfunctions_function.html#event_type CloudfunctionsFunction#event_type}
     *
     * @stability stable
     */
    readonly eventType: string;
    /**
     * The name or partial URI of the resource from which to observe events. For example, "myBucket" or "projects/my-project/topics/my-topic".
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudfunctions_function.html#resource CloudfunctionsFunction#resource}
     *
     * @stability stable
     */
    readonly resource: string;
    /**
     * failure_policy block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudfunctions_function.html#failure_policy CloudfunctionsFunction#failure_policy}
     *
     * @stability stable
     */
    readonly failurePolicy?: CloudfunctionsFunctionEventTriggerFailurePolicy[];
}
/**
 * @stability stable
 */
export interface CloudfunctionsFunctionSourceRepository {
    /**
     * The URL pointing to the hosted repository where the function is defined.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudfunctions_function.html#url CloudfunctionsFunction#url}
     *
     * @stability stable
     */
    readonly url: string;
}
/**
 * @stability stable
 */
export interface CloudfunctionsFunctionTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudfunctions_function.html#create CloudfunctionsFunction#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudfunctions_function.html#delete CloudfunctionsFunction#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudfunctions_function.html#read CloudfunctionsFunction#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudfunctions_function.html#update CloudfunctionsFunction#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/cloudfunctions_function.html google_cloudfunctions_function}.
 *
 * @stability stable
 */
export declare class CloudfunctionsFunction extends cdktf.TerraformResource {
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/cloudfunctions_function.html google_cloudfunctions_function} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: CloudfunctionsFunctionConfig);
    private _availableMemoryMb?;
    /**
     * @stability stable
     */
    get availableMemoryMb(): number;
    /**
     * @stability stable
     */
    set availableMemoryMb(value: number);
    /**
     * @stability stable
     */
    resetAvailableMemoryMb(): void;
    /**
     * @stability stable
     */
    get availableMemoryMbInput(): number | undefined;
    private _buildEnvironmentVariables?;
    /**
     * @stability stable
     */
    get buildEnvironmentVariables(): {
        [key: string]: string;
    };
    /**
     * @stability stable
     */
    set buildEnvironmentVariables(value: {
        [key: string]: string;
    });
    /**
     * @stability stable
     */
    resetBuildEnvironmentVariables(): void;
    /**
     * @stability stable
     */
    get buildEnvironmentVariablesInput(): {
        [key: string]: string;
    } | undefined;
    private _description?;
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    set description(value: string);
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    private _entryPoint?;
    /**
     * @stability stable
     */
    get entryPoint(): string;
    /**
     * @stability stable
     */
    set entryPoint(value: string);
    /**
     * @stability stable
     */
    resetEntryPoint(): void;
    /**
     * @stability stable
     */
    get entryPointInput(): string | undefined;
    private _environmentVariables?;
    /**
     * @stability stable
     */
    get environmentVariables(): {
        [key: string]: string;
    };
    /**
     * @stability stable
     */
    set environmentVariables(value: {
        [key: string]: string;
    });
    /**
     * @stability stable
     */
    resetEnvironmentVariables(): void;
    /**
     * @stability stable
     */
    get environmentVariablesInput(): {
        [key: string]: string;
    } | undefined;
    private _httpsTriggerUrl?;
    /**
     * @stability stable
     */
    get httpsTriggerUrl(): string;
    /**
     * @stability stable
     */
    set httpsTriggerUrl(value: string);
    /**
     * @stability stable
     */
    resetHttpsTriggerUrl(): void;
    /**
     * @stability stable
     */
    get httpsTriggerUrlInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _ingressSettings?;
    /**
     * @stability stable
     */
    get ingressSettings(): string;
    /**
     * @stability stable
     */
    set ingressSettings(value: string);
    /**
     * @stability stable
     */
    resetIngressSettings(): void;
    /**
     * @stability stable
     */
    get ingressSettingsInput(): string | undefined;
    private _labels?;
    /**
     * @stability stable
     */
    get labels(): {
        [key: string]: string;
    };
    /**
     * @stability stable
     */
    set labels(value: {
        [key: string]: string;
    });
    /**
     * @stability stable
     */
    resetLabels(): void;
    /**
     * @stability stable
     */
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _maxInstances?;
    /**
     * @stability stable
     */
    get maxInstances(): number;
    /**
     * @stability stable
     */
    set maxInstances(value: number);
    /**
     * @stability stable
     */
    resetMaxInstances(): void;
    /**
     * @stability stable
     */
    get maxInstancesInput(): number | undefined;
    private _name;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string;
    /**
     * @stability stable
     */
    set project(value: string);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    private _region?;
    /**
     * @stability stable
     */
    get region(): string;
    /**
     * @stability stable
     */
    set region(value: string);
    /**
     * @stability stable
     */
    resetRegion(): void;
    /**
     * @stability stable
     */
    get regionInput(): string | undefined;
    private _runtime;
    /**
     * @stability stable
     */
    get runtime(): string;
    /**
     * @stability stable
     */
    set runtime(value: string);
    /**
     * @stability stable
     */
    get runtimeInput(): string;
    private _serviceAccountEmail?;
    /**
     * @stability stable
     */
    get serviceAccountEmail(): string;
    /**
     * @stability stable
     */
    set serviceAccountEmail(value: string);
    /**
     * @stability stable
     */
    resetServiceAccountEmail(): void;
    /**
     * @stability stable
     */
    get serviceAccountEmailInput(): string | undefined;
    private _sourceArchiveBucket?;
    /**
     * @stability stable
     */
    get sourceArchiveBucket(): string;
    /**
     * @stability stable
     */
    set sourceArchiveBucket(value: string);
    /**
     * @stability stable
     */
    resetSourceArchiveBucket(): void;
    /**
     * @stability stable
     */
    get sourceArchiveBucketInput(): string | undefined;
    private _sourceArchiveObject?;
    /**
     * @stability stable
     */
    get sourceArchiveObject(): string;
    /**
     * @stability stable
     */
    set sourceArchiveObject(value: string);
    /**
     * @stability stable
     */
    resetSourceArchiveObject(): void;
    /**
     * @stability stable
     */
    get sourceArchiveObjectInput(): string | undefined;
    private _timeout?;
    /**
     * @stability stable
     */
    get timeout(): number;
    /**
     * @stability stable
     */
    set timeout(value: number);
    /**
     * @stability stable
     */
    resetTimeout(): void;
    /**
     * @stability stable
     */
    get timeoutInput(): number | undefined;
    private _triggerHttp?;
    /**
     * @stability stable
     */
    get triggerHttp(): boolean;
    /**
     * @stability stable
     */
    set triggerHttp(value: boolean);
    /**
     * @stability stable
     */
    resetTriggerHttp(): void;
    /**
     * @stability stable
     */
    get triggerHttpInput(): boolean | undefined;
    private _vpcConnector?;
    /**
     * @stability stable
     */
    get vpcConnector(): string;
    /**
     * @stability stable
     */
    set vpcConnector(value: string);
    /**
     * @stability stable
     */
    resetVpcConnector(): void;
    /**
     * @stability stable
     */
    get vpcConnectorInput(): string | undefined;
    private _vpcConnectorEgressSettings?;
    /**
     * @stability stable
     */
    get vpcConnectorEgressSettings(): string;
    /**
     * @stability stable
     */
    set vpcConnectorEgressSettings(value: string);
    /**
     * @stability stable
     */
    resetVpcConnectorEgressSettings(): void;
    /**
     * @stability stable
     */
    get vpcConnectorEgressSettingsInput(): string | undefined;
    private _eventTrigger?;
    /**
     * @stability stable
     */
    get eventTrigger(): CloudfunctionsFunctionEventTrigger[];
    /**
     * @stability stable
     */
    set eventTrigger(value: CloudfunctionsFunctionEventTrigger[]);
    /**
     * @stability stable
     */
    resetEventTrigger(): void;
    /**
     * @stability stable
     */
    get eventTriggerInput(): CloudfunctionsFunctionEventTrigger[] | undefined;
    private _sourceRepository?;
    /**
     * @stability stable
     */
    get sourceRepository(): CloudfunctionsFunctionSourceRepository[];
    /**
     * @stability stable
     */
    set sourceRepository(value: CloudfunctionsFunctionSourceRepository[]);
    /**
     * @stability stable
     */
    resetSourceRepository(): void;
    /**
     * @stability stable
     */
    get sourceRepositoryInput(): CloudfunctionsFunctionSourceRepository[] | undefined;
    private _timeouts?;
    /**
     * @stability stable
     */
    get timeouts(): CloudfunctionsFunctionTimeouts;
    /**
     * @stability stable
     */
    set timeouts(value: CloudfunctionsFunctionTimeouts);
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): CloudfunctionsFunctionTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
