import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface CloudiotDeviceConfig extends cdktf.TerraformMetaArguments {
    /**
     * If a device is blocked, connections or requests from this device will fail.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudiot_device.html#blocked CloudiotDevice#blocked}
     *
     * @stability stable
     */
    readonly blocked?: boolean;
    /**
     * The logging verbosity for device activity. Possible values: ["NONE", "ERROR", "INFO", "DEBUG"].
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudiot_device.html#log_level CloudiotDevice#log_level}
     *
     * @stability stable
     */
    readonly logLevel?: string;
    /**
     * The metadata key-value pairs assigned to the device.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudiot_device.html#metadata CloudiotDevice#metadata}
     *
     * @stability stable
     */
    readonly metadata?: {
        [key: string]: string;
    };
    /**
     * A unique name for the resource.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudiot_device.html#name CloudiotDevice#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * The name of the device registry where this device should be created.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudiot_device.html#registry CloudiotDevice#registry}
     *
     * @stability stable
     */
    readonly registry: string;
    /**
     * credentials block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudiot_device.html#credentials CloudiotDevice#credentials}
     *
     * @stability stable
     */
    readonly credentials?: CloudiotDeviceCredentials[];
    /**
     * gateway_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudiot_device.html#gateway_config CloudiotDevice#gateway_config}
     *
     * @stability stable
     */
    readonly gatewayConfig?: CloudiotDeviceGatewayConfig[];
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudiot_device.html#timeouts CloudiotDevice#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: CloudiotDeviceTimeouts;
}
/**
 * @stability stable
 */
export declare class CloudiotDeviceConfigA extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get binaryData(): string;
    /**
     * @stability stable
     */
    get cloudUpdateTime(): string;
    /**
     * @stability stable
     */
    get deviceAckTime(): string;
    /**
     * @stability stable
     */
    get version(): string;
}
/**
 * @stability stable
 */
export declare class CloudiotDeviceLastErrorStatus extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get details(): any;
    /**
     * @stability stable
     */
    get message(): string;
    /**
     * @stability stable
     */
    get number(): number;
}
/**
 * @stability stable
 */
export declare class CloudiotDeviceState extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get binaryData(): string;
    /**
     * @stability stable
     */
    get updateTime(): string;
}
/**
 * @stability stable
 */
export interface CloudiotDeviceCredentialsPublicKey {
    /**
     * The format of the key. Possible values: ["RSA_PEM", "RSA_X509_PEM", "ES256_PEM", "ES256_X509_PEM"].
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudiot_device.html#format CloudiotDevice#format}
     *
     * @stability stable
     */
    readonly format: string;
    /**
     * The key data.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudiot_device.html#key CloudiotDevice#key}
     *
     * @stability stable
     */
    readonly key: string;
}
/**
 * @stability stable
 */
export interface CloudiotDeviceCredentials {
    /**
     * The time at which this credential becomes invalid.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudiot_device.html#expiration_time CloudiotDevice#expiration_time}
     *
     * @stability stable
     */
    readonly expirationTime?: string;
    /**
     * public_key block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudiot_device.html#public_key CloudiotDevice#public_key}
     *
     * @stability stable
     */
    readonly publicKey: CloudiotDeviceCredentialsPublicKey[];
}
/**
 * @stability stable
 */
export interface CloudiotDeviceGatewayConfig {
    /**
     * Indicates whether the device is a gateway. Possible values: ["ASSOCIATION_ONLY", "DEVICE_AUTH_TOKEN_ONLY", "ASSOCIATION_AND_DEVICE_AUTH_TOKEN"].
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudiot_device.html#gateway_auth_method CloudiotDevice#gateway_auth_method}
     *
     * @stability stable
     */
    readonly gatewayAuthMethod?: string;
    /**
     * Indicates whether the device is a gateway. Default value: "NON_GATEWAY" Possible values: ["GATEWAY", "NON_GATEWAY"].
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudiot_device.html#gateway_type CloudiotDevice#gateway_type}
     *
     * @stability stable
     */
    readonly gatewayType?: string;
}
/**
 * @stability stable
 */
export interface CloudiotDeviceTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudiot_device.html#create CloudiotDevice#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudiot_device.html#delete CloudiotDevice#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudiot_device.html#update CloudiotDevice#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/cloudiot_device.html google_cloudiot_device}.
 *
 * @stability stable
 */
export declare class CloudiotDevice extends cdktf.TerraformResource {
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/cloudiot_device.html google_cloudiot_device} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: CloudiotDeviceConfig);
    private _blocked?;
    /**
     * @stability stable
     */
    get blocked(): boolean;
    /**
     * @stability stable
     */
    set blocked(value: boolean);
    /**
     * @stability stable
     */
    resetBlocked(): void;
    /**
     * @stability stable
     */
    get blockedInput(): boolean | undefined;
    /**
     * @stability stable
     */
    config(index: string): CloudiotDeviceConfigA;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get lastConfigAckTime(): string;
    /**
     * @stability stable
     */
    get lastConfigSendTime(): string;
    /**
     * @stability stable
     */
    lastErrorStatus(index: string): CloudiotDeviceLastErrorStatus;
    /**
     * @stability stable
     */
    get lastErrorTime(): string;
    /**
     * @stability stable
     */
    get lastEventTime(): string;
    /**
     * @stability stable
     */
    get lastHeartbeatTime(): string;
    /**
     * @stability stable
     */
    get lastStateTime(): string;
    private _logLevel?;
    /**
     * @stability stable
     */
    get logLevel(): string;
    /**
     * @stability stable
     */
    set logLevel(value: string);
    /**
     * @stability stable
     */
    resetLogLevel(): void;
    /**
     * @stability stable
     */
    get logLevelInput(): string | undefined;
    private _metadata?;
    /**
     * @stability stable
     */
    get metadata(): {
        [key: string]: string;
    };
    /**
     * @stability stable
     */
    set metadata(value: {
        [key: string]: string;
    });
    /**
     * @stability stable
     */
    resetMetadata(): void;
    /**
     * @stability stable
     */
    get metadataInput(): {
        [key: string]: string;
    } | undefined;
    private _name;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string;
    /**
     * @stability stable
     */
    get numId(): string;
    private _registry;
    /**
     * @stability stable
     */
    get registry(): string;
    /**
     * @stability stable
     */
    set registry(value: string);
    /**
     * @stability stable
     */
    get registryInput(): string;
    /**
     * @stability stable
     */
    state(index: string): CloudiotDeviceState;
    private _credentials?;
    /**
     * @stability stable
     */
    get credentials(): CloudiotDeviceCredentials[];
    /**
     * @stability stable
     */
    set credentials(value: CloudiotDeviceCredentials[]);
    /**
     * @stability stable
     */
    resetCredentials(): void;
    /**
     * @stability stable
     */
    get credentialsInput(): CloudiotDeviceCredentials[] | undefined;
    private _gatewayConfig?;
    /**
     * @stability stable
     */
    get gatewayConfig(): CloudiotDeviceGatewayConfig[];
    /**
     * @stability stable
     */
    set gatewayConfig(value: CloudiotDeviceGatewayConfig[]);
    /**
     * @stability stable
     */
    resetGatewayConfig(): void;
    /**
     * @stability stable
     */
    get gatewayConfigInput(): CloudiotDeviceGatewayConfig[] | undefined;
    private _timeouts?;
    /**
     * @stability stable
     */
    get timeouts(): CloudiotDeviceTimeouts;
    /**
     * @stability stable
     */
    set timeouts(value: CloudiotDeviceTimeouts);
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): CloudiotDeviceTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
