import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface ComputeBackendBucketSignedUrlKeyConfig extends cdktf.TerraformMetaArguments {
    /**
     * The backend bucket this signed URL key belongs.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_bucket_signed_url_key.html#backend_bucket ComputeBackendBucketSignedUrlKey#backend_bucket}
     *
     * @stability stable
     */
    readonly backendBucket: string;
    /**
     * 128-bit key value used for signing the URL.
     *
     * The key value must be a
     * valid RFC 4648 Section 5 base64url encoded string.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_bucket_signed_url_key.html#key_value ComputeBackendBucketSignedUrlKey#key_value}
     *
     * @stability stable
     */
    readonly keyValue: string;
    /**
     * Name of the signed URL key.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_bucket_signed_url_key.html#name ComputeBackendBucketSignedUrlKey#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_bucket_signed_url_key.html#project ComputeBackendBucketSignedUrlKey#project}.
     *
     * @stability stable
     */
    readonly project?: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_bucket_signed_url_key.html#timeouts ComputeBackendBucketSignedUrlKey#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: ComputeBackendBucketSignedUrlKeyTimeouts;
}
/**
 * @stability stable
 */
export interface ComputeBackendBucketSignedUrlKeyTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_bucket_signed_url_key.html#create ComputeBackendBucketSignedUrlKey#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_bucket_signed_url_key.html#delete ComputeBackendBucketSignedUrlKey#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/compute_backend_bucket_signed_url_key.html google_compute_backend_bucket_signed_url_key}.
 *
 * @stability stable
 */
export declare class ComputeBackendBucketSignedUrlKey extends cdktf.TerraformResource {
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/compute_backend_bucket_signed_url_key.html google_compute_backend_bucket_signed_url_key} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: ComputeBackendBucketSignedUrlKeyConfig);
    private _backendBucket;
    /**
     * @stability stable
     */
    get backendBucket(): string;
    /**
     * @stability stable
     */
    set backendBucket(value: string);
    /**
     * @stability stable
     */
    get backendBucketInput(): string;
    /**
     * @stability stable
     */
    get id(): string;
    private _keyValue;
    /**
     * @stability stable
     */
    get keyValue(): string;
    /**
     * @stability stable
     */
    set keyValue(value: string);
    /**
     * @stability stable
     */
    get keyValueInput(): string;
    private _name;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string;
    /**
     * @stability stable
     */
    set project(value: string);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    private _timeouts?;
    /**
     * @stability stable
     */
    get timeouts(): ComputeBackendBucketSignedUrlKeyTimeouts;
    /**
     * @stability stable
     */
    set timeouts(value: ComputeBackendBucketSignedUrlKeyTimeouts);
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): ComputeBackendBucketSignedUrlKeyTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
