import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface ComputeDiskIamPolicyConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_disk_iam_policy.html#name ComputeDiskIamPolicy#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_disk_iam_policy.html#policy_data ComputeDiskIamPolicy#policy_data}.
     *
     * @stability stable
     */
    readonly policyData: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_disk_iam_policy.html#project ComputeDiskIamPolicy#project}.
     *
     * @stability stable
     */
    readonly project?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_disk_iam_policy.html#zone ComputeDiskIamPolicy#zone}.
     *
     * @stability stable
     */
    readonly zone?: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/compute_disk_iam_policy.html google_compute_disk_iam_policy}.
 *
 * @stability stable
 */
export declare class ComputeDiskIamPolicy extends cdktf.TerraformResource {
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/compute_disk_iam_policy.html google_compute_disk_iam_policy} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: ComputeDiskIamPolicyConfig);
    /**
     * @stability stable
     */
    get etag(): string;
    /**
     * @stability stable
     */
    get id(): string;
    private _name;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string;
    private _policyData;
    /**
     * @stability stable
     */
    get policyData(): string;
    /**
     * @stability stable
     */
    set policyData(value: string);
    /**
     * @stability stable
     */
    get policyDataInput(): string;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string;
    /**
     * @stability stable
     */
    set project(value: string);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    private _zone?;
    /**
     * @stability stable
     */
    get zone(): string;
    /**
     * @stability stable
     */
    set zone(value: string);
    /**
     * @stability stable
     */
    resetZone(): void;
    /**
     * @stability stable
     */
    get zoneInput(): string | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
