import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface ComputeForwardingRuleConfig extends cdktf.TerraformMetaArguments {
    /**
     * For internal TCP/UDP load balancing (i.e. load balancing scheme is INTERNAL and protocol is TCP/UDP), set this to true to allow packets addressed to any ports to be forwarded to the backends configured with this forwarding rule. Used with backend service. Cannot be set if port or portRange are set.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_forwarding_rule.html#all_ports ComputeForwardingRule#all_ports}
     *
     * @stability stable
     */
    readonly allPorts?: boolean;
    /**
     * If true, clients can access ILB from all regions.
     *
     * Otherwise only allows from the local region the ILB is located at.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_forwarding_rule.html#allow_global_access ComputeForwardingRule#allow_global_access}
     *
     * @stability stable
     */
    readonly allowGlobalAccess?: boolean;
    /**
     * A BackendService to receive the matched traffic. This is used only for INTERNAL load balancing.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_forwarding_rule.html#backend_service ComputeForwardingRule#backend_service}
     *
     * @stability stable
     */
    readonly backendService?: string;
    /**
     * An optional description of this resource. Provide this property when you create the resource.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_forwarding_rule.html#description ComputeForwardingRule#description}
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * The IP address that this forwarding rule serves.
     *
     * When a client sends
     * traffic to this IP address, the forwarding rule directs the traffic to
     * the target that you specify in the forwarding rule. The
     * loadBalancingScheme and the forwarding rule's target determine the
     * type of IP address that you can use. For detailed information, refer
     * to [IP address specifications](https://cloud.google.com/load-balancing/docs/forwarding-rule-concepts#ip_address_specifications).
     *
     * An address can be specified either by a literal IP address or a
     * reference to an existing Address resource. If you don't specify a
     * reserved IP address, an ephemeral IP address is assigned.
     *
     * The value must be set to 0.0.0.0 when the target is a targetGrpcProxy
     * that has validateForProxyless field set to true.
     *
     * For Private Service Connect forwarding rules that forward traffic to
     * Google APIs, IP address must be provided.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_forwarding_rule.html#ip_address ComputeForwardingRule#ip_address}
     *
     * @stability stable
     */
    readonly ipAddress?: string;
    /**
     * The IP protocol to which this rule applies.
     *
     * When the load balancing scheme is INTERNAL, only TCP and UDP are
     * valid. Possible values: ["TCP", "UDP", "ESP", "AH", "SCTP", "ICMP"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_forwarding_rule.html#ip_protocol ComputeForwardingRule#ip_protocol}
     *
     * @stability stable
     */
    readonly ipProtocol?: string;
    /**
     * Indicates whether or not this load balancer can be used as a collector for packet mirroring.
     *
     * To prevent mirroring loops,
     * instances behind this load balancer will not have their traffic
     * mirrored even if a PacketMirroring rule applies to them. This
     * can only be set to true for load balancers that have their
     * loadBalancingScheme set to INTERNAL.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_forwarding_rule.html#is_mirroring_collector ComputeForwardingRule#is_mirroring_collector}
     *
     * @stability stable
     */
    readonly isMirroringCollector?: boolean;
    /**
     * This signifies what the ForwardingRule will be used for and can be EXTERNAL, INTERNAL, or INTERNAL_MANAGED.
     *
     * EXTERNAL is used for Classic
     * Cloud VPN gateways, protocol forwarding to VMs from an external IP address,
     * and HTTP(S), SSL Proxy, TCP Proxy, and Network TCP/UDP load balancers.
     * INTERNAL is used for protocol forwarding to VMs from an internal IP address,
     * and internal TCP/UDP load balancers.
     * INTERNAL_MANAGED is used for internal HTTP(S) load balancers. Default value: "EXTERNAL" Possible values: ["EXTERNAL", "INTERNAL", "INTERNAL_MANAGED"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_forwarding_rule.html#load_balancing_scheme ComputeForwardingRule#load_balancing_scheme}
     *
     * @stability stable
     */
    readonly loadBalancingScheme?: string;
    /**
     * Name of the resource;
     *
     * provided by the client when the resource is
     * created. The name must be 1-63 characters long, and comply with
     * RFC1035. Specifically, the name must be 1-63 characters long and match
     * the regular expression '[a-z]([-a-z0-9]*[a-z0-9])?' which means the
     * first character must be a lowercase letter, and all following
     * characters must be a dash, lowercase letter, or digit, except the last
     * character, which cannot be a dash.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_forwarding_rule.html#name ComputeForwardingRule#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * For internal load balancing, this field identifies the network that the load balanced IP should belong to for this Forwarding Rule.
     *
     * If
     * this field is not specified, the default network will be used.
     * This field is only used for INTERNAL load balancing.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_forwarding_rule.html#network ComputeForwardingRule#network}
     *
     * @stability stable
     */
    readonly network?: string;
    /**
     * The networking tier used for configuring this address.
     *
     * If this field is not
     * specified, it is assumed to be PREMIUM. Possible values: ["PREMIUM", "STANDARD"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_forwarding_rule.html#network_tier ComputeForwardingRule#network_tier}
     *
     * @stability stable
     */
    readonly networkTier?: string;
    /**
     * This field is used along with the target field for TargetHttpProxy, TargetHttpsProxy, TargetSslProxy, TargetTcpProxy, TargetVpnGateway, TargetPool, TargetInstance.
     *
     * Applicable only when IPProtocol is TCP, UDP, or SCTP, only packets
     * addressed to ports in the specified range will be forwarded to target.
     * Forwarding rules with the same [IPAddress, IPProtocol] pair must have
     * disjoint port ranges.
     *
     * Some types of forwarding target have constraints on the acceptable
     * ports:
     *
     * TargetHttpProxy: 80, 8080
     * TargetHttpsProxy: 443
     * TargetTcpProxy: 25, 43, 110, 143, 195, 443, 465, 587, 700, 993, 995,
     *                1883, 5222
     * TargetSslProxy: 25, 43, 110, 143, 195, 443, 465, 587, 700, 993, 995,
     *                1883, 5222
     * TargetVpnGateway: 500, 4500
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_forwarding_rule.html#port_range ComputeForwardingRule#port_range}
     *
     * @stability stable
     */
    readonly portRange?: string;
    /**
     * This field is used along with the backend_service field for internal load balancing.
     *
     * When the load balancing scheme is INTERNAL, a single port or a comma
     * separated list of ports can be configured. Only packets addressed to
     * these ports will be forwarded to the backends configured with this
     * forwarding rule.
     *
     * You may specify a maximum of up to 5 ports.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_forwarding_rule.html#ports ComputeForwardingRule#ports}
     *
     * @stability stable
     */
    readonly ports?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_forwarding_rule.html#project ComputeForwardingRule#project}.
     *
     * @stability stable
     */
    readonly project?: string;
    /**
     * A reference to the region where the regional forwarding rule resides. This field is not applicable to global forwarding rules.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_forwarding_rule.html#region ComputeForwardingRule#region}
     *
     * @stability stable
     */
    readonly region?: string;
    /**
     * An optional prefix to the service name for this Forwarding Rule.
     *
     * If specified, will be the first label of the fully qualified service
     * name.
     *
     * The label must be 1-63 characters long, and comply with RFC1035.
     * Specifically, the label must be 1-63 characters long and match the
     * regular expression '[a-z]([-a-z0-9]*[a-z0-9])?' which means the first
     * character must be a lowercase letter, and all following characters
     * must be a dash, lowercase letter, or digit, except the last
     * character, which cannot be a dash.
     *
     * This field is only used for INTERNAL load balancing.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_forwarding_rule.html#service_label ComputeForwardingRule#service_label}
     *
     * @stability stable
     */
    readonly serviceLabel?: string;
    /**
     * The subnetwork that the load balanced IP should belong to for this Forwarding Rule.
     *
     * This field is only used for INTERNAL load balancing.
     *
     * If the network specified is in auto subnet mode, this field is
     * optional. However, if the network is in custom subnet mode, a
     * subnetwork must be specified.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_forwarding_rule.html#subnetwork ComputeForwardingRule#subnetwork}
     *
     * @stability stable
     */
    readonly subnetwork?: string;
    /**
     * The URL of the target resource to receive the matched traffic.
     *
     * The target must live in the same region as the forwarding rule.
     * The forwarded traffic must be of a type appropriate to the target
     * object.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_forwarding_rule.html#target ComputeForwardingRule#target}
     *
     * @stability stable
     */
    readonly target?: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_forwarding_rule.html#timeouts ComputeForwardingRule#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: ComputeForwardingRuleTimeouts;
}
/**
 * @stability stable
 */
export interface ComputeForwardingRuleTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_forwarding_rule.html#create ComputeForwardingRule#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_forwarding_rule.html#delete ComputeForwardingRule#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_forwarding_rule.html#update ComputeForwardingRule#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/compute_forwarding_rule.html google_compute_forwarding_rule}.
 *
 * @stability stable
 */
export declare class ComputeForwardingRule extends cdktf.TerraformResource {
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/compute_forwarding_rule.html google_compute_forwarding_rule} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: ComputeForwardingRuleConfig);
    private _allPorts?;
    /**
     * @stability stable
     */
    get allPorts(): boolean;
    /**
     * @stability stable
     */
    set allPorts(value: boolean);
    /**
     * @stability stable
     */
    resetAllPorts(): void;
    /**
     * @stability stable
     */
    get allPortsInput(): boolean | undefined;
    private _allowGlobalAccess?;
    /**
     * @stability stable
     */
    get allowGlobalAccess(): boolean;
    /**
     * @stability stable
     */
    set allowGlobalAccess(value: boolean);
    /**
     * @stability stable
     */
    resetAllowGlobalAccess(): void;
    /**
     * @stability stable
     */
    get allowGlobalAccessInput(): boolean | undefined;
    private _backendService?;
    /**
     * @stability stable
     */
    get backendService(): string;
    /**
     * @stability stable
     */
    set backendService(value: string);
    /**
     * @stability stable
     */
    resetBackendService(): void;
    /**
     * @stability stable
     */
    get backendServiceInput(): string | undefined;
    /**
     * @stability stable
     */
    get creationTimestamp(): string;
    private _description?;
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    set description(value: string);
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _ipAddress?;
    /**
     * @stability stable
     */
    get ipAddress(): string;
    /**
     * @stability stable
     */
    set ipAddress(value: string);
    /**
     * @stability stable
     */
    resetIpAddress(): void;
    /**
     * @stability stable
     */
    get ipAddressInput(): string | undefined;
    private _ipProtocol?;
    /**
     * @stability stable
     */
    get ipProtocol(): string;
    /**
     * @stability stable
     */
    set ipProtocol(value: string);
    /**
     * @stability stable
     */
    resetIpProtocol(): void;
    /**
     * @stability stable
     */
    get ipProtocolInput(): string | undefined;
    private _isMirroringCollector?;
    /**
     * @stability stable
     */
    get isMirroringCollector(): boolean;
    /**
     * @stability stable
     */
    set isMirroringCollector(value: boolean);
    /**
     * @stability stable
     */
    resetIsMirroringCollector(): void;
    /**
     * @stability stable
     */
    get isMirroringCollectorInput(): boolean | undefined;
    private _loadBalancingScheme?;
    /**
     * @stability stable
     */
    get loadBalancingScheme(): string;
    /**
     * @stability stable
     */
    set loadBalancingScheme(value: string);
    /**
     * @stability stable
     */
    resetLoadBalancingScheme(): void;
    /**
     * @stability stable
     */
    get loadBalancingSchemeInput(): string | undefined;
    private _name;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string;
    private _network?;
    /**
     * @stability stable
     */
    get network(): string;
    /**
     * @stability stable
     */
    set network(value: string);
    /**
     * @stability stable
     */
    resetNetwork(): void;
    /**
     * @stability stable
     */
    get networkInput(): string | undefined;
    private _networkTier?;
    /**
     * @stability stable
     */
    get networkTier(): string;
    /**
     * @stability stable
     */
    set networkTier(value: string);
    /**
     * @stability stable
     */
    resetNetworkTier(): void;
    /**
     * @stability stable
     */
    get networkTierInput(): string | undefined;
    private _portRange?;
    /**
     * @stability stable
     */
    get portRange(): string;
    /**
     * @stability stable
     */
    set portRange(value: string);
    /**
     * @stability stable
     */
    resetPortRange(): void;
    /**
     * @stability stable
     */
    get portRangeInput(): string | undefined;
    private _ports?;
    /**
     * @stability stable
     */
    get ports(): string[];
    /**
     * @stability stable
     */
    set ports(value: string[]);
    /**
     * @stability stable
     */
    resetPorts(): void;
    /**
     * @stability stable
     */
    get portsInput(): string[] | undefined;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string;
    /**
     * @stability stable
     */
    set project(value: string);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    private _region?;
    /**
     * @stability stable
     */
    get region(): string;
    /**
     * @stability stable
     */
    set region(value: string);
    /**
     * @stability stable
     */
    resetRegion(): void;
    /**
     * @stability stable
     */
    get regionInput(): string | undefined;
    /**
     * @stability stable
     */
    get selfLink(): string;
    private _serviceLabel?;
    /**
     * @stability stable
     */
    get serviceLabel(): string;
    /**
     * @stability stable
     */
    set serviceLabel(value: string);
    /**
     * @stability stable
     */
    resetServiceLabel(): void;
    /**
     * @stability stable
     */
    get serviceLabelInput(): string | undefined;
    /**
     * @stability stable
     */
    get serviceName(): string;
    private _subnetwork?;
    /**
     * @stability stable
     */
    get subnetwork(): string;
    /**
     * @stability stable
     */
    set subnetwork(value: string);
    /**
     * @stability stable
     */
    resetSubnetwork(): void;
    /**
     * @stability stable
     */
    get subnetworkInput(): string | undefined;
    private _target?;
    /**
     * @stability stable
     */
    get target(): string;
    /**
     * @stability stable
     */
    set target(value: string);
    /**
     * @stability stable
     */
    resetTarget(): void;
    /**
     * @stability stable
     */
    get targetInput(): string | undefined;
    private _timeouts?;
    /**
     * @stability stable
     */
    get timeouts(): ComputeForwardingRuleTimeouts;
    /**
     * @stability stable
     */
    set timeouts(value: ComputeForwardingRuleTimeouts);
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): ComputeForwardingRuleTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
