import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface ComputeGlobalForwardingRuleConfig extends cdktf.TerraformMetaArguments {
    /**
     * An optional description of this resource. Provide this property when you create the resource.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_global_forwarding_rule.html#description ComputeGlobalForwardingRule#description}
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * The IP address that this forwarding rule serves.
     *
     * When a client sends
     * traffic to this IP address, the forwarding rule directs the traffic to
     * the target that you specify in the forwarding rule. The
     * loadBalancingScheme and the forwarding rule's target determine the
     * type of IP address that you can use. For detailed information, refer
     * to [IP address specifications](https://cloud.google.com/load-balancing/docs/forwarding-rule-concepts#ip_address_specifications).
     *
     * An address can be specified either by a literal IP address or a
     * reference to an existing Address resource. If you don't specify a
     * reserved IP address, an ephemeral IP address is assigned.
     *
     * The value must be set to 0.0.0.0 when the target is a targetGrpcProxy
     * that has validateForProxyless field set to true.
     *
     * For Private Service Connect forwarding rules that forward traffic to
     * Google APIs, IP address must be provided.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_global_forwarding_rule.html#ip_address ComputeGlobalForwardingRule#ip_address}
     *
     * @stability stable
     */
    readonly ipAddress?: string;
    /**
     * The IP protocol to which this rule applies.
     *
     * When the load balancing scheme is
     * INTERNAL_SELF_MANAGED, only TCP is valid. This field must not be set if the
     * global address is configured as a purpose of PRIVATE_SERVICE_CONNECT
     * and addressType of INTERNAL Possible values: ["TCP", "UDP", "ESP", "AH", "SCTP", "ICMP"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_global_forwarding_rule.html#ip_protocol ComputeGlobalForwardingRule#ip_protocol}
     *
     * @stability stable
     */
    readonly ipProtocol?: string;
    /**
     * The IP Version that will be used by this global forwarding rule. Possible values: ["IPV4", "IPV6"].
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_global_forwarding_rule.html#ip_version ComputeGlobalForwardingRule#ip_version}
     *
     * @stability stable
     */
    readonly ipVersion?: string;
    /**
     * This signifies what the GlobalForwardingRule will be used for.
     *
     * The value of INTERNAL_SELF_MANAGED means that this will be used for
     * Internal Global HTTP(S) LB. The value of EXTERNAL means that this
     * will be used for External Global Load Balancing (HTTP(S) LB,
     * External TCP/UDP LB, SSL Proxy)
     *
     * ([Beta](https://terraform.io/docs/providers/google/guides/provider_versions.html) only) Note: This field must be set "" if the global address is
     * configured as a purpose of PRIVATE_SERVICE_CONNECT and addressType of INTERNAL. Default value: "EXTERNAL" Possible values: ["EXTERNAL", "INTERNAL_SELF_MANAGED"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_global_forwarding_rule.html#load_balancing_scheme ComputeGlobalForwardingRule#load_balancing_scheme}
     *
     * @stability stable
     */
    readonly loadBalancingScheme?: string;
    /**
     * Name of the resource;
     *
     * provided by the client when the resource is
     * created. The name must be 1-63 characters long, and comply with
     * RFC1035. Specifically, the name must be 1-63 characters long and match
     * the regular expression '[a-z]([-a-z0-9]*[a-z0-9])?' which means the
     * first character must be a lowercase letter, and all following
     * characters must be a dash, lowercase letter, or digit, except the last
     * character, which cannot be a dash.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_global_forwarding_rule.html#name ComputeGlobalForwardingRule#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * This field is used along with the target field for TargetHttpProxy, TargetHttpsProxy, TargetSslProxy, TargetTcpProxy, TargetVpnGateway, TargetPool, TargetInstance.
     *
     * Applicable only when IPProtocol is TCP, UDP, or SCTP, only packets
     * addressed to ports in the specified range will be forwarded to target.
     * Forwarding rules with the same [IPAddress, IPProtocol] pair must have
     * disjoint port ranges.
     *
     * Some types of forwarding target have constraints on the acceptable
     * ports:
     *
     * TargetHttpProxy: 80, 8080
     * TargetHttpsProxy: 443
     * TargetTcpProxy: 25, 43, 110, 143, 195, 443, 465, 587, 700, 993, 995,
     *                1883, 5222
     * TargetSslProxy: 25, 43, 110, 143, 195, 443, 465, 587, 700, 993, 995,
     *                1883, 5222
     * TargetVpnGateway: 500, 4500
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_global_forwarding_rule.html#port_range ComputeGlobalForwardingRule#port_range}
     *
     * @stability stable
     */
    readonly portRange?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_global_forwarding_rule.html#project ComputeGlobalForwardingRule#project}.
     *
     * @stability stable
     */
    readonly project?: string;
    /**
     * The URL of the target resource to receive the matched traffic.
     *
     * The forwarded traffic must be of a type appropriate to the target object.
     * For INTERNAL_SELF_MANAGED load balancing, only HTTP and HTTPS targets
     * are valid.
     *
     * ([Beta](https://terraform.io/docs/providers/google/guides/provider_versions.html) only) For global address with a purpose of PRIVATE_SERVICE_CONNECT and
     * addressType of INTERNAL, only "all-apis" and "vpc-sc" are valid.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_global_forwarding_rule.html#target ComputeGlobalForwardingRule#target}
     *
     * @stability stable
     */
    readonly target: string;
    /**
     * metadata_filters block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_global_forwarding_rule.html#metadata_filters ComputeGlobalForwardingRule#metadata_filters}
     *
     * @stability stable
     */
    readonly metadataFilters?: ComputeGlobalForwardingRuleMetadataFilters[];
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_global_forwarding_rule.html#timeouts ComputeGlobalForwardingRule#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: ComputeGlobalForwardingRuleTimeouts;
}
/**
 * @stability stable
 */
export interface ComputeGlobalForwardingRuleMetadataFiltersFilterLabels {
    /**
     * Name of the metadata label. The length must be between 1 and 1024 characters, inclusive.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_global_forwarding_rule.html#name ComputeGlobalForwardingRule#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * The value that the label must match. The value has a maximum length of 1024 characters.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_global_forwarding_rule.html#value ComputeGlobalForwardingRule#value}
     *
     * @stability stable
     */
    readonly value: string;
}
/**
 * @stability stable
 */
export interface ComputeGlobalForwardingRuleMetadataFilters {
    /**
     * Specifies how individual filterLabel matches within the list of filterLabels contribute towards the overall metadataFilter match.
     *
     * MATCH_ANY - At least one of the filterLabels must have a matching
     * label in the provided metadata.
     * MATCH_ALL - All filterLabels must have matching labels in the
     * provided metadata. Possible values: ["MATCH_ANY", "MATCH_ALL"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_global_forwarding_rule.html#filter_match_criteria ComputeGlobalForwardingRule#filter_match_criteria}
     *
     * @stability stable
     */
    readonly filterMatchCriteria: string;
    /**
     * filter_labels block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_global_forwarding_rule.html#filter_labels ComputeGlobalForwardingRule#filter_labels}
     *
     * @stability stable
     */
    readonly filterLabels: ComputeGlobalForwardingRuleMetadataFiltersFilterLabels[];
}
/**
 * @stability stable
 */
export interface ComputeGlobalForwardingRuleTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_global_forwarding_rule.html#create ComputeGlobalForwardingRule#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_global_forwarding_rule.html#delete ComputeGlobalForwardingRule#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_global_forwarding_rule.html#update ComputeGlobalForwardingRule#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/compute_global_forwarding_rule.html google_compute_global_forwarding_rule}.
 *
 * @stability stable
 */
export declare class ComputeGlobalForwardingRule extends cdktf.TerraformResource {
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/compute_global_forwarding_rule.html google_compute_global_forwarding_rule} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: ComputeGlobalForwardingRuleConfig);
    private _description?;
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    set description(value: string);
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _ipAddress?;
    /**
     * @stability stable
     */
    get ipAddress(): string;
    /**
     * @stability stable
     */
    set ipAddress(value: string);
    /**
     * @stability stable
     */
    resetIpAddress(): void;
    /**
     * @stability stable
     */
    get ipAddressInput(): string | undefined;
    private _ipProtocol?;
    /**
     * @stability stable
     */
    get ipProtocol(): string;
    /**
     * @stability stable
     */
    set ipProtocol(value: string);
    /**
     * @stability stable
     */
    resetIpProtocol(): void;
    /**
     * @stability stable
     */
    get ipProtocolInput(): string | undefined;
    private _ipVersion?;
    /**
     * @stability stable
     */
    get ipVersion(): string;
    /**
     * @stability stable
     */
    set ipVersion(value: string);
    /**
     * @stability stable
     */
    resetIpVersion(): void;
    /**
     * @stability stable
     */
    get ipVersionInput(): string | undefined;
    private _loadBalancingScheme?;
    /**
     * @stability stable
     */
    get loadBalancingScheme(): string;
    /**
     * @stability stable
     */
    set loadBalancingScheme(value: string);
    /**
     * @stability stable
     */
    resetLoadBalancingScheme(): void;
    /**
     * @stability stable
     */
    get loadBalancingSchemeInput(): string | undefined;
    private _name;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string;
    private _portRange?;
    /**
     * @stability stable
     */
    get portRange(): string;
    /**
     * @stability stable
     */
    set portRange(value: string);
    /**
     * @stability stable
     */
    resetPortRange(): void;
    /**
     * @stability stable
     */
    get portRangeInput(): string | undefined;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string;
    /**
     * @stability stable
     */
    set project(value: string);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    /**
     * @stability stable
     */
    get selfLink(): string;
    private _target;
    /**
     * @stability stable
     */
    get target(): string;
    /**
     * @stability stable
     */
    set target(value: string);
    /**
     * @stability stable
     */
    get targetInput(): string;
    private _metadataFilters?;
    /**
     * @stability stable
     */
    get metadataFilters(): ComputeGlobalForwardingRuleMetadataFilters[];
    /**
     * @stability stable
     */
    set metadataFilters(value: ComputeGlobalForwardingRuleMetadataFilters[]);
    /**
     * @stability stable
     */
    resetMetadataFilters(): void;
    /**
     * @stability stable
     */
    get metadataFiltersInput(): ComputeGlobalForwardingRuleMetadataFilters[] | undefined;
    private _timeouts?;
    /**
     * @stability stable
     */
    get timeouts(): ComputeGlobalForwardingRuleTimeouts;
    /**
     * @stability stable
     */
    set timeouts(value: ComputeGlobalForwardingRuleTimeouts);
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): ComputeGlobalForwardingRuleTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
