import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface ComputeInstanceTemplateConfig extends cdktf.TerraformMetaArguments {
    /**
     * Whether to allow sending and receiving of packets with non-matching source or destination IPs. This defaults to false.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_template.html#can_ip_forward ComputeInstanceTemplate#can_ip_forward}
     *
     * @stability stable
     */
    readonly canIpForward?: boolean;
    /**
     * A brief description of this resource.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_template.html#description ComputeInstanceTemplate#description}
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * Enable Virtual Displays on this instance. Note: allow_stopping_for_update must be set to true in order to update this field.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_template.html#enable_display ComputeInstanceTemplate#enable_display}
     *
     * @stability stable
     */
    readonly enableDisplay?: boolean;
    /**
     * A description of the instance.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_template.html#instance_description ComputeInstanceTemplate#instance_description}
     *
     * @stability stable
     */
    readonly instanceDescription?: string;
    /**
     * A set of key/value label pairs to assign to instances created from this template,.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_template.html#labels ComputeInstanceTemplate#labels}
     *
     * @stability stable
     */
    readonly labels?: {
        [key: string]: string;
    };
    /**
     * The machine type to create.
     *
     * To create a machine with a custom type (such as extended memory), format the value like custom-VCPUS-MEM_IN_MB like custom-6-20480 for 6 vCPU and 20GB of RAM.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_template.html#machine_type ComputeInstanceTemplate#machine_type}
     *
     * @stability stable
     */
    readonly machineType: string;
    /**
     * Metadata key/value pairs to make available from within instances created from this template.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_template.html#metadata ComputeInstanceTemplate#metadata}
     *
     * @stability stable
     */
    readonly metadata?: {
        [key: string]: string;
    };
    /**
     * An alternative to using the startup-script metadata key, mostly to match the compute_instance resource.
     *
     * This replaces the startup-script metadata key on the created instance and thus the two mechanisms are not allowed to be used simultaneously.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_template.html#metadata_startup_script ComputeInstanceTemplate#metadata_startup_script}
     *
     * @stability stable
     */
    readonly metadataStartupScript?: string;
    /**
     * Specifies a minimum CPU platform.
     *
     * Applicable values are the friendly names of CPU platforms, such as Intel Haswell or Intel Skylake.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_template.html#min_cpu_platform ComputeInstanceTemplate#min_cpu_platform}
     *
     * @stability stable
     */
    readonly minCpuPlatform?: string;
    /**
     * The name of the instance template. If you leave this blank, Terraform will auto-generate a unique name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_template.html#name ComputeInstanceTemplate#name}
     *
     * @stability stable
     */
    readonly name?: string;
    /**
     * Creates a unique name beginning with the specified prefix. Conflicts with name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_template.html#name_prefix ComputeInstanceTemplate#name_prefix}
     *
     * @stability stable
     */
    readonly namePrefix?: string;
    /**
     * The ID of the project in which the resource belongs.
     *
     * If it is not provided, the provider project is used.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_template.html#project ComputeInstanceTemplate#project}
     *
     * @stability stable
     */
    readonly project?: string;
    /**
     * An instance template is a global resource that is not bound to a zone or a region.
     *
     * However, you can still specify some regional resources in an instance template, which restricts the template to the region where that resource resides. For example, a custom subnetwork resource is tied to a specific region. Defaults to the region of the Provider if no value is given.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_template.html#region ComputeInstanceTemplate#region}
     *
     * @stability stable
     */
    readonly region?: string;
    /**
     * Tags to attach to the instance.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_template.html#tags ComputeInstanceTemplate#tags}
     *
     * @stability stable
     */
    readonly tags?: string[];
    /**
     * confidential_instance_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_template.html#confidential_instance_config ComputeInstanceTemplate#confidential_instance_config}
     *
     * @stability stable
     */
    readonly confidentialInstanceConfig?: ComputeInstanceTemplateConfidentialInstanceConfig[];
    /**
     * disk block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_template.html#disk ComputeInstanceTemplate#disk}
     *
     * @stability stable
     */
    readonly disk: ComputeInstanceTemplateDisk[];
    /**
     * guest_accelerator block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_template.html#guest_accelerator ComputeInstanceTemplate#guest_accelerator}
     *
     * @stability stable
     */
    readonly guestAccelerator?: ComputeInstanceTemplateGuestAccelerator[];
    /**
     * network_interface block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_template.html#network_interface ComputeInstanceTemplate#network_interface}
     *
     * @stability stable
     */
    readonly networkInterface?: ComputeInstanceTemplateNetworkInterface[];
    /**
     * reservation_affinity block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_template.html#reservation_affinity ComputeInstanceTemplate#reservation_affinity}
     *
     * @stability stable
     */
    readonly reservationAffinity?: ComputeInstanceTemplateReservationAffinity[];
    /**
     * scheduling block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_template.html#scheduling ComputeInstanceTemplate#scheduling}
     *
     * @stability stable
     */
    readonly scheduling?: ComputeInstanceTemplateScheduling[];
    /**
     * service_account block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_template.html#service_account ComputeInstanceTemplate#service_account}
     *
     * @stability stable
     */
    readonly serviceAccount?: ComputeInstanceTemplateServiceAccount[];
    /**
     * shielded_instance_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_template.html#shielded_instance_config ComputeInstanceTemplate#shielded_instance_config}
     *
     * @stability stable
     */
    readonly shieldedInstanceConfig?: ComputeInstanceTemplateShieldedInstanceConfig[];
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_template.html#timeouts ComputeInstanceTemplate#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: ComputeInstanceTemplateTimeouts;
}
/**
 * @stability stable
 */
export interface ComputeInstanceTemplateConfidentialInstanceConfig {
    /**
     * Defines whether the instance should have confidential compute enabled.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_template.html#enable_confidential_compute ComputeInstanceTemplate#enable_confidential_compute}
     *
     * @stability stable
     */
    readonly enableConfidentialCompute: boolean;
}
/**
 * @stability stable
 */
export interface ComputeInstanceTemplateDiskDiskEncryptionKey {
    /**
     * The self link of the encryption key that is stored in Google Cloud KMS.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_template.html#kms_key_self_link ComputeInstanceTemplate#kms_key_self_link}
     *
     * @stability stable
     */
    readonly kmsKeySelfLink: string;
}
/**
 * @stability stable
 */
export interface ComputeInstanceTemplateDisk {
    /**
     * Whether or not the disk should be auto-deleted. This defaults to true.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_template.html#auto_delete ComputeInstanceTemplate#auto_delete}
     *
     * @stability stable
     */
    readonly autoDelete?: boolean;
    /**
     * Indicates that this is a boot disk.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_template.html#boot ComputeInstanceTemplate#boot}
     *
     * @stability stable
     */
    readonly boot?: boolean;
    /**
     * A unique device name that is reflected into the /dev/ tree of a Linux operating system running within the instance.
     *
     * If not specified, the server chooses a default device name to apply to this disk.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_template.html#device_name ComputeInstanceTemplate#device_name}
     *
     * @stability stable
     */
    readonly deviceName?: string;
    /**
     * Name of the disk. When not provided, this defaults to the name of the instance.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_template.html#disk_name ComputeInstanceTemplate#disk_name}
     *
     * @stability stable
     */
    readonly diskName?: string;
    /**
     * The size of the image in gigabytes.
     *
     * If not specified, it will inherit the size of its base image. For SCRATCH disks, the size must be exactly 375GB.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_template.html#disk_size_gb ComputeInstanceTemplate#disk_size_gb}
     *
     * @stability stable
     */
    readonly diskSizeGb?: number;
    /**
     * The Google Compute Engine disk type. Can be either "pd-ssd", "local-ssd", "pd-balanced" or "pd-standard".
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_template.html#disk_type ComputeInstanceTemplate#disk_type}
     *
     * @stability stable
     */
    readonly diskType?: string;
    /**
     * Specifies the disk interface to use for attaching this disk.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_template.html#interface ComputeInstanceTemplate#interface}
     *
     * @stability stable
     */
    readonly interface?: string;
    /**
     * A set of key/value label pairs to assign to disks,.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_template.html#labels ComputeInstanceTemplate#labels}
     *
     * @stability stable
     */
    readonly labels?: {
        [key: string]: string;
    };
    /**
     * The mode in which to attach this disk, either READ_WRITE or READ_ONLY.
     *
     * If you are attaching or creating a boot disk, this must read-write mode.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_template.html#mode ComputeInstanceTemplate#mode}
     *
     * @stability stable
     */
    readonly mode?: string;
    /**
     * A list (short name or id) of resource policies to attach to this disk.
     *
     * Currently a max of 1 resource policy is supported.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_template.html#resource_policies ComputeInstanceTemplate#resource_policies}
     *
     * @stability stable
     */
    readonly resourcePolicies?: string[];
    /**
     * The name (not self_link) of the disk (such as those managed by google_compute_disk) to attach.
     *
     * ~> Note: Either source or source_image is required when creating a new instance except for when creating a local SSD.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_template.html#source ComputeInstanceTemplate#source}
     *
     * @stability stable
     */
    readonly source?: string;
    /**
     * The image from which to initialize this disk.
     *
     * This can be one of: the image's self_link, projects/{project}/global/images/{image}, projects/{project}/global/images/family/{family}, global/images/{image}, global/images/family/{family}, family/{family}, {project}/{family}, {project}/{image}, {family}, or {image}. ~> Note: Either source or source_image is required when creating a new instance except for when creating a local SSD.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_template.html#source_image ComputeInstanceTemplate#source_image}
     *
     * @stability stable
     */
    readonly sourceImage?: string;
    /**
     * The type of Google Compute Engine disk, can be either "SCRATCH" or "PERSISTENT".
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_template.html#type ComputeInstanceTemplate#type}
     *
     * @stability stable
     */
    readonly type?: string;
    /**
     * disk_encryption_key block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_template.html#disk_encryption_key ComputeInstanceTemplate#disk_encryption_key}
     *
     * @stability stable
     */
    readonly diskEncryptionKey?: ComputeInstanceTemplateDiskDiskEncryptionKey[];
}
/**
 * @stability stable
 */
export interface ComputeInstanceTemplateGuestAccelerator {
    /**
     * The number of the guest accelerator cards exposed to this instance.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_template.html#count ComputeInstanceTemplate#count}
     *
     * @stability stable
     */
    readonly count: number;
    /**
     * The accelerator type resource to expose to this instance. E.g. nvidia-tesla-k80.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_template.html#type ComputeInstanceTemplate#type}
     *
     * @stability stable
     */
    readonly type: string;
}
/**
 * @stability stable
 */
export interface ComputeInstanceTemplateNetworkInterfaceAccessConfig {
    /**
     * The IP address that will be 1:1 mapped to the instance's network ip.
     *
     * If not given, one will be generated.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_template.html#nat_ip ComputeInstanceTemplate#nat_ip}
     *
     * @stability stable
     */
    readonly natIp?: string;
    /**
     * The networking tier used for configuring this instance template.
     *
     * This field can take the following values: PREMIUM or STANDARD. If this field is not specified, it is assumed to be PREMIUM.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_template.html#network_tier ComputeInstanceTemplate#network_tier}
     *
     * @stability stable
     */
    readonly networkTier?: string;
}
/**
 * @stability stable
 */
export interface ComputeInstanceTemplateNetworkInterfaceAliasIpRange {
    /**
     * The IP CIDR range represented by this alias IP range.
     *
     * This IP CIDR range must belong to the specified subnetwork and cannot contain IP addresses reserved by system or used by other network interfaces. At the time of writing only a netmask (e.g. /24) may be supplied, with a CIDR format resulting in an API error.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_template.html#ip_cidr_range ComputeInstanceTemplate#ip_cidr_range}
     *
     * @stability stable
     */
    readonly ipCidrRange: string;
    /**
     * The subnetwork secondary range name specifying the secondary range from which to allocate the IP CIDR range for this alias IP range.
     *
     * If left unspecified, the primary range of the subnetwork will be used.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_template.html#subnetwork_range_name ComputeInstanceTemplate#subnetwork_range_name}
     *
     * @stability stable
     */
    readonly subnetworkRangeName?: string;
}
/**
 * @stability stable
 */
export interface ComputeInstanceTemplateNetworkInterface {
    /**
     * The name or self_link of the network to attach this interface to.
     *
     * Use network attribute for Legacy or Auto subnetted networks and subnetwork for custom subnetted networks.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_template.html#network ComputeInstanceTemplate#network}
     *
     * @stability stable
     */
    readonly network?: string;
    /**
     * The private IP address to assign to the instance. If empty, the address will be automatically assigned.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_template.html#network_ip ComputeInstanceTemplate#network_ip}
     *
     * @stability stable
     */
    readonly networkIp?: string;
    /**
     * The type of vNIC to be used on this interface. Possible values:GVNIC, VIRTIO_NET.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_template.html#nic_type ComputeInstanceTemplate#nic_type}
     *
     * @stability stable
     */
    readonly nicType?: string;
    /**
     * The name of the subnetwork to attach this interface to.
     *
     * The subnetwork must exist in the same region this instance will be created in. Either network or subnetwork must be provided.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_template.html#subnetwork ComputeInstanceTemplate#subnetwork}
     *
     * @stability stable
     */
    readonly subnetwork?: string;
    /**
     * The ID of the project in which the subnetwork belongs.
     *
     * If it is not provided, the provider project is used.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_template.html#subnetwork_project ComputeInstanceTemplate#subnetwork_project}
     *
     * @stability stable
     */
    readonly subnetworkProject?: string;
    /**
     * access_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_template.html#access_config ComputeInstanceTemplate#access_config}
     *
     * @stability stable
     */
    readonly accessConfig?: ComputeInstanceTemplateNetworkInterfaceAccessConfig[];
    /**
     * alias_ip_range block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_template.html#alias_ip_range ComputeInstanceTemplate#alias_ip_range}
     *
     * @stability stable
     */
    readonly aliasIpRange?: ComputeInstanceTemplateNetworkInterfaceAliasIpRange[];
}
/**
 * @stability stable
 */
export interface ComputeInstanceTemplateReservationAffinitySpecificReservation {
    /**
     * Corresponds to the label key of a reservation resource.
     *
     * To target a SPECIFIC_RESERVATION by name, specify compute.googleapis.com/reservation-name as the key and specify the name of your reservation as the only value.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_template.html#key ComputeInstanceTemplate#key}
     *
     * @stability stable
     */
    readonly key: string;
    /**
     * Corresponds to the label values of a reservation resource.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_template.html#values ComputeInstanceTemplate#values}
     *
     * @stability stable
     */
    readonly values: string[];
}
/**
 * @stability stable
 */
export interface ComputeInstanceTemplateReservationAffinity {
    /**
     * The type of reservation from which this instance can consume resources.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_template.html#type ComputeInstanceTemplate#type}
     *
     * @stability stable
     */
    readonly type: string;
    /**
     * specific_reservation block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_template.html#specific_reservation ComputeInstanceTemplate#specific_reservation}
     *
     * @stability stable
     */
    readonly specificReservation?: ComputeInstanceTemplateReservationAffinitySpecificReservation[];
}
/**
 * @stability stable
 */
export interface ComputeInstanceTemplateSchedulingNodeAffinities {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_template.html#key ComputeInstanceTemplate#key}.
     *
     * @stability stable
     */
    readonly key: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_template.html#operator ComputeInstanceTemplate#operator}.
     *
     * @stability stable
     */
    readonly operator: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_template.html#values ComputeInstanceTemplate#values}.
     *
     * @stability stable
     */
    readonly values: string[];
}
/**
 * @stability stable
 */
export interface ComputeInstanceTemplateScheduling {
    /**
     * Specifies whether the instance should be automatically restarted if it is terminated by Compute Engine (not terminated by a user).
     *
     * This defaults to true.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_template.html#automatic_restart ComputeInstanceTemplate#automatic_restart}
     *
     * @stability stable
     */
    readonly automaticRestart?: boolean;
    /**
     * Minimum number of cpus for the instance.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_template.html#min_node_cpus ComputeInstanceTemplate#min_node_cpus}
     *
     * @stability stable
     */
    readonly minNodeCpus?: number;
    /**
     * Defines the maintenance behavior for this instance.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_template.html#on_host_maintenance ComputeInstanceTemplate#on_host_maintenance}
     *
     * @stability stable
     */
    readonly onHostMaintenance?: string;
    /**
     * Allows instance to be preempted. This defaults to false.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_template.html#preemptible ComputeInstanceTemplate#preemptible}
     *
     * @stability stable
     */
    readonly preemptible?: boolean;
    /**
     * node_affinities block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_template.html#node_affinities ComputeInstanceTemplate#node_affinities}
     *
     * @stability stable
     */
    readonly nodeAffinities?: ComputeInstanceTemplateSchedulingNodeAffinities[];
}
/**
 * @stability stable
 */
export interface ComputeInstanceTemplateServiceAccount {
    /**
     * The service account e-mail address. If not given, the default Google Compute Engine service account is used.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_template.html#email ComputeInstanceTemplate#email}
     *
     * @stability stable
     */
    readonly email?: string;
    /**
     * A list of service scopes.
     *
     * Both OAuth2 URLs and gcloud short names are supported. To allow full access to all Cloud APIs, use the cloud-platform scope.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_template.html#scopes ComputeInstanceTemplate#scopes}
     *
     * @stability stable
     */
    readonly scopes: string[];
}
/**
 * @stability stable
 */
export interface ComputeInstanceTemplateShieldedInstanceConfig {
    /**
     * Compare the most recent boot measurements to the integrity policy baseline and return a pair of pass/fail results depending on whether they match or not.
     *
     * Defaults to true.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_template.html#enable_integrity_monitoring ComputeInstanceTemplate#enable_integrity_monitoring}
     *
     * @stability stable
     */
    readonly enableIntegrityMonitoring?: boolean;
    /**
     * Verify the digital signature of all boot components, and halt the boot process if signature verification fails.
     *
     * Defaults to false.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_template.html#enable_secure_boot ComputeInstanceTemplate#enable_secure_boot}
     *
     * @stability stable
     */
    readonly enableSecureBoot?: boolean;
    /**
     * Use a virtualized trusted platform module, which is a specialized computer chip you can use to encrypt objects like keys and certificates.
     *
     * Defaults to true.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_template.html#enable_vtpm ComputeInstanceTemplate#enable_vtpm}
     *
     * @stability stable
     */
    readonly enableVtpm?: boolean;
}
/**
 * @stability stable
 */
export interface ComputeInstanceTemplateTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_template.html#create ComputeInstanceTemplate#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_template.html#delete ComputeInstanceTemplate#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/compute_instance_template.html google_compute_instance_template}.
 *
 * @stability stable
 */
export declare class ComputeInstanceTemplate extends cdktf.TerraformResource {
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/compute_instance_template.html google_compute_instance_template} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: ComputeInstanceTemplateConfig);
    private _canIpForward?;
    /**
     * @stability stable
     */
    get canIpForward(): boolean;
    /**
     * @stability stable
     */
    set canIpForward(value: boolean);
    /**
     * @stability stable
     */
    resetCanIpForward(): void;
    /**
     * @stability stable
     */
    get canIpForwardInput(): boolean | undefined;
    private _description?;
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    set description(value: string);
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    private _enableDisplay?;
    /**
     * @stability stable
     */
    get enableDisplay(): boolean;
    /**
     * @stability stable
     */
    set enableDisplay(value: boolean);
    /**
     * @stability stable
     */
    resetEnableDisplay(): void;
    /**
     * @stability stable
     */
    get enableDisplayInput(): boolean | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _instanceDescription?;
    /**
     * @stability stable
     */
    get instanceDescription(): string;
    /**
     * @stability stable
     */
    set instanceDescription(value: string);
    /**
     * @stability stable
     */
    resetInstanceDescription(): void;
    /**
     * @stability stable
     */
    get instanceDescriptionInput(): string | undefined;
    private _labels?;
    /**
     * @stability stable
     */
    get labels(): {
        [key: string]: string;
    };
    /**
     * @stability stable
     */
    set labels(value: {
        [key: string]: string;
    });
    /**
     * @stability stable
     */
    resetLabels(): void;
    /**
     * @stability stable
     */
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _machineType;
    /**
     * @stability stable
     */
    get machineType(): string;
    /**
     * @stability stable
     */
    set machineType(value: string);
    /**
     * @stability stable
     */
    get machineTypeInput(): string;
    private _metadata?;
    /**
     * @stability stable
     */
    get metadata(): {
        [key: string]: string;
    };
    /**
     * @stability stable
     */
    set metadata(value: {
        [key: string]: string;
    });
    /**
     * @stability stable
     */
    resetMetadata(): void;
    /**
     * @stability stable
     */
    get metadataInput(): {
        [key: string]: string;
    } | undefined;
    /**
     * @stability stable
     */
    get metadataFingerprint(): string;
    private _metadataStartupScript?;
    /**
     * @stability stable
     */
    get metadataStartupScript(): string;
    /**
     * @stability stable
     */
    set metadataStartupScript(value: string);
    /**
     * @stability stable
     */
    resetMetadataStartupScript(): void;
    /**
     * @stability stable
     */
    get metadataStartupScriptInput(): string | undefined;
    private _minCpuPlatform?;
    /**
     * @stability stable
     */
    get minCpuPlatform(): string;
    /**
     * @stability stable
     */
    set minCpuPlatform(value: string);
    /**
     * @stability stable
     */
    resetMinCpuPlatform(): void;
    /**
     * @stability stable
     */
    get minCpuPlatformInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    resetName(): void;
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _namePrefix?;
    /**
     * @stability stable
     */
    get namePrefix(): string;
    /**
     * @stability stable
     */
    set namePrefix(value: string);
    /**
     * @stability stable
     */
    resetNamePrefix(): void;
    /**
     * @stability stable
     */
    get namePrefixInput(): string | undefined;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string;
    /**
     * @stability stable
     */
    set project(value: string);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    private _region?;
    /**
     * @stability stable
     */
    get region(): string;
    /**
     * @stability stable
     */
    set region(value: string);
    /**
     * @stability stable
     */
    resetRegion(): void;
    /**
     * @stability stable
     */
    get regionInput(): string | undefined;
    /**
     * @stability stable
     */
    get selfLink(): string;
    private _tags?;
    /**
     * @stability stable
     */
    get tags(): string[];
    /**
     * @stability stable
     */
    set tags(value: string[]);
    /**
     * @stability stable
     */
    resetTags(): void;
    /**
     * @stability stable
     */
    get tagsInput(): string[] | undefined;
    /**
     * @stability stable
     */
    get tagsFingerprint(): string;
    private _confidentialInstanceConfig?;
    /**
     * @stability stable
     */
    get confidentialInstanceConfig(): ComputeInstanceTemplateConfidentialInstanceConfig[];
    /**
     * @stability stable
     */
    set confidentialInstanceConfig(value: ComputeInstanceTemplateConfidentialInstanceConfig[]);
    /**
     * @stability stable
     */
    resetConfidentialInstanceConfig(): void;
    /**
     * @stability stable
     */
    get confidentialInstanceConfigInput(): ComputeInstanceTemplateConfidentialInstanceConfig[] | undefined;
    private _disk;
    /**
     * @stability stable
     */
    get disk(): ComputeInstanceTemplateDisk[];
    /**
     * @stability stable
     */
    set disk(value: ComputeInstanceTemplateDisk[]);
    /**
     * @stability stable
     */
    get diskInput(): ComputeInstanceTemplateDisk[];
    private _guestAccelerator?;
    /**
     * @stability stable
     */
    get guestAccelerator(): ComputeInstanceTemplateGuestAccelerator[];
    /**
     * @stability stable
     */
    set guestAccelerator(value: ComputeInstanceTemplateGuestAccelerator[]);
    /**
     * @stability stable
     */
    resetGuestAccelerator(): void;
    /**
     * @stability stable
     */
    get guestAcceleratorInput(): ComputeInstanceTemplateGuestAccelerator[] | undefined;
    private _networkInterface?;
    /**
     * @stability stable
     */
    get networkInterface(): ComputeInstanceTemplateNetworkInterface[];
    /**
     * @stability stable
     */
    set networkInterface(value: ComputeInstanceTemplateNetworkInterface[]);
    /**
     * @stability stable
     */
    resetNetworkInterface(): void;
    /**
     * @stability stable
     */
    get networkInterfaceInput(): ComputeInstanceTemplateNetworkInterface[] | undefined;
    private _reservationAffinity?;
    /**
     * @stability stable
     */
    get reservationAffinity(): ComputeInstanceTemplateReservationAffinity[];
    /**
     * @stability stable
     */
    set reservationAffinity(value: ComputeInstanceTemplateReservationAffinity[]);
    /**
     * @stability stable
     */
    resetReservationAffinity(): void;
    /**
     * @stability stable
     */
    get reservationAffinityInput(): ComputeInstanceTemplateReservationAffinity[] | undefined;
    private _scheduling?;
    /**
     * @stability stable
     */
    get scheduling(): ComputeInstanceTemplateScheduling[];
    /**
     * @stability stable
     */
    set scheduling(value: ComputeInstanceTemplateScheduling[]);
    /**
     * @stability stable
     */
    resetScheduling(): void;
    /**
     * @stability stable
     */
    get schedulingInput(): ComputeInstanceTemplateScheduling[] | undefined;
    private _serviceAccount?;
    /**
     * @stability stable
     */
    get serviceAccount(): ComputeInstanceTemplateServiceAccount[];
    /**
     * @stability stable
     */
    set serviceAccount(value: ComputeInstanceTemplateServiceAccount[]);
    /**
     * @stability stable
     */
    resetServiceAccount(): void;
    /**
     * @stability stable
     */
    get serviceAccountInput(): ComputeInstanceTemplateServiceAccount[] | undefined;
    private _shieldedInstanceConfig?;
    /**
     * @stability stable
     */
    get shieldedInstanceConfig(): ComputeInstanceTemplateShieldedInstanceConfig[];
    /**
     * @stability stable
     */
    set shieldedInstanceConfig(value: ComputeInstanceTemplateShieldedInstanceConfig[]);
    /**
     * @stability stable
     */
    resetShieldedInstanceConfig(): void;
    /**
     * @stability stable
     */
    get shieldedInstanceConfigInput(): ComputeInstanceTemplateShieldedInstanceConfig[] | undefined;
    private _timeouts?;
    /**
     * @stability stable
     */
    get timeouts(): ComputeInstanceTemplateTimeouts;
    /**
     * @stability stable
     */
    set timeouts(value: ComputeInstanceTemplateTimeouts);
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): ComputeInstanceTemplateTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
