import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface ComputeNodeGroupConfig extends cdktf.TerraformMetaArguments {
    /**
     * An optional textual description of the resource.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_node_group.html#description ComputeNodeGroup#description}
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * The initial number of nodes in the node group. One of 'initial_size' or 'size' must be specified.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_node_group.html#initial_size ComputeNodeGroup#initial_size}
     *
     * @stability stable
     */
    readonly initialSize?: number;
    /**
     * Specifies how to handle instances when a node in the group undergoes maintenance.
     *
     * Set to one of: DEFAULT, RESTART_IN_PLACE, or MIGRATE_WITHIN_NODE_GROUP. The default value is DEFAULT.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_node_group.html#maintenance_policy ComputeNodeGroup#maintenance_policy}
     *
     * @stability stable
     */
    readonly maintenancePolicy?: string;
    /**
     * Name of the resource.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_node_group.html#name ComputeNodeGroup#name}
     *
     * @stability stable
     */
    readonly name?: string;
    /**
     * The URL of the node template to which this node group belongs.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_node_group.html#node_template ComputeNodeGroup#node_template}
     *
     * @stability stable
     */
    readonly nodeTemplate: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_node_group.html#project ComputeNodeGroup#project}.
     *
     * @stability stable
     */
    readonly project?: string;
    /**
     * The total number of nodes in the node group. One of 'initial_size' or 'size' must be specified.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_node_group.html#size ComputeNodeGroup#size}
     *
     * @stability stable
     */
    readonly size?: number;
    /**
     * Zone where this node group is located.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_node_group.html#zone ComputeNodeGroup#zone}
     *
     * @stability stable
     */
    readonly zone?: string;
    /**
     * autoscaling_policy block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_node_group.html#autoscaling_policy ComputeNodeGroup#autoscaling_policy}
     *
     * @stability stable
     */
    readonly autoscalingPolicy?: ComputeNodeGroupAutoscalingPolicy[];
    /**
     * maintenance_window block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_node_group.html#maintenance_window ComputeNodeGroup#maintenance_window}
     *
     * @stability stable
     */
    readonly maintenanceWindow?: ComputeNodeGroupMaintenanceWindow[];
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_node_group.html#timeouts ComputeNodeGroup#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: ComputeNodeGroupTimeouts;
}
/**
 * @stability stable
 */
export interface ComputeNodeGroupAutoscalingPolicy {
    /**
     * Maximum size of the node group.
     *
     * Set to a value less than or equal
     * to 100 and greater than or equal to min-nodes.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_node_group.html#max_nodes ComputeNodeGroup#max_nodes}
     *
     * @stability stable
     */
    readonly maxNodes?: number;
    /**
     * Minimum size of the node group. Must be less than or equal to max-nodes. The default value is 0.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_node_group.html#min_nodes ComputeNodeGroup#min_nodes}
     *
     * @stability stable
     */
    readonly minNodes?: number;
    /**
     * The autoscaling mode.
     *
     * Set to one of the following:
     * - OFF: Disables the autoscaler.
     * - ON: Enables scaling in and scaling out.
     * - ONLY_SCALE_OUT: Enables only scaling out.
     * You must use this mode if your node groups are configured to
     * restart their hosted VMs on minimal servers. Possible values: ["OFF", "ON", "ONLY_SCALE_OUT"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_node_group.html#mode ComputeNodeGroup#mode}
     *
     * @stability stable
     */
    readonly mode?: string;
}
/**
 * @stability stable
 */
export interface ComputeNodeGroupMaintenanceWindow {
    /**
     * instances.start time of the window. This must be in UTC format that resolves to one of 00:00, 04:00, 08:00, 12:00, 16:00, or 20:00. For example, both 13:00-5 and 08:00 are valid.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_node_group.html#start_time ComputeNodeGroup#start_time}
     *
     * @stability stable
     */
    readonly startTime: string;
}
/**
 * @stability stable
 */
export interface ComputeNodeGroupTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_node_group.html#create ComputeNodeGroup#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_node_group.html#delete ComputeNodeGroup#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_node_group.html#update ComputeNodeGroup#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/compute_node_group.html google_compute_node_group}.
 *
 * @stability stable
 */
export declare class ComputeNodeGroup extends cdktf.TerraformResource {
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/compute_node_group.html google_compute_node_group} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: ComputeNodeGroupConfig);
    /**
     * @stability stable
     */
    get creationTimestamp(): string;
    private _description?;
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    set description(value: string);
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _initialSize?;
    /**
     * @stability stable
     */
    get initialSize(): number;
    /**
     * @stability stable
     */
    set initialSize(value: number);
    /**
     * @stability stable
     */
    resetInitialSize(): void;
    /**
     * @stability stable
     */
    get initialSizeInput(): number | undefined;
    private _maintenancePolicy?;
    /**
     * @stability stable
     */
    get maintenancePolicy(): string;
    /**
     * @stability stable
     */
    set maintenancePolicy(value: string);
    /**
     * @stability stable
     */
    resetMaintenancePolicy(): void;
    /**
     * @stability stable
     */
    get maintenancePolicyInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    resetName(): void;
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _nodeTemplate;
    /**
     * @stability stable
     */
    get nodeTemplate(): string;
    /**
     * @stability stable
     */
    set nodeTemplate(value: string);
    /**
     * @stability stable
     */
    get nodeTemplateInput(): string;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string;
    /**
     * @stability stable
     */
    set project(value: string);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    /**
     * @stability stable
     */
    get selfLink(): string;
    private _size?;
    /**
     * @stability stable
     */
    get size(): number;
    /**
     * @stability stable
     */
    set size(value: number);
    /**
     * @stability stable
     */
    resetSize(): void;
    /**
     * @stability stable
     */
    get sizeInput(): number | undefined;
    private _zone?;
    /**
     * @stability stable
     */
    get zone(): string;
    /**
     * @stability stable
     */
    set zone(value: string);
    /**
     * @stability stable
     */
    resetZone(): void;
    /**
     * @stability stable
     */
    get zoneInput(): string | undefined;
    private _autoscalingPolicy?;
    /**
     * @stability stable
     */
    get autoscalingPolicy(): ComputeNodeGroupAutoscalingPolicy[];
    /**
     * @stability stable
     */
    set autoscalingPolicy(value: ComputeNodeGroupAutoscalingPolicy[]);
    /**
     * @stability stable
     */
    resetAutoscalingPolicy(): void;
    /**
     * @stability stable
     */
    get autoscalingPolicyInput(): ComputeNodeGroupAutoscalingPolicy[] | undefined;
    private _maintenanceWindow?;
    /**
     * @stability stable
     */
    get maintenanceWindow(): ComputeNodeGroupMaintenanceWindow[];
    /**
     * @stability stable
     */
    set maintenanceWindow(value: ComputeNodeGroupMaintenanceWindow[]);
    /**
     * @stability stable
     */
    resetMaintenanceWindow(): void;
    /**
     * @stability stable
     */
    get maintenanceWindowInput(): ComputeNodeGroupMaintenanceWindow[] | undefined;
    private _timeouts?;
    /**
     * @stability stable
     */
    get timeouts(): ComputeNodeGroupTimeouts;
    /**
     * @stability stable
     */
    set timeouts(value: ComputeNodeGroupTimeouts);
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): ComputeNodeGroupTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
