import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface ComputeRegionNetworkEndpointGroupConfig extends cdktf.TerraformMetaArguments {
    /**
     * An optional description of this resource. Provide this property when you create the resource.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_network_endpoint_group.html#description ComputeRegionNetworkEndpointGroup#description}
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * Name of the resource;
     *
     * provided by the client when the resource is
     * created. The name must be 1-63 characters long, and comply with
     * RFC1035. Specifically, the name must be 1-63 characters long and match
     * the regular expression '[a-z]([-a-z0-9]*[a-z0-9])?' which means the
     * first character must be a lowercase letter, and all following
     * characters must be a dash, lowercase letter, or digit, except the last
     * character, which cannot be a dash.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_network_endpoint_group.html#name ComputeRegionNetworkEndpointGroup#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Type of network endpoints in this network endpoint group. Defaults to SERVERLESS Default value: "SERVERLESS" Possible values: ["SERVERLESS"].
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_network_endpoint_group.html#network_endpoint_type ComputeRegionNetworkEndpointGroup#network_endpoint_type}
     *
     * @stability stable
     */
    readonly networkEndpointType?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_network_endpoint_group.html#project ComputeRegionNetworkEndpointGroup#project}.
     *
     * @stability stable
     */
    readonly project?: string;
    /**
     * A reference to the region where the Serverless NEGs Reside.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_network_endpoint_group.html#region ComputeRegionNetworkEndpointGroup#region}
     *
     * @stability stable
     */
    readonly region: string;
    /**
     * app_engine block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_network_endpoint_group.html#app_engine ComputeRegionNetworkEndpointGroup#app_engine}
     *
     * @stability stable
     */
    readonly appEngine?: ComputeRegionNetworkEndpointGroupAppEngine[];
    /**
     * cloud_function block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_network_endpoint_group.html#cloud_function ComputeRegionNetworkEndpointGroup#cloud_function}
     *
     * @stability stable
     */
    readonly cloudFunction?: ComputeRegionNetworkEndpointGroupCloudFunction[];
    /**
     * cloud_run block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_network_endpoint_group.html#cloud_run ComputeRegionNetworkEndpointGroup#cloud_run}
     *
     * @stability stable
     */
    readonly cloudRun?: ComputeRegionNetworkEndpointGroupCloudRun[];
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_network_endpoint_group.html#timeouts ComputeRegionNetworkEndpointGroup#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: ComputeRegionNetworkEndpointGroupTimeouts;
}
/**
 * @stability stable
 */
export interface ComputeRegionNetworkEndpointGroupAppEngine {
    /**
     * Optional serving service. The service name must be 1-63 characters long, and comply with RFC1035. Example value: "default", "my-service".
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_network_endpoint_group.html#service ComputeRegionNetworkEndpointGroup#service}
     *
     * @stability stable
     */
    readonly service?: string;
    /**
     * A template to parse service and version fields from a request URL.
     *
     * URL mask allows for routing to multiple App Engine services without
     * having to create multiple Network Endpoint Groups and backend services.
     *
     * For example, the request URLs "foo1-dot-appname.appspot.com/v1" and
     * "foo1-dot-appname.appspot.com/v2" can be backed by the same Serverless NEG with
     * URL mask "-dot-appname.appspot.com/". The URL mask will parse
     * them to { service = "foo1", version = "v1" } and { service = "foo1", version = "v2" } respectively.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_network_endpoint_group.html#url_mask ComputeRegionNetworkEndpointGroup#url_mask}
     *
     * @stability stable
     */
    readonly urlMask?: string;
    /**
     * Optional serving version. The version must be 1-63 characters long, and comply with RFC1035. Example value: "v1", "v2".
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_network_endpoint_group.html#version ComputeRegionNetworkEndpointGroup#version}
     *
     * @stability stable
     */
    readonly version?: string;
}
/**
 * @stability stable
 */
export interface ComputeRegionNetworkEndpointGroupCloudFunction {
    /**
     * A user-defined name of the Cloud Function. The function name is case-sensitive and must be 1-63 characters long. Example value: "func1".
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_network_endpoint_group.html#function ComputeRegionNetworkEndpointGroup#function}
     *
     * @stability stable
     */
    readonly function?: string;
    /**
     * A template to parse function field from a request URL.
     *
     * URL mask allows
     * for routing to multiple Cloud Functions without having to create
     * multiple Network Endpoint Groups and backend services.
     *
     * For example, request URLs "mydomain.com/function1" and "mydomain.com/function2"
     * can be backed by the same Serverless NEG with URL mask "/". The URL mask
     * will parse them to { function = "function1" } and { function = "function2" } respectively.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_network_endpoint_group.html#url_mask ComputeRegionNetworkEndpointGroup#url_mask}
     *
     * @stability stable
     */
    readonly urlMask?: string;
}
/**
 * @stability stable
 */
export interface ComputeRegionNetworkEndpointGroupCloudRun {
    /**
     * Cloud Run service is the main resource of Cloud Run.
     *
     * The service must be 1-63 characters long, and comply with RFC1035.
     * Example value: "run-service".
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_network_endpoint_group.html#service ComputeRegionNetworkEndpointGroup#service}
     *
     * @stability stable
     */
    readonly service?: string;
    /**
     * Cloud Run tag represents the "named-revision" to provide additional fine-grained traffic routing information.
     *
     * The tag must be 1-63 characters long, and comply with RFC1035.
     * Example value: "revision-0010".
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_network_endpoint_group.html#tag ComputeRegionNetworkEndpointGroup#tag}
     *
     * @stability stable
     */
    readonly tag?: string;
    /**
     * A template to parse service and tag fields from a request URL.
     *
     * URL mask allows for routing to multiple Run services without having
     * to create multiple network endpoint groups and backend services.
     *
     * For example, request URLs "foo1.domain.com/bar1" and "foo1.domain.com/bar2"
     * an be backed by the same Serverless Network Endpoint Group (NEG) with
     * URL mask ".domain.com/". The URL mask will parse them to { service="bar1", tag="foo1" }
     * and { service="bar2", tag="foo2" } respectively.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_network_endpoint_group.html#url_mask ComputeRegionNetworkEndpointGroup#url_mask}
     *
     * @stability stable
     */
    readonly urlMask?: string;
}
/**
 * @stability stable
 */
export interface ComputeRegionNetworkEndpointGroupTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_network_endpoint_group.html#create ComputeRegionNetworkEndpointGroup#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_network_endpoint_group.html#delete ComputeRegionNetworkEndpointGroup#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/compute_region_network_endpoint_group.html google_compute_region_network_endpoint_group}.
 *
 * @stability stable
 */
export declare class ComputeRegionNetworkEndpointGroup extends cdktf.TerraformResource {
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/compute_region_network_endpoint_group.html google_compute_region_network_endpoint_group} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: ComputeRegionNetworkEndpointGroupConfig);
    private _description?;
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    set description(value: string);
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _name;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string;
    private _networkEndpointType?;
    /**
     * @stability stable
     */
    get networkEndpointType(): string;
    /**
     * @stability stable
     */
    set networkEndpointType(value: string);
    /**
     * @stability stable
     */
    resetNetworkEndpointType(): void;
    /**
     * @stability stable
     */
    get networkEndpointTypeInput(): string | undefined;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string;
    /**
     * @stability stable
     */
    set project(value: string);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    private _region;
    /**
     * @stability stable
     */
    get region(): string;
    /**
     * @stability stable
     */
    set region(value: string);
    /**
     * @stability stable
     */
    get regionInput(): string;
    /**
     * @stability stable
     */
    get selfLink(): string;
    private _appEngine?;
    /**
     * @stability stable
     */
    get appEngine(): ComputeRegionNetworkEndpointGroupAppEngine[];
    /**
     * @stability stable
     */
    set appEngine(value: ComputeRegionNetworkEndpointGroupAppEngine[]);
    /**
     * @stability stable
     */
    resetAppEngine(): void;
    /**
     * @stability stable
     */
    get appEngineInput(): ComputeRegionNetworkEndpointGroupAppEngine[] | undefined;
    private _cloudFunction?;
    /**
     * @stability stable
     */
    get cloudFunction(): ComputeRegionNetworkEndpointGroupCloudFunction[];
    /**
     * @stability stable
     */
    set cloudFunction(value: ComputeRegionNetworkEndpointGroupCloudFunction[]);
    /**
     * @stability stable
     */
    resetCloudFunction(): void;
    /**
     * @stability stable
     */
    get cloudFunctionInput(): ComputeRegionNetworkEndpointGroupCloudFunction[] | undefined;
    private _cloudRun?;
    /**
     * @stability stable
     */
    get cloudRun(): ComputeRegionNetworkEndpointGroupCloudRun[];
    /**
     * @stability stable
     */
    set cloudRun(value: ComputeRegionNetworkEndpointGroupCloudRun[]);
    /**
     * @stability stable
     */
    resetCloudRun(): void;
    /**
     * @stability stable
     */
    get cloudRunInput(): ComputeRegionNetworkEndpointGroupCloudRun[] | undefined;
    private _timeouts?;
    /**
     * @stability stable
     */
    get timeouts(): ComputeRegionNetworkEndpointGroupTimeouts;
    /**
     * @stability stable
     */
    set timeouts(value: ComputeRegionNetworkEndpointGroupTimeouts);
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): ComputeRegionNetworkEndpointGroupTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
