import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface ComputeResourcePolicyConfig extends cdktf.TerraformMetaArguments {
    /**
     * An optional description of this resource. Provide this property when you create the resource.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_resource_policy.html#description ComputeResourcePolicy#description}
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * The name of the resource, provided by the client when initially creating the resource.
     *
     * The resource name must be 1-63 characters long, and comply
     * with RFC1035. Specifically, the name must be 1-63 characters long and
     * match the regular expression '[a-z]([-a-z0-9]*[a-z0-9])'? which means the
     * first character must be a lowercase letter, and all following characters
     * must be a dash, lowercase letter, or digit, except the last character,
     * which cannot be a dash.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_resource_policy.html#name ComputeResourcePolicy#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_resource_policy.html#project ComputeResourcePolicy#project}.
     *
     * @stability stable
     */
    readonly project?: string;
    /**
     * Region where resource policy resides.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_resource_policy.html#region ComputeResourcePolicy#region}
     *
     * @stability stable
     */
    readonly region?: string;
    /**
     * group_placement_policy block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_resource_policy.html#group_placement_policy ComputeResourcePolicy#group_placement_policy}
     *
     * @stability stable
     */
    readonly groupPlacementPolicy?: ComputeResourcePolicyGroupPlacementPolicy[];
    /**
     * instance_schedule_policy block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_resource_policy.html#instance_schedule_policy ComputeResourcePolicy#instance_schedule_policy}
     *
     * @stability stable
     */
    readonly instanceSchedulePolicy?: ComputeResourcePolicyInstanceSchedulePolicy[];
    /**
     * snapshot_schedule_policy block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_resource_policy.html#snapshot_schedule_policy ComputeResourcePolicy#snapshot_schedule_policy}
     *
     * @stability stable
     */
    readonly snapshotSchedulePolicy?: ComputeResourcePolicySnapshotSchedulePolicy[];
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_resource_policy.html#timeouts ComputeResourcePolicy#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: ComputeResourcePolicyTimeouts;
}
/**
 * @stability stable
 */
export interface ComputeResourcePolicyGroupPlacementPolicy {
    /**
     * The number of availability domains instances will be spread across.
     *
     * If two instances are in different
     * availability domain, they will not be put in the same low latency network
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_resource_policy.html#availability_domain_count ComputeResourcePolicy#availability_domain_count}
     *
     * @stability stable
     */
    readonly availabilityDomainCount?: number;
    /**
     * Collocation specifies whether to place VMs inside the same availability domain on the same low-latency network.
     *
     * Specify 'COLLOCATED' to enable collocation. Can only be specified with 'vm_count'. If compute instances are created
     * with a COLLOCATED policy, then exactly 'vm_count' instances must be created at the same time with the resource policy
     * attached. Possible values: ["COLLOCATED"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_resource_policy.html#collocation ComputeResourcePolicy#collocation}
     *
     * @stability stable
     */
    readonly collocation?: string;
    /**
     * Number of vms in this placement group.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_resource_policy.html#vm_count ComputeResourcePolicy#vm_count}
     *
     * @stability stable
     */
    readonly vmCount?: number;
}
/**
 * @stability stable
 */
export interface ComputeResourcePolicyInstanceSchedulePolicyVmStartSchedule {
    /**
     * Specifies the frequency for the operation, using the unix-cron format.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_resource_policy.html#schedule ComputeResourcePolicy#schedule}
     *
     * @stability stable
     */
    readonly schedule: string;
}
/**
 * @stability stable
 */
export interface ComputeResourcePolicyInstanceSchedulePolicyVmStopSchedule {
    /**
     * Specifies the frequency for the operation, using the unix-cron format.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_resource_policy.html#schedule ComputeResourcePolicy#schedule}
     *
     * @stability stable
     */
    readonly schedule: string;
}
/**
 * @stability stable
 */
export interface ComputeResourcePolicyInstanceSchedulePolicy {
    /**
     * The expiration time of the schedule. The timestamp is an RFC3339 string.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_resource_policy.html#expiration_time ComputeResourcePolicy#expiration_time}
     *
     * @stability stable
     */
    readonly expirationTime?: string;
    /**
     * The start time of the schedule. The timestamp is an RFC3339 string.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_resource_policy.html#start_time ComputeResourcePolicy#start_time}
     *
     * @stability stable
     */
    readonly startTime?: string;
    /**
     * Specifies the time zone to be used in interpreting the schedule.
     *
     * The value of this field must be a time zone name
     * from the tz database: http://en.wikipedia.org/wiki/Tz_database.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_resource_policy.html#time_zone ComputeResourcePolicy#time_zone}
     *
     * @stability stable
     */
    readonly timeZone: string;
    /**
     * vm_start_schedule block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_resource_policy.html#vm_start_schedule ComputeResourcePolicy#vm_start_schedule}
     *
     * @stability stable
     */
    readonly vmStartSchedule?: ComputeResourcePolicyInstanceSchedulePolicyVmStartSchedule[];
    /**
     * vm_stop_schedule block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_resource_policy.html#vm_stop_schedule ComputeResourcePolicy#vm_stop_schedule}
     *
     * @stability stable
     */
    readonly vmStopSchedule?: ComputeResourcePolicyInstanceSchedulePolicyVmStopSchedule[];
}
/**
 * @stability stable
 */
export interface ComputeResourcePolicySnapshotSchedulePolicyRetentionPolicy {
    /**
     * Maximum age of the snapshot that is allowed to be kept.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_resource_policy.html#max_retention_days ComputeResourcePolicy#max_retention_days}
     *
     * @stability stable
     */
    readonly maxRetentionDays: number;
    /**
     * Specifies the behavior to apply to scheduled snapshots when the source disk is deleted.
     *
     * Default value: "KEEP_AUTO_SNAPSHOTS" Possible values: ["KEEP_AUTO_SNAPSHOTS", "APPLY_RETENTION_POLICY"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_resource_policy.html#on_source_disk_delete ComputeResourcePolicy#on_source_disk_delete}
     *
     * @stability stable
     */
    readonly onSourceDiskDelete?: string;
}
/**
 * @stability stable
 */
export interface ComputeResourcePolicySnapshotSchedulePolicyScheduleDailySchedule {
    /**
     * The number of days between snapshots.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_resource_policy.html#days_in_cycle ComputeResourcePolicy#days_in_cycle}
     *
     * @stability stable
     */
    readonly daysInCycle: number;
    /**
     * This must be in UTC format that resolves to one of 00:00, 04:00, 08:00, 12:00, 16:00, or 20:00.
     *
     * For example,
     * both 13:00-5 and 08:00 are valid.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_resource_policy.html#start_time ComputeResourcePolicy#start_time}
     *
     * @stability stable
     */
    readonly startTime: string;
}
/**
 * @stability stable
 */
export interface ComputeResourcePolicySnapshotSchedulePolicyScheduleHourlySchedule {
    /**
     * The number of hours between snapshots.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_resource_policy.html#hours_in_cycle ComputeResourcePolicy#hours_in_cycle}
     *
     * @stability stable
     */
    readonly hoursInCycle: number;
    /**
     * Time within the window to start the operations.
     *
     * It must be in an hourly format "HH:MM",
     * where HH : [00-23] and MM : [00] GMT.
     * eg: 21:00
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_resource_policy.html#start_time ComputeResourcePolicy#start_time}
     *
     * @stability stable
     */
    readonly startTime: string;
}
/**
 * @stability stable
 */
export interface ComputeResourcePolicySnapshotSchedulePolicyScheduleWeeklyScheduleDayOfWeeks {
    /**
     * The day of the week to create the snapshot.
     *
     * e.g. MONDAY Possible values: ["MONDAY", "TUESDAY", "WEDNESDAY", "THURSDAY", "FRIDAY", "SATURDAY", "SUNDAY"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_resource_policy.html#day ComputeResourcePolicy#day}
     *
     * @stability stable
     */
    readonly day: string;
    /**
     * Time within the window to start the operations.
     *
     * It must be in format "HH:MM", where HH : [00-23] and MM : [00-00] GMT.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_resource_policy.html#start_time ComputeResourcePolicy#start_time}
     *
     * @stability stable
     */
    readonly startTime: string;
}
/**
 * @stability stable
 */
export interface ComputeResourcePolicySnapshotSchedulePolicyScheduleWeeklySchedule {
    /**
     * day_of_weeks block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_resource_policy.html#day_of_weeks ComputeResourcePolicy#day_of_weeks}
     *
     * @stability stable
     */
    readonly dayOfWeeks: ComputeResourcePolicySnapshotSchedulePolicyScheduleWeeklyScheduleDayOfWeeks[];
}
/**
 * @stability stable
 */
export interface ComputeResourcePolicySnapshotSchedulePolicySchedule {
    /**
     * daily_schedule block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_resource_policy.html#daily_schedule ComputeResourcePolicy#daily_schedule}
     *
     * @stability stable
     */
    readonly dailySchedule?: ComputeResourcePolicySnapshotSchedulePolicyScheduleDailySchedule[];
    /**
     * hourly_schedule block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_resource_policy.html#hourly_schedule ComputeResourcePolicy#hourly_schedule}
     *
     * @stability stable
     */
    readonly hourlySchedule?: ComputeResourcePolicySnapshotSchedulePolicyScheduleHourlySchedule[];
    /**
     * weekly_schedule block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_resource_policy.html#weekly_schedule ComputeResourcePolicy#weekly_schedule}
     *
     * @stability stable
     */
    readonly weeklySchedule?: ComputeResourcePolicySnapshotSchedulePolicyScheduleWeeklySchedule[];
}
/**
 * @stability stable
 */
export interface ComputeResourcePolicySnapshotSchedulePolicySnapshotProperties {
    /**
     * Whether to perform a 'guest aware' snapshot.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_resource_policy.html#guest_flush ComputeResourcePolicy#guest_flush}
     *
     * @stability stable
     */
    readonly guestFlush?: boolean;
    /**
     * A set of key-value pairs.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_resource_policy.html#labels ComputeResourcePolicy#labels}
     *
     * @stability stable
     */
    readonly labels?: {
        [key: string]: string;
    };
    /**
     * Cloud Storage bucket location to store the auto snapshot (regional or multi-regional).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_resource_policy.html#storage_locations ComputeResourcePolicy#storage_locations}
     *
     * @stability stable
     */
    readonly storageLocations?: string[];
}
/**
 * @stability stable
 */
export interface ComputeResourcePolicySnapshotSchedulePolicy {
    /**
     * retention_policy block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_resource_policy.html#retention_policy ComputeResourcePolicy#retention_policy}
     *
     * @stability stable
     */
    readonly retentionPolicy?: ComputeResourcePolicySnapshotSchedulePolicyRetentionPolicy[];
    /**
     * schedule block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_resource_policy.html#schedule ComputeResourcePolicy#schedule}
     *
     * @stability stable
     */
    readonly schedule: ComputeResourcePolicySnapshotSchedulePolicySchedule[];
    /**
     * snapshot_properties block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_resource_policy.html#snapshot_properties ComputeResourcePolicy#snapshot_properties}
     *
     * @stability stable
     */
    readonly snapshotProperties?: ComputeResourcePolicySnapshotSchedulePolicySnapshotProperties[];
}
/**
 * @stability stable
 */
export interface ComputeResourcePolicyTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_resource_policy.html#create ComputeResourcePolicy#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_resource_policy.html#delete ComputeResourcePolicy#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/compute_resource_policy.html google_compute_resource_policy}.
 *
 * @stability stable
 */
export declare class ComputeResourcePolicy extends cdktf.TerraformResource {
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/compute_resource_policy.html google_compute_resource_policy} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: ComputeResourcePolicyConfig);
    private _description?;
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    set description(value: string);
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _name;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string;
    /**
     * @stability stable
     */
    set project(value: string);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    private _region?;
    /**
     * @stability stable
     */
    get region(): string;
    /**
     * @stability stable
     */
    set region(value: string);
    /**
     * @stability stable
     */
    resetRegion(): void;
    /**
     * @stability stable
     */
    get regionInput(): string | undefined;
    /**
     * @stability stable
     */
    get selfLink(): string;
    private _groupPlacementPolicy?;
    /**
     * @stability stable
     */
    get groupPlacementPolicy(): ComputeResourcePolicyGroupPlacementPolicy[];
    /**
     * @stability stable
     */
    set groupPlacementPolicy(value: ComputeResourcePolicyGroupPlacementPolicy[]);
    /**
     * @stability stable
     */
    resetGroupPlacementPolicy(): void;
    /**
     * @stability stable
     */
    get groupPlacementPolicyInput(): ComputeResourcePolicyGroupPlacementPolicy[] | undefined;
    private _instanceSchedulePolicy?;
    /**
     * @stability stable
     */
    get instanceSchedulePolicy(): ComputeResourcePolicyInstanceSchedulePolicy[];
    /**
     * @stability stable
     */
    set instanceSchedulePolicy(value: ComputeResourcePolicyInstanceSchedulePolicy[]);
    /**
     * @stability stable
     */
    resetInstanceSchedulePolicy(): void;
    /**
     * @stability stable
     */
    get instanceSchedulePolicyInput(): ComputeResourcePolicyInstanceSchedulePolicy[] | undefined;
    private _snapshotSchedulePolicy?;
    /**
     * @stability stable
     */
    get snapshotSchedulePolicy(): ComputeResourcePolicySnapshotSchedulePolicy[];
    /**
     * @stability stable
     */
    set snapshotSchedulePolicy(value: ComputeResourcePolicySnapshotSchedulePolicy[]);
    /**
     * @stability stable
     */
    resetSnapshotSchedulePolicy(): void;
    /**
     * @stability stable
     */
    get snapshotSchedulePolicyInput(): ComputeResourcePolicySnapshotSchedulePolicy[] | undefined;
    private _timeouts?;
    /**
     * @stability stable
     */
    get timeouts(): ComputeResourcePolicyTimeouts;
    /**
     * @stability stable
     */
    set timeouts(value: ComputeResourcePolicyTimeouts);
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): ComputeResourcePolicyTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
