import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface ComputeRouterConfig extends cdktf.TerraformMetaArguments {
    /**
     * An optional description of this resource.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_router.html#description ComputeRouter#description}
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * Name of the resource.
     *
     * The name must be 1-63 characters long, and
     * comply with RFC1035. Specifically, the name must be 1-63 characters
     * long and match the regular expression '[a-z]([-a-z0-9]*[a-z0-9])?'
     * which means the first character must be a lowercase letter, and all
     * following characters must be a dash, lowercase letter, or digit,
     * except the last character, which cannot be a dash.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_router.html#name ComputeRouter#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * A reference to the network to which this router belongs.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_router.html#network ComputeRouter#network}
     *
     * @stability stable
     */
    readonly network: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_router.html#project ComputeRouter#project}.
     *
     * @stability stable
     */
    readonly project?: string;
    /**
     * Region where the router resides.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_router.html#region ComputeRouter#region}
     *
     * @stability stable
     */
    readonly region?: string;
    /**
     * bgp block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_router.html#bgp ComputeRouter#bgp}
     *
     * @stability stable
     */
    readonly bgp?: ComputeRouterBgp[];
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_router.html#timeouts ComputeRouter#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: ComputeRouterTimeouts;
}
/**
 * @stability stable
 */
export interface ComputeRouterBgpAdvertisedIpRanges {
    /**
     * User-specified description for the IP range.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_router.html#description ComputeRouter#description}
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * The IP range to advertise. The value must be a CIDR-formatted string.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_router.html#range ComputeRouter#range}
     *
     * @stability stable
     */
    readonly range: string;
}
/**
 * @stability stable
 */
export interface ComputeRouterBgp {
    /**
     * User-specified flag to indicate which mode to use for advertisement. Default value: "DEFAULT" Possible values: ["DEFAULT", "CUSTOM"].
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_router.html#advertise_mode ComputeRouter#advertise_mode}
     *
     * @stability stable
     */
    readonly advertiseMode?: string;
    /**
     * User-specified list of prefix groups to advertise in custom mode.
     *
     * This field can only be populated if advertiseMode is CUSTOM and
     * is advertised to all peers of the router. These groups will be
     * advertised in addition to any specified prefixes. Leave this field
     * blank to advertise no custom groups.
     *
     * This enum field has the one valid value: ALL_SUBNETS
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_router.html#advertised_groups ComputeRouter#advertised_groups}
     *
     * @stability stable
     */
    readonly advertisedGroups?: string[];
    /**
     * Local BGP Autonomous System Number (ASN).
     *
     * Must be an RFC6996
     * private ASN, either 16-bit or 32-bit. The value will be fixed for
     * this router resource. All VPN tunnels that link to this router
     * will have the same local ASN.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_router.html#asn ComputeRouter#asn}
     *
     * @stability stable
     */
    readonly asn: number;
    /**
     * advertised_ip_ranges block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_router.html#advertised_ip_ranges ComputeRouter#advertised_ip_ranges}
     *
     * @stability stable
     */
    readonly advertisedIpRanges?: ComputeRouterBgpAdvertisedIpRanges[];
}
/**
 * @stability stable
 */
export interface ComputeRouterTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_router.html#create ComputeRouter#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_router.html#delete ComputeRouter#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_router.html#update ComputeRouter#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/compute_router.html google_compute_router}.
 *
 * @stability stable
 */
export declare class ComputeRouter extends cdktf.TerraformResource {
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/compute_router.html google_compute_router} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: ComputeRouterConfig);
    /**
     * @stability stable
     */
    get creationTimestamp(): string;
    private _description?;
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    set description(value: string);
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _name;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string;
    private _network;
    /**
     * @stability stable
     */
    get network(): string;
    /**
     * @stability stable
     */
    set network(value: string);
    /**
     * @stability stable
     */
    get networkInput(): string;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string;
    /**
     * @stability stable
     */
    set project(value: string);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    private _region?;
    /**
     * @stability stable
     */
    get region(): string;
    /**
     * @stability stable
     */
    set region(value: string);
    /**
     * @stability stable
     */
    resetRegion(): void;
    /**
     * @stability stable
     */
    get regionInput(): string | undefined;
    /**
     * @stability stable
     */
    get selfLink(): string;
    private _bgp?;
    /**
     * @stability stable
     */
    get bgp(): ComputeRouterBgp[];
    /**
     * @stability stable
     */
    set bgp(value: ComputeRouterBgp[]);
    /**
     * @stability stable
     */
    resetBgp(): void;
    /**
     * @stability stable
     */
    get bgpInput(): ComputeRouterBgp[] | undefined;
    private _timeouts?;
    /**
     * @stability stable
     */
    get timeouts(): ComputeRouterTimeouts;
    /**
     * @stability stable
     */
    set timeouts(value: ComputeRouterTimeouts);
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): ComputeRouterTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
