import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface ComputeSharedVpcHostProjectConfig extends cdktf.TerraformMetaArguments {
    /**
     * The ID of the project that will serve as a Shared VPC host project.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_shared_vpc_host_project.html#project ComputeSharedVpcHostProject#project}
     *
     * @stability stable
     */
    readonly project: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_shared_vpc_host_project.html#timeouts ComputeSharedVpcHostProject#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: ComputeSharedVpcHostProjectTimeouts;
}
/**
 * @stability stable
 */
export interface ComputeSharedVpcHostProjectTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_shared_vpc_host_project.html#create ComputeSharedVpcHostProject#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_shared_vpc_host_project.html#delete ComputeSharedVpcHostProject#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/compute_shared_vpc_host_project.html google_compute_shared_vpc_host_project}.
 *
 * @stability stable
 */
export declare class ComputeSharedVpcHostProject extends cdktf.TerraformResource {
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/compute_shared_vpc_host_project.html google_compute_shared_vpc_host_project} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: ComputeSharedVpcHostProjectConfig);
    /**
     * @stability stable
     */
    get id(): string;
    private _project;
    /**
     * @stability stable
     */
    get project(): string;
    /**
     * @stability stable
     */
    set project(value: string);
    /**
     * @stability stable
     */
    get projectInput(): string;
    private _timeouts?;
    /**
     * @stability stable
     */
    get timeouts(): ComputeSharedVpcHostProjectTimeouts;
    /**
     * @stability stable
     */
    set timeouts(value: ComputeSharedVpcHostProjectTimeouts);
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): ComputeSharedVpcHostProjectTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
