import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface ComputeSharedVpcServiceProjectConfig extends cdktf.TerraformMetaArguments {
    /**
     * The ID of a host project to associate.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_shared_vpc_service_project.html#host_project ComputeSharedVpcServiceProject#host_project}
     *
     * @stability stable
     */
    readonly hostProject: string;
    /**
     * The ID of the project that will serve as a Shared VPC service project.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_shared_vpc_service_project.html#service_project ComputeSharedVpcServiceProject#service_project}
     *
     * @stability stable
     */
    readonly serviceProject: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_shared_vpc_service_project.html#timeouts ComputeSharedVpcServiceProject#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: ComputeSharedVpcServiceProjectTimeouts;
}
/**
 * @stability stable
 */
export interface ComputeSharedVpcServiceProjectTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_shared_vpc_service_project.html#create ComputeSharedVpcServiceProject#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_shared_vpc_service_project.html#delete ComputeSharedVpcServiceProject#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/compute_shared_vpc_service_project.html google_compute_shared_vpc_service_project}.
 *
 * @stability stable
 */
export declare class ComputeSharedVpcServiceProject extends cdktf.TerraformResource {
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/compute_shared_vpc_service_project.html google_compute_shared_vpc_service_project} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: ComputeSharedVpcServiceProjectConfig);
    private _hostProject;
    /**
     * @stability stable
     */
    get hostProject(): string;
    /**
     * @stability stable
     */
    set hostProject(value: string);
    /**
     * @stability stable
     */
    get hostProjectInput(): string;
    /**
     * @stability stable
     */
    get id(): string;
    private _serviceProject;
    /**
     * @stability stable
     */
    get serviceProject(): string;
    /**
     * @stability stable
     */
    set serviceProject(value: string);
    /**
     * @stability stable
     */
    get serviceProjectInput(): string;
    private _timeouts?;
    /**
     * @stability stable
     */
    get timeouts(): ComputeSharedVpcServiceProjectTimeouts;
    /**
     * @stability stable
     */
    set timeouts(value: ComputeSharedVpcServiceProjectTimeouts);
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): ComputeSharedVpcServiceProjectTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
