import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface ComputeSubnetworkIamBindingConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_subnetwork_iam_binding.html#members ComputeSubnetworkIamBinding#members}.
     *
     * @stability stable
     */
    readonly members: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_subnetwork_iam_binding.html#project ComputeSubnetworkIamBinding#project}.
     *
     * @stability stable
     */
    readonly project?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_subnetwork_iam_binding.html#region ComputeSubnetworkIamBinding#region}.
     *
     * @stability stable
     */
    readonly region?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_subnetwork_iam_binding.html#role ComputeSubnetworkIamBinding#role}.
     *
     * @stability stable
     */
    readonly role: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_subnetwork_iam_binding.html#subnetwork ComputeSubnetworkIamBinding#subnetwork}.
     *
     * @stability stable
     */
    readonly subnetwork: string;
    /**
     * condition block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_subnetwork_iam_binding.html#condition ComputeSubnetworkIamBinding#condition}
     *
     * @stability stable
     */
    readonly condition?: ComputeSubnetworkIamBindingCondition[];
}
/**
 * @stability stable
 */
export interface ComputeSubnetworkIamBindingCondition {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_subnetwork_iam_binding.html#description ComputeSubnetworkIamBinding#description}.
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_subnetwork_iam_binding.html#expression ComputeSubnetworkIamBinding#expression}.
     *
     * @stability stable
     */
    readonly expression: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_subnetwork_iam_binding.html#title ComputeSubnetworkIamBinding#title}.
     *
     * @stability stable
     */
    readonly title: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/compute_subnetwork_iam_binding.html google_compute_subnetwork_iam_binding}.
 *
 * @stability stable
 */
export declare class ComputeSubnetworkIamBinding extends cdktf.TerraformResource {
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/compute_subnetwork_iam_binding.html google_compute_subnetwork_iam_binding} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: ComputeSubnetworkIamBindingConfig);
    /**
     * @stability stable
     */
    get etag(): string;
    /**
     * @stability stable
     */
    get id(): string;
    private _members;
    /**
     * @stability stable
     */
    get members(): string[];
    /**
     * @stability stable
     */
    set members(value: string[]);
    /**
     * @stability stable
     */
    get membersInput(): string[];
    private _project?;
    /**
     * @stability stable
     */
    get project(): string;
    /**
     * @stability stable
     */
    set project(value: string);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    private _region?;
    /**
     * @stability stable
     */
    get region(): string;
    /**
     * @stability stable
     */
    set region(value: string);
    /**
     * @stability stable
     */
    resetRegion(): void;
    /**
     * @stability stable
     */
    get regionInput(): string | undefined;
    private _role;
    /**
     * @stability stable
     */
    get role(): string;
    /**
     * @stability stable
     */
    set role(value: string);
    /**
     * @stability stable
     */
    get roleInput(): string;
    private _subnetwork;
    /**
     * @stability stable
     */
    get subnetwork(): string;
    /**
     * @stability stable
     */
    set subnetwork(value: string);
    /**
     * @stability stable
     */
    get subnetworkInput(): string;
    private _condition?;
    /**
     * @stability stable
     */
    get condition(): ComputeSubnetworkIamBindingCondition[];
    /**
     * @stability stable
     */
    set condition(value: ComputeSubnetworkIamBindingCondition[]);
    /**
     * @stability stable
     */
    resetCondition(): void;
    /**
     * @stability stable
     */
    get conditionInput(): ComputeSubnetworkIamBindingCondition[] | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
