import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface ComputeTargetHttpProxyConfig extends cdktf.TerraformMetaArguments {
    /**
     * An optional description of this resource.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_target_http_proxy.html#description ComputeTargetHttpProxy#description}
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * Name of the resource.
     *
     * Provided by the client when the resource is
     * created. The name must be 1-63 characters long, and comply with
     * RFC1035. Specifically, the name must be 1-63 characters long and match
     * the regular expression '[a-z]([-a-z0-9]*[a-z0-9])?' which means the
     * first character must be a lowercase letter, and all following
     * characters must be a dash, lowercase letter, or digit, except the last
     * character, which cannot be a dash.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_target_http_proxy.html#name ComputeTargetHttpProxy#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_target_http_proxy.html#project ComputeTargetHttpProxy#project}.
     *
     * @stability stable
     */
    readonly project?: string;
    /**
     * This field only applies when the forwarding rule that references this target proxy has a loadBalancingScheme set to INTERNAL_SELF_MANAGED.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_target_http_proxy.html#proxy_bind ComputeTargetHttpProxy#proxy_bind}
     *
     * @stability stable
     */
    readonly proxyBind?: boolean;
    /**
     * A reference to the UrlMap resource that defines the mapping from URL to the BackendService.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_target_http_proxy.html#url_map ComputeTargetHttpProxy#url_map}
     *
     * @stability stable
     */
    readonly urlMap: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_target_http_proxy.html#timeouts ComputeTargetHttpProxy#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: ComputeTargetHttpProxyTimeouts;
}
/**
 * @stability stable
 */
export interface ComputeTargetHttpProxyTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_target_http_proxy.html#create ComputeTargetHttpProxy#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_target_http_proxy.html#delete ComputeTargetHttpProxy#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_target_http_proxy.html#update ComputeTargetHttpProxy#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/compute_target_http_proxy.html google_compute_target_http_proxy}.
 *
 * @stability stable
 */
export declare class ComputeTargetHttpProxy extends cdktf.TerraformResource {
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/compute_target_http_proxy.html google_compute_target_http_proxy} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: ComputeTargetHttpProxyConfig);
    /**
     * @stability stable
     */
    get creationTimestamp(): string;
    private _description?;
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    set description(value: string);
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _name;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string;
    /**
     * @stability stable
     */
    set project(value: string);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    private _proxyBind?;
    /**
     * @stability stable
     */
    get proxyBind(): boolean;
    /**
     * @stability stable
     */
    set proxyBind(value: boolean);
    /**
     * @stability stable
     */
    resetProxyBind(): void;
    /**
     * @stability stable
     */
    get proxyBindInput(): boolean | undefined;
    /**
     * @stability stable
     */
    get proxyId(): number;
    /**
     * @stability stable
     */
    get selfLink(): string;
    private _urlMap;
    /**
     * @stability stable
     */
    get urlMap(): string;
    /**
     * @stability stable
     */
    set urlMap(value: string);
    /**
     * @stability stable
     */
    get urlMapInput(): string;
    private _timeouts?;
    /**
     * @stability stable
     */
    get timeouts(): ComputeTargetHttpProxyTimeouts;
    /**
     * @stability stable
     */
    set timeouts(value: ComputeTargetHttpProxyTimeouts);
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): ComputeTargetHttpProxyTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
