import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface ContainerAnalysisOccurrenceConfig extends cdktf.TerraformMetaArguments {
    /**
     * The analysis note associated with this occurrence, in the form of projects/[PROJECT]/notes/[NOTE_ID].
     *
     * This field can be used as a
     * filter in list requests.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_analysis_occurrence.html#note_name ContainerAnalysisOccurrence#note_name}
     *
     * @stability stable
     */
    readonly noteName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_analysis_occurrence.html#project ContainerAnalysisOccurrence#project}.
     *
     * @stability stable
     */
    readonly project?: string;
    /**
     * A description of actions that can be taken to remedy the note.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_analysis_occurrence.html#remediation ContainerAnalysisOccurrence#remediation}
     *
     * @stability stable
     */
    readonly remediation?: string;
    /**
     * Required. Immutable. A URI that represents the resource for which the occurrence applies. For example, https://gcr.io/project/image@sha256:123abc for a Docker image.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_analysis_occurrence.html#resource_uri ContainerAnalysisOccurrence#resource_uri}
     *
     * @stability stable
     */
    readonly resourceUri: string;
    /**
     * attestation block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_analysis_occurrence.html#attestation ContainerAnalysisOccurrence#attestation}
     *
     * @stability stable
     */
    readonly attestation: ContainerAnalysisOccurrenceAttestation[];
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_analysis_occurrence.html#timeouts ContainerAnalysisOccurrence#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: ContainerAnalysisOccurrenceTimeouts;
}
/**
 * @stability stable
 */
export interface ContainerAnalysisOccurrenceAttestationSignatures {
    /**
     * The identifier for the public key that verifies this signature.
     *
     * MUST be an RFC3986 conformant
     * URI. * When possible, the key id should be an
     * immutable reference, such as a cryptographic digest.
     * Examples of valid values:
     *
     * OpenPGP V4 public key fingerprint. See https://www.iana.org/assignments/uri-schemes/prov/openpgp4fpr
     * for more details on this scheme.
     *  'openpgp4fpr:74FAF3B861BDA0870C7B6DEF607E48D2A663AEEA'
     * RFC6920 digest-named SubjectPublicKeyInfo (digest of the DER serialization):
     *  "ni:///sha-256;cD9o9Cq6LG3jD0iKXqEi_vdjJGecm_iXkbqVoScViaU"
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_analysis_occurrence.html#public_key_id ContainerAnalysisOccurrence#public_key_id}
     *
     * @stability stable
     */
    readonly publicKeyId: string;
    /**
     * The content of the signature, an opaque bytestring.
     *
     * The payload that this signature verifies MUST be
     * unambiguously provided with the Signature during
     * verification. A wrapper message might provide the
     * payload explicitly. Alternatively, a message might
     * have a canonical serialization that can always be
     * unambiguously computed to derive the payload.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_analysis_occurrence.html#signature ContainerAnalysisOccurrence#signature}
     *
     * @stability stable
     */
    readonly signature?: string;
}
/**
 * @stability stable
 */
export interface ContainerAnalysisOccurrenceAttestation {
    /**
     * The serialized payload that is verified by one or more signatures. A base64-encoded string.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_analysis_occurrence.html#serialized_payload ContainerAnalysisOccurrence#serialized_payload}
     *
     * @stability stable
     */
    readonly serializedPayload: string;
    /**
     * signatures block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_analysis_occurrence.html#signatures ContainerAnalysisOccurrence#signatures}
     *
     * @stability stable
     */
    readonly signatures: ContainerAnalysisOccurrenceAttestationSignatures[];
}
/**
 * @stability stable
 */
export interface ContainerAnalysisOccurrenceTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_analysis_occurrence.html#create ContainerAnalysisOccurrence#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_analysis_occurrence.html#delete ContainerAnalysisOccurrence#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_analysis_occurrence.html#update ContainerAnalysisOccurrence#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/container_analysis_occurrence.html google_container_analysis_occurrence}.
 *
 * @stability stable
 */
export declare class ContainerAnalysisOccurrence extends cdktf.TerraformResource {
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/container_analysis_occurrence.html google_container_analysis_occurrence} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: ContainerAnalysisOccurrenceConfig);
    /**
     * @stability stable
     */
    get createTime(): string;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get kind(): string;
    /**
     * @stability stable
     */
    get name(): string;
    private _noteName;
    /**
     * @stability stable
     */
    get noteName(): string;
    /**
     * @stability stable
     */
    set noteName(value: string);
    /**
     * @stability stable
     */
    get noteNameInput(): string;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string;
    /**
     * @stability stable
     */
    set project(value: string);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    private _remediation?;
    /**
     * @stability stable
     */
    get remediation(): string;
    /**
     * @stability stable
     */
    set remediation(value: string);
    /**
     * @stability stable
     */
    resetRemediation(): void;
    /**
     * @stability stable
     */
    get remediationInput(): string | undefined;
    private _resourceUri;
    /**
     * @stability stable
     */
    get resourceUri(): string;
    /**
     * @stability stable
     */
    set resourceUri(value: string);
    /**
     * @stability stable
     */
    get resourceUriInput(): string;
    /**
     * @stability stable
     */
    get updateTime(): string;
    private _attestation;
    /**
     * @stability stable
     */
    get attestation(): ContainerAnalysisOccurrenceAttestation[];
    /**
     * @stability stable
     */
    set attestation(value: ContainerAnalysisOccurrenceAttestation[]);
    /**
     * @stability stable
     */
    get attestationInput(): ContainerAnalysisOccurrenceAttestation[];
    private _timeouts?;
    /**
     * @stability stable
     */
    get timeouts(): ContainerAnalysisOccurrenceTimeouts;
    /**
     * @stability stable
     */
    set timeouts(value: ContainerAnalysisOccurrenceTimeouts);
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): ContainerAnalysisOccurrenceTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
