import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface ContainerNodePoolConfig extends cdktf.TerraformMetaArguments {
    /**
     * The cluster to create the node pool for. Cluster must be present in location provided for zonal clusters.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_node_pool.html#cluster ContainerNodePool#cluster}
     *
     * @stability stable
     */
    readonly cluster: string;
    /**
     * The initial number of nodes for the pool.
     *
     * In regional or multi-zonal clusters, this is the number of nodes per zone. Changing this will force recreation of the resource.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_node_pool.html#initial_node_count ContainerNodePool#initial_node_count}
     *
     * @stability stable
     */
    readonly initialNodeCount?: number;
    /**
     * The location (region or zone) of the cluster.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_node_pool.html#location ContainerNodePool#location}
     *
     * @stability stable
     */
    readonly location?: string;
    /**
     * The maximum number of pods per node in this node pool.
     *
     * Note that this does not work on node pools which are "route-based" - that is, node pools belonging to clusters that do not have IP Aliasing enabled.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_node_pool.html#max_pods_per_node ContainerNodePool#max_pods_per_node}
     *
     * @stability stable
     */
    readonly maxPodsPerNode?: number;
    /**
     * The name of the node pool. If left blank, Terraform will auto-generate a unique name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_node_pool.html#name ContainerNodePool#name}
     *
     * @stability stable
     */
    readonly name?: string;
    /**
     * Creates a unique name for the node pool beginning with the specified prefix. Conflicts with name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_node_pool.html#name_prefix ContainerNodePool#name_prefix}
     *
     * @stability stable
     */
    readonly namePrefix?: string;
    /**
     * The number of nodes per instance group.
     *
     * This field can be used to update the number of nodes per instance group but should not be used alongside autoscaling.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_node_pool.html#node_count ContainerNodePool#node_count}
     *
     * @stability stable
     */
    readonly nodeCount?: number;
    /**
     * The list of zones in which the node pool's nodes should be located.
     *
     * Nodes must be in the region of their regional cluster or in the same region as their cluster's zone for zonal clusters. If unspecified, the cluster-level node_locations will be used.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_node_pool.html#node_locations ContainerNodePool#node_locations}
     *
     * @stability stable
     */
    readonly nodeLocations?: string[];
    /**
     * The ID of the project in which to create the node pool.
     *
     * If blank, the provider-configured project will be used.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_node_pool.html#project ContainerNodePool#project}
     *
     * @stability stable
     */
    readonly project?: string;
    /**
     * The Kubernetes version for the nodes in this pool.
     *
     * Note that if this field and auto_upgrade are both specified, they will fight each other for what the node version should be, so setting both is highly discouraged. While a fuzzy version can be specified, it's recommended that you specify explicit versions as Terraform will see spurious diffs when fuzzy versions are used. See the google_container_engine_versions data source's version_prefix field to approximate fuzzy versions in a Terraform-compatible way.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_node_pool.html#version ContainerNodePool#version}
     *
     * @stability stable
     */
    readonly version?: string;
    /**
     * autoscaling block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_node_pool.html#autoscaling ContainerNodePool#autoscaling}
     *
     * @stability stable
     */
    readonly autoscaling?: ContainerNodePoolAutoscaling[];
    /**
     * management block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_node_pool.html#management ContainerNodePool#management}
     *
     * @stability stable
     */
    readonly management?: ContainerNodePoolManagement[];
    /**
     * node_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_node_pool.html#node_config ContainerNodePool#node_config}
     *
     * @stability stable
     */
    readonly nodeConfig?: ContainerNodePoolNodeConfig[];
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_node_pool.html#timeouts ContainerNodePool#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: ContainerNodePoolTimeouts;
    /**
     * upgrade_settings block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_node_pool.html#upgrade_settings ContainerNodePool#upgrade_settings}
     *
     * @stability stable
     */
    readonly upgradeSettings?: ContainerNodePoolUpgradeSettings[];
}
/**
 * @stability stable
 */
export interface ContainerNodePoolAutoscaling {
    /**
     * Maximum number of nodes in the NodePool. Must be >= min_node_count.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_node_pool.html#max_node_count ContainerNodePool#max_node_count}
     *
     * @stability stable
     */
    readonly maxNodeCount: number;
    /**
     * Minimum number of nodes in the NodePool. Must be >=0 and <= max_node_count.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_node_pool.html#min_node_count ContainerNodePool#min_node_count}
     *
     * @stability stable
     */
    readonly minNodeCount: number;
}
/**
 * @stability stable
 */
export interface ContainerNodePoolManagement {
    /**
     * Whether the nodes will be automatically repaired.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_node_pool.html#auto_repair ContainerNodePool#auto_repair}
     *
     * @stability stable
     */
    readonly autoRepair?: boolean;
    /**
     * Whether the nodes will be automatically upgraded.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_node_pool.html#auto_upgrade ContainerNodePool#auto_upgrade}
     *
     * @stability stable
     */
    readonly autoUpgrade?: boolean;
}
/**
 * @stability stable
 */
export interface ContainerNodePoolNodeConfigGuestAccelerator {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_node_pool.html#count ContainerNodePool#count}.
     *
     * @stability stable
     */
    readonly count?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_node_pool.html#type ContainerNodePool#type}.
     *
     * @stability stable
     */
    readonly type?: string;
}
/**
 * @stability stable
 */
export interface ContainerNodePoolNodeConfigTaint {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_node_pool.html#effect ContainerNodePool#effect}.
     *
     * @stability stable
     */
    readonly effect?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_node_pool.html#key ContainerNodePool#key}.
     *
     * @stability stable
     */
    readonly key?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_node_pool.html#value ContainerNodePool#value}.
     *
     * @stability stable
     */
    readonly value?: string;
}
/**
 * @stability stable
 */
export interface ContainerNodePoolNodeConfigShieldedInstanceConfig {
    /**
     * Defines whether the instance has integrity monitoring enabled.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_node_pool.html#enable_integrity_monitoring ContainerNodePool#enable_integrity_monitoring}
     *
     * @stability stable
     */
    readonly enableIntegrityMonitoring?: boolean;
    /**
     * Defines whether the instance has Secure Boot enabled.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_node_pool.html#enable_secure_boot ContainerNodePool#enable_secure_boot}
     *
     * @stability stable
     */
    readonly enableSecureBoot?: boolean;
}
/**
 * @stability stable
 */
export interface ContainerNodePoolNodeConfigWorkloadMetadataConfig {
    /**
     * NodeMetadata is the configuration for how to expose metadata to the workloads running on the node.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_node_pool.html#node_metadata ContainerNodePool#node_metadata}
     *
     * @stability stable
     */
    readonly nodeMetadata: string;
}
/**
 * @stability stable
 */
export interface ContainerNodePoolNodeConfig {
    /**
     * Size of the disk attached to each node, specified in GB. The smallest allowed disk size is 10GB.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_node_pool.html#disk_size_gb ContainerNodePool#disk_size_gb}
     *
     * @stability stable
     */
    readonly diskSizeGb?: number;
    /**
     * Type of the disk attached to each node.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_node_pool.html#disk_type ContainerNodePool#disk_type}
     *
     * @stability stable
     */
    readonly diskType?: string;
    /**
     * List of the type and count of accelerator cards attached to the instance.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_node_pool.html#guest_accelerator ContainerNodePool#guest_accelerator}
     *
     * @stability stable
     */
    readonly guestAccelerator?: ContainerNodePoolNodeConfigGuestAccelerator[];
    /**
     * The image type to use for this node.
     *
     * Note that for a given image type, the latest version of it will be used.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_node_pool.html#image_type ContainerNodePool#image_type}
     *
     * @stability stable
     */
    readonly imageType?: string;
    /**
     * The map of Kubernetes labels (key/value pairs) to be applied to each node.
     *
     * These will added in addition to any default label(s) that Kubernetes may apply to the node.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_node_pool.html#labels ContainerNodePool#labels}
     *
     * @stability stable
     */
    readonly labels?: {
        [key: string]: string;
    };
    /**
     * The number of local SSD disks to be attached to the node.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_node_pool.html#local_ssd_count ContainerNodePool#local_ssd_count}
     *
     * @stability stable
     */
    readonly localSsdCount?: number;
    /**
     * The name of a Google Compute Engine machine type.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_node_pool.html#machine_type ContainerNodePool#machine_type}
     *
     * @stability stable
     */
    readonly machineType?: string;
    /**
     * The metadata key/value pairs assigned to instances in the cluster.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_node_pool.html#metadata ContainerNodePool#metadata}
     *
     * @stability stable
     */
    readonly metadata?: {
        [key: string]: string;
    };
    /**
     * Minimum CPU platform to be used by this instance.
     *
     * The instance may be scheduled on the specified or newer CPU platform.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_node_pool.html#min_cpu_platform ContainerNodePool#min_cpu_platform}
     *
     * @stability stable
     */
    readonly minCpuPlatform?: string;
    /**
     * The set of Google API scopes to be made available on all of the node VMs.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_node_pool.html#oauth_scopes ContainerNodePool#oauth_scopes}
     *
     * @stability stable
     */
    readonly oauthScopes?: string[];
    /**
     * Whether the nodes are created as preemptible VM instances.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_node_pool.html#preemptible ContainerNodePool#preemptible}
     *
     * @stability stable
     */
    readonly preemptible?: boolean;
    /**
     * The Google Cloud Platform Service Account to be used by the node VMs.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_node_pool.html#service_account ContainerNodePool#service_account}
     *
     * @stability stable
     */
    readonly serviceAccount?: string;
    /**
     * The list of instance tags applied to all nodes.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_node_pool.html#tags ContainerNodePool#tags}
     *
     * @stability stable
     */
    readonly tags?: string[];
    /**
     * List of Kubernetes taints to be applied to each node.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_node_pool.html#taint ContainerNodePool#taint}
     *
     * @stability stable
     */
    readonly taint?: ContainerNodePoolNodeConfigTaint[];
    /**
     * shielded_instance_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_node_pool.html#shielded_instance_config ContainerNodePool#shielded_instance_config}
     *
     * @stability stable
     */
    readonly shieldedInstanceConfig?: ContainerNodePoolNodeConfigShieldedInstanceConfig[];
    /**
     * workload_metadata_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_node_pool.html#workload_metadata_config ContainerNodePool#workload_metadata_config}
     *
     * @stability stable
     */
    readonly workloadMetadataConfig?: ContainerNodePoolNodeConfigWorkloadMetadataConfig[];
}
/**
 * @stability stable
 */
export interface ContainerNodePoolTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_node_pool.html#create ContainerNodePool#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_node_pool.html#delete ContainerNodePool#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_node_pool.html#update ContainerNodePool#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
/**
 * @stability stable
 */
export interface ContainerNodePoolUpgradeSettings {
    /**
     * The number of additional nodes that can be added to the node pool during an upgrade.
     *
     * Increasing max_surge raises the number of nodes that can be upgraded simultaneously. Can be set to 0 or greater.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_node_pool.html#max_surge ContainerNodePool#max_surge}
     *
     * @stability stable
     */
    readonly maxSurge: number;
    /**
     * The number of nodes that can be simultaneously unavailable during an upgrade.
     *
     * Increasing max_unavailable raises the number of nodes that can be upgraded in parallel. Can be set to 0 or greater.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_node_pool.html#max_unavailable ContainerNodePool#max_unavailable}
     *
     * @stability stable
     */
    readonly maxUnavailable: number;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/container_node_pool.html google_container_node_pool}.
 *
 * @stability stable
 */
export declare class ContainerNodePool extends cdktf.TerraformResource {
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/container_node_pool.html google_container_node_pool} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: ContainerNodePoolConfig);
    private _cluster;
    /**
     * @stability stable
     */
    get cluster(): string;
    /**
     * @stability stable
     */
    set cluster(value: string);
    /**
     * @stability stable
     */
    get clusterInput(): string;
    /**
     * @stability stable
     */
    get id(): string;
    private _initialNodeCount?;
    /**
     * @stability stable
     */
    get initialNodeCount(): number;
    /**
     * @stability stable
     */
    set initialNodeCount(value: number);
    /**
     * @stability stable
     */
    resetInitialNodeCount(): void;
    /**
     * @stability stable
     */
    get initialNodeCountInput(): number | undefined;
    /**
     * @stability stable
     */
    get instanceGroupUrls(): string[];
    private _location?;
    /**
     * @stability stable
     */
    get location(): string;
    /**
     * @stability stable
     */
    set location(value: string);
    /**
     * @stability stable
     */
    resetLocation(): void;
    /**
     * @stability stable
     */
    get locationInput(): string | undefined;
    private _maxPodsPerNode?;
    /**
     * @stability stable
     */
    get maxPodsPerNode(): number;
    /**
     * @stability stable
     */
    set maxPodsPerNode(value: number);
    /**
     * @stability stable
     */
    resetMaxPodsPerNode(): void;
    /**
     * @stability stable
     */
    get maxPodsPerNodeInput(): number | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    resetName(): void;
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _namePrefix?;
    /**
     * @stability stable
     */
    get namePrefix(): string;
    /**
     * @stability stable
     */
    set namePrefix(value: string);
    /**
     * @stability stable
     */
    resetNamePrefix(): void;
    /**
     * @stability stable
     */
    get namePrefixInput(): string | undefined;
    private _nodeCount?;
    /**
     * @stability stable
     */
    get nodeCount(): number;
    /**
     * @stability stable
     */
    set nodeCount(value: number);
    /**
     * @stability stable
     */
    resetNodeCount(): void;
    /**
     * @stability stable
     */
    get nodeCountInput(): number | undefined;
    private _nodeLocations?;
    /**
     * @stability stable
     */
    get nodeLocations(): string[];
    /**
     * @stability stable
     */
    set nodeLocations(value: string[]);
    /**
     * @stability stable
     */
    resetNodeLocations(): void;
    /**
     * @stability stable
     */
    get nodeLocationsInput(): string[] | undefined;
    /**
     * @stability stable
     */
    get operation(): string;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string;
    /**
     * @stability stable
     */
    set project(value: string);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    private _version?;
    /**
     * @stability stable
     */
    get version(): string;
    /**
     * @stability stable
     */
    set version(value: string);
    /**
     * @stability stable
     */
    resetVersion(): void;
    /**
     * @stability stable
     */
    get versionInput(): string | undefined;
    private _autoscaling?;
    /**
     * @stability stable
     */
    get autoscaling(): ContainerNodePoolAutoscaling[];
    /**
     * @stability stable
     */
    set autoscaling(value: ContainerNodePoolAutoscaling[]);
    /**
     * @stability stable
     */
    resetAutoscaling(): void;
    /**
     * @stability stable
     */
    get autoscalingInput(): ContainerNodePoolAutoscaling[] | undefined;
    private _management?;
    /**
     * @stability stable
     */
    get management(): ContainerNodePoolManagement[];
    /**
     * @stability stable
     */
    set management(value: ContainerNodePoolManagement[]);
    /**
     * @stability stable
     */
    resetManagement(): void;
    /**
     * @stability stable
     */
    get managementInput(): ContainerNodePoolManagement[] | undefined;
    private _nodeConfig?;
    /**
     * @stability stable
     */
    get nodeConfig(): ContainerNodePoolNodeConfig[];
    /**
     * @stability stable
     */
    set nodeConfig(value: ContainerNodePoolNodeConfig[]);
    /**
     * @stability stable
     */
    resetNodeConfig(): void;
    /**
     * @stability stable
     */
    get nodeConfigInput(): ContainerNodePoolNodeConfig[] | undefined;
    private _timeouts?;
    /**
     * @stability stable
     */
    get timeouts(): ContainerNodePoolTimeouts;
    /**
     * @stability stable
     */
    set timeouts(value: ContainerNodePoolTimeouts);
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): ContainerNodePoolTimeouts | undefined;
    private _upgradeSettings?;
    /**
     * @stability stable
     */
    get upgradeSettings(): ContainerNodePoolUpgradeSettings[];
    /**
     * @stability stable
     */
    set upgradeSettings(value: ContainerNodePoolUpgradeSettings[]);
    /**
     * @stability stable
     */
    resetUpgradeSettings(): void;
    /**
     * @stability stable
     */
    get upgradeSettingsInput(): ContainerNodePoolUpgradeSettings[] | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
