import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataCatalogTagConfig extends cdktf.TerraformMetaArguments {
    /**
     * Resources like Entry can have schemas associated with them.
     *
     * This scope allows users to attach tags to an
     * individual column based on that schema.
     *
     * For attaching a tag to a nested column, use '.' to separate the column names. Example:
     * 'outer_column.inner_column'
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_catalog_tag.html#column DataCatalogTag#column}
     *
     * @stability stable
     */
    readonly column?: string;
    /**
     * The name of the parent this tag is attached to.
     *
     * This can be the name of an entry or an entry group. If an entry group, the tag will be attached to
     * all entries in that group.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_catalog_tag.html#parent DataCatalogTag#parent}
     *
     * @stability stable
     */
    readonly parent?: string;
    /**
     * The resource name of the tag template that this tag uses. Example: projects/{project_id}/locations/{location}/tagTemplates/{tagTemplateId} This field cannot be modified after creation.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_catalog_tag.html#template DataCatalogTag#template}
     *
     * @stability stable
     */
    readonly template: string;
    /**
     * fields block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_catalog_tag.html#fields DataCatalogTag#fields}
     *
     * @stability stable
     */
    readonly fields: DataCatalogTagFields[];
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_catalog_tag.html#timeouts DataCatalogTag#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: DataCatalogTagTimeouts;
}
/**
 * @stability stable
 */
export interface DataCatalogTagFields {
    /**
     * Holds the value for a tag field with boolean type.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_catalog_tag.html#bool_value DataCatalogTag#bool_value}
     *
     * @stability stable
     */
    readonly boolValue?: boolean;
    /**
     * Holds the value for a tag field with double type.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_catalog_tag.html#double_value DataCatalogTag#double_value}
     *
     * @stability stable
     */
    readonly doubleValue?: number;
    /**
     * The display name of the enum value.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_catalog_tag.html#enum_value DataCatalogTag#enum_value}
     *
     * @stability stable
     */
    readonly enumValue?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_catalog_tag.html#field_name DataCatalogTag#field_name}.
     *
     * @stability stable
     */
    readonly fieldName: string;
    /**
     * Holds the value for a tag field with string type.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_catalog_tag.html#string_value DataCatalogTag#string_value}
     *
     * @stability stable
     */
    readonly stringValue?: string;
    /**
     * Holds the value for a tag field with timestamp type.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_catalog_tag.html#timestamp_value DataCatalogTag#timestamp_value}
     *
     * @stability stable
     */
    readonly timestampValue?: string;
}
/**
 * @stability stable
 */
export interface DataCatalogTagTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_catalog_tag.html#create DataCatalogTag#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_catalog_tag.html#delete DataCatalogTag#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_catalog_tag.html#update DataCatalogTag#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/data_catalog_tag.html google_data_catalog_tag}.
 *
 * @stability stable
 */
export declare class DataCatalogTag extends cdktf.TerraformResource {
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/data_catalog_tag.html google_data_catalog_tag} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataCatalogTagConfig);
    private _column?;
    /**
     * @stability stable
     */
    get column(): string;
    /**
     * @stability stable
     */
    set column(value: string);
    /**
     * @stability stable
     */
    resetColumn(): void;
    /**
     * @stability stable
     */
    get columnInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get name(): string;
    private _parent?;
    /**
     * @stability stable
     */
    get parent(): string;
    /**
     * @stability stable
     */
    set parent(value: string);
    /**
     * @stability stable
     */
    resetParent(): void;
    /**
     * @stability stable
     */
    get parentInput(): string | undefined;
    private _template;
    /**
     * @stability stable
     */
    get template(): string;
    /**
     * @stability stable
     */
    set template(value: string);
    /**
     * @stability stable
     */
    get templateInput(): string;
    /**
     * @stability stable
     */
    get templateDisplayname(): string;
    private _fields;
    /**
     * @stability stable
     */
    get fields(): DataCatalogTagFields[];
    /**
     * @stability stable
     */
    set fields(value: DataCatalogTagFields[]);
    /**
     * @stability stable
     */
    get fieldsInput(): DataCatalogTagFields[];
    private _timeouts?;
    /**
     * @stability stable
     */
    get timeouts(): DataCatalogTagTimeouts;
    /**
     * @stability stable
     */
    set timeouts(value: DataCatalogTagTimeouts);
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): DataCatalogTagTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
