import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataGoogleComputeInstanceTemplateConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/compute_instance_template.html#filter DataGoogleComputeInstanceTemplate#filter}.
     *
     * @stability stable
     */
    readonly filter?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/compute_instance_template.html#most_recent DataGoogleComputeInstanceTemplate#most_recent}.
     *
     * @stability stable
     */
    readonly mostRecent?: boolean;
    /**
     * The name of the instance template. If you leave this blank, Terraform will auto-generate a unique name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/compute_instance_template.html#name DataGoogleComputeInstanceTemplate#name}
     *
     * @stability stable
     */
    readonly name?: string;
    /**
     * The ID of the project in which the resource belongs.
     *
     * If it is not provided, the provider project is used.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/compute_instance_template.html#project DataGoogleComputeInstanceTemplate#project}
     *
     * @stability stable
     */
    readonly project: string;
}
/**
 * @stability stable
 */
export declare class DataGoogleComputeInstanceTemplateConfidentialInstanceConfig extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get enableConfidentialCompute(): boolean;
}
/**
 * @stability stable
 */
export declare class DataGoogleComputeInstanceTemplateDiskDiskEncryptionKey extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get kmsKeySelfLink(): string;
}
/**
 * @stability stable
 */
export declare class DataGoogleComputeInstanceTemplateDisk extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get autoDelete(): boolean;
    /**
     * @stability stable
     */
    get boot(): boolean;
    /**
     * @stability stable
     */
    get deviceName(): string;
    /**
     * @stability stable
     */
    get diskEncryptionKey(): any;
    /**
     * @stability stable
     */
    get diskName(): string;
    /**
     * @stability stable
     */
    get diskSizeGb(): number;
    /**
     * @stability stable
     */
    get diskType(): string;
    /**
     * @stability stable
     */
    get interface(): string;
    /**
     * @stability stable
     */
    get labels(): any;
    /**
     * @stability stable
     */
    get mode(): string;
    /**
     * @stability stable
     */
    get resourcePolicies(): string[];
    /**
     * @stability stable
     */
    get source(): string;
    /**
     * @stability stable
     */
    get sourceImage(): string;
    /**
     * @stability stable
     */
    get type(): string;
}
/**
 * @stability stable
 */
export declare class DataGoogleComputeInstanceTemplateGuestAccelerator extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get count(): number;
    /**
     * @stability stable
     */
    get type(): string;
}
/**
 * @stability stable
 */
export declare class DataGoogleComputeInstanceTemplateNetworkInterfaceAccessConfig extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get natIp(): string;
    /**
     * @stability stable
     */
    get networkTier(): string;
    /**
     * @stability stable
     */
    get publicPtrDomainName(): string;
}
/**
 * @stability stable
 */
export declare class DataGoogleComputeInstanceTemplateNetworkInterfaceAliasIpRange extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get ipCidrRange(): string;
    /**
     * @stability stable
     */
    get subnetworkRangeName(): string;
}
/**
 * @stability stable
 */
export declare class DataGoogleComputeInstanceTemplateNetworkInterface extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get accessConfig(): any;
    /**
     * @stability stable
     */
    get aliasIpRange(): any;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    get network(): string;
    /**
     * @stability stable
     */
    get networkIp(): string;
    /**
     * @stability stable
     */
    get nicType(): string;
    /**
     * @stability stable
     */
    get subnetwork(): string;
    /**
     * @stability stable
     */
    get subnetworkProject(): string;
}
/**
 * @stability stable
 */
export declare class DataGoogleComputeInstanceTemplateReservationAffinitySpecificReservation extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get key(): string;
    /**
     * @stability stable
     */
    get values(): string[];
}
/**
 * @stability stable
 */
export declare class DataGoogleComputeInstanceTemplateReservationAffinity extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get specificReservation(): any;
    /**
     * @stability stable
     */
    get type(): string;
}
/**
 * @stability stable
 */
export declare class DataGoogleComputeInstanceTemplateSchedulingNodeAffinities extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get key(): string;
    /**
     * @stability stable
     */
    get operator(): string;
    /**
     * @stability stable
     */
    get values(): string[];
}
/**
 * @stability stable
 */
export declare class DataGoogleComputeInstanceTemplateScheduling extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get automaticRestart(): boolean;
    /**
     * @stability stable
     */
    get minNodeCpus(): number;
    /**
     * @stability stable
     */
    get nodeAffinities(): any;
    /**
     * @stability stable
     */
    get onHostMaintenance(): string;
    /**
     * @stability stable
     */
    get preemptible(): boolean;
}
/**
 * @stability stable
 */
export declare class DataGoogleComputeInstanceTemplateServiceAccount extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get email(): string;
    /**
     * @stability stable
     */
    get scopes(): string[];
}
/**
 * @stability stable
 */
export declare class DataGoogleComputeInstanceTemplateShieldedInstanceConfig extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get enableIntegrityMonitoring(): boolean;
    /**
     * @stability stable
     */
    get enableSecureBoot(): boolean;
    /**
     * @stability stable
     */
    get enableVtpm(): boolean;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/d/compute_instance_template.html google_compute_instance_template}.
 *
 * @stability stable
 */
export declare class DataGoogleComputeInstanceTemplate extends cdktf.TerraformDataSource {
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/d/compute_instance_template.html google_compute_instance_template} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataGoogleComputeInstanceTemplateConfig);
    /**
     * @stability stable
     */
    get canIpForward(): boolean;
    /**
     * @stability stable
     */
    confidentialInstanceConfig(index: string): DataGoogleComputeInstanceTemplateConfidentialInstanceConfig;
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    disk(index: string): DataGoogleComputeInstanceTemplateDisk;
    /**
     * @stability stable
     */
    get enableDisplay(): boolean;
    private _filter?;
    /**
     * @stability stable
     */
    get filter(): string;
    /**
     * @stability stable
     */
    set filter(value: string);
    /**
     * @stability stable
     */
    resetFilter(): void;
    /**
     * @stability stable
     */
    get filterInput(): string | undefined;
    /**
     * @stability stable
     */
    guestAccelerator(index: string): DataGoogleComputeInstanceTemplateGuestAccelerator;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get instanceDescription(): string;
    /**
     * @stability stable
     */
    labels(key: string): string;
    /**
     * @stability stable
     */
    get machineType(): string;
    /**
     * @stability stable
     */
    metadata(key: string): string;
    /**
     * @stability stable
     */
    get metadataFingerprint(): string;
    /**
     * @stability stable
     */
    get metadataStartupScript(): string;
    /**
     * @stability stable
     */
    get minCpuPlatform(): string;
    private _mostRecent?;
    /**
     * @stability stable
     */
    get mostRecent(): boolean;
    /**
     * @stability stable
     */
    set mostRecent(value: boolean);
    /**
     * @stability stable
     */
    resetMostRecent(): void;
    /**
     * @stability stable
     */
    get mostRecentInput(): boolean | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    resetName(): void;
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    /**
     * @stability stable
     */
    get namePrefix(): string;
    /**
     * @stability stable
     */
    networkInterface(index: string): DataGoogleComputeInstanceTemplateNetworkInterface;
    private _project;
    /**
     * @stability stable
     */
    get project(): string;
    /**
     * @stability stable
     */
    set project(value: string);
    /**
     * @stability stable
     */
    get projectInput(): string;
    /**
     * @stability stable
     */
    get region(): string;
    /**
     * @stability stable
     */
    reservationAffinity(index: string): DataGoogleComputeInstanceTemplateReservationAffinity;
    /**
     * @stability stable
     */
    scheduling(index: string): DataGoogleComputeInstanceTemplateScheduling;
    /**
     * @stability stable
     */
    get selfLink(): string;
    /**
     * @stability stable
     */
    serviceAccount(index: string): DataGoogleComputeInstanceTemplateServiceAccount;
    /**
     * @stability stable
     */
    shieldedInstanceConfig(index: string): DataGoogleComputeInstanceTemplateShieldedInstanceConfig;
    /**
     * @stability stable
     */
    get tags(): string[];
    /**
     * @stability stable
     */
    get tagsFingerprint(): string;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
