import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataGoogleKmsCryptoKeyVersionConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/kms_crypto_key_version.html#crypto_key DataGoogleKmsCryptoKeyVersion#crypto_key}.
     *
     * @stability stable
     */
    readonly cryptoKey: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/kms_crypto_key_version.html#version DataGoogleKmsCryptoKeyVersion#version}.
     *
     * @stability stable
     */
    readonly version?: number;
}
/**
 * @stability stable
 */
export declare class DataGoogleKmsCryptoKeyVersionPublicKey extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get algorithm(): string;
    /**
     * @stability stable
     */
    get pem(): string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/d/kms_crypto_key_version.html google_kms_crypto_key_version}.
 *
 * @stability stable
 */
export declare class DataGoogleKmsCryptoKeyVersion extends cdktf.TerraformDataSource {
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/d/kms_crypto_key_version.html google_kms_crypto_key_version} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataGoogleKmsCryptoKeyVersionConfig);
    /**
     * @stability stable
     */
    get algorithm(): string;
    private _cryptoKey;
    /**
     * @stability stable
     */
    get cryptoKey(): string;
    /**
     * @stability stable
     */
    set cryptoKey(value: string);
    /**
     * @stability stable
     */
    get cryptoKeyInput(): string;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get protectionLevel(): string;
    /**
     * @stability stable
     */
    publicKey(index: string): DataGoogleKmsCryptoKeyVersionPublicKey;
    /**
     * @stability stable
     */
    get state(): string;
    private _version?;
    /**
     * @stability stable
     */
    get version(): number;
    /**
     * @stability stable
     */
    set version(value: number);
    /**
     * @stability stable
     */
    resetVersion(): void;
    /**
     * @stability stable
     */
    get versionInput(): number | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
