import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataGoogleServiceAccountKeyConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/service_account_key.html#name DataGoogleServiceAccountKey#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/service_account_key.html#project DataGoogleServiceAccountKey#project}.
     *
     * @stability stable
     */
    readonly project?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/service_account_key.html#public_key_type DataGoogleServiceAccountKey#public_key_type}.
     *
     * @stability stable
     */
    readonly publicKeyType?: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/d/service_account_key.html google_service_account_key}.
 *
 * @stability stable
 */
export declare class DataGoogleServiceAccountKey extends cdktf.TerraformDataSource {
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/d/service_account_key.html google_service_account_key} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataGoogleServiceAccountKeyConfig);
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get keyAlgorithm(): string;
    private _name;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string;
    /**
     * @stability stable
     */
    set project(value: string);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    /**
     * @stability stable
     */
    get publicKey(): string;
    private _publicKeyType?;
    /**
     * @stability stable
     */
    get publicKeyType(): string;
    /**
     * @stability stable
     */
    set publicKeyType(value: string);
    /**
     * @stability stable
     */
    resetPublicKeyType(): void;
    /**
     * @stability stable
     */
    get publicKeyTypeInput(): string | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
