import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataGoogleSqlBackupRunConfig extends cdktf.TerraformMetaArguments {
    /**
     * The identifier for this backup run.
     *
     * Unique only for a specific Cloud SQL instance. If left empty and multiple backups exist for the instance, most_recent must be set to true.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/sql_backup_run.html#backup_id DataGoogleSqlBackupRun#backup_id}
     *
     * @stability stable
     */
    readonly backupId?: number;
    /**
     * Name of the database instance.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/sql_backup_run.html#instance DataGoogleSqlBackupRun#instance}
     *
     * @stability stable
     */
    readonly instance: string;
    /**
     * Toggles use of the most recent backup run if multiple backups exist for a Cloud SQL instance.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/sql_backup_run.html#most_recent DataGoogleSqlBackupRun#most_recent}
     *
     * @stability stable
     */
    readonly mostRecent?: boolean;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/d/sql_backup_run.html google_sql_backup_run}.
 *
 * @stability stable
 */
export declare class DataGoogleSqlBackupRun extends cdktf.TerraformDataSource {
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/d/sql_backup_run.html google_sql_backup_run} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataGoogleSqlBackupRunConfig);
    private _backupId?;
    /**
     * @stability stable
     */
    get backupId(): number;
    /**
     * @stability stable
     */
    set backupId(value: number);
    /**
     * @stability stable
     */
    resetBackupId(): void;
    /**
     * @stability stable
     */
    get backupIdInput(): number | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _instance;
    /**
     * @stability stable
     */
    get instance(): string;
    /**
     * @stability stable
     */
    set instance(value: string);
    /**
     * @stability stable
     */
    get instanceInput(): string;
    /**
     * @stability stable
     */
    get location(): string;
    private _mostRecent?;
    /**
     * @stability stable
     */
    get mostRecent(): boolean;
    /**
     * @stability stable
     */
    set mostRecent(value: boolean);
    /**
     * @stability stable
     */
    resetMostRecent(): void;
    /**
     * @stability stable
     */
    get mostRecentInput(): boolean | undefined;
    /**
     * @stability stable
     */
    get startTime(): string;
    /**
     * @stability stable
     */
    get status(): string;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
