import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataLossPreventionInspectTemplateConfig extends cdktf.TerraformMetaArguments {
    /**
     * A description of the inspect template.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_inspect_template.html#description DataLossPreventionInspectTemplate#description}
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * User set display name of the inspect template.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_inspect_template.html#display_name DataLossPreventionInspectTemplate#display_name}
     *
     * @stability stable
     */
    readonly displayName?: string;
    /**
     * The parent of the inspect template in any of the following formats:.
     *
     * 'projects/{{project}}'
     * 'projects/{{project}}/locations/{{location}}'
     * 'organizations/{{organization_id}}'
     * 'organizations/{{organization_id}}/locations/{{location}}'
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_inspect_template.html#parent DataLossPreventionInspectTemplate#parent}
     *
     * @stability stable
     */
    readonly parent: string;
    /**
     * inspect_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_inspect_template.html#inspect_config DataLossPreventionInspectTemplate#inspect_config}
     *
     * @stability stable
     */
    readonly inspectConfig?: DataLossPreventionInspectTemplateInspectConfig[];
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_inspect_template.html#timeouts DataLossPreventionInspectTemplate#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: DataLossPreventionInspectTemplateTimeouts;
}
/**
 * @stability stable
 */
export interface DataLossPreventionInspectTemplateInspectConfigCustomInfoTypesDictionaryCloudStoragePath {
    /**
     * A url representing a file or path (no wildcards) in Cloud Storage. Example: 'gs://[BUCKET_NAME]/dictionary.txt'.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_inspect_template.html#path DataLossPreventionInspectTemplate#path}
     *
     * @stability stable
     */
    readonly path: string;
}
/**
 * @stability stable
 */
export interface DataLossPreventionInspectTemplateInspectConfigCustomInfoTypesDictionaryWordList {
    /**
     * Words or phrases defining the dictionary.
     *
     * The dictionary must contain at least one
     * phrase and every phrase must contain at least 2 characters that are letters or digits.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_inspect_template.html#words DataLossPreventionInspectTemplate#words}
     *
     * @stability stable
     */
    readonly words: string[];
}
/**
 * @stability stable
 */
export interface DataLossPreventionInspectTemplateInspectConfigCustomInfoTypesDictionary {
    /**
     * cloud_storage_path block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_inspect_template.html#cloud_storage_path DataLossPreventionInspectTemplate#cloud_storage_path}
     *
     * @stability stable
     */
    readonly cloudStoragePath?: DataLossPreventionInspectTemplateInspectConfigCustomInfoTypesDictionaryCloudStoragePath[];
    /**
     * word_list block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_inspect_template.html#word_list DataLossPreventionInspectTemplate#word_list}
     *
     * @stability stable
     */
    readonly wordList?: DataLossPreventionInspectTemplateInspectConfigCustomInfoTypesDictionaryWordList[];
}
/**
 * @stability stable
 */
export interface DataLossPreventionInspectTemplateInspectConfigCustomInfoTypesInfoType {
    /**
     * Name of the information type.
     *
     * Either a name of your choosing when creating a CustomInfoType, or one of the names
     * listed at https://cloud.google.com/dlp/docs/infotypes-reference when specifying a built-in type.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_inspect_template.html#name DataLossPreventionInspectTemplate#name}
     *
     * @stability stable
     */
    readonly name: string;
}
/**
 * @stability stable
 */
export interface DataLossPreventionInspectTemplateInspectConfigCustomInfoTypesRegex {
    /**
     * The index of the submatch to extract as findings.
     *
     * When not specified, the entire match is returned. No more than 3 may be included.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_inspect_template.html#group_indexes DataLossPreventionInspectTemplate#group_indexes}
     *
     * @stability stable
     */
    readonly groupIndexes?: number[];
    /**
     * Pattern defining the regular expression. Its syntax (https://github.com/google/re2/wiki/Syntax) can be found under the google/re2 repository on GitHub.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_inspect_template.html#pattern DataLossPreventionInspectTemplate#pattern}
     *
     * @stability stable
     */
    readonly pattern: string;
}
/**
 * @stability stable
 */
export interface DataLossPreventionInspectTemplateInspectConfigCustomInfoTypesStoredType {
    /**
     * Resource name of the requested StoredInfoType, for example 'organizations/433245324/storedInfoTypes/432452342' or 'projects/project-id/storedInfoTypes/432452342'.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_inspect_template.html#name DataLossPreventionInspectTemplate#name}
     *
     * @stability stable
     */
    readonly name: string;
}
/**
 * @stability stable
 */
export interface DataLossPreventionInspectTemplateInspectConfigCustomInfoTypes {
    /**
     * If set to EXCLUSION_TYPE_EXCLUDE this infoType will not cause a finding to be returned.
     *
     * It still can be used for rules matching. Possible values: ["EXCLUSION_TYPE_EXCLUDE"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_inspect_template.html#exclusion_type DataLossPreventionInspectTemplate#exclusion_type}
     *
     * @stability stable
     */
    readonly exclusionType?: string;
    /**
     * Likelihood to return for this CustomInfoType.
     *
     * This base value can be altered by a detection rule if the finding meets the criteria
     * specified by the rule. Default value: "VERY_LIKELY" Possible values: ["VERY_UNLIKELY", "UNLIKELY", "POSSIBLE", "LIKELY", "VERY_LIKELY"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_inspect_template.html#likelihood DataLossPreventionInspectTemplate#likelihood}
     *
     * @stability stable
     */
    readonly likelihood?: string;
    /**
     * dictionary block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_inspect_template.html#dictionary DataLossPreventionInspectTemplate#dictionary}
     *
     * @stability stable
     */
    readonly dictionary?: DataLossPreventionInspectTemplateInspectConfigCustomInfoTypesDictionary[];
    /**
     * info_type block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_inspect_template.html#info_type DataLossPreventionInspectTemplate#info_type}
     *
     * @stability stable
     */
    readonly infoType: DataLossPreventionInspectTemplateInspectConfigCustomInfoTypesInfoType[];
    /**
     * regex block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_inspect_template.html#regex DataLossPreventionInspectTemplate#regex}
     *
     * @stability stable
     */
    readonly regex?: DataLossPreventionInspectTemplateInspectConfigCustomInfoTypesRegex[];
    /**
     * stored_type block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_inspect_template.html#stored_type DataLossPreventionInspectTemplate#stored_type}
     *
     * @stability stable
     */
    readonly storedType?: DataLossPreventionInspectTemplateInspectConfigCustomInfoTypesStoredType[];
}
/**
 * @stability stable
 */
export interface DataLossPreventionInspectTemplateInspectConfigInfoTypes {
    /**
     * Name of the information type.
     *
     * Either a name of your choosing when creating a CustomInfoType, or one of the names listed
     * at https://cloud.google.com/dlp/docs/infotypes-reference when specifying a built-in type.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_inspect_template.html#name DataLossPreventionInspectTemplate#name}
     *
     * @stability stable
     */
    readonly name: string;
}
/**
 * @stability stable
 */
export interface DataLossPreventionInspectTemplateInspectConfigLimitsMaxFindingsPerInfoTypeInfoType {
    /**
     * Name of the information type.
     *
     * Either a name of your choosing when creating a CustomInfoType, or one of the names listed
     * at https://cloud.google.com/dlp/docs/infotypes-reference when specifying a built-in type.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_inspect_template.html#name DataLossPreventionInspectTemplate#name}
     *
     * @stability stable
     */
    readonly name: string;
}
/**
 * @stability stable
 */
export interface DataLossPreventionInspectTemplateInspectConfigLimitsMaxFindingsPerInfoType {
    /**
     * Max findings limit for the given infoType.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_inspect_template.html#max_findings DataLossPreventionInspectTemplate#max_findings}
     *
     * @stability stable
     */
    readonly maxFindings: number;
    /**
     * info_type block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_inspect_template.html#info_type DataLossPreventionInspectTemplate#info_type}
     *
     * @stability stable
     */
    readonly infoType: DataLossPreventionInspectTemplateInspectConfigLimitsMaxFindingsPerInfoTypeInfoType[];
}
/**
 * @stability stable
 */
export interface DataLossPreventionInspectTemplateInspectConfigLimits {
    /**
     * Max number of findings that will be returned for each item scanned. The maximum returned is 2000.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_inspect_template.html#max_findings_per_item DataLossPreventionInspectTemplate#max_findings_per_item}
     *
     * @stability stable
     */
    readonly maxFindingsPerItem: number;
    /**
     * Max number of findings that will be returned per request/job. The maximum returned is 2000.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_inspect_template.html#max_findings_per_request DataLossPreventionInspectTemplate#max_findings_per_request}
     *
     * @stability stable
     */
    readonly maxFindingsPerRequest: number;
    /**
     * max_findings_per_info_type block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_inspect_template.html#max_findings_per_info_type DataLossPreventionInspectTemplate#max_findings_per_info_type}
     *
     * @stability stable
     */
    readonly maxFindingsPerInfoType?: DataLossPreventionInspectTemplateInspectConfigLimitsMaxFindingsPerInfoType[];
}
/**
 * @stability stable
 */
export interface DataLossPreventionInspectTemplateInspectConfigRuleSetInfoTypes {
    /**
     * Name of the information type.
     *
     * Either a name of your choosing when creating a CustomInfoType, or one of the names listed
     * at https://cloud.google.com/dlp/docs/infotypes-reference when specifying a built-in type.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_inspect_template.html#name DataLossPreventionInspectTemplate#name}
     *
     * @stability stable
     */
    readonly name: string;
}
/**
 * @stability stable
 */
export interface DataLossPreventionInspectTemplateInspectConfigRuleSetRulesExclusionRuleDictionaryCloudStoragePath {
    /**
     * A url representing a file or path (no wildcards) in Cloud Storage. Example: 'gs://[BUCKET_NAME]/dictionary.txt'.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_inspect_template.html#path DataLossPreventionInspectTemplate#path}
     *
     * @stability stable
     */
    readonly path: string;
}
/**
 * @stability stable
 */
export interface DataLossPreventionInspectTemplateInspectConfigRuleSetRulesExclusionRuleDictionaryWordList {
    /**
     * Words or phrases defining the dictionary.
     *
     * The dictionary must contain at least one
     * phrase and every phrase must contain at least 2 characters that are letters or digits.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_inspect_template.html#words DataLossPreventionInspectTemplate#words}
     *
     * @stability stable
     */
    readonly words: string[];
}
/**
 * @stability stable
 */
export interface DataLossPreventionInspectTemplateInspectConfigRuleSetRulesExclusionRuleDictionary {
    /**
     * cloud_storage_path block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_inspect_template.html#cloud_storage_path DataLossPreventionInspectTemplate#cloud_storage_path}
     *
     * @stability stable
     */
    readonly cloudStoragePath?: DataLossPreventionInspectTemplateInspectConfigRuleSetRulesExclusionRuleDictionaryCloudStoragePath[];
    /**
     * word_list block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_inspect_template.html#word_list DataLossPreventionInspectTemplate#word_list}
     *
     * @stability stable
     */
    readonly wordList?: DataLossPreventionInspectTemplateInspectConfigRuleSetRulesExclusionRuleDictionaryWordList[];
}
/**
 * @stability stable
 */
export interface DataLossPreventionInspectTemplateInspectConfigRuleSetRulesExclusionRuleExcludeInfoTypesInfoTypes {
    /**
     * Name of the information type.
     *
     * Either a name of your choosing when creating a CustomInfoType, or one of the names listed
     * at https://cloud.google.com/dlp/docs/infotypes-reference when specifying a built-in type.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_inspect_template.html#name DataLossPreventionInspectTemplate#name}
     *
     * @stability stable
     */
    readonly name: string;
}
/**
 * @stability stable
 */
export interface DataLossPreventionInspectTemplateInspectConfigRuleSetRulesExclusionRuleExcludeInfoTypes {
    /**
     * info_types block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_inspect_template.html#info_types DataLossPreventionInspectTemplate#info_types}
     *
     * @stability stable
     */
    readonly infoTypes: DataLossPreventionInspectTemplateInspectConfigRuleSetRulesExclusionRuleExcludeInfoTypesInfoTypes[];
}
/**
 * @stability stable
 */
export interface DataLossPreventionInspectTemplateInspectConfigRuleSetRulesExclusionRuleRegex {
    /**
     * The index of the submatch to extract as findings.
     *
     * When not specified, the entire match is returned. No more than 3 may be included.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_inspect_template.html#group_indexes DataLossPreventionInspectTemplate#group_indexes}
     *
     * @stability stable
     */
    readonly groupIndexes?: number[];
    /**
     * Pattern defining the regular expression. Its syntax (https://github.com/google/re2/wiki/Syntax) can be found under the google/re2 repository on GitHub.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_inspect_template.html#pattern DataLossPreventionInspectTemplate#pattern}
     *
     * @stability stable
     */
    readonly pattern: string;
}
/**
 * @stability stable
 */
export interface DataLossPreventionInspectTemplateInspectConfigRuleSetRulesExclusionRule {
    /**
     * How the rule is applied. See the documentation for more information: https://cloud.google.com/dlp/docs/reference/rest/v2/InspectConfig#MatchingType Possible values: ["MATCHING_TYPE_FULL_MATCH", "MATCHING_TYPE_PARTIAL_MATCH", "MATCHING_TYPE_INVERSE_MATCH"].
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_inspect_template.html#matching_type DataLossPreventionInspectTemplate#matching_type}
     *
     * @stability stable
     */
    readonly matchingType: string;
    /**
     * dictionary block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_inspect_template.html#dictionary DataLossPreventionInspectTemplate#dictionary}
     *
     * @stability stable
     */
    readonly dictionary?: DataLossPreventionInspectTemplateInspectConfigRuleSetRulesExclusionRuleDictionary[];
    /**
     * exclude_info_types block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_inspect_template.html#exclude_info_types DataLossPreventionInspectTemplate#exclude_info_types}
     *
     * @stability stable
     */
    readonly excludeInfoTypes?: DataLossPreventionInspectTemplateInspectConfigRuleSetRulesExclusionRuleExcludeInfoTypes[];
    /**
     * regex block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_inspect_template.html#regex DataLossPreventionInspectTemplate#regex}
     *
     * @stability stable
     */
    readonly regex?: DataLossPreventionInspectTemplateInspectConfigRuleSetRulesExclusionRuleRegex[];
}
/**
 * @stability stable
 */
export interface DataLossPreventionInspectTemplateInspectConfigRuleSetRulesHotwordRuleHotwordRegex {
    /**
     * The index of the submatch to extract as findings.
     *
     * When not specified,
     * the entire match is returned. No more than 3 may be included.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_inspect_template.html#group_indexes DataLossPreventionInspectTemplate#group_indexes}
     *
     * @stability stable
     */
    readonly groupIndexes?: number[];
    /**
     * Pattern defining the regular expression. Its syntax (https://github.com/google/re2/wiki/Syntax) can be found under the google/re2 repository on GitHub.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_inspect_template.html#pattern DataLossPreventionInspectTemplate#pattern}
     *
     * @stability stable
     */
    readonly pattern: string;
}
/**
 * @stability stable
 */
export interface DataLossPreventionInspectTemplateInspectConfigRuleSetRulesHotwordRuleLikelihoodAdjustment {
    /**
     * Set the likelihood of a finding to a fixed value.
     *
     * Either this or relative_likelihood can be set. Possible values: ["VERY_UNLIKELY", "UNLIKELY", "POSSIBLE", "LIKELY", "VERY_LIKELY"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_inspect_template.html#fixed_likelihood DataLossPreventionInspectTemplate#fixed_likelihood}
     *
     * @stability stable
     */
    readonly fixedLikelihood?: string;
    /**
     * Increase or decrease the likelihood by the specified number of levels.
     *
     * For example,
     * if a finding would be POSSIBLE without the detection rule and relativeLikelihood is 1,
     * then it is upgraded to LIKELY, while a value of -1 would downgrade it to UNLIKELY.
     * Likelihood may never drop below VERY_UNLIKELY or exceed VERY_LIKELY, so applying an
     * adjustment of 1 followed by an adjustment of -1 when base likelihood is VERY_LIKELY
     * will result in a final likelihood of LIKELY. Either this or fixed_likelihood can be set.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_inspect_template.html#relative_likelihood DataLossPreventionInspectTemplate#relative_likelihood}
     *
     * @stability stable
     */
    readonly relativeLikelihood?: number;
}
/**
 * @stability stable
 */
export interface DataLossPreventionInspectTemplateInspectConfigRuleSetRulesHotwordRuleProximity {
    /**
     * Number of characters after the finding to consider. Either this or window_before must be specified.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_inspect_template.html#window_after DataLossPreventionInspectTemplate#window_after}
     *
     * @stability stable
     */
    readonly windowAfter?: number;
    /**
     * Number of characters before the finding to consider. Either this or window_after must be specified.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_inspect_template.html#window_before DataLossPreventionInspectTemplate#window_before}
     *
     * @stability stable
     */
    readonly windowBefore?: number;
}
/**
 * @stability stable
 */
export interface DataLossPreventionInspectTemplateInspectConfigRuleSetRulesHotwordRule {
    /**
     * hotword_regex block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_inspect_template.html#hotword_regex DataLossPreventionInspectTemplate#hotword_regex}
     *
     * @stability stable
     */
    readonly hotwordRegex: DataLossPreventionInspectTemplateInspectConfigRuleSetRulesHotwordRuleHotwordRegex[];
    /**
     * likelihood_adjustment block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_inspect_template.html#likelihood_adjustment DataLossPreventionInspectTemplate#likelihood_adjustment}
     *
     * @stability stable
     */
    readonly likelihoodAdjustment: DataLossPreventionInspectTemplateInspectConfigRuleSetRulesHotwordRuleLikelihoodAdjustment[];
    /**
     * proximity block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_inspect_template.html#proximity DataLossPreventionInspectTemplate#proximity}
     *
     * @stability stable
     */
    readonly proximity: DataLossPreventionInspectTemplateInspectConfigRuleSetRulesHotwordRuleProximity[];
}
/**
 * @stability stable
 */
export interface DataLossPreventionInspectTemplateInspectConfigRuleSetRules {
    /**
     * exclusion_rule block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_inspect_template.html#exclusion_rule DataLossPreventionInspectTemplate#exclusion_rule}
     *
     * @stability stable
     */
    readonly exclusionRule?: DataLossPreventionInspectTemplateInspectConfigRuleSetRulesExclusionRule[];
    /**
     * hotword_rule block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_inspect_template.html#hotword_rule DataLossPreventionInspectTemplate#hotword_rule}
     *
     * @stability stable
     */
    readonly hotwordRule?: DataLossPreventionInspectTemplateInspectConfigRuleSetRulesHotwordRule[];
}
/**
 * @stability stable
 */
export interface DataLossPreventionInspectTemplateInspectConfigRuleSet {
    /**
     * info_types block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_inspect_template.html#info_types DataLossPreventionInspectTemplate#info_types}
     *
     * @stability stable
     */
    readonly infoTypes: DataLossPreventionInspectTemplateInspectConfigRuleSetInfoTypes[];
    /**
     * rules block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_inspect_template.html#rules DataLossPreventionInspectTemplate#rules}
     *
     * @stability stable
     */
    readonly rules: DataLossPreventionInspectTemplateInspectConfigRuleSetRules[];
}
/**
 * @stability stable
 */
export interface DataLossPreventionInspectTemplateInspectConfig {
    /**
     * List of options defining data content to scan.
     *
     * If empty, text, images, and other content will be included. Possible values: ["CONTENT_TEXT", "CONTENT_IMAGE"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_inspect_template.html#content_options DataLossPreventionInspectTemplate#content_options}
     *
     * @stability stable
     */
    readonly contentOptions?: string[];
    /**
     * When true, excludes type information of the findings.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_inspect_template.html#exclude_info_types DataLossPreventionInspectTemplate#exclude_info_types}
     *
     * @stability stable
     */
    readonly excludeInfoTypes?: boolean;
    /**
     * When true, a contextual quote from the data that triggered a finding is included in the response.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_inspect_template.html#include_quote DataLossPreventionInspectTemplate#include_quote}
     *
     * @stability stable
     */
    readonly includeQuote?: boolean;
    /**
     * Only returns findings equal or above this threshold.
     *
     * See https://cloud.google.com/dlp/docs/likelihood for more info Default value: "POSSIBLE" Possible values: ["VERY_UNLIKELY", "UNLIKELY", "POSSIBLE", "LIKELY", "VERY_LIKELY"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_inspect_template.html#min_likelihood DataLossPreventionInspectTemplate#min_likelihood}
     *
     * @stability stable
     */
    readonly minLikelihood?: string;
    /**
     * custom_info_types block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_inspect_template.html#custom_info_types DataLossPreventionInspectTemplate#custom_info_types}
     *
     * @stability stable
     */
    readonly customInfoTypes?: DataLossPreventionInspectTemplateInspectConfigCustomInfoTypes[];
    /**
     * info_types block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_inspect_template.html#info_types DataLossPreventionInspectTemplate#info_types}
     *
     * @stability stable
     */
    readonly infoTypes?: DataLossPreventionInspectTemplateInspectConfigInfoTypes[];
    /**
     * limits block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_inspect_template.html#limits DataLossPreventionInspectTemplate#limits}
     *
     * @stability stable
     */
    readonly limits?: DataLossPreventionInspectTemplateInspectConfigLimits[];
    /**
     * rule_set block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_inspect_template.html#rule_set DataLossPreventionInspectTemplate#rule_set}
     *
     * @stability stable
     */
    readonly ruleSet?: DataLossPreventionInspectTemplateInspectConfigRuleSet[];
}
/**
 * @stability stable
 */
export interface DataLossPreventionInspectTemplateTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_inspect_template.html#create DataLossPreventionInspectTemplate#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_inspect_template.html#delete DataLossPreventionInspectTemplate#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_inspect_template.html#update DataLossPreventionInspectTemplate#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_inspect_template.html google_data_loss_prevention_inspect_template}.
 *
 * @stability stable
 */
export declare class DataLossPreventionInspectTemplate extends cdktf.TerraformResource {
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_inspect_template.html google_data_loss_prevention_inspect_template} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataLossPreventionInspectTemplateConfig);
    private _description?;
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    set description(value: string);
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    private _displayName?;
    /**
     * @stability stable
     */
    get displayName(): string;
    /**
     * @stability stable
     */
    set displayName(value: string);
    /**
     * @stability stable
     */
    resetDisplayName(): void;
    /**
     * @stability stable
     */
    get displayNameInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get name(): string;
    private _parent;
    /**
     * @stability stable
     */
    get parent(): string;
    /**
     * @stability stable
     */
    set parent(value: string);
    /**
     * @stability stable
     */
    get parentInput(): string;
    private _inspectConfig?;
    /**
     * @stability stable
     */
    get inspectConfig(): DataLossPreventionInspectTemplateInspectConfig[];
    /**
     * @stability stable
     */
    set inspectConfig(value: DataLossPreventionInspectTemplateInspectConfig[]);
    /**
     * @stability stable
     */
    resetInspectConfig(): void;
    /**
     * @stability stable
     */
    get inspectConfigInput(): DataLossPreventionInspectTemplateInspectConfig[] | undefined;
    private _timeouts?;
    /**
     * @stability stable
     */
    get timeouts(): DataLossPreventionInspectTemplateTimeouts;
    /**
     * @stability stable
     */
    set timeouts(value: DataLossPreventionInspectTemplateTimeouts);
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): DataLossPreventionInspectTemplateTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
