import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataLossPreventionJobTriggerConfig extends cdktf.TerraformMetaArguments {
    /**
     * A description of the job trigger.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_job_trigger.html#description DataLossPreventionJobTrigger#description}
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * User set display name of the job trigger.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_job_trigger.html#display_name DataLossPreventionJobTrigger#display_name}
     *
     * @stability stable
     */
    readonly displayName?: string;
    /**
     * The parent of the trigger, either in the format 'projects/{{project}}' or 'projects/{{project}}/locations/{{location}}'.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_job_trigger.html#parent DataLossPreventionJobTrigger#parent}
     *
     * @stability stable
     */
    readonly parent: string;
    /**
     * Whether the trigger is currently active. Default value: "HEALTHY" Possible values: ["PAUSED", "HEALTHY", "CANCELLED"].
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_job_trigger.html#status DataLossPreventionJobTrigger#status}
     *
     * @stability stable
     */
    readonly status?: string;
    /**
     * inspect_job block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_job_trigger.html#inspect_job DataLossPreventionJobTrigger#inspect_job}
     *
     * @stability stable
     */
    readonly inspectJob?: DataLossPreventionJobTriggerInspectJob[];
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_job_trigger.html#timeouts DataLossPreventionJobTrigger#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: DataLossPreventionJobTriggerTimeouts;
    /**
     * triggers block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_job_trigger.html#triggers DataLossPreventionJobTrigger#triggers}
     *
     * @stability stable
     */
    readonly triggers: DataLossPreventionJobTriggerTriggers[];
}
/**
 * @stability stable
 */
export interface DataLossPreventionJobTriggerInspectJobActionsSaveFindingsOutputConfigTable {
    /**
     * Dataset ID of the table.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_job_trigger.html#dataset_id DataLossPreventionJobTrigger#dataset_id}
     *
     * @stability stable
     */
    readonly datasetId: string;
    /**
     * The Google Cloud Platform project ID of the project containing the table.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_job_trigger.html#project_id DataLossPreventionJobTrigger#project_id}
     *
     * @stability stable
     */
    readonly projectId: string;
    /**
     * Name of the table.
     *
     * If is not set a new one will be generated for you with the following format:
     * 'dlp_googleapis_yyyy_mm_dd_[dlp_job_id]'. Pacific timezone will be used for generating the date details.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_job_trigger.html#table_id DataLossPreventionJobTrigger#table_id}
     *
     * @stability stable
     */
    readonly tableId?: string;
}
/**
 * @stability stable
 */
export interface DataLossPreventionJobTriggerInspectJobActionsSaveFindingsOutputConfig {
    /**
     * Schema used for writing the findings for Inspect jobs.
     *
     * This field is only used for
     * Inspect and must be unspecified for Risk jobs. Columns are derived from the Finding
     * object. If appending to an existing table, any columns from the predefined schema
     * that are missing will be added. No columns in the existing table will be deleted.
     *
     * If unspecified, then all available columns will be used for a new table or an (existing)
     * table with no schema, and no changes will be made to an existing table that has a schema.
     * Only for use with external storage. Possible values: ["BASIC_COLUMNS", "GCS_COLUMNS", "DATASTORE_COLUMNS", "BIG_QUERY_COLUMNS", "ALL_COLUMNS"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_job_trigger.html#output_schema DataLossPreventionJobTrigger#output_schema}
     *
     * @stability stable
     */
    readonly outputSchema?: string;
    /**
     * table block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_job_trigger.html#table DataLossPreventionJobTrigger#table}
     *
     * @stability stable
     */
    readonly table: DataLossPreventionJobTriggerInspectJobActionsSaveFindingsOutputConfigTable[];
}
/**
 * @stability stable
 */
export interface DataLossPreventionJobTriggerInspectJobActionsSaveFindings {
    /**
     * output_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_job_trigger.html#output_config DataLossPreventionJobTrigger#output_config}
     *
     * @stability stable
     */
    readonly outputConfig: DataLossPreventionJobTriggerInspectJobActionsSaveFindingsOutputConfig[];
}
/**
 * @stability stable
 */
export interface DataLossPreventionJobTriggerInspectJobActions {
    /**
     * save_findings block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_job_trigger.html#save_findings DataLossPreventionJobTrigger#save_findings}
     *
     * @stability stable
     */
    readonly saveFindings: DataLossPreventionJobTriggerInspectJobActionsSaveFindings[];
}
/**
 * @stability stable
 */
export interface DataLossPreventionJobTriggerInspectJobStorageConfigBigQueryOptionsTableReference {
    /**
     * The dataset ID of the table.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_job_trigger.html#dataset_id DataLossPreventionJobTrigger#dataset_id}
     *
     * @stability stable
     */
    readonly datasetId: string;
    /**
     * The Google Cloud Platform project ID of the project containing the table.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_job_trigger.html#project_id DataLossPreventionJobTrigger#project_id}
     *
     * @stability stable
     */
    readonly projectId: string;
    /**
     * The name of the table.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_job_trigger.html#table_id DataLossPreventionJobTrigger#table_id}
     *
     * @stability stable
     */
    readonly tableId: string;
}
/**
 * @stability stable
 */
export interface DataLossPreventionJobTriggerInspectJobStorageConfigBigQueryOptions {
    /**
     * table_reference block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_job_trigger.html#table_reference DataLossPreventionJobTrigger#table_reference}
     *
     * @stability stable
     */
    readonly tableReference: DataLossPreventionJobTriggerInspectJobStorageConfigBigQueryOptionsTableReference[];
}
/**
 * @stability stable
 */
export interface DataLossPreventionJobTriggerInspectJobStorageConfigCloudStorageOptionsFileSetRegexFileSet {
    /**
     * The name of a Cloud Storage bucket.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_job_trigger.html#bucket_name DataLossPreventionJobTrigger#bucket_name}
     *
     * @stability stable
     */
    readonly bucketName: string;
    /**
     * A list of regular expressions matching file paths to exclude.
     *
     * All files in the bucket that match at
     * least one of these regular expressions will be excluded from the scan.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_job_trigger.html#exclude_regex DataLossPreventionJobTrigger#exclude_regex}
     *
     * @stability stable
     */
    readonly excludeRegex?: string[];
    /**
     * A list of regular expressions matching file paths to include.
     *
     * All files in the bucket
     * that match at least one of these regular expressions will be included in the set of files,
     * except for those that also match an item in excludeRegex. Leaving this field empty will
     * match all files by default (this is equivalent to including .* in the list)
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_job_trigger.html#include_regex DataLossPreventionJobTrigger#include_regex}
     *
     * @stability stable
     */
    readonly includeRegex?: string[];
}
/**
 * @stability stable
 */
export interface DataLossPreventionJobTriggerInspectJobStorageConfigCloudStorageOptionsFileSet {
    /**
     * The Cloud Storage url of the file(s) to scan, in the format 'gs://<bucket>/<path>'. Trailing wildcard in the path is allowed.
     *
     * If the url ends in a trailing slash, the bucket or directory represented by the url will be scanned
     * non-recursively (content in sub-directories will not be scanned). This means that 'gs://mybucket/' is
     * equivalent to 'gs://mybucket/*', and 'gs://mybucket/directory/' is equivalent to 'gs://mybucket/directory/*'.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_job_trigger.html#url DataLossPreventionJobTrigger#url}
     *
     * @stability stable
     */
    readonly url?: string;
    /**
     * regex_file_set block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_job_trigger.html#regex_file_set DataLossPreventionJobTrigger#regex_file_set}
     *
     * @stability stable
     */
    readonly regexFileSet?: DataLossPreventionJobTriggerInspectJobStorageConfigCloudStorageOptionsFileSetRegexFileSet[];
}
/**
 * @stability stable
 */
export interface DataLossPreventionJobTriggerInspectJobStorageConfigCloudStorageOptions {
    /**
     * Max number of bytes to scan from a file.
     *
     * If a scanned file's size is bigger than this value
     * then the rest of the bytes are omitted.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_job_trigger.html#bytes_limit_per_file DataLossPreventionJobTrigger#bytes_limit_per_file}
     *
     * @stability stable
     */
    readonly bytesLimitPerFile?: number;
    /**
     * Max percentage of bytes to scan from a file.
     *
     * The rest are omitted. The number of bytes scanned is rounded down.
     * Must be between 0 and 100, inclusively. Both 0 and 100 means no limit.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_job_trigger.html#bytes_limit_per_file_percent DataLossPreventionJobTrigger#bytes_limit_per_file_percent}
     *
     * @stability stable
     */
    readonly bytesLimitPerFilePercent?: number;
    /**
     * List of file type groups to include in the scan.
     *
     * If empty, all files are scanned and available data
     * format processors are applied. In addition, the binary content of the selected files is always scanned as well.
     * Images are scanned only as binary if the specified region does not support image inspection and no fileTypes were specified. Possible values: ["BINARY_FILE", "TEXT_FILE", "IMAGE", "WORD", "PDF", "AVRO", "CSV", "TSV"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_job_trigger.html#file_types DataLossPreventionJobTrigger#file_types}
     *
     * @stability stable
     */
    readonly fileTypes?: string[];
    /**
     * Limits the number of files to scan to this percentage of the input FileSet.
     *
     * Number of files scanned is rounded down.
     * Must be between 0 and 100, inclusively. Both 0 and 100 means no limit.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_job_trigger.html#files_limit_percent DataLossPreventionJobTrigger#files_limit_percent}
     *
     * @stability stable
     */
    readonly filesLimitPercent?: number;
    /**
     * How to sample bytes if not all bytes are scanned.
     *
     * Meaningful only when used in conjunction with bytesLimitPerFile.
     * If not specified, scanning would start from the top. Possible values: ["TOP", "RANDOM_START"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_job_trigger.html#sample_method DataLossPreventionJobTrigger#sample_method}
     *
     * @stability stable
     */
    readonly sampleMethod?: string;
    /**
     * file_set block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_job_trigger.html#file_set DataLossPreventionJobTrigger#file_set}
     *
     * @stability stable
     */
    readonly fileSet: DataLossPreventionJobTriggerInspectJobStorageConfigCloudStorageOptionsFileSet[];
}
/**
 * @stability stable
 */
export interface DataLossPreventionJobTriggerInspectJobStorageConfigDatastoreOptionsKind {
    /**
     * The name of the Datastore kind.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_job_trigger.html#name DataLossPreventionJobTrigger#name}
     *
     * @stability stable
     */
    readonly name: string;
}
/**
 * @stability stable
 */
export interface DataLossPreventionJobTriggerInspectJobStorageConfigDatastoreOptionsPartitionId {
    /**
     * If not empty, the ID of the namespace to which the entities belong.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_job_trigger.html#namespace_id DataLossPreventionJobTrigger#namespace_id}
     *
     * @stability stable
     */
    readonly namespaceId?: string;
    /**
     * The ID of the project to which the entities belong.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_job_trigger.html#project_id DataLossPreventionJobTrigger#project_id}
     *
     * @stability stable
     */
    readonly projectId: string;
}
/**
 * @stability stable
 */
export interface DataLossPreventionJobTriggerInspectJobStorageConfigDatastoreOptions {
    /**
     * kind block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_job_trigger.html#kind DataLossPreventionJobTrigger#kind}
     *
     * @stability stable
     */
    readonly kind: DataLossPreventionJobTriggerInspectJobStorageConfigDatastoreOptionsKind[];
    /**
     * partition_id block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_job_trigger.html#partition_id DataLossPreventionJobTrigger#partition_id}
     *
     * @stability stable
     */
    readonly partitionId: DataLossPreventionJobTriggerInspectJobStorageConfigDatastoreOptionsPartitionId[];
}
/**
 * @stability stable
 */
export interface DataLossPreventionJobTriggerInspectJobStorageConfigTimespanConfigTimestampField {
    /**
     * Specification of the field containing the timestamp of scanned items. Used for data sources like Datastore and BigQuery.
     *
     * For BigQuery: Required to filter out rows based on the given start and end times. If not specified and the table was
     * modified between the given start and end times, the entire table will be scanned. The valid data types of the timestamp
     * field are: INTEGER, DATE, TIMESTAMP, or DATETIME BigQuery column.
     *
     * For Datastore. Valid data types of the timestamp field are: TIMESTAMP. Datastore entity will be scanned if the
     * timestamp property does not exist or its value is empty or invalid.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_job_trigger.html#name DataLossPreventionJobTrigger#name}
     *
     * @stability stable
     */
    readonly name: string;
}
/**
 * @stability stable
 */
export interface DataLossPreventionJobTriggerInspectJobStorageConfigTimespanConfig {
    /**
     * When the job is started by a JobTrigger we will automatically figure out a valid startTime to avoid scanning files that have not been modified since the last time the JobTrigger executed.
     *
     * This will
     * be based on the time of the execution of the last run of the JobTrigger.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_job_trigger.html#enable_auto_population_of_timespan_config DataLossPreventionJobTrigger#enable_auto_population_of_timespan_config}
     *
     * @stability stable
     */
    readonly enableAutoPopulationOfTimespanConfig?: boolean;
    /**
     * Exclude files or rows newer than this value. If set to zero, no upper time limit is applied.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_job_trigger.html#end_time DataLossPreventionJobTrigger#end_time}
     *
     * @stability stable
     */
    readonly endTime?: string;
    /**
     * Exclude files or rows older than this value.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_job_trigger.html#start_time DataLossPreventionJobTrigger#start_time}
     *
     * @stability stable
     */
    readonly startTime?: string;
    /**
     * timestamp_field block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_job_trigger.html#timestamp_field DataLossPreventionJobTrigger#timestamp_field}
     *
     * @stability stable
     */
    readonly timestampField: DataLossPreventionJobTriggerInspectJobStorageConfigTimespanConfigTimestampField[];
}
/**
 * @stability stable
 */
export interface DataLossPreventionJobTriggerInspectJobStorageConfig {
    /**
     * big_query_options block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_job_trigger.html#big_query_options DataLossPreventionJobTrigger#big_query_options}
     *
     * @stability stable
     */
    readonly bigQueryOptions?: DataLossPreventionJobTriggerInspectJobStorageConfigBigQueryOptions[];
    /**
     * cloud_storage_options block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_job_trigger.html#cloud_storage_options DataLossPreventionJobTrigger#cloud_storage_options}
     *
     * @stability stable
     */
    readonly cloudStorageOptions?: DataLossPreventionJobTriggerInspectJobStorageConfigCloudStorageOptions[];
    /**
     * datastore_options block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_job_trigger.html#datastore_options DataLossPreventionJobTrigger#datastore_options}
     *
     * @stability stable
     */
    readonly datastoreOptions?: DataLossPreventionJobTriggerInspectJobStorageConfigDatastoreOptions[];
    /**
     * timespan_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_job_trigger.html#timespan_config DataLossPreventionJobTrigger#timespan_config}
     *
     * @stability stable
     */
    readonly timespanConfig?: DataLossPreventionJobTriggerInspectJobStorageConfigTimespanConfig[];
}
/**
 * @stability stable
 */
export interface DataLossPreventionJobTriggerInspectJob {
    /**
     * The name of the template to run when this job is triggered.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_job_trigger.html#inspect_template_name DataLossPreventionJobTrigger#inspect_template_name}
     *
     * @stability stable
     */
    readonly inspectTemplateName: string;
    /**
     * actions block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_job_trigger.html#actions DataLossPreventionJobTrigger#actions}
     *
     * @stability stable
     */
    readonly actions: DataLossPreventionJobTriggerInspectJobActions[];
    /**
     * storage_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_job_trigger.html#storage_config DataLossPreventionJobTrigger#storage_config}
     *
     * @stability stable
     */
    readonly storageConfig: DataLossPreventionJobTriggerInspectJobStorageConfig[];
}
/**
 * @stability stable
 */
export interface DataLossPreventionJobTriggerTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_job_trigger.html#create DataLossPreventionJobTrigger#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_job_trigger.html#delete DataLossPreventionJobTrigger#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_job_trigger.html#update DataLossPreventionJobTrigger#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
/**
 * @stability stable
 */
export interface DataLossPreventionJobTriggerTriggersSchedule {
    /**
     * With this option a job is started a regular periodic basis. For example: every day (86400 seconds).
     *
     * A scheduled start time will be skipped if the previous execution has not ended when its scheduled time occurs.
     *
     * This value must be set to a time duration greater than or equal to 1 day and can be no longer than 60 days.
     *
     * A duration in seconds with up to nine fractional digits, terminated by 's'. Example: "3.5s".
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_job_trigger.html#recurrence_period_duration DataLossPreventionJobTrigger#recurrence_period_duration}
     *
     * @stability stable
     */
    readonly recurrencePeriodDuration?: string;
}
/**
 * @stability stable
 */
export interface DataLossPreventionJobTriggerTriggers {
    /**
     * schedule block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_job_trigger.html#schedule DataLossPreventionJobTrigger#schedule}
     *
     * @stability stable
     */
    readonly schedule?: DataLossPreventionJobTriggerTriggersSchedule[];
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_job_trigger.html google_data_loss_prevention_job_trigger}.
 *
 * @stability stable
 */
export declare class DataLossPreventionJobTrigger extends cdktf.TerraformResource {
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_job_trigger.html google_data_loss_prevention_job_trigger} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataLossPreventionJobTriggerConfig);
    private _description?;
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    set description(value: string);
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    private _displayName?;
    /**
     * @stability stable
     */
    get displayName(): string;
    /**
     * @stability stable
     */
    set displayName(value: string);
    /**
     * @stability stable
     */
    resetDisplayName(): void;
    /**
     * @stability stable
     */
    get displayNameInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get lastRunTime(): string;
    /**
     * @stability stable
     */
    get name(): string;
    private _parent;
    /**
     * @stability stable
     */
    get parent(): string;
    /**
     * @stability stable
     */
    set parent(value: string);
    /**
     * @stability stable
     */
    get parentInput(): string;
    private _status?;
    /**
     * @stability stable
     */
    get status(): string;
    /**
     * @stability stable
     */
    set status(value: string);
    /**
     * @stability stable
     */
    resetStatus(): void;
    /**
     * @stability stable
     */
    get statusInput(): string | undefined;
    private _inspectJob?;
    /**
     * @stability stable
     */
    get inspectJob(): DataLossPreventionJobTriggerInspectJob[];
    /**
     * @stability stable
     */
    set inspectJob(value: DataLossPreventionJobTriggerInspectJob[]);
    /**
     * @stability stable
     */
    resetInspectJob(): void;
    /**
     * @stability stable
     */
    get inspectJobInput(): DataLossPreventionJobTriggerInspectJob[] | undefined;
    private _timeouts?;
    /**
     * @stability stable
     */
    get timeouts(): DataLossPreventionJobTriggerTimeouts;
    /**
     * @stability stable
     */
    set timeouts(value: DataLossPreventionJobTriggerTimeouts);
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): DataLossPreventionJobTriggerTimeouts | undefined;
    private _triggers;
    /**
     * @stability stable
     */
    get triggers(): DataLossPreventionJobTriggerTriggers[];
    /**
     * @stability stable
     */
    set triggers(value: DataLossPreventionJobTriggerTriggers[]);
    /**
     * @stability stable
     */
    get triggersInput(): DataLossPreventionJobTriggerTriggers[];
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
