import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataprocJobConfig extends cdktf.TerraformMetaArguments {
    /**
     * By default, you can only delete inactive jobs within Dataproc.
     *
     * Setting this to true, and calling destroy, will ensure that the job is first cancelled before issuing the delete.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_job.html#force_delete DataprocJob#force_delete}
     *
     * @stability stable
     */
    readonly forceDelete?: boolean;
    /**
     * Optional. The labels to associate with this job.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_job.html#labels DataprocJob#labels}
     *
     * @stability stable
     */
    readonly labels?: {
        [key: string]: string;
    };
    /**
     * The project in which the cluster can be found and jobs subsequently run against.
     *
     * If it is not provided, the provider project is used.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_job.html#project DataprocJob#project}
     *
     * @stability stable
     */
    readonly project?: string;
    /**
     * The Cloud Dataproc region.
     *
     * This essentially determines which clusters are available for this job to be submitted to. If not specified, defaults to global.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_job.html#region DataprocJob#region}
     *
     * @stability stable
     */
    readonly region?: string;
    /**
     * hadoop_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_job.html#hadoop_config DataprocJob#hadoop_config}
     *
     * @stability stable
     */
    readonly hadoopConfig?: DataprocJobHadoopConfig[];
    /**
     * hive_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_job.html#hive_config DataprocJob#hive_config}
     *
     * @stability stable
     */
    readonly hiveConfig?: DataprocJobHiveConfig[];
    /**
     * pig_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_job.html#pig_config DataprocJob#pig_config}
     *
     * @stability stable
     */
    readonly pigConfig?: DataprocJobPigConfig[];
    /**
     * placement block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_job.html#placement DataprocJob#placement}
     *
     * @stability stable
     */
    readonly placement: DataprocJobPlacement[];
    /**
     * pyspark_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_job.html#pyspark_config DataprocJob#pyspark_config}
     *
     * @stability stable
     */
    readonly pysparkConfig?: DataprocJobPysparkConfig[];
    /**
     * reference block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_job.html#reference DataprocJob#reference}
     *
     * @stability stable
     */
    readonly reference?: DataprocJobReference[];
    /**
     * scheduling block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_job.html#scheduling DataprocJob#scheduling}
     *
     * @stability stable
     */
    readonly scheduling?: DataprocJobScheduling[];
    /**
     * spark_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_job.html#spark_config DataprocJob#spark_config}
     *
     * @stability stable
     */
    readonly sparkConfig?: DataprocJobSparkConfig[];
    /**
     * sparksql_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_job.html#sparksql_config DataprocJob#sparksql_config}
     *
     * @stability stable
     */
    readonly sparksqlConfig?: DataprocJobSparksqlConfig[];
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_job.html#timeouts DataprocJob#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: DataprocJobTimeouts;
}
/**
 * @stability stable
 */
export declare class DataprocJobStatus extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get details(): string;
    /**
     * @stability stable
     */
    get state(): string;
    /**
     * @stability stable
     */
    get stateStartTime(): string;
    /**
     * @stability stable
     */
    get substate(): string;
}
/**
 * @stability stable
 */
export interface DataprocJobHadoopConfigLoggingConfig {
    /**
     * Optional.
     *
     * The per-package log levels for the driver. This may include 'root' package name to configure rootLogger. Examples: 'com.google = FATAL', 'root = INFO', 'org.apache = DEBUG'.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_job.html#driver_log_levels DataprocJob#driver_log_levels}
     *
     * @stability stable
     */
    readonly driverLogLevels: {
        [key: string]: string;
    };
}
/**
 * @stability stable
 */
export interface DataprocJobHadoopConfig {
    /**
     * HCFS URIs of archives to be extracted in the working directory of .jar, .tar, .tar.gz, .tgz, and .zip.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_job.html#archive_uris DataprocJob#archive_uris}
     *
     * @stability stable
     */
    readonly archiveUris?: string[];
    /**
     * The arguments to pass to the driver.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_job.html#args DataprocJob#args}
     *
     * @stability stable
     */
    readonly args?: string[];
    /**
     * HCFS URIs of files to be copied to the working directory of Spark drivers and distributed tasks.
     *
     * Useful for naively parallel tasks.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_job.html#file_uris DataprocJob#file_uris}
     *
     * @stability stable
     */
    readonly fileUris?: string[];
    /**
     * HCFS URIs of jar files to add to the CLASSPATHs of the Spark driver and tasks.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_job.html#jar_file_uris DataprocJob#jar_file_uris}
     *
     * @stability stable
     */
    readonly jarFileUris?: string[];
    /**
     * The class containing the main method of the driver.
     *
     * Must be in a provided jar or jar that is already on the classpath. Conflicts with main_jar_file_uri
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_job.html#main_class DataprocJob#main_class}
     *
     * @stability stable
     */
    readonly mainClass?: string;
    /**
     * The HCFS URI of jar file containing the driver jar. Conflicts with main_class.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_job.html#main_jar_file_uri DataprocJob#main_jar_file_uri}
     *
     * @stability stable
     */
    readonly mainJarFileUri?: string;
    /**
     * A mapping of property names to values, used to configure Spark.
     *
     * Properties that conflict with values set by the Cloud Dataproc API may be overwritten. Can include properties set in /etc/spark/conf/spark-defaults.conf and classes in user code.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_job.html#properties DataprocJob#properties}
     *
     * @stability stable
     */
    readonly properties?: {
        [key: string]: string;
    };
    /**
     * logging_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_job.html#logging_config DataprocJob#logging_config}
     *
     * @stability stable
     */
    readonly loggingConfig?: DataprocJobHadoopConfigLoggingConfig[];
}
/**
 * @stability stable
 */
export interface DataprocJobHiveConfig {
    /**
     * Whether to continue executing queries if a query fails.
     *
     * The default value is false. Setting to true can be useful when executing independent parallel queries. Defaults to false.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_job.html#continue_on_failure DataprocJob#continue_on_failure}
     *
     * @stability stable
     */
    readonly continueOnFailure?: boolean;
    /**
     * HCFS URIs of jar files to add to the CLASSPATH of the Hive server and Hadoop MapReduce (MR) tasks.
     *
     * Can contain Hive SerDes and UDFs.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_job.html#jar_file_uris DataprocJob#jar_file_uris}
     *
     * @stability stable
     */
    readonly jarFileUris?: string[];
    /**
     * A mapping of property names and values, used to configure Hive.
     *
     * Properties that conflict with values set by the Cloud Dataproc API may be overwritten. Can include properties set in /etc/hadoop/conf/*-site.xml, /etc/hive/conf/hive-site.xml, and classes in user code.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_job.html#properties DataprocJob#properties}
     *
     * @stability stable
     */
    readonly properties?: {
        [key: string]: string;
    };
    /**
     * HCFS URI of file containing Hive script to execute as the job. Conflicts with query_list.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_job.html#query_file_uri DataprocJob#query_file_uri}
     *
     * @stability stable
     */
    readonly queryFileUri?: string;
    /**
     * The list of Hive queries or statements to execute as part of the job. Conflicts with query_file_uri.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_job.html#query_list DataprocJob#query_list}
     *
     * @stability stable
     */
    readonly queryList?: string[];
    /**
     * Mapping of query variable names to values (equivalent to the Hive command: SET name="value";).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_job.html#script_variables DataprocJob#script_variables}
     *
     * @stability stable
     */
    readonly scriptVariables?: {
        [key: string]: string;
    };
}
/**
 * @stability stable
 */
export interface DataprocJobPigConfigLoggingConfig {
    /**
     * Optional.
     *
     * The per-package log levels for the driver. This may include 'root' package name to configure rootLogger. Examples: 'com.google = FATAL', 'root = INFO', 'org.apache = DEBUG'.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_job.html#driver_log_levels DataprocJob#driver_log_levels}
     *
     * @stability stable
     */
    readonly driverLogLevels: {
        [key: string]: string;
    };
}
/**
 * @stability stable
 */
export interface DataprocJobPigConfig {
    /**
     * Whether to continue executing queries if a query fails.
     *
     * The default value is false. Setting to true can be useful when executing independent parallel queries. Defaults to false.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_job.html#continue_on_failure DataprocJob#continue_on_failure}
     *
     * @stability stable
     */
    readonly continueOnFailure?: boolean;
    /**
     * HCFS URIs of jar files to add to the CLASSPATH of the Pig Client and Hadoop MapReduce (MR) tasks.
     *
     * Can contain Pig UDFs.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_job.html#jar_file_uris DataprocJob#jar_file_uris}
     *
     * @stability stable
     */
    readonly jarFileUris?: string[];
    /**
     * A mapping of property names to values, used to configure Pig.
     *
     * Properties that conflict with values set by the Cloud Dataproc API may be overwritten. Can include properties set in /etc/hadoop/conf/*-site.xml, /etc/pig/conf/pig.properties, and classes in user code.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_job.html#properties DataprocJob#properties}
     *
     * @stability stable
     */
    readonly properties?: {
        [key: string]: string;
    };
    /**
     * HCFS URI of file containing Hive script to execute as the job. Conflicts with query_list.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_job.html#query_file_uri DataprocJob#query_file_uri}
     *
     * @stability stable
     */
    readonly queryFileUri?: string;
    /**
     * The list of Hive queries or statements to execute as part of the job. Conflicts with query_file_uri.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_job.html#query_list DataprocJob#query_list}
     *
     * @stability stable
     */
    readonly queryList?: string[];
    /**
     * Mapping of query variable names to values (equivalent to the Pig command: name=[value]).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_job.html#script_variables DataprocJob#script_variables}
     *
     * @stability stable
     */
    readonly scriptVariables?: {
        [key: string]: string;
    };
    /**
     * logging_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_job.html#logging_config DataprocJob#logging_config}
     *
     * @stability stable
     */
    readonly loggingConfig?: DataprocJobPigConfigLoggingConfig[];
}
/**
 * @stability stable
 */
export interface DataprocJobPlacement {
    /**
     * The name of the cluster where the job will be submitted.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_job.html#cluster_name DataprocJob#cluster_name}
     *
     * @stability stable
     */
    readonly clusterName: string;
}
/**
 * @stability stable
 */
export interface DataprocJobPysparkConfigLoggingConfig {
    /**
     * Optional.
     *
     * The per-package log levels for the driver. This may include 'root' package name to configure rootLogger. Examples: 'com.google = FATAL', 'root = INFO', 'org.apache = DEBUG'.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_job.html#driver_log_levels DataprocJob#driver_log_levels}
     *
     * @stability stable
     */
    readonly driverLogLevels: {
        [key: string]: string;
    };
}
/**
 * @stability stable
 */
export interface DataprocJobPysparkConfig {
    /**
     * Optional. HCFS URIs of archives to be extracted in the working directory of .jar, .tar, .tar.gz, .tgz, and .zip.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_job.html#archive_uris DataprocJob#archive_uris}
     *
     * @stability stable
     */
    readonly archiveUris?: string[];
    /**
     * Optional.
     *
     * The arguments to pass to the driver. Do not include arguments, such as --conf, that can be set as job properties, since a collision may occur that causes an incorrect job submission
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_job.html#args DataprocJob#args}
     *
     * @stability stable
     */
    readonly args?: string[];
    /**
     * Optional.
     *
     * HCFS URIs of files to be copied to the working directory of Python drivers and distributed tasks. Useful for naively parallel tasks
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_job.html#file_uris DataprocJob#file_uris}
     *
     * @stability stable
     */
    readonly fileUris?: string[];
    /**
     * Optional. HCFS URIs of jar files to add to the CLASSPATHs of the Python driver and tasks.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_job.html#jar_file_uris DataprocJob#jar_file_uris}
     *
     * @stability stable
     */
    readonly jarFileUris?: string[];
    /**
     * Required. The HCFS URI of the main Python file to use as the driver. Must be a .py file.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_job.html#main_python_file_uri DataprocJob#main_python_file_uri}
     *
     * @stability stable
     */
    readonly mainPythonFileUri: string;
    /**
     * Optional.
     *
     * A mapping of property names to values, used to configure PySpark. Properties that conflict with values set by the Cloud Dataproc API may be overwritten. Can include properties set in /etc/spark/conf/spark-defaults.conf and classes in user code
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_job.html#properties DataprocJob#properties}
     *
     * @stability stable
     */
    readonly properties?: {
        [key: string]: string;
    };
    /**
     * Optional.
     *
     * HCFS file URIs of Python files to pass to the PySpark framework. Supported file types: .py, .egg, and .zip
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_job.html#python_file_uris DataprocJob#python_file_uris}
     *
     * @stability stable
     */
    readonly pythonFileUris?: string[];
    /**
     * logging_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_job.html#logging_config DataprocJob#logging_config}
     *
     * @stability stable
     */
    readonly loggingConfig?: DataprocJobPysparkConfigLoggingConfig[];
}
/**
 * @stability stable
 */
export interface DataprocJobReference {
    /**
     * The job ID, which must be unique within the project.
     *
     * The job ID is generated by the server upon job submission or provided by the user as a means to perform retries without creating duplicate jobs
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_job.html#job_id DataprocJob#job_id}
     *
     * @stability stable
     */
    readonly jobId?: string;
}
/**
 * @stability stable
 */
export interface DataprocJobScheduling {
    /**
     * Maximum number of times per hour a driver may be restarted as a result of driver exiting with non-zero code before job is reported failed.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_job.html#max_failures_per_hour DataprocJob#max_failures_per_hour}
     *
     * @stability stable
     */
    readonly maxFailuresPerHour: number;
    /**
     * Maximum number of times in total a driver may be restarted as a result of driver exiting with non-zero code before job is reported failed.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_job.html#max_failures_total DataprocJob#max_failures_total}
     *
     * @stability stable
     */
    readonly maxFailuresTotal: number;
}
/**
 * @stability stable
 */
export interface DataprocJobSparkConfigLoggingConfig {
    /**
     * Optional.
     *
     * The per-package log levels for the driver. This may include 'root' package name to configure rootLogger. Examples: 'com.google = FATAL', 'root = INFO', 'org.apache = DEBUG'.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_job.html#driver_log_levels DataprocJob#driver_log_levels}
     *
     * @stability stable
     */
    readonly driverLogLevels: {
        [key: string]: string;
    };
}
/**
 * @stability stable
 */
export interface DataprocJobSparkConfig {
    /**
     * HCFS URIs of archives to be extracted in the working directory of .jar, .tar, .tar.gz, .tgz, and .zip.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_job.html#archive_uris DataprocJob#archive_uris}
     *
     * @stability stable
     */
    readonly archiveUris?: string[];
    /**
     * The arguments to pass to the driver.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_job.html#args DataprocJob#args}
     *
     * @stability stable
     */
    readonly args?: string[];
    /**
     * HCFS URIs of files to be copied to the working directory of Spark drivers and distributed tasks.
     *
     * Useful for naively parallel tasks.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_job.html#file_uris DataprocJob#file_uris}
     *
     * @stability stable
     */
    readonly fileUris?: string[];
    /**
     * HCFS URIs of jar files to add to the CLASSPATHs of the Spark driver and tasks.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_job.html#jar_file_uris DataprocJob#jar_file_uris}
     *
     * @stability stable
     */
    readonly jarFileUris?: string[];
    /**
     * The class containing the main method of the driver.
     *
     * Must be in a provided jar or jar that is already on the classpath. Conflicts with main_jar_file_uri
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_job.html#main_class DataprocJob#main_class}
     *
     * @stability stable
     */
    readonly mainClass?: string;
    /**
     * The HCFS URI of jar file containing the driver jar. Conflicts with main_class.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_job.html#main_jar_file_uri DataprocJob#main_jar_file_uri}
     *
     * @stability stable
     */
    readonly mainJarFileUri?: string;
    /**
     * A mapping of property names to values, used to configure Spark.
     *
     * Properties that conflict with values set by the Cloud Dataproc API may be overwritten. Can include properties set in /etc/spark/conf/spark-defaults.conf and classes in user code.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_job.html#properties DataprocJob#properties}
     *
     * @stability stable
     */
    readonly properties?: {
        [key: string]: string;
    };
    /**
     * logging_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_job.html#logging_config DataprocJob#logging_config}
     *
     * @stability stable
     */
    readonly loggingConfig?: DataprocJobSparkConfigLoggingConfig[];
}
/**
 * @stability stable
 */
export interface DataprocJobSparksqlConfigLoggingConfig {
    /**
     * Optional.
     *
     * The per-package log levels for the driver. This may include 'root' package name to configure rootLogger. Examples: 'com.google = FATAL', 'root = INFO', 'org.apache = DEBUG'.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_job.html#driver_log_levels DataprocJob#driver_log_levels}
     *
     * @stability stable
     */
    readonly driverLogLevels: {
        [key: string]: string;
    };
}
/**
 * @stability stable
 */
export interface DataprocJobSparksqlConfig {
    /**
     * HCFS URIs of jar files to be added to the Spark CLASSPATH.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_job.html#jar_file_uris DataprocJob#jar_file_uris}
     *
     * @stability stable
     */
    readonly jarFileUris?: string[];
    /**
     * A mapping of property names to values, used to configure Spark SQL's SparkConf.
     *
     * Properties that conflict with values set by the Cloud Dataproc API may be overwritten.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_job.html#properties DataprocJob#properties}
     *
     * @stability stable
     */
    readonly properties?: {
        [key: string]: string;
    };
    /**
     * The HCFS URI of the script that contains SQL queries. Conflicts with query_list.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_job.html#query_file_uri DataprocJob#query_file_uri}
     *
     * @stability stable
     */
    readonly queryFileUri?: string;
    /**
     * The list of SQL queries or statements to execute as part of the job. Conflicts with query_file_uri.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_job.html#query_list DataprocJob#query_list}
     *
     * @stability stable
     */
    readonly queryList?: string[];
    /**
     * Mapping of query variable names to values (equivalent to the Spark SQL command: SET name="value";).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_job.html#script_variables DataprocJob#script_variables}
     *
     * @stability stable
     */
    readonly scriptVariables?: {
        [key: string]: string;
    };
    /**
     * logging_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_job.html#logging_config DataprocJob#logging_config}
     *
     * @stability stable
     */
    readonly loggingConfig?: DataprocJobSparksqlConfigLoggingConfig[];
}
/**
 * @stability stable
 */
export interface DataprocJobTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_job.html#create DataprocJob#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_job.html#delete DataprocJob#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/dataproc_job.html google_dataproc_job}.
 *
 * @stability stable
 */
export declare class DataprocJob extends cdktf.TerraformResource {
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/dataproc_job.html google_dataproc_job} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataprocJobConfig);
    /**
     * @stability stable
     */
    get driverControlsFilesUri(): string;
    /**
     * @stability stable
     */
    get driverOutputResourceUri(): string;
    private _forceDelete?;
    /**
     * @stability stable
     */
    get forceDelete(): boolean;
    /**
     * @stability stable
     */
    set forceDelete(value: boolean);
    /**
     * @stability stable
     */
    resetForceDelete(): void;
    /**
     * @stability stable
     */
    get forceDeleteInput(): boolean | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _labels?;
    /**
     * @stability stable
     */
    get labels(): {
        [key: string]: string;
    };
    /**
     * @stability stable
     */
    set labels(value: {
        [key: string]: string;
    });
    /**
     * @stability stable
     */
    resetLabels(): void;
    /**
     * @stability stable
     */
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string;
    /**
     * @stability stable
     */
    set project(value: string);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    private _region?;
    /**
     * @stability stable
     */
    get region(): string;
    /**
     * @stability stable
     */
    set region(value: string);
    /**
     * @stability stable
     */
    resetRegion(): void;
    /**
     * @stability stable
     */
    get regionInput(): string | undefined;
    /**
     * @stability stable
     */
    status(index: string): DataprocJobStatus;
    private _hadoopConfig?;
    /**
     * @stability stable
     */
    get hadoopConfig(): DataprocJobHadoopConfig[];
    /**
     * @stability stable
     */
    set hadoopConfig(value: DataprocJobHadoopConfig[]);
    /**
     * @stability stable
     */
    resetHadoopConfig(): void;
    /**
     * @stability stable
     */
    get hadoopConfigInput(): DataprocJobHadoopConfig[] | undefined;
    private _hiveConfig?;
    /**
     * @stability stable
     */
    get hiveConfig(): DataprocJobHiveConfig[];
    /**
     * @stability stable
     */
    set hiveConfig(value: DataprocJobHiveConfig[]);
    /**
     * @stability stable
     */
    resetHiveConfig(): void;
    /**
     * @stability stable
     */
    get hiveConfigInput(): DataprocJobHiveConfig[] | undefined;
    private _pigConfig?;
    /**
     * @stability stable
     */
    get pigConfig(): DataprocJobPigConfig[];
    /**
     * @stability stable
     */
    set pigConfig(value: DataprocJobPigConfig[]);
    /**
     * @stability stable
     */
    resetPigConfig(): void;
    /**
     * @stability stable
     */
    get pigConfigInput(): DataprocJobPigConfig[] | undefined;
    private _placement;
    /**
     * @stability stable
     */
    get placement(): DataprocJobPlacement[];
    /**
     * @stability stable
     */
    set placement(value: DataprocJobPlacement[]);
    /**
     * @stability stable
     */
    get placementInput(): DataprocJobPlacement[];
    private _pysparkConfig?;
    /**
     * @stability stable
     */
    get pysparkConfig(): DataprocJobPysparkConfig[];
    /**
     * @stability stable
     */
    set pysparkConfig(value: DataprocJobPysparkConfig[]);
    /**
     * @stability stable
     */
    resetPysparkConfig(): void;
    /**
     * @stability stable
     */
    get pysparkConfigInput(): DataprocJobPysparkConfig[] | undefined;
    private _reference?;
    /**
     * @stability stable
     */
    get reference(): DataprocJobReference[];
    /**
     * @stability stable
     */
    set reference(value: DataprocJobReference[]);
    /**
     * @stability stable
     */
    resetReference(): void;
    /**
     * @stability stable
     */
    get referenceInput(): DataprocJobReference[] | undefined;
    private _scheduling?;
    /**
     * @stability stable
     */
    get scheduling(): DataprocJobScheduling[];
    /**
     * @stability stable
     */
    set scheduling(value: DataprocJobScheduling[]);
    /**
     * @stability stable
     */
    resetScheduling(): void;
    /**
     * @stability stable
     */
    get schedulingInput(): DataprocJobScheduling[] | undefined;
    private _sparkConfig?;
    /**
     * @stability stable
     */
    get sparkConfig(): DataprocJobSparkConfig[];
    /**
     * @stability stable
     */
    set sparkConfig(value: DataprocJobSparkConfig[]);
    /**
     * @stability stable
     */
    resetSparkConfig(): void;
    /**
     * @stability stable
     */
    get sparkConfigInput(): DataprocJobSparkConfig[] | undefined;
    private _sparksqlConfig?;
    /**
     * @stability stable
     */
    get sparksqlConfig(): DataprocJobSparksqlConfig[];
    /**
     * @stability stable
     */
    set sparksqlConfig(value: DataprocJobSparksqlConfig[]);
    /**
     * @stability stable
     */
    resetSparksqlConfig(): void;
    /**
     * @stability stable
     */
    get sparksqlConfigInput(): DataprocJobSparksqlConfig[] | undefined;
    private _timeouts?;
    /**
     * @stability stable
     */
    get timeouts(): DataprocJobTimeouts;
    /**
     * @stability stable
     */
    set timeouts(value: DataprocJobTimeouts);
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): DataprocJobTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
