import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataprocWorkflowTemplateConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#labels DataprocWorkflowTemplate#labels}.
     *
     * @stability stable
     */
    readonly labels?: {
        [key: string]: string;
    };
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#location DataprocWorkflowTemplate#location}.
     *
     * @stability stable
     */
    readonly location: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#name DataprocWorkflowTemplate#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#project DataprocWorkflowTemplate#project}.
     *
     * @stability stable
     */
    readonly project?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#version DataprocWorkflowTemplate#version}.
     *
     * @stability stable
     */
    readonly version?: number;
    /**
     * jobs block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#jobs DataprocWorkflowTemplate#jobs}
     *
     * @stability stable
     */
    readonly jobs: DataprocWorkflowTemplateJobs[];
    /**
     * parameters block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#parameters DataprocWorkflowTemplate#parameters}
     *
     * @stability stable
     */
    readonly parameters?: DataprocWorkflowTemplateParameters[];
    /**
     * placement block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#placement DataprocWorkflowTemplate#placement}
     *
     * @stability stable
     */
    readonly placement: DataprocWorkflowTemplatePlacement[];
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#timeouts DataprocWorkflowTemplate#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: DataprocWorkflowTemplateTimeouts;
}
/**
 * @stability stable
 */
export interface DataprocWorkflowTemplateJobsHadoopJobLoggingConfig {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#driver_log_levels DataprocWorkflowTemplate#driver_log_levels}.
     *
     * @stability stable
     */
    readonly driverLogLevels?: {
        [key: string]: string;
    };
}
/**
 * @stability stable
 */
export interface DataprocWorkflowTemplateJobsHadoopJob {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#archive_uris DataprocWorkflowTemplate#archive_uris}.
     *
     * @stability stable
     */
    readonly archiveUris?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#args DataprocWorkflowTemplate#args}.
     *
     * @stability stable
     */
    readonly args?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#file_uris DataprocWorkflowTemplate#file_uris}.
     *
     * @stability stable
     */
    readonly fileUris?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#jar_file_uris DataprocWorkflowTemplate#jar_file_uris}.
     *
     * @stability stable
     */
    readonly jarFileUris?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#main_class DataprocWorkflowTemplate#main_class}.
     *
     * @stability stable
     */
    readonly mainClass?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#main_jar_file_uri DataprocWorkflowTemplate#main_jar_file_uri}.
     *
     * @stability stable
     */
    readonly mainJarFileUri?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#properties DataprocWorkflowTemplate#properties}.
     *
     * @stability stable
     */
    readonly properties?: {
        [key: string]: string;
    };
    /**
     * logging_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#logging_config DataprocWorkflowTemplate#logging_config}
     *
     * @stability stable
     */
    readonly loggingConfig?: DataprocWorkflowTemplateJobsHadoopJobLoggingConfig[];
}
/**
 * @stability stable
 */
export interface DataprocWorkflowTemplateJobsHiveJobQueryList {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#queries DataprocWorkflowTemplate#queries}.
     *
     * @stability stable
     */
    readonly queries: string[];
}
/**
 * @stability stable
 */
export interface DataprocWorkflowTemplateJobsHiveJob {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#continue_on_failure DataprocWorkflowTemplate#continue_on_failure}.
     *
     * @stability stable
     */
    readonly continueOnFailure?: boolean;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#jar_file_uris DataprocWorkflowTemplate#jar_file_uris}.
     *
     * @stability stable
     */
    readonly jarFileUris?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#properties DataprocWorkflowTemplate#properties}.
     *
     * @stability stable
     */
    readonly properties?: {
        [key: string]: string;
    };
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#query_file_uri DataprocWorkflowTemplate#query_file_uri}.
     *
     * @stability stable
     */
    readonly queryFileUri?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#script_variables DataprocWorkflowTemplate#script_variables}.
     *
     * @stability stable
     */
    readonly scriptVariables?: {
        [key: string]: string;
    };
    /**
     * query_list block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#query_list DataprocWorkflowTemplate#query_list}
     *
     * @stability stable
     */
    readonly queryList?: DataprocWorkflowTemplateJobsHiveJobQueryList[];
}
/**
 * @stability stable
 */
export interface DataprocWorkflowTemplateJobsPigJobLoggingConfig {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#driver_log_levels DataprocWorkflowTemplate#driver_log_levels}.
     *
     * @stability stable
     */
    readonly driverLogLevels?: {
        [key: string]: string;
    };
}
/**
 * @stability stable
 */
export interface DataprocWorkflowTemplateJobsPigJobQueryList {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#queries DataprocWorkflowTemplate#queries}.
     *
     * @stability stable
     */
    readonly queries: string[];
}
/**
 * @stability stable
 */
export interface DataprocWorkflowTemplateJobsPigJob {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#continue_on_failure DataprocWorkflowTemplate#continue_on_failure}.
     *
     * @stability stable
     */
    readonly continueOnFailure?: boolean;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#jar_file_uris DataprocWorkflowTemplate#jar_file_uris}.
     *
     * @stability stable
     */
    readonly jarFileUris?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#properties DataprocWorkflowTemplate#properties}.
     *
     * @stability stable
     */
    readonly properties?: {
        [key: string]: string;
    };
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#query_file_uri DataprocWorkflowTemplate#query_file_uri}.
     *
     * @stability stable
     */
    readonly queryFileUri?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#script_variables DataprocWorkflowTemplate#script_variables}.
     *
     * @stability stable
     */
    readonly scriptVariables?: {
        [key: string]: string;
    };
    /**
     * logging_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#logging_config DataprocWorkflowTemplate#logging_config}
     *
     * @stability stable
     */
    readonly loggingConfig?: DataprocWorkflowTemplateJobsPigJobLoggingConfig[];
    /**
     * query_list block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#query_list DataprocWorkflowTemplate#query_list}
     *
     * @stability stable
     */
    readonly queryList?: DataprocWorkflowTemplateJobsPigJobQueryList[];
}
/**
 * @stability stable
 */
export interface DataprocWorkflowTemplateJobsPrestoJobLoggingConfig {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#driver_log_levels DataprocWorkflowTemplate#driver_log_levels}.
     *
     * @stability stable
     */
    readonly driverLogLevels?: {
        [key: string]: string;
    };
}
/**
 * @stability stable
 */
export interface DataprocWorkflowTemplateJobsPrestoJobQueryList {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#queries DataprocWorkflowTemplate#queries}.
     *
     * @stability stable
     */
    readonly queries: string[];
}
/**
 * @stability stable
 */
export interface DataprocWorkflowTemplateJobsPrestoJob {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#client_tags DataprocWorkflowTemplate#client_tags}.
     *
     * @stability stable
     */
    readonly clientTags?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#continue_on_failure DataprocWorkflowTemplate#continue_on_failure}.
     *
     * @stability stable
     */
    readonly continueOnFailure?: boolean;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#output_format DataprocWorkflowTemplate#output_format}.
     *
     * @stability stable
     */
    readonly outputFormat?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#properties DataprocWorkflowTemplate#properties}.
     *
     * @stability stable
     */
    readonly properties?: {
        [key: string]: string;
    };
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#query_file_uri DataprocWorkflowTemplate#query_file_uri}.
     *
     * @stability stable
     */
    readonly queryFileUri?: string;
    /**
     * logging_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#logging_config DataprocWorkflowTemplate#logging_config}
     *
     * @stability stable
     */
    readonly loggingConfig?: DataprocWorkflowTemplateJobsPrestoJobLoggingConfig[];
    /**
     * query_list block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#query_list DataprocWorkflowTemplate#query_list}
     *
     * @stability stable
     */
    readonly queryList?: DataprocWorkflowTemplateJobsPrestoJobQueryList[];
}
/**
 * @stability stable
 */
export interface DataprocWorkflowTemplateJobsPysparkJobLoggingConfig {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#driver_log_levels DataprocWorkflowTemplate#driver_log_levels}.
     *
     * @stability stable
     */
    readonly driverLogLevels?: {
        [key: string]: string;
    };
}
/**
 * @stability stable
 */
export interface DataprocWorkflowTemplateJobsPysparkJob {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#archive_uris DataprocWorkflowTemplate#archive_uris}.
     *
     * @stability stable
     */
    readonly archiveUris?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#args DataprocWorkflowTemplate#args}.
     *
     * @stability stable
     */
    readonly args?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#file_uris DataprocWorkflowTemplate#file_uris}.
     *
     * @stability stable
     */
    readonly fileUris?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#jar_file_uris DataprocWorkflowTemplate#jar_file_uris}.
     *
     * @stability stable
     */
    readonly jarFileUris?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#main_python_file_uri DataprocWorkflowTemplate#main_python_file_uri}.
     *
     * @stability stable
     */
    readonly mainPythonFileUri: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#properties DataprocWorkflowTemplate#properties}.
     *
     * @stability stable
     */
    readonly properties?: {
        [key: string]: string;
    };
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#python_file_uris DataprocWorkflowTemplate#python_file_uris}.
     *
     * @stability stable
     */
    readonly pythonFileUris?: string[];
    /**
     * logging_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#logging_config DataprocWorkflowTemplate#logging_config}
     *
     * @stability stable
     */
    readonly loggingConfig?: DataprocWorkflowTemplateJobsPysparkJobLoggingConfig[];
}
/**
 * @stability stable
 */
export interface DataprocWorkflowTemplateJobsScheduling {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#max_failures_per_hour DataprocWorkflowTemplate#max_failures_per_hour}.
     *
     * @stability stable
     */
    readonly maxFailuresPerHour?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#max_failures_total DataprocWorkflowTemplate#max_failures_total}.
     *
     * @stability stable
     */
    readonly maxFailuresTotal?: number;
}
/**
 * @stability stable
 */
export interface DataprocWorkflowTemplateJobsSparkJobLoggingConfig {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#driver_log_levels DataprocWorkflowTemplate#driver_log_levels}.
     *
     * @stability stable
     */
    readonly driverLogLevels?: {
        [key: string]: string;
    };
}
/**
 * @stability stable
 */
export interface DataprocWorkflowTemplateJobsSparkJob {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#archive_uris DataprocWorkflowTemplate#archive_uris}.
     *
     * @stability stable
     */
    readonly archiveUris?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#args DataprocWorkflowTemplate#args}.
     *
     * @stability stable
     */
    readonly args?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#file_uris DataprocWorkflowTemplate#file_uris}.
     *
     * @stability stable
     */
    readonly fileUris?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#jar_file_uris DataprocWorkflowTemplate#jar_file_uris}.
     *
     * @stability stable
     */
    readonly jarFileUris?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#main_class DataprocWorkflowTemplate#main_class}.
     *
     * @stability stable
     */
    readonly mainClass?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#main_jar_file_uri DataprocWorkflowTemplate#main_jar_file_uri}.
     *
     * @stability stable
     */
    readonly mainJarFileUri?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#properties DataprocWorkflowTemplate#properties}.
     *
     * @stability stable
     */
    readonly properties?: {
        [key: string]: string;
    };
    /**
     * logging_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#logging_config DataprocWorkflowTemplate#logging_config}
     *
     * @stability stable
     */
    readonly loggingConfig?: DataprocWorkflowTemplateJobsSparkJobLoggingConfig[];
}
/**
 * @stability stable
 */
export interface DataprocWorkflowTemplateJobsSparkRJobLoggingConfig {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#driver_log_levels DataprocWorkflowTemplate#driver_log_levels}.
     *
     * @stability stable
     */
    readonly driverLogLevels?: {
        [key: string]: string;
    };
}
/**
 * @stability stable
 */
export interface DataprocWorkflowTemplateJobsSparkRJob {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#archive_uris DataprocWorkflowTemplate#archive_uris}.
     *
     * @stability stable
     */
    readonly archiveUris?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#args DataprocWorkflowTemplate#args}.
     *
     * @stability stable
     */
    readonly args?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#file_uris DataprocWorkflowTemplate#file_uris}.
     *
     * @stability stable
     */
    readonly fileUris?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#main_r_file_uri DataprocWorkflowTemplate#main_r_file_uri}.
     *
     * @stability stable
     */
    readonly mainRFileUri: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#properties DataprocWorkflowTemplate#properties}.
     *
     * @stability stable
     */
    readonly properties?: {
        [key: string]: string;
    };
    /**
     * logging_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#logging_config DataprocWorkflowTemplate#logging_config}
     *
     * @stability stable
     */
    readonly loggingConfig?: DataprocWorkflowTemplateJobsSparkRJobLoggingConfig[];
}
/**
 * @stability stable
 */
export interface DataprocWorkflowTemplateJobsSparkSqlJobLoggingConfig {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#driver_log_levels DataprocWorkflowTemplate#driver_log_levels}.
     *
     * @stability stable
     */
    readonly driverLogLevels?: {
        [key: string]: string;
    };
}
/**
 * @stability stable
 */
export interface DataprocWorkflowTemplateJobsSparkSqlJobQueryList {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#queries DataprocWorkflowTemplate#queries}.
     *
     * @stability stable
     */
    readonly queries: string[];
}
/**
 * @stability stable
 */
export interface DataprocWorkflowTemplateJobsSparkSqlJob {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#jar_file_uris DataprocWorkflowTemplate#jar_file_uris}.
     *
     * @stability stable
     */
    readonly jarFileUris?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#properties DataprocWorkflowTemplate#properties}.
     *
     * @stability stable
     */
    readonly properties?: {
        [key: string]: string;
    };
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#query_file_uri DataprocWorkflowTemplate#query_file_uri}.
     *
     * @stability stable
     */
    readonly queryFileUri?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#script_variables DataprocWorkflowTemplate#script_variables}.
     *
     * @stability stable
     */
    readonly scriptVariables?: {
        [key: string]: string;
    };
    /**
     * logging_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#logging_config DataprocWorkflowTemplate#logging_config}
     *
     * @stability stable
     */
    readonly loggingConfig?: DataprocWorkflowTemplateJobsSparkSqlJobLoggingConfig[];
    /**
     * query_list block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#query_list DataprocWorkflowTemplate#query_list}
     *
     * @stability stable
     */
    readonly queryList?: DataprocWorkflowTemplateJobsSparkSqlJobQueryList[];
}
/**
 * @stability stable
 */
export interface DataprocWorkflowTemplateJobs {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#labels DataprocWorkflowTemplate#labels}.
     *
     * @stability stable
     */
    readonly labels?: {
        [key: string]: string;
    };
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#prerequisite_step_ids DataprocWorkflowTemplate#prerequisite_step_ids}.
     *
     * @stability stable
     */
    readonly prerequisiteStepIds?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#step_id DataprocWorkflowTemplate#step_id}.
     *
     * @stability stable
     */
    readonly stepId: string;
    /**
     * hadoop_job block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#hadoop_job DataprocWorkflowTemplate#hadoop_job}
     *
     * @stability stable
     */
    readonly hadoopJob?: DataprocWorkflowTemplateJobsHadoopJob[];
    /**
     * hive_job block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#hive_job DataprocWorkflowTemplate#hive_job}
     *
     * @stability stable
     */
    readonly hiveJob?: DataprocWorkflowTemplateJobsHiveJob[];
    /**
     * pig_job block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#pig_job DataprocWorkflowTemplate#pig_job}
     *
     * @stability stable
     */
    readonly pigJob?: DataprocWorkflowTemplateJobsPigJob[];
    /**
     * presto_job block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#presto_job DataprocWorkflowTemplate#presto_job}
     *
     * @stability stable
     */
    readonly prestoJob?: DataprocWorkflowTemplateJobsPrestoJob[];
    /**
     * pyspark_job block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#pyspark_job DataprocWorkflowTemplate#pyspark_job}
     *
     * @stability stable
     */
    readonly pysparkJob?: DataprocWorkflowTemplateJobsPysparkJob[];
    /**
     * scheduling block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#scheduling DataprocWorkflowTemplate#scheduling}
     *
     * @stability stable
     */
    readonly scheduling?: DataprocWorkflowTemplateJobsScheduling[];
    /**
     * spark_job block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#spark_job DataprocWorkflowTemplate#spark_job}
     *
     * @stability stable
     */
    readonly sparkJob?: DataprocWorkflowTemplateJobsSparkJob[];
    /**
     * spark_r_job block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#spark_r_job DataprocWorkflowTemplate#spark_r_job}
     *
     * @stability stable
     */
    readonly sparkRJob?: DataprocWorkflowTemplateJobsSparkRJob[];
    /**
     * spark_sql_job block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#spark_sql_job DataprocWorkflowTemplate#spark_sql_job}
     *
     * @stability stable
     */
    readonly sparkSqlJob?: DataprocWorkflowTemplateJobsSparkSqlJob[];
}
/**
 * @stability stable
 */
export interface DataprocWorkflowTemplateParametersValidationRegex {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#regexes DataprocWorkflowTemplate#regexes}.
     *
     * @stability stable
     */
    readonly regexes: string[];
}
/**
 * @stability stable
 */
export interface DataprocWorkflowTemplateParametersValidationValues {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#values DataprocWorkflowTemplate#values}.
     *
     * @stability stable
     */
    readonly values: string[];
}
/**
 * @stability stable
 */
export interface DataprocWorkflowTemplateParametersValidation {
    /**
     * regex block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#regex DataprocWorkflowTemplate#regex}
     *
     * @stability stable
     */
    readonly regex?: DataprocWorkflowTemplateParametersValidationRegex[];
    /**
     * values block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#values DataprocWorkflowTemplate#values}
     *
     * @stability stable
     */
    readonly values?: DataprocWorkflowTemplateParametersValidationValues[];
}
/**
 * @stability stable
 */
export interface DataprocWorkflowTemplateParameters {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#description DataprocWorkflowTemplate#description}.
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#fields DataprocWorkflowTemplate#fields}.
     *
     * @stability stable
     */
    readonly fields: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#name DataprocWorkflowTemplate#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * validation block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#validation DataprocWorkflowTemplate#validation}
     *
     * @stability stable
     */
    readonly validation?: DataprocWorkflowTemplateParametersValidation[];
}
/**
 * @stability stable
 */
export interface DataprocWorkflowTemplatePlacementClusterSelector {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#cluster_labels DataprocWorkflowTemplate#cluster_labels}.
     *
     * @stability stable
     */
    readonly clusterLabels: {
        [key: string]: string;
    };
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#zone DataprocWorkflowTemplate#zone}.
     *
     * @stability stable
     */
    readonly zone?: string;
}
/**
 * @stability stable
 */
export interface DataprocWorkflowTemplatePlacementManagedClusterConfigAutoscalingConfig {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#policy DataprocWorkflowTemplate#policy}.
     *
     * @stability stable
     */
    readonly policy?: string;
}
/**
 * @stability stable
 */
export interface DataprocWorkflowTemplatePlacementManagedClusterConfigEncryptionConfig {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#gce_pd_kms_key_name DataprocWorkflowTemplate#gce_pd_kms_key_name}.
     *
     * @stability stable
     */
    readonly gcePdKmsKeyName?: string;
}
/**
 * @stability stable
 */
export interface DataprocWorkflowTemplatePlacementManagedClusterConfigEndpointConfig {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#enable_http_port_access DataprocWorkflowTemplate#enable_http_port_access}.
     *
     * @stability stable
     */
    readonly enableHttpPortAccess?: boolean;
}
/**
 * @stability stable
 */
export interface DataprocWorkflowTemplatePlacementManagedClusterConfigGceClusterConfigNodeGroupAffinity {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#node_group DataprocWorkflowTemplate#node_group}.
     *
     * @stability stable
     */
    readonly nodeGroup: string;
}
/**
 * @stability stable
 */
export interface DataprocWorkflowTemplatePlacementManagedClusterConfigGceClusterConfigReservationAffinity {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#consume_reservation_type DataprocWorkflowTemplate#consume_reservation_type}.
     *
     * @stability stable
     */
    readonly consumeReservationType?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#key DataprocWorkflowTemplate#key}.
     *
     * @stability stable
     */
    readonly key?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#values DataprocWorkflowTemplate#values}.
     *
     * @stability stable
     */
    readonly values?: string[];
}
/**
 * @stability stable
 */
export interface DataprocWorkflowTemplatePlacementManagedClusterConfigGceClusterConfig {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#internal_ip_only DataprocWorkflowTemplate#internal_ip_only}.
     *
     * @stability stable
     */
    readonly internalIpOnly?: boolean;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#metadata DataprocWorkflowTemplate#metadata}.
     *
     * @stability stable
     */
    readonly metadata?: {
        [key: string]: string;
    };
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#network DataprocWorkflowTemplate#network}.
     *
     * @stability stable
     */
    readonly network?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#private_ipv6_google_access DataprocWorkflowTemplate#private_ipv6_google_access}.
     *
     * @stability stable
     */
    readonly privateIpv6GoogleAccess?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#service_account DataprocWorkflowTemplate#service_account}.
     *
     * @stability stable
     */
    readonly serviceAccount?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#service_account_scopes DataprocWorkflowTemplate#service_account_scopes}.
     *
     * @stability stable
     */
    readonly serviceAccountScopes?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#subnetwork DataprocWorkflowTemplate#subnetwork}.
     *
     * @stability stable
     */
    readonly subnetwork?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#tags DataprocWorkflowTemplate#tags}.
     *
     * @stability stable
     */
    readonly tags?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#zone DataprocWorkflowTemplate#zone}.
     *
     * @stability stable
     */
    readonly zone?: string;
    /**
     * node_group_affinity block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#node_group_affinity DataprocWorkflowTemplate#node_group_affinity}
     *
     * @stability stable
     */
    readonly nodeGroupAffinity?: DataprocWorkflowTemplatePlacementManagedClusterConfigGceClusterConfigNodeGroupAffinity[];
    /**
     * reservation_affinity block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#reservation_affinity DataprocWorkflowTemplate#reservation_affinity}
     *
     * @stability stable
     */
    readonly reservationAffinity?: DataprocWorkflowTemplatePlacementManagedClusterConfigGceClusterConfigReservationAffinity[];
}
/**
 * @stability stable
 */
export interface DataprocWorkflowTemplatePlacementManagedClusterConfigInitializationActions {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#executable_file DataprocWorkflowTemplate#executable_file}.
     *
     * @stability stable
     */
    readonly executableFile?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#execution_timeout DataprocWorkflowTemplate#execution_timeout}.
     *
     * @stability stable
     */
    readonly executionTimeout?: string;
}
/**
 * @stability stable
 */
export interface DataprocWorkflowTemplatePlacementManagedClusterConfigLifecycleConfig {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#auto_delete_time DataprocWorkflowTemplate#auto_delete_time}.
     *
     * @stability stable
     */
    readonly autoDeleteTime?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#auto_delete_ttl DataprocWorkflowTemplate#auto_delete_ttl}.
     *
     * @stability stable
     */
    readonly autoDeleteTtl?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#idle_delete_ttl DataprocWorkflowTemplate#idle_delete_ttl}.
     *
     * @stability stable
     */
    readonly idleDeleteTtl?: string;
}
/**
 * @stability stable
 */
export interface DataprocWorkflowTemplatePlacementManagedClusterConfigMasterConfigAccelerators {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#accelerator_count DataprocWorkflowTemplate#accelerator_count}.
     *
     * @stability stable
     */
    readonly acceleratorCount?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#accelerator_type DataprocWorkflowTemplate#accelerator_type}.
     *
     * @stability stable
     */
    readonly acceleratorType?: string;
}
/**
 * @stability stable
 */
export interface DataprocWorkflowTemplatePlacementManagedClusterConfigMasterConfigDiskConfig {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#boot_disk_size_gb DataprocWorkflowTemplate#boot_disk_size_gb}.
     *
     * @stability stable
     */
    readonly bootDiskSizeGb?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#boot_disk_type DataprocWorkflowTemplate#boot_disk_type}.
     *
     * @stability stable
     */
    readonly bootDiskType?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#num_local_ssds DataprocWorkflowTemplate#num_local_ssds}.
     *
     * @stability stable
     */
    readonly numLocalSsds?: number;
}
/**
 * @stability stable
 */
export interface DataprocWorkflowTemplatePlacementManagedClusterConfigMasterConfig {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#image DataprocWorkflowTemplate#image}.
     *
     * @stability stable
     */
    readonly image?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#machine_type DataprocWorkflowTemplate#machine_type}.
     *
     * @stability stable
     */
    readonly machineType?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#min_cpu_platform DataprocWorkflowTemplate#min_cpu_platform}.
     *
     * @stability stable
     */
    readonly minCpuPlatform?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#num_instances DataprocWorkflowTemplate#num_instances}.
     *
     * @stability stable
     */
    readonly numInstances?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#preemptibility DataprocWorkflowTemplate#preemptibility}.
     *
     * @stability stable
     */
    readonly preemptibility?: string;
    /**
     * accelerators block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#accelerators DataprocWorkflowTemplate#accelerators}
     *
     * @stability stable
     */
    readonly accelerators?: DataprocWorkflowTemplatePlacementManagedClusterConfigMasterConfigAccelerators[];
    /**
     * disk_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#disk_config DataprocWorkflowTemplate#disk_config}
     *
     * @stability stable
     */
    readonly diskConfig?: DataprocWorkflowTemplatePlacementManagedClusterConfigMasterConfigDiskConfig[];
}
/**
 * @stability stable
 */
export interface DataprocWorkflowTemplatePlacementManagedClusterConfigSecondaryWorkerConfigAccelerators {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#accelerator_count DataprocWorkflowTemplate#accelerator_count}.
     *
     * @stability stable
     */
    readonly acceleratorCount?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#accelerator_type DataprocWorkflowTemplate#accelerator_type}.
     *
     * @stability stable
     */
    readonly acceleratorType?: string;
}
/**
 * @stability stable
 */
export interface DataprocWorkflowTemplatePlacementManagedClusterConfigSecondaryWorkerConfigDiskConfig {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#boot_disk_size_gb DataprocWorkflowTemplate#boot_disk_size_gb}.
     *
     * @stability stable
     */
    readonly bootDiskSizeGb?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#boot_disk_type DataprocWorkflowTemplate#boot_disk_type}.
     *
     * @stability stable
     */
    readonly bootDiskType?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#num_local_ssds DataprocWorkflowTemplate#num_local_ssds}.
     *
     * @stability stable
     */
    readonly numLocalSsds?: number;
}
/**
 * @stability stable
 */
export interface DataprocWorkflowTemplatePlacementManagedClusterConfigSecondaryWorkerConfig {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#image DataprocWorkflowTemplate#image}.
     *
     * @stability stable
     */
    readonly image?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#machine_type DataprocWorkflowTemplate#machine_type}.
     *
     * @stability stable
     */
    readonly machineType?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#min_cpu_platform DataprocWorkflowTemplate#min_cpu_platform}.
     *
     * @stability stable
     */
    readonly minCpuPlatform?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#num_instances DataprocWorkflowTemplate#num_instances}.
     *
     * @stability stable
     */
    readonly numInstances?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#preemptibility DataprocWorkflowTemplate#preemptibility}.
     *
     * @stability stable
     */
    readonly preemptibility?: string;
    /**
     * accelerators block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#accelerators DataprocWorkflowTemplate#accelerators}
     *
     * @stability stable
     */
    readonly accelerators?: DataprocWorkflowTemplatePlacementManagedClusterConfigSecondaryWorkerConfigAccelerators[];
    /**
     * disk_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#disk_config DataprocWorkflowTemplate#disk_config}
     *
     * @stability stable
     */
    readonly diskConfig?: DataprocWorkflowTemplatePlacementManagedClusterConfigSecondaryWorkerConfigDiskConfig[];
}
/**
 * @stability stable
 */
export interface DataprocWorkflowTemplatePlacementManagedClusterConfigSecurityConfigKerberosConfig {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#cross_realm_trust_admin_server DataprocWorkflowTemplate#cross_realm_trust_admin_server}.
     *
     * @stability stable
     */
    readonly crossRealmTrustAdminServer?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#cross_realm_trust_kdc DataprocWorkflowTemplate#cross_realm_trust_kdc}.
     *
     * @stability stable
     */
    readonly crossRealmTrustKdc?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#cross_realm_trust_realm DataprocWorkflowTemplate#cross_realm_trust_realm}.
     *
     * @stability stable
     */
    readonly crossRealmTrustRealm?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#cross_realm_trust_shared_password DataprocWorkflowTemplate#cross_realm_trust_shared_password}.
     *
     * @stability stable
     */
    readonly crossRealmTrustSharedPassword?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#enable_kerberos DataprocWorkflowTemplate#enable_kerberos}.
     *
     * @stability stable
     */
    readonly enableKerberos?: boolean;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#kdc_db_key DataprocWorkflowTemplate#kdc_db_key}.
     *
     * @stability stable
     */
    readonly kdcDbKey?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#key_password DataprocWorkflowTemplate#key_password}.
     *
     * @stability stable
     */
    readonly keyPassword?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#keystore DataprocWorkflowTemplate#keystore}.
     *
     * @stability stable
     */
    readonly keystore?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#keystore_password DataprocWorkflowTemplate#keystore_password}.
     *
     * @stability stable
     */
    readonly keystorePassword?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#kms_key DataprocWorkflowTemplate#kms_key}.
     *
     * @stability stable
     */
    readonly kmsKey?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#realm DataprocWorkflowTemplate#realm}.
     *
     * @stability stable
     */
    readonly realm?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#root_principal_password DataprocWorkflowTemplate#root_principal_password}.
     *
     * @stability stable
     */
    readonly rootPrincipalPassword?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#tgt_lifetime_hours DataprocWorkflowTemplate#tgt_lifetime_hours}.
     *
     * @stability stable
     */
    readonly tgtLifetimeHours?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#truststore DataprocWorkflowTemplate#truststore}.
     *
     * @stability stable
     */
    readonly truststore?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#truststore_password DataprocWorkflowTemplate#truststore_password}.
     *
     * @stability stable
     */
    readonly truststorePassword?: string;
}
/**
 * @stability stable
 */
export interface DataprocWorkflowTemplatePlacementManagedClusterConfigSecurityConfig {
    /**
     * kerberos_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#kerberos_config DataprocWorkflowTemplate#kerberos_config}
     *
     * @stability stable
     */
    readonly kerberosConfig?: DataprocWorkflowTemplatePlacementManagedClusterConfigSecurityConfigKerberosConfig[];
}
/**
 * @stability stable
 */
export interface DataprocWorkflowTemplatePlacementManagedClusterConfigSoftwareConfig {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#image_version DataprocWorkflowTemplate#image_version}.
     *
     * @stability stable
     */
    readonly imageVersion?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#properties DataprocWorkflowTemplate#properties}.
     *
     * @stability stable
     */
    readonly properties?: {
        [key: string]: string;
    };
}
/**
 * @stability stable
 */
export interface DataprocWorkflowTemplatePlacementManagedClusterConfigWorkerConfigAccelerators {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#accelerator_count DataprocWorkflowTemplate#accelerator_count}.
     *
     * @stability stable
     */
    readonly acceleratorCount?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#accelerator_type DataprocWorkflowTemplate#accelerator_type}.
     *
     * @stability stable
     */
    readonly acceleratorType?: string;
}
/**
 * @stability stable
 */
export interface DataprocWorkflowTemplatePlacementManagedClusterConfigWorkerConfigDiskConfig {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#boot_disk_size_gb DataprocWorkflowTemplate#boot_disk_size_gb}.
     *
     * @stability stable
     */
    readonly bootDiskSizeGb?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#boot_disk_type DataprocWorkflowTemplate#boot_disk_type}.
     *
     * @stability stable
     */
    readonly bootDiskType?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#num_local_ssds DataprocWorkflowTemplate#num_local_ssds}.
     *
     * @stability stable
     */
    readonly numLocalSsds?: number;
}
/**
 * @stability stable
 */
export interface DataprocWorkflowTemplatePlacementManagedClusterConfigWorkerConfig {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#image DataprocWorkflowTemplate#image}.
     *
     * @stability stable
     */
    readonly image?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#machine_type DataprocWorkflowTemplate#machine_type}.
     *
     * @stability stable
     */
    readonly machineType?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#min_cpu_platform DataprocWorkflowTemplate#min_cpu_platform}.
     *
     * @stability stable
     */
    readonly minCpuPlatform?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#num_instances DataprocWorkflowTemplate#num_instances}.
     *
     * @stability stable
     */
    readonly numInstances?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#preemptibility DataprocWorkflowTemplate#preemptibility}.
     *
     * @stability stable
     */
    readonly preemptibility?: string;
    /**
     * accelerators block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#accelerators DataprocWorkflowTemplate#accelerators}
     *
     * @stability stable
     */
    readonly accelerators?: DataprocWorkflowTemplatePlacementManagedClusterConfigWorkerConfigAccelerators[];
    /**
     * disk_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#disk_config DataprocWorkflowTemplate#disk_config}
     *
     * @stability stable
     */
    readonly diskConfig?: DataprocWorkflowTemplatePlacementManagedClusterConfigWorkerConfigDiskConfig[];
}
/**
 * @stability stable
 */
export interface DataprocWorkflowTemplatePlacementManagedClusterConfig {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#staging_bucket DataprocWorkflowTemplate#staging_bucket}.
     *
     * @stability stable
     */
    readonly stagingBucket?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#temp_bucket DataprocWorkflowTemplate#temp_bucket}.
     *
     * @stability stable
     */
    readonly tempBucket?: string;
    /**
     * autoscaling_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#autoscaling_config DataprocWorkflowTemplate#autoscaling_config}
     *
     * @stability stable
     */
    readonly autoscalingConfig?: DataprocWorkflowTemplatePlacementManagedClusterConfigAutoscalingConfig[];
    /**
     * encryption_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#encryption_config DataprocWorkflowTemplate#encryption_config}
     *
     * @stability stable
     */
    readonly encryptionConfig?: DataprocWorkflowTemplatePlacementManagedClusterConfigEncryptionConfig[];
    /**
     * endpoint_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#endpoint_config DataprocWorkflowTemplate#endpoint_config}
     *
     * @stability stable
     */
    readonly endpointConfig?: DataprocWorkflowTemplatePlacementManagedClusterConfigEndpointConfig[];
    /**
     * gce_cluster_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#gce_cluster_config DataprocWorkflowTemplate#gce_cluster_config}
     *
     * @stability stable
     */
    readonly gceClusterConfig?: DataprocWorkflowTemplatePlacementManagedClusterConfigGceClusterConfig[];
    /**
     * initialization_actions block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#initialization_actions DataprocWorkflowTemplate#initialization_actions}
     *
     * @stability stable
     */
    readonly initializationActions?: DataprocWorkflowTemplatePlacementManagedClusterConfigInitializationActions[];
    /**
     * lifecycle_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#lifecycle_config DataprocWorkflowTemplate#lifecycle_config}
     *
     * @stability stable
     */
    readonly lifecycleConfig?: DataprocWorkflowTemplatePlacementManagedClusterConfigLifecycleConfig[];
    /**
     * master_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#master_config DataprocWorkflowTemplate#master_config}
     *
     * @stability stable
     */
    readonly masterConfig?: DataprocWorkflowTemplatePlacementManagedClusterConfigMasterConfig[];
    /**
     * secondary_worker_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#secondary_worker_config DataprocWorkflowTemplate#secondary_worker_config}
     *
     * @stability stable
     */
    readonly secondaryWorkerConfig?: DataprocWorkflowTemplatePlacementManagedClusterConfigSecondaryWorkerConfig[];
    /**
     * security_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#security_config DataprocWorkflowTemplate#security_config}
     *
     * @stability stable
     */
    readonly securityConfig?: DataprocWorkflowTemplatePlacementManagedClusterConfigSecurityConfig[];
    /**
     * software_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#software_config DataprocWorkflowTemplate#software_config}
     *
     * @stability stable
     */
    readonly softwareConfig?: DataprocWorkflowTemplatePlacementManagedClusterConfigSoftwareConfig[];
    /**
     * worker_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#worker_config DataprocWorkflowTemplate#worker_config}
     *
     * @stability stable
     */
    readonly workerConfig?: DataprocWorkflowTemplatePlacementManagedClusterConfigWorkerConfig[];
}
/**
 * @stability stable
 */
export interface DataprocWorkflowTemplatePlacementManagedCluster {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#cluster_name DataprocWorkflowTemplate#cluster_name}.
     *
     * @stability stable
     */
    readonly clusterName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#labels DataprocWorkflowTemplate#labels}.
     *
     * @stability stable
     */
    readonly labels?: {
        [key: string]: string;
    };
    /**
     * config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#config DataprocWorkflowTemplate#config}
     *
     * @stability stable
     */
    readonly config: DataprocWorkflowTemplatePlacementManagedClusterConfig[];
}
/**
 * @stability stable
 */
export interface DataprocWorkflowTemplatePlacement {
    /**
     * cluster_selector block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#cluster_selector DataprocWorkflowTemplate#cluster_selector}
     *
     * @stability stable
     */
    readonly clusterSelector?: DataprocWorkflowTemplatePlacementClusterSelector[];
    /**
     * managed_cluster block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#managed_cluster DataprocWorkflowTemplate#managed_cluster}
     *
     * @stability stable
     */
    readonly managedCluster?: DataprocWorkflowTemplatePlacementManagedCluster[];
}
/**
 * @stability stable
 */
export interface DataprocWorkflowTemplateTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#create DataprocWorkflowTemplate#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#delete DataprocWorkflowTemplate#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html google_dataproc_workflow_template}.
 *
 * @stability stable
 */
export declare class DataprocWorkflowTemplate extends cdktf.TerraformResource {
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html google_dataproc_workflow_template} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataprocWorkflowTemplateConfig);
    /**
     * @stability stable
     */
    get createTime(): string;
    /**
     * @stability stable
     */
    get id(): string;
    private _labels?;
    /**
     * @stability stable
     */
    get labels(): {
        [key: string]: string;
    };
    /**
     * @stability stable
     */
    set labels(value: {
        [key: string]: string;
    });
    /**
     * @stability stable
     */
    resetLabels(): void;
    /**
     * @stability stable
     */
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _location;
    /**
     * @stability stable
     */
    get location(): string;
    /**
     * @stability stable
     */
    set location(value: string);
    /**
     * @stability stable
     */
    get locationInput(): string;
    private _name;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string;
    /**
     * @stability stable
     */
    set project(value: string);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    /**
     * @stability stable
     */
    get updateTime(): string;
    private _version?;
    /**
     * @stability stable
     */
    get version(): number;
    /**
     * @stability stable
     */
    set version(value: number);
    /**
     * @stability stable
     */
    resetVersion(): void;
    /**
     * @stability stable
     */
    get versionInput(): number | undefined;
    private _jobs;
    /**
     * @stability stable
     */
    get jobs(): DataprocWorkflowTemplateJobs[];
    /**
     * @stability stable
     */
    set jobs(value: DataprocWorkflowTemplateJobs[]);
    /**
     * @stability stable
     */
    get jobsInput(): DataprocWorkflowTemplateJobs[];
    private _parameters?;
    /**
     * @stability stable
     */
    get parameters(): DataprocWorkflowTemplateParameters[];
    /**
     * @stability stable
     */
    set parameters(value: DataprocWorkflowTemplateParameters[]);
    /**
     * @stability stable
     */
    resetParameters(): void;
    /**
     * @stability stable
     */
    get parametersInput(): DataprocWorkflowTemplateParameters[] | undefined;
    private _placement;
    /**
     * @stability stable
     */
    get placement(): DataprocWorkflowTemplatePlacement[];
    /**
     * @stability stable
     */
    set placement(value: DataprocWorkflowTemplatePlacement[]);
    /**
     * @stability stable
     */
    get placementInput(): DataprocWorkflowTemplatePlacement[];
    private _timeouts?;
    /**
     * @stability stable
     */
    get timeouts(): DataprocWorkflowTemplateTimeouts;
    /**
     * @stability stable
     */
    set timeouts(value: DataprocWorkflowTemplateTimeouts);
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): DataprocWorkflowTemplateTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
