import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DatastoreIndexConfig extends cdktf.TerraformMetaArguments {
    /**
     * Policy for including ancestors in the index. Default value: "NONE" Possible values: ["NONE", "ALL_ANCESTORS"].
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/datastore_index.html#ancestor DatastoreIndex#ancestor}
     *
     * @stability stable
     */
    readonly ancestor?: string;
    /**
     * The entity kind which the index applies to.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/datastore_index.html#kind DatastoreIndex#kind}
     *
     * @stability stable
     */
    readonly kind: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/datastore_index.html#project DatastoreIndex#project}.
     *
     * @stability stable
     */
    readonly project?: string;
    /**
     * properties block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/datastore_index.html#properties DatastoreIndex#properties}
     *
     * @stability stable
     */
    readonly properties?: DatastoreIndexProperties[];
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/datastore_index.html#timeouts DatastoreIndex#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: DatastoreIndexTimeouts;
}
/**
 * @stability stable
 */
export interface DatastoreIndexProperties {
    /**
     * The direction the index should optimize for sorting. Possible values: ["ASCENDING", "DESCENDING"].
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/datastore_index.html#direction DatastoreIndex#direction}
     *
     * @stability stable
     */
    readonly direction: string;
    /**
     * The property name to index.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/datastore_index.html#name DatastoreIndex#name}
     *
     * @stability stable
     */
    readonly name: string;
}
/**
 * @stability stable
 */
export interface DatastoreIndexTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/datastore_index.html#create DatastoreIndex#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/datastore_index.html#delete DatastoreIndex#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/datastore_index.html google_datastore_index}.
 *
 * @stability stable
 */
export declare class DatastoreIndex extends cdktf.TerraformResource {
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/datastore_index.html google_datastore_index} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DatastoreIndexConfig);
    private _ancestor?;
    /**
     * @stability stable
     */
    get ancestor(): string;
    /**
     * @stability stable
     */
    set ancestor(value: string);
    /**
     * @stability stable
     */
    resetAncestor(): void;
    /**
     * @stability stable
     */
    get ancestorInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get indexId(): string;
    private _kind;
    /**
     * @stability stable
     */
    get kind(): string;
    /**
     * @stability stable
     */
    set kind(value: string);
    /**
     * @stability stable
     */
    get kindInput(): string;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string;
    /**
     * @stability stable
     */
    set project(value: string);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    private _properties?;
    /**
     * @stability stable
     */
    get properties(): DatastoreIndexProperties[];
    /**
     * @stability stable
     */
    set properties(value: DatastoreIndexProperties[]);
    /**
     * @stability stable
     */
    resetProperties(): void;
    /**
     * @stability stable
     */
    get propertiesInput(): DatastoreIndexProperties[] | undefined;
    private _timeouts?;
    /**
     * @stability stable
     */
    get timeouts(): DatastoreIndexTimeouts;
    /**
     * @stability stable
     */
    set timeouts(value: DatastoreIndexTimeouts);
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): DatastoreIndexTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
