import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DeploymentManagerDeploymentConfig extends cdktf.TerraformMetaArguments {
    /**
     * Set the policy to use for creating new resources.
     *
     * Only used on
     * create and update. Valid values are 'CREATE_OR_ACQUIRE' (default) or
     * 'ACQUIRE'. If set to 'ACQUIRE' and resources do not already exist,
     * the deployment will fail. Note that updating this field does not
     * actually affect the deployment, just how it is updated. Default value: "CREATE_OR_ACQUIRE" Possible values: ["ACQUIRE", "CREATE_OR_ACQUIRE"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/deployment_manager_deployment.html#create_policy DeploymentManagerDeployment#create_policy}
     *
     * @stability stable
     */
    readonly createPolicy?: string;
    /**
     * Set the policy to use for deleting new resources on update/delete.
     *
     * Valid values are 'DELETE' (default) or 'ABANDON'. If 'DELETE',
     * resource is deleted after removal from Deployment Manager. If
     * 'ABANDON', the resource is only removed from Deployment Manager
     * and is not actually deleted. Note that updating this field does not
     * actually change the deployment, just how it is updated. Default value: "DELETE" Possible values: ["ABANDON", "DELETE"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/deployment_manager_deployment.html#delete_policy DeploymentManagerDeployment#delete_policy}
     *
     * @stability stable
     */
    readonly deletePolicy?: string;
    /**
     * Optional user-provided description of deployment.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/deployment_manager_deployment.html#description DeploymentManagerDeployment#description}
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * Unique name for the deployment.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/deployment_manager_deployment.html#name DeploymentManagerDeployment#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * If set to true, a deployment is created with "shell" resources that are not actually instantiated.
     *
     * This allows you to preview a
     * deployment. It can be updated to false to actually deploy
     * with real resources.
     * ~>**NOTE:** Deployment Manager does not allow update
     * of a deployment in preview (unless updating to preview=false). Thus,
     * Terraform will force-recreate deployments if either preview is updated
     * to true or if other fields are updated while preview is true.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/deployment_manager_deployment.html#preview DeploymentManagerDeployment#preview}
     *
     * @stability stable
     */
    readonly preview?: boolean;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/deployment_manager_deployment.html#project DeploymentManagerDeployment#project}.
     *
     * @stability stable
     */
    readonly project?: string;
    /**
     * labels block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/deployment_manager_deployment.html#labels DeploymentManagerDeployment#labels}
     *
     * @stability stable
     */
    readonly labels?: DeploymentManagerDeploymentLabels[];
    /**
     * target block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/deployment_manager_deployment.html#target DeploymentManagerDeployment#target}
     *
     * @stability stable
     */
    readonly target: DeploymentManagerDeploymentTarget[];
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/deployment_manager_deployment.html#timeouts DeploymentManagerDeployment#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: DeploymentManagerDeploymentTimeouts;
}
/**
 * @stability stable
 */
export interface DeploymentManagerDeploymentLabels {
    /**
     * Key for label.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/deployment_manager_deployment.html#key DeploymentManagerDeployment#key}
     *
     * @stability stable
     */
    readonly key?: string;
    /**
     * Value of label.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/deployment_manager_deployment.html#value DeploymentManagerDeployment#value}
     *
     * @stability stable
     */
    readonly value?: string;
}
/**
 * @stability stable
 */
export interface DeploymentManagerDeploymentTargetConfig {
    /**
     * The full YAML contents of your configuration file.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/deployment_manager_deployment.html#content DeploymentManagerDeployment#content}
     *
     * @stability stable
     */
    readonly content: string;
}
/**
 * @stability stable
 */
export interface DeploymentManagerDeploymentTargetImports {
    /**
     * The full contents of the template that you want to import.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/deployment_manager_deployment.html#content DeploymentManagerDeployment#content}
     *
     * @stability stable
     */
    readonly content?: string;
    /**
     * The name of the template to import, as declared in the YAML configuration.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/deployment_manager_deployment.html#name DeploymentManagerDeployment#name}
     *
     * @stability stable
     */
    readonly name?: string;
}
/**
 * @stability stable
 */
export interface DeploymentManagerDeploymentTarget {
    /**
     * config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/deployment_manager_deployment.html#config DeploymentManagerDeployment#config}
     *
     * @stability stable
     */
    readonly config: DeploymentManagerDeploymentTargetConfig[];
    /**
     * imports block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/deployment_manager_deployment.html#imports DeploymentManagerDeployment#imports}
     *
     * @stability stable
     */
    readonly imports?: DeploymentManagerDeploymentTargetImports[];
}
/**
 * @stability stable
 */
export interface DeploymentManagerDeploymentTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/deployment_manager_deployment.html#create DeploymentManagerDeployment#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/deployment_manager_deployment.html#delete DeploymentManagerDeployment#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/deployment_manager_deployment.html#update DeploymentManagerDeployment#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/deployment_manager_deployment.html google_deployment_manager_deployment}.
 *
 * @stability stable
 */
export declare class DeploymentManagerDeployment extends cdktf.TerraformResource {
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/deployment_manager_deployment.html google_deployment_manager_deployment} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DeploymentManagerDeploymentConfig);
    private _createPolicy?;
    /**
     * @stability stable
     */
    get createPolicy(): string;
    /**
     * @stability stable
     */
    set createPolicy(value: string);
    /**
     * @stability stable
     */
    resetCreatePolicy(): void;
    /**
     * @stability stable
     */
    get createPolicyInput(): string | undefined;
    private _deletePolicy?;
    /**
     * @stability stable
     */
    get deletePolicy(): string;
    /**
     * @stability stable
     */
    set deletePolicy(value: string);
    /**
     * @stability stable
     */
    resetDeletePolicy(): void;
    /**
     * @stability stable
     */
    get deletePolicyInput(): string | undefined;
    /**
     * @stability stable
     */
    get deploymentId(): string;
    private _description?;
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    set description(value: string);
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get manifest(): string;
    private _name;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string;
    private _preview?;
    /**
     * @stability stable
     */
    get preview(): boolean;
    /**
     * @stability stable
     */
    set preview(value: boolean);
    /**
     * @stability stable
     */
    resetPreview(): void;
    /**
     * @stability stable
     */
    get previewInput(): boolean | undefined;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string;
    /**
     * @stability stable
     */
    set project(value: string);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    /**
     * @stability stable
     */
    get selfLink(): string;
    private _labels?;
    /**
     * @stability stable
     */
    get labels(): DeploymentManagerDeploymentLabels[];
    /**
     * @stability stable
     */
    set labels(value: DeploymentManagerDeploymentLabels[]);
    /**
     * @stability stable
     */
    resetLabels(): void;
    /**
     * @stability stable
     */
    get labelsInput(): DeploymentManagerDeploymentLabels[] | undefined;
    private _target;
    /**
     * @stability stable
     */
    get target(): DeploymentManagerDeploymentTarget[];
    /**
     * @stability stable
     */
    set target(value: DeploymentManagerDeploymentTarget[]);
    /**
     * @stability stable
     */
    get targetInput(): DeploymentManagerDeploymentTarget[];
    private _timeouts?;
    /**
     * @stability stable
     */
    get timeouts(): DeploymentManagerDeploymentTimeouts;
    /**
     * @stability stable
     */
    set timeouts(value: DeploymentManagerDeploymentTimeouts);
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): DeploymentManagerDeploymentTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
