import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DialogflowEntityTypeConfig extends cdktf.TerraformMetaArguments {
    /**
     * The name of this entity type to be displayed on the console.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_entity_type.html#display_name DialogflowEntityType#display_name}
     *
     * @stability stable
     */
    readonly displayName: string;
    /**
     * Enables fuzzy entity extraction during classification.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_entity_type.html#enable_fuzzy_extraction DialogflowEntityType#enable_fuzzy_extraction}
     *
     * @stability stable
     */
    readonly enableFuzzyExtraction?: boolean;
    /**
     * Indicates the kind of entity type.
     *
     * KIND_MAP: Map entity types allow mapping of a group of synonyms to a reference value.
     * KIND_LIST: List entity types contain a set of entries that do not map to reference values. However, list entity
     * types can contain references to other entity types (with or without aliases).
     * KIND_REGEXP: Regexp entity types allow to specify regular expressions in entries values. Possible values: ["KIND_MAP", "KIND_LIST", "KIND_REGEXP"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_entity_type.html#kind DialogflowEntityType#kind}
     *
     * @stability stable
     */
    readonly kind: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_entity_type.html#project DialogflowEntityType#project}.
     *
     * @stability stable
     */
    readonly project?: string;
    /**
     * entities block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_entity_type.html#entities DialogflowEntityType#entities}
     *
     * @stability stable
     */
    readonly entities?: DialogflowEntityTypeEntities[];
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_entity_type.html#timeouts DialogflowEntityType#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: DialogflowEntityTypeTimeouts;
}
/**
 * @stability stable
 */
export interface DialogflowEntityTypeEntities {
    /**
     * A collection of value synonyms.
     *
     * For example, if the entity type is vegetable, and value is scallions, a synonym
     * could be green onions.
     * For KIND_LIST entity types:
     * This collection must contain exactly one synonym equal to value.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_entity_type.html#synonyms DialogflowEntityType#synonyms}
     *
     * @stability stable
     */
    readonly synonyms: string[];
    /**
     * The primary value associated with this entity entry.
     *
     * For example, if the entity type is vegetable, the value
     * could be scallions.
     * For KIND_MAP entity types:
     * A reference value to be used in place of synonyms.
     * For KIND_LIST entity types:
     * A string that can contain references to other entity types (with or without aliases).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_entity_type.html#value DialogflowEntityType#value}
     *
     * @stability stable
     */
    readonly value: string;
}
/**
 * @stability stable
 */
export interface DialogflowEntityTypeTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_entity_type.html#create DialogflowEntityType#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_entity_type.html#delete DialogflowEntityType#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_entity_type.html#update DialogflowEntityType#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/dialogflow_entity_type.html google_dialogflow_entity_type}.
 *
 * @stability stable
 */
export declare class DialogflowEntityType extends cdktf.TerraformResource {
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/dialogflow_entity_type.html google_dialogflow_entity_type} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DialogflowEntityTypeConfig);
    private _displayName;
    /**
     * @stability stable
     */
    get displayName(): string;
    /**
     * @stability stable
     */
    set displayName(value: string);
    /**
     * @stability stable
     */
    get displayNameInput(): string;
    private _enableFuzzyExtraction?;
    /**
     * @stability stable
     */
    get enableFuzzyExtraction(): boolean;
    /**
     * @stability stable
     */
    set enableFuzzyExtraction(value: boolean);
    /**
     * @stability stable
     */
    resetEnableFuzzyExtraction(): void;
    /**
     * @stability stable
     */
    get enableFuzzyExtractionInput(): boolean | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _kind;
    /**
     * @stability stable
     */
    get kind(): string;
    /**
     * @stability stable
     */
    set kind(value: string);
    /**
     * @stability stable
     */
    get kindInput(): string;
    /**
     * @stability stable
     */
    get name(): string;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string;
    /**
     * @stability stable
     */
    set project(value: string);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    private _entities?;
    /**
     * @stability stable
     */
    get entities(): DialogflowEntityTypeEntities[];
    /**
     * @stability stable
     */
    set entities(value: DialogflowEntityTypeEntities[]);
    /**
     * @stability stable
     */
    resetEntities(): void;
    /**
     * @stability stable
     */
    get entitiesInput(): DialogflowEntityTypeEntities[] | undefined;
    private _timeouts?;
    /**
     * @stability stable
     */
    get timeouts(): DialogflowEntityTypeTimeouts;
    /**
     * @stability stable
     */
    set timeouts(value: DialogflowEntityTypeTimeouts);
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): DialogflowEntityTypeTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
