import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DialogflowFulfillmentConfig extends cdktf.TerraformMetaArguments {
    /**
     * The human-readable name of the fulfillment, unique within the agent.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_fulfillment.html#display_name DialogflowFulfillment#display_name}
     *
     * @stability stable
     */
    readonly displayName: string;
    /**
     * Whether fulfillment is enabled.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_fulfillment.html#enabled DialogflowFulfillment#enabled}
     *
     * @stability stable
     */
    readonly enabled?: boolean;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_fulfillment.html#project DialogflowFulfillment#project}.
     *
     * @stability stable
     */
    readonly project?: string;
    /**
     * features block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_fulfillment.html#features DialogflowFulfillment#features}
     *
     * @stability stable
     */
    readonly features?: DialogflowFulfillmentFeatures[];
    /**
     * generic_web_service block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_fulfillment.html#generic_web_service DialogflowFulfillment#generic_web_service}
     *
     * @stability stable
     */
    readonly genericWebService?: DialogflowFulfillmentGenericWebService[];
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_fulfillment.html#timeouts DialogflowFulfillment#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: DialogflowFulfillmentTimeouts;
}
/**
 * @stability stable
 */
export interface DialogflowFulfillmentFeatures {
    /**
     * The type of the feature that enabled for fulfillment. SMALLTALK: Fulfillment is enabled for SmallTalk. Possible values: ["SMALLTALK"].
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_fulfillment.html#type DialogflowFulfillment#type}
     *
     * @stability stable
     */
    readonly type: string;
}
/**
 * @stability stable
 */
export interface DialogflowFulfillmentGenericWebService {
    /**
     * The password for HTTP Basic authentication.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_fulfillment.html#password DialogflowFulfillment#password}
     *
     * @stability stable
     */
    readonly password?: string;
    /**
     * The HTTP request headers to send together with fulfillment requests.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_fulfillment.html#request_headers DialogflowFulfillment#request_headers}
     *
     * @stability stable
     */
    readonly requestHeaders?: {
        [key: string]: string;
    };
    /**
     * The fulfillment URI for receiving POST requests. It must use https protocol.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_fulfillment.html#uri DialogflowFulfillment#uri}
     *
     * @stability stable
     */
    readonly uri: string;
    /**
     * The user name for HTTP Basic authentication.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_fulfillment.html#username DialogflowFulfillment#username}
     *
     * @stability stable
     */
    readonly username?: string;
}
/**
 * @stability stable
 */
export interface DialogflowFulfillmentTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_fulfillment.html#create DialogflowFulfillment#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_fulfillment.html#delete DialogflowFulfillment#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_fulfillment.html#update DialogflowFulfillment#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/dialogflow_fulfillment.html google_dialogflow_fulfillment}.
 *
 * @stability stable
 */
export declare class DialogflowFulfillment extends cdktf.TerraformResource {
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/dialogflow_fulfillment.html google_dialogflow_fulfillment} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DialogflowFulfillmentConfig);
    private _displayName;
    /**
     * @stability stable
     */
    get displayName(): string;
    /**
     * @stability stable
     */
    set displayName(value: string);
    /**
     * @stability stable
     */
    get displayNameInput(): string;
    private _enabled?;
    /**
     * @stability stable
     */
    get enabled(): boolean;
    /**
     * @stability stable
     */
    set enabled(value: boolean);
    /**
     * @stability stable
     */
    resetEnabled(): void;
    /**
     * @stability stable
     */
    get enabledInput(): boolean | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get name(): string;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string;
    /**
     * @stability stable
     */
    set project(value: string);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    private _features?;
    /**
     * @stability stable
     */
    get features(): DialogflowFulfillmentFeatures[];
    /**
     * @stability stable
     */
    set features(value: DialogflowFulfillmentFeatures[]);
    /**
     * @stability stable
     */
    resetFeatures(): void;
    /**
     * @stability stable
     */
    get featuresInput(): DialogflowFulfillmentFeatures[] | undefined;
    private _genericWebService?;
    /**
     * @stability stable
     */
    get genericWebService(): DialogflowFulfillmentGenericWebService[];
    /**
     * @stability stable
     */
    set genericWebService(value: DialogflowFulfillmentGenericWebService[]);
    /**
     * @stability stable
     */
    resetGenericWebService(): void;
    /**
     * @stability stable
     */
    get genericWebServiceInput(): DialogflowFulfillmentGenericWebService[] | undefined;
    private _timeouts?;
    /**
     * @stability stable
     */
    get timeouts(): DialogflowFulfillmentTimeouts;
    /**
     * @stability stable
     */
    set timeouts(value: DialogflowFulfillmentTimeouts);
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): DialogflowFulfillmentTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
