import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DnsManagedZoneConfig extends cdktf.TerraformMetaArguments {
    /**
     * A textual description field. Defaults to 'Managed by Terraform'.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_managed_zone.html#description DnsManagedZone#description}
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * The DNS name of this managed zone, for instance "example.com.".
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_managed_zone.html#dns_name DnsManagedZone#dns_name}
     *
     * @stability stable
     */
    readonly dnsName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_managed_zone.html#force_destroy DnsManagedZone#force_destroy}.
     *
     * @stability stable
     */
    readonly forceDestroy?: boolean;
    /**
     * A set of key/value label pairs to assign to this ManagedZone.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_managed_zone.html#labels DnsManagedZone#labels}
     *
     * @stability stable
     */
    readonly labels?: {
        [key: string]: string;
    };
    /**
     * User assigned name for this resource. Must be unique within the project.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_managed_zone.html#name DnsManagedZone#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_managed_zone.html#project DnsManagedZone#project}.
     *
     * @stability stable
     */
    readonly project?: string;
    /**
     * The zone's visibility: public zones are exposed to the Internet, while private zones are visible only to Virtual Private Cloud resources.
     *
     * Default value: "public" Possible values: ["private", "public"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_managed_zone.html#visibility DnsManagedZone#visibility}
     *
     * @stability stable
     */
    readonly visibility?: string;
    /**
     * dnssec_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_managed_zone.html#dnssec_config DnsManagedZone#dnssec_config}
     *
     * @stability stable
     */
    readonly dnssecConfig?: DnsManagedZoneDnssecConfig[];
    /**
     * forwarding_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_managed_zone.html#forwarding_config DnsManagedZone#forwarding_config}
     *
     * @stability stable
     */
    readonly forwardingConfig?: DnsManagedZoneForwardingConfig[];
    /**
     * peering_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_managed_zone.html#peering_config DnsManagedZone#peering_config}
     *
     * @stability stable
     */
    readonly peeringConfig?: DnsManagedZonePeeringConfig[];
    /**
     * private_visibility_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_managed_zone.html#private_visibility_config DnsManagedZone#private_visibility_config}
     *
     * @stability stable
     */
    readonly privateVisibilityConfig?: DnsManagedZonePrivateVisibilityConfig[];
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_managed_zone.html#timeouts DnsManagedZone#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: DnsManagedZoneTimeouts;
}
/**
 * @stability stable
 */
export interface DnsManagedZoneDnssecConfigDefaultKeySpecs {
    /**
     * String mnemonic specifying the DNSSEC algorithm of this key Possible values: ["ecdsap256sha256", "ecdsap384sha384", "rsasha1", "rsasha256", "rsasha512"].
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_managed_zone.html#algorithm DnsManagedZone#algorithm}
     *
     * @stability stable
     */
    readonly algorithm?: string;
    /**
     * Length of the keys in bits.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_managed_zone.html#key_length DnsManagedZone#key_length}
     *
     * @stability stable
     */
    readonly keyLength?: number;
    /**
     * Specifies whether this is a key signing key (KSK) or a zone signing key (ZSK).
     *
     * Key signing keys have the Secure Entry
     * Point flag set and, when active, will only be used to sign
     * resource record sets of type DNSKEY. Zone signing keys do
     * not have the Secure Entry Point flag set and will be used
     * to sign all other types of resource record sets. Possible values: ["keySigning", "zoneSigning"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_managed_zone.html#key_type DnsManagedZone#key_type}
     *
     * @stability stable
     */
    readonly keyType?: string;
    /**
     * Identifies what kind of resource this is.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_managed_zone.html#kind DnsManagedZone#kind}
     *
     * @stability stable
     */
    readonly kind?: string;
}
/**
 * @stability stable
 */
export interface DnsManagedZoneDnssecConfig {
    /**
     * Identifies what kind of resource this is.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_managed_zone.html#kind DnsManagedZone#kind}
     *
     * @stability stable
     */
    readonly kind?: string;
    /**
     * Specifies the mechanism used to provide authenticated denial-of-existence responses.
     *
     * non_existence can only be updated when the state is 'off'. Possible values: ["nsec", "nsec3"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_managed_zone.html#non_existence DnsManagedZone#non_existence}
     *
     * @stability stable
     */
    readonly nonExistence?: string;
    /**
     * Specifies whether DNSSEC is enabled, and what mode it is in Possible values: ["off", "on", "transfer"].
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_managed_zone.html#state DnsManagedZone#state}
     *
     * @stability stable
     */
    readonly state?: string;
    /**
     * default_key_specs block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_managed_zone.html#default_key_specs DnsManagedZone#default_key_specs}
     *
     * @stability stable
     */
    readonly defaultKeySpecs?: DnsManagedZoneDnssecConfigDefaultKeySpecs[];
}
/**
 * @stability stable
 */
export interface DnsManagedZoneForwardingConfigTargetNameServers {
    /**
     * Forwarding path for this TargetNameServer.
     *
     * If unset or 'default' Cloud DNS will make forwarding
     * decision based on address ranges, i.e. RFC1918 addresses go to the VPC, Non-RFC1918 addresses go
     * to the Internet. When set to 'private', Cloud DNS will always send queries through VPC for this target Possible values: ["default", "private"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_managed_zone.html#forwarding_path DnsManagedZone#forwarding_path}
     *
     * @stability stable
     */
    readonly forwardingPath?: string;
    /**
     * IPv4 address of a target name server.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_managed_zone.html#ipv4_address DnsManagedZone#ipv4_address}
     *
     * @stability stable
     */
    readonly ipv4Address: string;
}
/**
 * @stability stable
 */
export interface DnsManagedZoneForwardingConfig {
    /**
     * target_name_servers block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_managed_zone.html#target_name_servers DnsManagedZone#target_name_servers}
     *
     * @stability stable
     */
    readonly targetNameServers: DnsManagedZoneForwardingConfigTargetNameServers[];
}
/**
 * @stability stable
 */
export interface DnsManagedZonePeeringConfigTargetNetwork {
    /**
     * The id or fully qualified URL of the VPC network to forward queries to.
     *
     * This should be formatted like 'projects/{project}/global/networks/{network}' or
     * 'https://www.googleapis.com/compute/v1/projects/{project}/global/networks/{network}'
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_managed_zone.html#network_url DnsManagedZone#network_url}
     *
     * @stability stable
     */
    readonly networkUrl: string;
}
/**
 * @stability stable
 */
export interface DnsManagedZonePeeringConfig {
    /**
     * target_network block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_managed_zone.html#target_network DnsManagedZone#target_network}
     *
     * @stability stable
     */
    readonly targetNetwork: DnsManagedZonePeeringConfigTargetNetwork[];
}
/**
 * @stability stable
 */
export interface DnsManagedZonePrivateVisibilityConfigNetworks {
    /**
     * The id or fully qualified URL of the VPC network to bind to. This should be formatted like 'projects/{project}/global/networks/{network}' or 'https://www.googleapis.com/compute/v1/projects/{project}/global/networks/{network}'.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_managed_zone.html#network_url DnsManagedZone#network_url}
     *
     * @stability stable
     */
    readonly networkUrl: string;
}
/**
 * @stability stable
 */
export interface DnsManagedZonePrivateVisibilityConfig {
    /**
     * networks block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_managed_zone.html#networks DnsManagedZone#networks}
     *
     * @stability stable
     */
    readonly networks: DnsManagedZonePrivateVisibilityConfigNetworks[];
}
/**
 * @stability stable
 */
export interface DnsManagedZoneTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_managed_zone.html#create DnsManagedZone#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_managed_zone.html#delete DnsManagedZone#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_managed_zone.html#update DnsManagedZone#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/dns_managed_zone.html google_dns_managed_zone}.
 *
 * @stability stable
 */
export declare class DnsManagedZone extends cdktf.TerraformResource {
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/dns_managed_zone.html google_dns_managed_zone} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DnsManagedZoneConfig);
    private _description?;
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    set description(value: string);
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    private _dnsName;
    /**
     * @stability stable
     */
    get dnsName(): string;
    /**
     * @stability stable
     */
    set dnsName(value: string);
    /**
     * @stability stable
     */
    get dnsNameInput(): string;
    private _forceDestroy?;
    /**
     * @stability stable
     */
    get forceDestroy(): boolean;
    /**
     * @stability stable
     */
    set forceDestroy(value: boolean);
    /**
     * @stability stable
     */
    resetForceDestroy(): void;
    /**
     * @stability stable
     */
    get forceDestroyInput(): boolean | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _labels?;
    /**
     * @stability stable
     */
    get labels(): {
        [key: string]: string;
    };
    /**
     * @stability stable
     */
    set labels(value: {
        [key: string]: string;
    });
    /**
     * @stability stable
     */
    resetLabels(): void;
    /**
     * @stability stable
     */
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _name;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string;
    /**
     * @stability stable
     */
    get nameServers(): string[];
    private _project?;
    /**
     * @stability stable
     */
    get project(): string;
    /**
     * @stability stable
     */
    set project(value: string);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    private _visibility?;
    /**
     * @stability stable
     */
    get visibility(): string;
    /**
     * @stability stable
     */
    set visibility(value: string);
    /**
     * @stability stable
     */
    resetVisibility(): void;
    /**
     * @stability stable
     */
    get visibilityInput(): string | undefined;
    private _dnssecConfig?;
    /**
     * @stability stable
     */
    get dnssecConfig(): DnsManagedZoneDnssecConfig[];
    /**
     * @stability stable
     */
    set dnssecConfig(value: DnsManagedZoneDnssecConfig[]);
    /**
     * @stability stable
     */
    resetDnssecConfig(): void;
    /**
     * @stability stable
     */
    get dnssecConfigInput(): DnsManagedZoneDnssecConfig[] | undefined;
    private _forwardingConfig?;
    /**
     * @stability stable
     */
    get forwardingConfig(): DnsManagedZoneForwardingConfig[];
    /**
     * @stability stable
     */
    set forwardingConfig(value: DnsManagedZoneForwardingConfig[]);
    /**
     * @stability stable
     */
    resetForwardingConfig(): void;
    /**
     * @stability stable
     */
    get forwardingConfigInput(): DnsManagedZoneForwardingConfig[] | undefined;
    private _peeringConfig?;
    /**
     * @stability stable
     */
    get peeringConfig(): DnsManagedZonePeeringConfig[];
    /**
     * @stability stable
     */
    set peeringConfig(value: DnsManagedZonePeeringConfig[]);
    /**
     * @stability stable
     */
    resetPeeringConfig(): void;
    /**
     * @stability stable
     */
    get peeringConfigInput(): DnsManagedZonePeeringConfig[] | undefined;
    private _privateVisibilityConfig?;
    /**
     * @stability stable
     */
    get privateVisibilityConfig(): DnsManagedZonePrivateVisibilityConfig[];
    /**
     * @stability stable
     */
    set privateVisibilityConfig(value: DnsManagedZonePrivateVisibilityConfig[]);
    /**
     * @stability stable
     */
    resetPrivateVisibilityConfig(): void;
    /**
     * @stability stable
     */
    get privateVisibilityConfigInput(): DnsManagedZonePrivateVisibilityConfig[] | undefined;
    private _timeouts?;
    /**
     * @stability stable
     */
    get timeouts(): DnsManagedZoneTimeouts;
    /**
     * @stability stable
     */
    set timeouts(value: DnsManagedZoneTimeouts);
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): DnsManagedZoneTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
