import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DnsRecordSetConfig extends cdktf.TerraformMetaArguments {
    /**
     * Identifies the managed zone addressed by this request.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_record_set.html#managed_zone DnsRecordSet#managed_zone}
     *
     * @stability stable
     */
    readonly managedZone: string;
    /**
     * For example, www.example.com.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_record_set.html#name DnsRecordSet#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_record_set.html#project DnsRecordSet#project}.
     *
     * @stability stable
     */
    readonly project?: string;
    /**
     * The string data for the records in this record set whose meaning depends on the DNS type.
     *
     * For TXT record, if the string data contains spaces, add surrounding \" if you don't want your string to get
     * split on spaces. To specify a single record value longer than 255 characters such as a TXT record for
     * DKIM, add \"\" inside the Terraform configuration string (e.g. "first255characters\"\"morecharacters").
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_record_set.html#rrdatas DnsRecordSet#rrdatas}
     *
     * @stability stable
     */
    readonly rrdatas?: string[];
    /**
     * Number of seconds that this ResourceRecordSet can be cached by resolvers.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_record_set.html#ttl DnsRecordSet#ttl}
     *
     * @stability stable
     */
    readonly ttl?: number;
    /**
     * One of valid DNS resource types.
     *
     * Possible values: ["A", "AAAA", "CAA", "CNAME", "DNSKEY", "DS", "IPSECVPNKEY", "MX", "NAPTR", "NS", "PTR", "SOA", "SPF", "SRV", "SSHFP", "TLSA", "TXT"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_record_set.html#type DnsRecordSet#type}
     *
     * @stability stable
     */
    readonly type: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_record_set.html#timeouts DnsRecordSet#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: DnsRecordSetTimeouts;
}
/**
 * @stability stable
 */
export interface DnsRecordSetTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_record_set.html#create DnsRecordSet#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_record_set.html#delete DnsRecordSet#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_record_set.html#update DnsRecordSet#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/dns_record_set.html google_dns_record_set}.
 *
 * @stability stable
 */
export declare class DnsRecordSet extends cdktf.TerraformResource {
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/dns_record_set.html google_dns_record_set} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DnsRecordSetConfig);
    /**
     * @stability stable
     */
    get id(): string;
    private _managedZone;
    /**
     * @stability stable
     */
    get managedZone(): string;
    /**
     * @stability stable
     */
    set managedZone(value: string);
    /**
     * @stability stable
     */
    get managedZoneInput(): string;
    private _name;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string;
    /**
     * @stability stable
     */
    set project(value: string);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    private _rrdatas?;
    /**
     * @stability stable
     */
    get rrdatas(): string[];
    /**
     * @stability stable
     */
    set rrdatas(value: string[]);
    /**
     * @stability stable
     */
    resetRrdatas(): void;
    /**
     * @stability stable
     */
    get rrdatasInput(): string[] | undefined;
    private _ttl?;
    /**
     * @stability stable
     */
    get ttl(): number;
    /**
     * @stability stable
     */
    set ttl(value: number);
    /**
     * @stability stable
     */
    resetTtl(): void;
    /**
     * @stability stable
     */
    get ttlInput(): number | undefined;
    private _type;
    /**
     * @stability stable
     */
    get type(): string;
    /**
     * @stability stable
     */
    set type(value: string);
    /**
     * @stability stable
     */
    get typeInput(): string;
    private _timeouts?;
    /**
     * @stability stable
     */
    get timeouts(): DnsRecordSetTimeouts;
    /**
     * @stability stable
     */
    set timeouts(value: DnsRecordSetTimeouts);
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): DnsRecordSetTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
