import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface EventarcTriggerConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/eventarc_trigger.html#labels EventarcTrigger#labels}.
     *
     * @stability stable
     */
    readonly labels?: {
        [key: string]: string;
    };
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/eventarc_trigger.html#location EventarcTrigger#location}.
     *
     * @stability stable
     */
    readonly location: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/eventarc_trigger.html#name EventarcTrigger#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/eventarc_trigger.html#project EventarcTrigger#project}.
     *
     * @stability stable
     */
    readonly project?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/eventarc_trigger.html#service_account EventarcTrigger#service_account}.
     *
     * @stability stable
     */
    readonly serviceAccount?: string;
    /**
     * destination block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/eventarc_trigger.html#destination EventarcTrigger#destination}
     *
     * @stability stable
     */
    readonly destination: EventarcTriggerDestination[];
    /**
     * matching_criteria block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/eventarc_trigger.html#matching_criteria EventarcTrigger#matching_criteria}
     *
     * @stability stable
     */
    readonly matchingCriteria: EventarcTriggerMatchingCriteria[];
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/eventarc_trigger.html#timeouts EventarcTrigger#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: EventarcTriggerTimeouts;
    /**
     * transport block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/eventarc_trigger.html#transport EventarcTrigger#transport}
     *
     * @stability stable
     */
    readonly transport?: EventarcTriggerTransport[];
}
/**
 * @stability stable
 */
export interface EventarcTriggerDestinationCloudRunService {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/eventarc_trigger.html#path EventarcTrigger#path}.
     *
     * @stability stable
     */
    readonly path?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/eventarc_trigger.html#region EventarcTrigger#region}.
     *
     * @stability stable
     */
    readonly region?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/eventarc_trigger.html#service EventarcTrigger#service}.
     *
     * @stability stable
     */
    readonly service: string;
}
/**
 * @stability stable
 */
export interface EventarcTriggerDestination {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/eventarc_trigger.html#cloud_function EventarcTrigger#cloud_function}.
     *
     * @stability stable
     */
    readonly cloudFunction?: string;
    /**
     * cloud_run_service block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/eventarc_trigger.html#cloud_run_service EventarcTrigger#cloud_run_service}
     *
     * @stability stable
     */
    readonly cloudRunService?: EventarcTriggerDestinationCloudRunService[];
}
/**
 * @stability stable
 */
export interface EventarcTriggerMatchingCriteria {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/eventarc_trigger.html#attribute EventarcTrigger#attribute}.
     *
     * @stability stable
     */
    readonly attribute: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/eventarc_trigger.html#value EventarcTrigger#value}.
     *
     * @stability stable
     */
    readonly value: string;
}
/**
 * @stability stable
 */
export interface EventarcTriggerTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/eventarc_trigger.html#create EventarcTrigger#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/eventarc_trigger.html#delete EventarcTrigger#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/eventarc_trigger.html#update EventarcTrigger#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
/**
 * @stability stable
 */
export interface EventarcTriggerTransportPubsub {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/eventarc_trigger.html#topic EventarcTrigger#topic}.
     *
     * @stability stable
     */
    readonly topic?: string;
}
/**
 * @stability stable
 */
export interface EventarcTriggerTransport {
    /**
     * pubsub block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/eventarc_trigger.html#pubsub EventarcTrigger#pubsub}
     *
     * @stability stable
     */
    readonly pubsub?: EventarcTriggerTransportPubsub[];
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/eventarc_trigger.html google_eventarc_trigger}.
 *
 * @stability stable
 */
export declare class EventarcTrigger extends cdktf.TerraformResource {
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/eventarc_trigger.html google_eventarc_trigger} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: EventarcTriggerConfig);
    /**
     * @stability stable
     */
    get createTime(): string;
    /**
     * @stability stable
     */
    get etag(): string;
    /**
     * @stability stable
     */
    get id(): string;
    private _labels?;
    /**
     * @stability stable
     */
    get labels(): {
        [key: string]: string;
    };
    /**
     * @stability stable
     */
    set labels(value: {
        [key: string]: string;
    });
    /**
     * @stability stable
     */
    resetLabels(): void;
    /**
     * @stability stable
     */
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _location;
    /**
     * @stability stable
     */
    get location(): string;
    /**
     * @stability stable
     */
    set location(value: string);
    /**
     * @stability stable
     */
    get locationInput(): string;
    private _name;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string;
    /**
     * @stability stable
     */
    set project(value: string);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    private _serviceAccount?;
    /**
     * @stability stable
     */
    get serviceAccount(): string;
    /**
     * @stability stable
     */
    set serviceAccount(value: string);
    /**
     * @stability stable
     */
    resetServiceAccount(): void;
    /**
     * @stability stable
     */
    get serviceAccountInput(): string | undefined;
    /**
     * @stability stable
     */
    get uid(): string;
    /**
     * @stability stable
     */
    get updateTime(): string;
    private _destination;
    /**
     * @stability stable
     */
    get destination(): EventarcTriggerDestination[];
    /**
     * @stability stable
     */
    set destination(value: EventarcTriggerDestination[]);
    /**
     * @stability stable
     */
    get destinationInput(): EventarcTriggerDestination[];
    private _matchingCriteria;
    /**
     * @stability stable
     */
    get matchingCriteria(): EventarcTriggerMatchingCriteria[];
    /**
     * @stability stable
     */
    set matchingCriteria(value: EventarcTriggerMatchingCriteria[]);
    /**
     * @stability stable
     */
    get matchingCriteriaInput(): EventarcTriggerMatchingCriteria[];
    private _timeouts?;
    /**
     * @stability stable
     */
    get timeouts(): EventarcTriggerTimeouts;
    /**
     * @stability stable
     */
    set timeouts(value: EventarcTriggerTimeouts);
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): EventarcTriggerTimeouts | undefined;
    private _transport?;
    /**
     * @stability stable
     */
    get transport(): EventarcTriggerTransport[];
    /**
     * @stability stable
     */
    set transport(value: EventarcTriggerTransport[]);
    /**
     * @stability stable
     */
    resetTransport(): void;
    /**
     * @stability stable
     */
    get transportInput(): EventarcTriggerTransport[] | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
