"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.GoogleProvider = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdktf = require("cdktf");
function googleProviderBatchingToTerraform(struct) {
    if (!cdktf.canInspect(struct)) {
        return struct;
    }
    return {
        enable_batching: cdktf.booleanToTerraform(struct.enableBatching),
        send_after: cdktf.stringToTerraform(struct.sendAfter),
    };
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google google}.
 *
 * @stability stable
 */
class GoogleProvider extends cdktf.TerraformProvider {
    // ===========
    // INITIALIZER
    // ===========
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google google} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope, id, config = {}) {
        super(scope, id, {
            terraformResourceType: 'google',
            terraformGeneratorMetadata: {
                providerName: 'google',
                providerVersionConstraint: '~> 3.0'
            },
            terraformProviderSource: 'google'
        });
        this._accessApprovalCustomEndpoint = config.accessApprovalCustomEndpoint;
        this._accessContextManagerCustomEndpoint = config.accessContextManagerCustomEndpoint;
        this._accessToken = config.accessToken;
        this._activeDirectoryCustomEndpoint = config.activeDirectoryCustomEndpoint;
        this._apigeeCustomEndpoint = config.apigeeCustomEndpoint;
        this._appEngineCustomEndpoint = config.appEngineCustomEndpoint;
        this._bigQueryCustomEndpoint = config.bigQueryCustomEndpoint;
        this._bigqueryDataTransferCustomEndpoint = config.bigqueryDataTransferCustomEndpoint;
        this._bigqueryReservationCustomEndpoint = config.bigqueryReservationCustomEndpoint;
        this._bigtableCustomEndpoint = config.bigtableCustomEndpoint;
        this._billingCustomEndpoint = config.billingCustomEndpoint;
        this._billingProject = config.billingProject;
        this._binaryAuthorizationCustomEndpoint = config.binaryAuthorizationCustomEndpoint;
        this._cloudAssetCustomEndpoint = config.cloudAssetCustomEndpoint;
        this._cloudBillingCustomEndpoint = config.cloudBillingCustomEndpoint;
        this._cloudBuildCustomEndpoint = config.cloudBuildCustomEndpoint;
        this._cloudFunctionsCustomEndpoint = config.cloudFunctionsCustomEndpoint;
        this._cloudIdentityCustomEndpoint = config.cloudIdentityCustomEndpoint;
        this._cloudIotCustomEndpoint = config.cloudIotCustomEndpoint;
        this._cloudRunCustomEndpoint = config.cloudRunCustomEndpoint;
        this._cloudSchedulerCustomEndpoint = config.cloudSchedulerCustomEndpoint;
        this._cloudTasksCustomEndpoint = config.cloudTasksCustomEndpoint;
        this._composerCustomEndpoint = config.composerCustomEndpoint;
        this._computeBetaCustomEndpoint = config.computeBetaCustomEndpoint;
        this._computeCustomEndpoint = config.computeCustomEndpoint;
        this._containerAnalysisCustomEndpoint = config.containerAnalysisCustomEndpoint;
        this._containerBetaCustomEndpoint = config.containerBetaCustomEndpoint;
        this._containerCustomEndpoint = config.containerCustomEndpoint;
        this._credentials = config.credentials;
        this._dataCatalogCustomEndpoint = config.dataCatalogCustomEndpoint;
        this._dataLossPreventionCustomEndpoint = config.dataLossPreventionCustomEndpoint;
        this._dataflowCustomEndpoint = config.dataflowCustomEndpoint;
        this._dataprocBetaCustomEndpoint = config.dataprocBetaCustomEndpoint;
        this._dataprocCustomEndpoint = config.dataprocCustomEndpoint;
        this._datastoreCustomEndpoint = config.datastoreCustomEndpoint;
        this._deploymentManagerCustomEndpoint = config.deploymentManagerCustomEndpoint;
        this._dialogflowCustomEndpoint = config.dialogflowCustomEndpoint;
        this._dnsCustomEndpoint = config.dnsCustomEndpoint;
        this._eventarcCustomEndpoint = config.eventarcCustomEndpoint;
        this._filestoreCustomEndpoint = config.filestoreCustomEndpoint;
        this._firestoreCustomEndpoint = config.firestoreCustomEndpoint;
        this._gameServicesCustomEndpoint = config.gameServicesCustomEndpoint;
        this._healthcareCustomEndpoint = config.healthcareCustomEndpoint;
        this._iamCredentialsCustomEndpoint = config.iamCredentialsCustomEndpoint;
        this._iamCustomEndpoint = config.iamCustomEndpoint;
        this._iapCustomEndpoint = config.iapCustomEndpoint;
        this._identityPlatformCustomEndpoint = config.identityPlatformCustomEndpoint;
        this._impersonateServiceAccount = config.impersonateServiceAccount;
        this._impersonateServiceAccountDelegates = config.impersonateServiceAccountDelegates;
        this._kmsCustomEndpoint = config.kmsCustomEndpoint;
        this._loggingCustomEndpoint = config.loggingCustomEndpoint;
        this._memcacheCustomEndpoint = config.memcacheCustomEndpoint;
        this._mlEngineCustomEndpoint = config.mlEngineCustomEndpoint;
        this._monitoringCustomEndpoint = config.monitoringCustomEndpoint;
        this._networkManagementCustomEndpoint = config.networkManagementCustomEndpoint;
        this._notebooksCustomEndpoint = config.notebooksCustomEndpoint;
        this._osConfigCustomEndpoint = config.osConfigCustomEndpoint;
        this._osLoginCustomEndpoint = config.osLoginCustomEndpoint;
        this._project = config.project;
        this._pubsubCustomEndpoint = config.pubsubCustomEndpoint;
        this._pubsubLiteCustomEndpoint = config.pubsubLiteCustomEndpoint;
        this._redisCustomEndpoint = config.redisCustomEndpoint;
        this._region = config.region;
        this._requestTimeout = config.requestTimeout;
        this._resourceManagerCustomEndpoint = config.resourceManagerCustomEndpoint;
        this._resourceManagerV2CustomEndpoint = config.resourceManagerV2CustomEndpoint;
        this._runtimeConfigCustomEndpoint = config.runtimeConfigCustomEndpoint;
        this._runtimeconfigCustomEndpoint = config.runtimeconfigCustomEndpoint;
        this._scopes = config.scopes;
        this._secretManagerCustomEndpoint = config.secretManagerCustomEndpoint;
        this._securityCenterCustomEndpoint = config.securityCenterCustomEndpoint;
        this._serviceManagementCustomEndpoint = config.serviceManagementCustomEndpoint;
        this._serviceNetworkingCustomEndpoint = config.serviceNetworkingCustomEndpoint;
        this._serviceUsageCustomEndpoint = config.serviceUsageCustomEndpoint;
        this._sourceRepoCustomEndpoint = config.sourceRepoCustomEndpoint;
        this._spannerCustomEndpoint = config.spannerCustomEndpoint;
        this._sqlCustomEndpoint = config.sqlCustomEndpoint;
        this._storageCustomEndpoint = config.storageCustomEndpoint;
        this._storageTransferCustomEndpoint = config.storageTransferCustomEndpoint;
        this._tagsCustomEndpoint = config.tagsCustomEndpoint;
        this._tpuCustomEndpoint = config.tpuCustomEndpoint;
        this._userProjectOverride = config.userProjectOverride;
        this._vpcAccessCustomEndpoint = config.vpcAccessCustomEndpoint;
        this._workflowsCustomEndpoint = config.workflowsCustomEndpoint;
        this._zone = config.zone;
        this._alias = config.alias;
        this._batching = config.batching;
    }
    /**
     * @stability stable
     */
    get accessApprovalCustomEndpoint() {
        return this._accessApprovalCustomEndpoint;
    }
    /**
     * @stability stable
     */
    set accessApprovalCustomEndpoint(value) {
        this._accessApprovalCustomEndpoint = value;
    }
    /**
     * @stability stable
     */
    resetAccessApprovalCustomEndpoint() {
        this._accessApprovalCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get accessApprovalCustomEndpointInput() {
        return this._accessApprovalCustomEndpoint;
    }
    /**
     * @stability stable
     */
    get accessContextManagerCustomEndpoint() {
        return this._accessContextManagerCustomEndpoint;
    }
    /**
     * @stability stable
     */
    set accessContextManagerCustomEndpoint(value) {
        this._accessContextManagerCustomEndpoint = value;
    }
    /**
     * @stability stable
     */
    resetAccessContextManagerCustomEndpoint() {
        this._accessContextManagerCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get accessContextManagerCustomEndpointInput() {
        return this._accessContextManagerCustomEndpoint;
    }
    /**
     * @stability stable
     */
    get accessToken() {
        return this._accessToken;
    }
    /**
     * @stability stable
     */
    set accessToken(value) {
        this._accessToken = value;
    }
    /**
     * @stability stable
     */
    resetAccessToken() {
        this._accessToken = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get accessTokenInput() {
        return this._accessToken;
    }
    /**
     * @stability stable
     */
    get activeDirectoryCustomEndpoint() {
        return this._activeDirectoryCustomEndpoint;
    }
    /**
     * @stability stable
     */
    set activeDirectoryCustomEndpoint(value) {
        this._activeDirectoryCustomEndpoint = value;
    }
    /**
     * @stability stable
     */
    resetActiveDirectoryCustomEndpoint() {
        this._activeDirectoryCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get activeDirectoryCustomEndpointInput() {
        return this._activeDirectoryCustomEndpoint;
    }
    /**
     * @stability stable
     */
    get apigeeCustomEndpoint() {
        return this._apigeeCustomEndpoint;
    }
    /**
     * @stability stable
     */
    set apigeeCustomEndpoint(value) {
        this._apigeeCustomEndpoint = value;
    }
    /**
     * @stability stable
     */
    resetApigeeCustomEndpoint() {
        this._apigeeCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get apigeeCustomEndpointInput() {
        return this._apigeeCustomEndpoint;
    }
    /**
     * @stability stable
     */
    get appEngineCustomEndpoint() {
        return this._appEngineCustomEndpoint;
    }
    /**
     * @stability stable
     */
    set appEngineCustomEndpoint(value) {
        this._appEngineCustomEndpoint = value;
    }
    /**
     * @stability stable
     */
    resetAppEngineCustomEndpoint() {
        this._appEngineCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get appEngineCustomEndpointInput() {
        return this._appEngineCustomEndpoint;
    }
    /**
     * @stability stable
     */
    get bigQueryCustomEndpoint() {
        return this._bigQueryCustomEndpoint;
    }
    /**
     * @stability stable
     */
    set bigQueryCustomEndpoint(value) {
        this._bigQueryCustomEndpoint = value;
    }
    /**
     * @stability stable
     */
    resetBigQueryCustomEndpoint() {
        this._bigQueryCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get bigQueryCustomEndpointInput() {
        return this._bigQueryCustomEndpoint;
    }
    /**
     * @stability stable
     */
    get bigqueryDataTransferCustomEndpoint() {
        return this._bigqueryDataTransferCustomEndpoint;
    }
    /**
     * @stability stable
     */
    set bigqueryDataTransferCustomEndpoint(value) {
        this._bigqueryDataTransferCustomEndpoint = value;
    }
    /**
     * @stability stable
     */
    resetBigqueryDataTransferCustomEndpoint() {
        this._bigqueryDataTransferCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get bigqueryDataTransferCustomEndpointInput() {
        return this._bigqueryDataTransferCustomEndpoint;
    }
    /**
     * @stability stable
     */
    get bigqueryReservationCustomEndpoint() {
        return this._bigqueryReservationCustomEndpoint;
    }
    /**
     * @stability stable
     */
    set bigqueryReservationCustomEndpoint(value) {
        this._bigqueryReservationCustomEndpoint = value;
    }
    /**
     * @stability stable
     */
    resetBigqueryReservationCustomEndpoint() {
        this._bigqueryReservationCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get bigqueryReservationCustomEndpointInput() {
        return this._bigqueryReservationCustomEndpoint;
    }
    /**
     * @stability stable
     */
    get bigtableCustomEndpoint() {
        return this._bigtableCustomEndpoint;
    }
    /**
     * @stability stable
     */
    set bigtableCustomEndpoint(value) {
        this._bigtableCustomEndpoint = value;
    }
    /**
     * @stability stable
     */
    resetBigtableCustomEndpoint() {
        this._bigtableCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get bigtableCustomEndpointInput() {
        return this._bigtableCustomEndpoint;
    }
    /**
     * @stability stable
     */
    get billingCustomEndpoint() {
        return this._billingCustomEndpoint;
    }
    /**
     * @stability stable
     */
    set billingCustomEndpoint(value) {
        this._billingCustomEndpoint = value;
    }
    /**
     * @stability stable
     */
    resetBillingCustomEndpoint() {
        this._billingCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get billingCustomEndpointInput() {
        return this._billingCustomEndpoint;
    }
    /**
     * @stability stable
     */
    get billingProject() {
        return this._billingProject;
    }
    /**
     * @stability stable
     */
    set billingProject(value) {
        this._billingProject = value;
    }
    /**
     * @stability stable
     */
    resetBillingProject() {
        this._billingProject = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get billingProjectInput() {
        return this._billingProject;
    }
    /**
     * @stability stable
     */
    get binaryAuthorizationCustomEndpoint() {
        return this._binaryAuthorizationCustomEndpoint;
    }
    /**
     * @stability stable
     */
    set binaryAuthorizationCustomEndpoint(value) {
        this._binaryAuthorizationCustomEndpoint = value;
    }
    /**
     * @stability stable
     */
    resetBinaryAuthorizationCustomEndpoint() {
        this._binaryAuthorizationCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get binaryAuthorizationCustomEndpointInput() {
        return this._binaryAuthorizationCustomEndpoint;
    }
    /**
     * @stability stable
     */
    get cloudAssetCustomEndpoint() {
        return this._cloudAssetCustomEndpoint;
    }
    /**
     * @stability stable
     */
    set cloudAssetCustomEndpoint(value) {
        this._cloudAssetCustomEndpoint = value;
    }
    /**
     * @stability stable
     */
    resetCloudAssetCustomEndpoint() {
        this._cloudAssetCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get cloudAssetCustomEndpointInput() {
        return this._cloudAssetCustomEndpoint;
    }
    /**
     * @stability stable
     */
    get cloudBillingCustomEndpoint() {
        return this._cloudBillingCustomEndpoint;
    }
    /**
     * @stability stable
     */
    set cloudBillingCustomEndpoint(value) {
        this._cloudBillingCustomEndpoint = value;
    }
    /**
     * @stability stable
     */
    resetCloudBillingCustomEndpoint() {
        this._cloudBillingCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get cloudBillingCustomEndpointInput() {
        return this._cloudBillingCustomEndpoint;
    }
    /**
     * @stability stable
     */
    get cloudBuildCustomEndpoint() {
        return this._cloudBuildCustomEndpoint;
    }
    /**
     * @stability stable
     */
    set cloudBuildCustomEndpoint(value) {
        this._cloudBuildCustomEndpoint = value;
    }
    /**
     * @stability stable
     */
    resetCloudBuildCustomEndpoint() {
        this._cloudBuildCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get cloudBuildCustomEndpointInput() {
        return this._cloudBuildCustomEndpoint;
    }
    /**
     * @stability stable
     */
    get cloudFunctionsCustomEndpoint() {
        return this._cloudFunctionsCustomEndpoint;
    }
    /**
     * @stability stable
     */
    set cloudFunctionsCustomEndpoint(value) {
        this._cloudFunctionsCustomEndpoint = value;
    }
    /**
     * @stability stable
     */
    resetCloudFunctionsCustomEndpoint() {
        this._cloudFunctionsCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get cloudFunctionsCustomEndpointInput() {
        return this._cloudFunctionsCustomEndpoint;
    }
    /**
     * @stability stable
     */
    get cloudIdentityCustomEndpoint() {
        return this._cloudIdentityCustomEndpoint;
    }
    /**
     * @stability stable
     */
    set cloudIdentityCustomEndpoint(value) {
        this._cloudIdentityCustomEndpoint = value;
    }
    /**
     * @stability stable
     */
    resetCloudIdentityCustomEndpoint() {
        this._cloudIdentityCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get cloudIdentityCustomEndpointInput() {
        return this._cloudIdentityCustomEndpoint;
    }
    /**
     * @stability stable
     */
    get cloudIotCustomEndpoint() {
        return this._cloudIotCustomEndpoint;
    }
    /**
     * @stability stable
     */
    set cloudIotCustomEndpoint(value) {
        this._cloudIotCustomEndpoint = value;
    }
    /**
     * @stability stable
     */
    resetCloudIotCustomEndpoint() {
        this._cloudIotCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get cloudIotCustomEndpointInput() {
        return this._cloudIotCustomEndpoint;
    }
    /**
     * @stability stable
     */
    get cloudRunCustomEndpoint() {
        return this._cloudRunCustomEndpoint;
    }
    /**
     * @stability stable
     */
    set cloudRunCustomEndpoint(value) {
        this._cloudRunCustomEndpoint = value;
    }
    /**
     * @stability stable
     */
    resetCloudRunCustomEndpoint() {
        this._cloudRunCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get cloudRunCustomEndpointInput() {
        return this._cloudRunCustomEndpoint;
    }
    /**
     * @stability stable
     */
    get cloudSchedulerCustomEndpoint() {
        return this._cloudSchedulerCustomEndpoint;
    }
    /**
     * @stability stable
     */
    set cloudSchedulerCustomEndpoint(value) {
        this._cloudSchedulerCustomEndpoint = value;
    }
    /**
     * @stability stable
     */
    resetCloudSchedulerCustomEndpoint() {
        this._cloudSchedulerCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get cloudSchedulerCustomEndpointInput() {
        return this._cloudSchedulerCustomEndpoint;
    }
    /**
     * @stability stable
     */
    get cloudTasksCustomEndpoint() {
        return this._cloudTasksCustomEndpoint;
    }
    /**
     * @stability stable
     */
    set cloudTasksCustomEndpoint(value) {
        this._cloudTasksCustomEndpoint = value;
    }
    /**
     * @stability stable
     */
    resetCloudTasksCustomEndpoint() {
        this._cloudTasksCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get cloudTasksCustomEndpointInput() {
        return this._cloudTasksCustomEndpoint;
    }
    /**
     * @stability stable
     */
    get composerCustomEndpoint() {
        return this._composerCustomEndpoint;
    }
    /**
     * @stability stable
     */
    set composerCustomEndpoint(value) {
        this._composerCustomEndpoint = value;
    }
    /**
     * @stability stable
     */
    resetComposerCustomEndpoint() {
        this._composerCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get composerCustomEndpointInput() {
        return this._composerCustomEndpoint;
    }
    /**
     * @stability stable
     */
    get computeBetaCustomEndpoint() {
        return this._computeBetaCustomEndpoint;
    }
    /**
     * @stability stable
     */
    set computeBetaCustomEndpoint(value) {
        this._computeBetaCustomEndpoint = value;
    }
    /**
     * @stability stable
     */
    resetComputeBetaCustomEndpoint() {
        this._computeBetaCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get computeBetaCustomEndpointInput() {
        return this._computeBetaCustomEndpoint;
    }
    /**
     * @stability stable
     */
    get computeCustomEndpoint() {
        return this._computeCustomEndpoint;
    }
    /**
     * @stability stable
     */
    set computeCustomEndpoint(value) {
        this._computeCustomEndpoint = value;
    }
    /**
     * @stability stable
     */
    resetComputeCustomEndpoint() {
        this._computeCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get computeCustomEndpointInput() {
        return this._computeCustomEndpoint;
    }
    /**
     * @stability stable
     */
    get containerAnalysisCustomEndpoint() {
        return this._containerAnalysisCustomEndpoint;
    }
    /**
     * @stability stable
     */
    set containerAnalysisCustomEndpoint(value) {
        this._containerAnalysisCustomEndpoint = value;
    }
    /**
     * @stability stable
     */
    resetContainerAnalysisCustomEndpoint() {
        this._containerAnalysisCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get containerAnalysisCustomEndpointInput() {
        return this._containerAnalysisCustomEndpoint;
    }
    /**
     * @stability stable
     */
    get containerBetaCustomEndpoint() {
        return this._containerBetaCustomEndpoint;
    }
    /**
     * @stability stable
     */
    set containerBetaCustomEndpoint(value) {
        this._containerBetaCustomEndpoint = value;
    }
    /**
     * @stability stable
     */
    resetContainerBetaCustomEndpoint() {
        this._containerBetaCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get containerBetaCustomEndpointInput() {
        return this._containerBetaCustomEndpoint;
    }
    /**
     * @stability stable
     */
    get containerCustomEndpoint() {
        return this._containerCustomEndpoint;
    }
    /**
     * @stability stable
     */
    set containerCustomEndpoint(value) {
        this._containerCustomEndpoint = value;
    }
    /**
     * @stability stable
     */
    resetContainerCustomEndpoint() {
        this._containerCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get containerCustomEndpointInput() {
        return this._containerCustomEndpoint;
    }
    /**
     * @stability stable
     */
    get credentials() {
        return this._credentials;
    }
    /**
     * @stability stable
     */
    set credentials(value) {
        this._credentials = value;
    }
    /**
     * @stability stable
     */
    resetCredentials() {
        this._credentials = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get credentialsInput() {
        return this._credentials;
    }
    /**
     * @stability stable
     */
    get dataCatalogCustomEndpoint() {
        return this._dataCatalogCustomEndpoint;
    }
    /**
     * @stability stable
     */
    set dataCatalogCustomEndpoint(value) {
        this._dataCatalogCustomEndpoint = value;
    }
    /**
     * @stability stable
     */
    resetDataCatalogCustomEndpoint() {
        this._dataCatalogCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get dataCatalogCustomEndpointInput() {
        return this._dataCatalogCustomEndpoint;
    }
    /**
     * @stability stable
     */
    get dataLossPreventionCustomEndpoint() {
        return this._dataLossPreventionCustomEndpoint;
    }
    /**
     * @stability stable
     */
    set dataLossPreventionCustomEndpoint(value) {
        this._dataLossPreventionCustomEndpoint = value;
    }
    /**
     * @stability stable
     */
    resetDataLossPreventionCustomEndpoint() {
        this._dataLossPreventionCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get dataLossPreventionCustomEndpointInput() {
        return this._dataLossPreventionCustomEndpoint;
    }
    /**
     * @stability stable
     */
    get dataflowCustomEndpoint() {
        return this._dataflowCustomEndpoint;
    }
    /**
     * @stability stable
     */
    set dataflowCustomEndpoint(value) {
        this._dataflowCustomEndpoint = value;
    }
    /**
     * @stability stable
     */
    resetDataflowCustomEndpoint() {
        this._dataflowCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get dataflowCustomEndpointInput() {
        return this._dataflowCustomEndpoint;
    }
    /**
     * @stability stable
     */
    get dataprocBetaCustomEndpoint() {
        return this._dataprocBetaCustomEndpoint;
    }
    /**
     * @stability stable
     */
    set dataprocBetaCustomEndpoint(value) {
        this._dataprocBetaCustomEndpoint = value;
    }
    /**
     * @stability stable
     */
    resetDataprocBetaCustomEndpoint() {
        this._dataprocBetaCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get dataprocBetaCustomEndpointInput() {
        return this._dataprocBetaCustomEndpoint;
    }
    /**
     * @stability stable
     */
    get dataprocCustomEndpoint() {
        return this._dataprocCustomEndpoint;
    }
    /**
     * @stability stable
     */
    set dataprocCustomEndpoint(value) {
        this._dataprocCustomEndpoint = value;
    }
    /**
     * @stability stable
     */
    resetDataprocCustomEndpoint() {
        this._dataprocCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get dataprocCustomEndpointInput() {
        return this._dataprocCustomEndpoint;
    }
    /**
     * @stability stable
     */
    get datastoreCustomEndpoint() {
        return this._datastoreCustomEndpoint;
    }
    /**
     * @stability stable
     */
    set datastoreCustomEndpoint(value) {
        this._datastoreCustomEndpoint = value;
    }
    /**
     * @stability stable
     */
    resetDatastoreCustomEndpoint() {
        this._datastoreCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get datastoreCustomEndpointInput() {
        return this._datastoreCustomEndpoint;
    }
    /**
     * @stability stable
     */
    get deploymentManagerCustomEndpoint() {
        return this._deploymentManagerCustomEndpoint;
    }
    /**
     * @stability stable
     */
    set deploymentManagerCustomEndpoint(value) {
        this._deploymentManagerCustomEndpoint = value;
    }
    /**
     * @stability stable
     */
    resetDeploymentManagerCustomEndpoint() {
        this._deploymentManagerCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get deploymentManagerCustomEndpointInput() {
        return this._deploymentManagerCustomEndpoint;
    }
    /**
     * @stability stable
     */
    get dialogflowCustomEndpoint() {
        return this._dialogflowCustomEndpoint;
    }
    /**
     * @stability stable
     */
    set dialogflowCustomEndpoint(value) {
        this._dialogflowCustomEndpoint = value;
    }
    /**
     * @stability stable
     */
    resetDialogflowCustomEndpoint() {
        this._dialogflowCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get dialogflowCustomEndpointInput() {
        return this._dialogflowCustomEndpoint;
    }
    /**
     * @stability stable
     */
    get dnsCustomEndpoint() {
        return this._dnsCustomEndpoint;
    }
    /**
     * @stability stable
     */
    set dnsCustomEndpoint(value) {
        this._dnsCustomEndpoint = value;
    }
    /**
     * @stability stable
     */
    resetDnsCustomEndpoint() {
        this._dnsCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get dnsCustomEndpointInput() {
        return this._dnsCustomEndpoint;
    }
    /**
     * @stability stable
     */
    get eventarcCustomEndpoint() {
        return this._eventarcCustomEndpoint;
    }
    /**
     * @stability stable
     */
    set eventarcCustomEndpoint(value) {
        this._eventarcCustomEndpoint = value;
    }
    /**
     * @stability stable
     */
    resetEventarcCustomEndpoint() {
        this._eventarcCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get eventarcCustomEndpointInput() {
        return this._eventarcCustomEndpoint;
    }
    /**
     * @stability stable
     */
    get filestoreCustomEndpoint() {
        return this._filestoreCustomEndpoint;
    }
    /**
     * @stability stable
     */
    set filestoreCustomEndpoint(value) {
        this._filestoreCustomEndpoint = value;
    }
    /**
     * @stability stable
     */
    resetFilestoreCustomEndpoint() {
        this._filestoreCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get filestoreCustomEndpointInput() {
        return this._filestoreCustomEndpoint;
    }
    /**
     * @stability stable
     */
    get firestoreCustomEndpoint() {
        return this._firestoreCustomEndpoint;
    }
    /**
     * @stability stable
     */
    set firestoreCustomEndpoint(value) {
        this._firestoreCustomEndpoint = value;
    }
    /**
     * @stability stable
     */
    resetFirestoreCustomEndpoint() {
        this._firestoreCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get firestoreCustomEndpointInput() {
        return this._firestoreCustomEndpoint;
    }
    /**
     * @stability stable
     */
    get gameServicesCustomEndpoint() {
        return this._gameServicesCustomEndpoint;
    }
    /**
     * @stability stable
     */
    set gameServicesCustomEndpoint(value) {
        this._gameServicesCustomEndpoint = value;
    }
    /**
     * @stability stable
     */
    resetGameServicesCustomEndpoint() {
        this._gameServicesCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get gameServicesCustomEndpointInput() {
        return this._gameServicesCustomEndpoint;
    }
    /**
     * @stability stable
     */
    get healthcareCustomEndpoint() {
        return this._healthcareCustomEndpoint;
    }
    /**
     * @stability stable
     */
    set healthcareCustomEndpoint(value) {
        this._healthcareCustomEndpoint = value;
    }
    /**
     * @stability stable
     */
    resetHealthcareCustomEndpoint() {
        this._healthcareCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get healthcareCustomEndpointInput() {
        return this._healthcareCustomEndpoint;
    }
    /**
     * @stability stable
     */
    get iamCredentialsCustomEndpoint() {
        return this._iamCredentialsCustomEndpoint;
    }
    /**
     * @stability stable
     */
    set iamCredentialsCustomEndpoint(value) {
        this._iamCredentialsCustomEndpoint = value;
    }
    /**
     * @stability stable
     */
    resetIamCredentialsCustomEndpoint() {
        this._iamCredentialsCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get iamCredentialsCustomEndpointInput() {
        return this._iamCredentialsCustomEndpoint;
    }
    /**
     * @stability stable
     */
    get iamCustomEndpoint() {
        return this._iamCustomEndpoint;
    }
    /**
     * @stability stable
     */
    set iamCustomEndpoint(value) {
        this._iamCustomEndpoint = value;
    }
    /**
     * @stability stable
     */
    resetIamCustomEndpoint() {
        this._iamCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get iamCustomEndpointInput() {
        return this._iamCustomEndpoint;
    }
    /**
     * @stability stable
     */
    get iapCustomEndpoint() {
        return this._iapCustomEndpoint;
    }
    /**
     * @stability stable
     */
    set iapCustomEndpoint(value) {
        this._iapCustomEndpoint = value;
    }
    /**
     * @stability stable
     */
    resetIapCustomEndpoint() {
        this._iapCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get iapCustomEndpointInput() {
        return this._iapCustomEndpoint;
    }
    /**
     * @stability stable
     */
    get identityPlatformCustomEndpoint() {
        return this._identityPlatformCustomEndpoint;
    }
    /**
     * @stability stable
     */
    set identityPlatformCustomEndpoint(value) {
        this._identityPlatformCustomEndpoint = value;
    }
    /**
     * @stability stable
     */
    resetIdentityPlatformCustomEndpoint() {
        this._identityPlatformCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get identityPlatformCustomEndpointInput() {
        return this._identityPlatformCustomEndpoint;
    }
    /**
     * @stability stable
     */
    get impersonateServiceAccount() {
        return this._impersonateServiceAccount;
    }
    /**
     * @stability stable
     */
    set impersonateServiceAccount(value) {
        this._impersonateServiceAccount = value;
    }
    /**
     * @stability stable
     */
    resetImpersonateServiceAccount() {
        this._impersonateServiceAccount = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get impersonateServiceAccountInput() {
        return this._impersonateServiceAccount;
    }
    /**
     * @stability stable
     */
    get impersonateServiceAccountDelegates() {
        return this._impersonateServiceAccountDelegates;
    }
    /**
     * @stability stable
     */
    set impersonateServiceAccountDelegates(value) {
        this._impersonateServiceAccountDelegates = value;
    }
    /**
     * @stability stable
     */
    resetImpersonateServiceAccountDelegates() {
        this._impersonateServiceAccountDelegates = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get impersonateServiceAccountDelegatesInput() {
        return this._impersonateServiceAccountDelegates;
    }
    /**
     * @stability stable
     */
    get kmsCustomEndpoint() {
        return this._kmsCustomEndpoint;
    }
    /**
     * @stability stable
     */
    set kmsCustomEndpoint(value) {
        this._kmsCustomEndpoint = value;
    }
    /**
     * @stability stable
     */
    resetKmsCustomEndpoint() {
        this._kmsCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get kmsCustomEndpointInput() {
        return this._kmsCustomEndpoint;
    }
    /**
     * @stability stable
     */
    get loggingCustomEndpoint() {
        return this._loggingCustomEndpoint;
    }
    /**
     * @stability stable
     */
    set loggingCustomEndpoint(value) {
        this._loggingCustomEndpoint = value;
    }
    /**
     * @stability stable
     */
    resetLoggingCustomEndpoint() {
        this._loggingCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get loggingCustomEndpointInput() {
        return this._loggingCustomEndpoint;
    }
    /**
     * @stability stable
     */
    get memcacheCustomEndpoint() {
        return this._memcacheCustomEndpoint;
    }
    /**
     * @stability stable
     */
    set memcacheCustomEndpoint(value) {
        this._memcacheCustomEndpoint = value;
    }
    /**
     * @stability stable
     */
    resetMemcacheCustomEndpoint() {
        this._memcacheCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get memcacheCustomEndpointInput() {
        return this._memcacheCustomEndpoint;
    }
    /**
     * @stability stable
     */
    get mlEngineCustomEndpoint() {
        return this._mlEngineCustomEndpoint;
    }
    /**
     * @stability stable
     */
    set mlEngineCustomEndpoint(value) {
        this._mlEngineCustomEndpoint = value;
    }
    /**
     * @stability stable
     */
    resetMlEngineCustomEndpoint() {
        this._mlEngineCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get mlEngineCustomEndpointInput() {
        return this._mlEngineCustomEndpoint;
    }
    /**
     * @stability stable
     */
    get monitoringCustomEndpoint() {
        return this._monitoringCustomEndpoint;
    }
    /**
     * @stability stable
     */
    set monitoringCustomEndpoint(value) {
        this._monitoringCustomEndpoint = value;
    }
    /**
     * @stability stable
     */
    resetMonitoringCustomEndpoint() {
        this._monitoringCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get monitoringCustomEndpointInput() {
        return this._monitoringCustomEndpoint;
    }
    /**
     * @stability stable
     */
    get networkManagementCustomEndpoint() {
        return this._networkManagementCustomEndpoint;
    }
    /**
     * @stability stable
     */
    set networkManagementCustomEndpoint(value) {
        this._networkManagementCustomEndpoint = value;
    }
    /**
     * @stability stable
     */
    resetNetworkManagementCustomEndpoint() {
        this._networkManagementCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get networkManagementCustomEndpointInput() {
        return this._networkManagementCustomEndpoint;
    }
    /**
     * @stability stable
     */
    get notebooksCustomEndpoint() {
        return this._notebooksCustomEndpoint;
    }
    /**
     * @stability stable
     */
    set notebooksCustomEndpoint(value) {
        this._notebooksCustomEndpoint = value;
    }
    /**
     * @stability stable
     */
    resetNotebooksCustomEndpoint() {
        this._notebooksCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get notebooksCustomEndpointInput() {
        return this._notebooksCustomEndpoint;
    }
    /**
     * @stability stable
     */
    get osConfigCustomEndpoint() {
        return this._osConfigCustomEndpoint;
    }
    /**
     * @stability stable
     */
    set osConfigCustomEndpoint(value) {
        this._osConfigCustomEndpoint = value;
    }
    /**
     * @stability stable
     */
    resetOsConfigCustomEndpoint() {
        this._osConfigCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get osConfigCustomEndpointInput() {
        return this._osConfigCustomEndpoint;
    }
    /**
     * @stability stable
     */
    get osLoginCustomEndpoint() {
        return this._osLoginCustomEndpoint;
    }
    /**
     * @stability stable
     */
    set osLoginCustomEndpoint(value) {
        this._osLoginCustomEndpoint = value;
    }
    /**
     * @stability stable
     */
    resetOsLoginCustomEndpoint() {
        this._osLoginCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get osLoginCustomEndpointInput() {
        return this._osLoginCustomEndpoint;
    }
    /**
     * @stability stable
     */
    get project() {
        return this._project;
    }
    /**
     * @stability stable
     */
    set project(value) {
        this._project = value;
    }
    /**
     * @stability stable
     */
    resetProject() {
        this._project = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get projectInput() {
        return this._project;
    }
    /**
     * @stability stable
     */
    get pubsubCustomEndpoint() {
        return this._pubsubCustomEndpoint;
    }
    /**
     * @stability stable
     */
    set pubsubCustomEndpoint(value) {
        this._pubsubCustomEndpoint = value;
    }
    /**
     * @stability stable
     */
    resetPubsubCustomEndpoint() {
        this._pubsubCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get pubsubCustomEndpointInput() {
        return this._pubsubCustomEndpoint;
    }
    /**
     * @stability stable
     */
    get pubsubLiteCustomEndpoint() {
        return this._pubsubLiteCustomEndpoint;
    }
    /**
     * @stability stable
     */
    set pubsubLiteCustomEndpoint(value) {
        this._pubsubLiteCustomEndpoint = value;
    }
    /**
     * @stability stable
     */
    resetPubsubLiteCustomEndpoint() {
        this._pubsubLiteCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get pubsubLiteCustomEndpointInput() {
        return this._pubsubLiteCustomEndpoint;
    }
    /**
     * @stability stable
     */
    get redisCustomEndpoint() {
        return this._redisCustomEndpoint;
    }
    /**
     * @stability stable
     */
    set redisCustomEndpoint(value) {
        this._redisCustomEndpoint = value;
    }
    /**
     * @stability stable
     */
    resetRedisCustomEndpoint() {
        this._redisCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get redisCustomEndpointInput() {
        return this._redisCustomEndpoint;
    }
    /**
     * @stability stable
     */
    get region() {
        return this._region;
    }
    /**
     * @stability stable
     */
    set region(value) {
        this._region = value;
    }
    /**
     * @stability stable
     */
    resetRegion() {
        this._region = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get regionInput() {
        return this._region;
    }
    /**
     * @stability stable
     */
    get requestTimeout() {
        return this._requestTimeout;
    }
    /**
     * @stability stable
     */
    set requestTimeout(value) {
        this._requestTimeout = value;
    }
    /**
     * @stability stable
     */
    resetRequestTimeout() {
        this._requestTimeout = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get requestTimeoutInput() {
        return this._requestTimeout;
    }
    /**
     * @stability stable
     */
    get resourceManagerCustomEndpoint() {
        return this._resourceManagerCustomEndpoint;
    }
    /**
     * @stability stable
     */
    set resourceManagerCustomEndpoint(value) {
        this._resourceManagerCustomEndpoint = value;
    }
    /**
     * @stability stable
     */
    resetResourceManagerCustomEndpoint() {
        this._resourceManagerCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get resourceManagerCustomEndpointInput() {
        return this._resourceManagerCustomEndpoint;
    }
    /**
     * @stability stable
     */
    get resourceManagerV2CustomEndpoint() {
        return this._resourceManagerV2CustomEndpoint;
    }
    /**
     * @stability stable
     */
    set resourceManagerV2CustomEndpoint(value) {
        this._resourceManagerV2CustomEndpoint = value;
    }
    /**
     * @stability stable
     */
    resetResourceManagerV2CustomEndpoint() {
        this._resourceManagerV2CustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get resourceManagerV2CustomEndpointInput() {
        return this._resourceManagerV2CustomEndpoint;
    }
    /**
     * @stability stable
     */
    get runtimeConfigCustomEndpoint() {
        return this._runtimeConfigCustomEndpoint;
    }
    /**
     * @stability stable
     */
    set runtimeConfigCustomEndpoint(value) {
        this._runtimeConfigCustomEndpoint = value;
    }
    /**
     * @stability stable
     */
    resetRuntimeConfigCustomEndpoint() {
        this._runtimeConfigCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get runtimeConfigCustomEndpointInput() {
        return this._runtimeConfigCustomEndpoint;
    }
    /**
     * @stability stable
     */
    get runtimeconfigCustomEndpoint() {
        return this._runtimeconfigCustomEndpoint;
    }
    /**
     * @stability stable
     */
    set runtimeconfigCustomEndpoint(value) {
        this._runtimeconfigCustomEndpoint = value;
    }
    /**
     * @stability stable
     */
    resetRuntimeconfigCustomEndpoint() {
        this._runtimeconfigCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get runtimeconfigCustomEndpointInput() {
        return this._runtimeconfigCustomEndpoint;
    }
    /**
     * @stability stable
     */
    get scopes() {
        return this._scopes;
    }
    /**
     * @stability stable
     */
    set scopes(value) {
        this._scopes = value;
    }
    /**
     * @stability stable
     */
    resetScopes() {
        this._scopes = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get scopesInput() {
        return this._scopes;
    }
    /**
     * @stability stable
     */
    get secretManagerCustomEndpoint() {
        return this._secretManagerCustomEndpoint;
    }
    /**
     * @stability stable
     */
    set secretManagerCustomEndpoint(value) {
        this._secretManagerCustomEndpoint = value;
    }
    /**
     * @stability stable
     */
    resetSecretManagerCustomEndpoint() {
        this._secretManagerCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get secretManagerCustomEndpointInput() {
        return this._secretManagerCustomEndpoint;
    }
    /**
     * @stability stable
     */
    get securityCenterCustomEndpoint() {
        return this._securityCenterCustomEndpoint;
    }
    /**
     * @stability stable
     */
    set securityCenterCustomEndpoint(value) {
        this._securityCenterCustomEndpoint = value;
    }
    /**
     * @stability stable
     */
    resetSecurityCenterCustomEndpoint() {
        this._securityCenterCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get securityCenterCustomEndpointInput() {
        return this._securityCenterCustomEndpoint;
    }
    /**
     * @stability stable
     */
    get serviceManagementCustomEndpoint() {
        return this._serviceManagementCustomEndpoint;
    }
    /**
     * @stability stable
     */
    set serviceManagementCustomEndpoint(value) {
        this._serviceManagementCustomEndpoint = value;
    }
    /**
     * @stability stable
     */
    resetServiceManagementCustomEndpoint() {
        this._serviceManagementCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get serviceManagementCustomEndpointInput() {
        return this._serviceManagementCustomEndpoint;
    }
    /**
     * @stability stable
     */
    get serviceNetworkingCustomEndpoint() {
        return this._serviceNetworkingCustomEndpoint;
    }
    /**
     * @stability stable
     */
    set serviceNetworkingCustomEndpoint(value) {
        this._serviceNetworkingCustomEndpoint = value;
    }
    /**
     * @stability stable
     */
    resetServiceNetworkingCustomEndpoint() {
        this._serviceNetworkingCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get serviceNetworkingCustomEndpointInput() {
        return this._serviceNetworkingCustomEndpoint;
    }
    /**
     * @stability stable
     */
    get serviceUsageCustomEndpoint() {
        return this._serviceUsageCustomEndpoint;
    }
    /**
     * @stability stable
     */
    set serviceUsageCustomEndpoint(value) {
        this._serviceUsageCustomEndpoint = value;
    }
    /**
     * @stability stable
     */
    resetServiceUsageCustomEndpoint() {
        this._serviceUsageCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get serviceUsageCustomEndpointInput() {
        return this._serviceUsageCustomEndpoint;
    }
    /**
     * @stability stable
     */
    get sourceRepoCustomEndpoint() {
        return this._sourceRepoCustomEndpoint;
    }
    /**
     * @stability stable
     */
    set sourceRepoCustomEndpoint(value) {
        this._sourceRepoCustomEndpoint = value;
    }
    /**
     * @stability stable
     */
    resetSourceRepoCustomEndpoint() {
        this._sourceRepoCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get sourceRepoCustomEndpointInput() {
        return this._sourceRepoCustomEndpoint;
    }
    /**
     * @stability stable
     */
    get spannerCustomEndpoint() {
        return this._spannerCustomEndpoint;
    }
    /**
     * @stability stable
     */
    set spannerCustomEndpoint(value) {
        this._spannerCustomEndpoint = value;
    }
    /**
     * @stability stable
     */
    resetSpannerCustomEndpoint() {
        this._spannerCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get spannerCustomEndpointInput() {
        return this._spannerCustomEndpoint;
    }
    /**
     * @stability stable
     */
    get sqlCustomEndpoint() {
        return this._sqlCustomEndpoint;
    }
    /**
     * @stability stable
     */
    set sqlCustomEndpoint(value) {
        this._sqlCustomEndpoint = value;
    }
    /**
     * @stability stable
     */
    resetSqlCustomEndpoint() {
        this._sqlCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get sqlCustomEndpointInput() {
        return this._sqlCustomEndpoint;
    }
    /**
     * @stability stable
     */
    get storageCustomEndpoint() {
        return this._storageCustomEndpoint;
    }
    /**
     * @stability stable
     */
    set storageCustomEndpoint(value) {
        this._storageCustomEndpoint = value;
    }
    /**
     * @stability stable
     */
    resetStorageCustomEndpoint() {
        this._storageCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get storageCustomEndpointInput() {
        return this._storageCustomEndpoint;
    }
    /**
     * @stability stable
     */
    get storageTransferCustomEndpoint() {
        return this._storageTransferCustomEndpoint;
    }
    /**
     * @stability stable
     */
    set storageTransferCustomEndpoint(value) {
        this._storageTransferCustomEndpoint = value;
    }
    /**
     * @stability stable
     */
    resetStorageTransferCustomEndpoint() {
        this._storageTransferCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get storageTransferCustomEndpointInput() {
        return this._storageTransferCustomEndpoint;
    }
    /**
     * @stability stable
     */
    get tagsCustomEndpoint() {
        return this._tagsCustomEndpoint;
    }
    /**
     * @stability stable
     */
    set tagsCustomEndpoint(value) {
        this._tagsCustomEndpoint = value;
    }
    /**
     * @stability stable
     */
    resetTagsCustomEndpoint() {
        this._tagsCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get tagsCustomEndpointInput() {
        return this._tagsCustomEndpoint;
    }
    /**
     * @stability stable
     */
    get tpuCustomEndpoint() {
        return this._tpuCustomEndpoint;
    }
    /**
     * @stability stable
     */
    set tpuCustomEndpoint(value) {
        this._tpuCustomEndpoint = value;
    }
    /**
     * @stability stable
     */
    resetTpuCustomEndpoint() {
        this._tpuCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get tpuCustomEndpointInput() {
        return this._tpuCustomEndpoint;
    }
    /**
     * @stability stable
     */
    get userProjectOverride() {
        return this._userProjectOverride;
    }
    /**
     * @stability stable
     */
    set userProjectOverride(value) {
        this._userProjectOverride = value;
    }
    /**
     * @stability stable
     */
    resetUserProjectOverride() {
        this._userProjectOverride = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get userProjectOverrideInput() {
        return this._userProjectOverride;
    }
    /**
     * @stability stable
     */
    get vpcAccessCustomEndpoint() {
        return this._vpcAccessCustomEndpoint;
    }
    /**
     * @stability stable
     */
    set vpcAccessCustomEndpoint(value) {
        this._vpcAccessCustomEndpoint = value;
    }
    /**
     * @stability stable
     */
    resetVpcAccessCustomEndpoint() {
        this._vpcAccessCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get vpcAccessCustomEndpointInput() {
        return this._vpcAccessCustomEndpoint;
    }
    /**
     * @stability stable
     */
    get workflowsCustomEndpoint() {
        return this._workflowsCustomEndpoint;
    }
    /**
     * @stability stable
     */
    set workflowsCustomEndpoint(value) {
        this._workflowsCustomEndpoint = value;
    }
    /**
     * @stability stable
     */
    resetWorkflowsCustomEndpoint() {
        this._workflowsCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get workflowsCustomEndpointInput() {
        return this._workflowsCustomEndpoint;
    }
    /**
     * @stability stable
     */
    get zone() {
        return this._zone;
    }
    /**
     * @stability stable
     */
    set zone(value) {
        this._zone = value;
    }
    /**
     * @stability stable
     */
    resetZone() {
        this._zone = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get zoneInput() {
        return this._zone;
    }
    /**
     * @stability stable
     */
    get alias() {
        return this._alias;
    }
    /**
     * @stability stable
     */
    set alias(value) {
        this._alias = value;
    }
    /**
     * @stability stable
     */
    resetAlias() {
        this._alias = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get aliasInput() {
        return this._alias;
    }
    /**
     * @stability stable
     */
    get batching() {
        return this._batching;
    }
    /**
     * @stability stable
     */
    set batching(value) {
        this._batching = value;
    }
    /**
     * @stability stable
     */
    resetBatching() {
        this._batching = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get batchingInput() {
        return this._batching;
    }
    // =========
    // SYNTHESIS
    // =========
    /**
     * @stability stable
     */
    synthesizeAttributes() {
        return {
            access_approval_custom_endpoint: cdktf.stringToTerraform(this._accessApprovalCustomEndpoint),
            access_context_manager_custom_endpoint: cdktf.stringToTerraform(this._accessContextManagerCustomEndpoint),
            access_token: cdktf.stringToTerraform(this._accessToken),
            active_directory_custom_endpoint: cdktf.stringToTerraform(this._activeDirectoryCustomEndpoint),
            apigee_custom_endpoint: cdktf.stringToTerraform(this._apigeeCustomEndpoint),
            app_engine_custom_endpoint: cdktf.stringToTerraform(this._appEngineCustomEndpoint),
            big_query_custom_endpoint: cdktf.stringToTerraform(this._bigQueryCustomEndpoint),
            bigquery_data_transfer_custom_endpoint: cdktf.stringToTerraform(this._bigqueryDataTransferCustomEndpoint),
            bigquery_reservation_custom_endpoint: cdktf.stringToTerraform(this._bigqueryReservationCustomEndpoint),
            bigtable_custom_endpoint: cdktf.stringToTerraform(this._bigtableCustomEndpoint),
            billing_custom_endpoint: cdktf.stringToTerraform(this._billingCustomEndpoint),
            billing_project: cdktf.stringToTerraform(this._billingProject),
            binary_authorization_custom_endpoint: cdktf.stringToTerraform(this._binaryAuthorizationCustomEndpoint),
            cloud_asset_custom_endpoint: cdktf.stringToTerraform(this._cloudAssetCustomEndpoint),
            cloud_billing_custom_endpoint: cdktf.stringToTerraform(this._cloudBillingCustomEndpoint),
            cloud_build_custom_endpoint: cdktf.stringToTerraform(this._cloudBuildCustomEndpoint),
            cloud_functions_custom_endpoint: cdktf.stringToTerraform(this._cloudFunctionsCustomEndpoint),
            cloud_identity_custom_endpoint: cdktf.stringToTerraform(this._cloudIdentityCustomEndpoint),
            cloud_iot_custom_endpoint: cdktf.stringToTerraform(this._cloudIotCustomEndpoint),
            cloud_run_custom_endpoint: cdktf.stringToTerraform(this._cloudRunCustomEndpoint),
            cloud_scheduler_custom_endpoint: cdktf.stringToTerraform(this._cloudSchedulerCustomEndpoint),
            cloud_tasks_custom_endpoint: cdktf.stringToTerraform(this._cloudTasksCustomEndpoint),
            composer_custom_endpoint: cdktf.stringToTerraform(this._composerCustomEndpoint),
            compute_beta_custom_endpoint: cdktf.stringToTerraform(this._computeBetaCustomEndpoint),
            compute_custom_endpoint: cdktf.stringToTerraform(this._computeCustomEndpoint),
            container_analysis_custom_endpoint: cdktf.stringToTerraform(this._containerAnalysisCustomEndpoint),
            container_beta_custom_endpoint: cdktf.stringToTerraform(this._containerBetaCustomEndpoint),
            container_custom_endpoint: cdktf.stringToTerraform(this._containerCustomEndpoint),
            credentials: cdktf.stringToTerraform(this._credentials),
            data_catalog_custom_endpoint: cdktf.stringToTerraform(this._dataCatalogCustomEndpoint),
            data_loss_prevention_custom_endpoint: cdktf.stringToTerraform(this._dataLossPreventionCustomEndpoint),
            dataflow_custom_endpoint: cdktf.stringToTerraform(this._dataflowCustomEndpoint),
            dataproc_beta_custom_endpoint: cdktf.stringToTerraform(this._dataprocBetaCustomEndpoint),
            dataproc_custom_endpoint: cdktf.stringToTerraform(this._dataprocCustomEndpoint),
            datastore_custom_endpoint: cdktf.stringToTerraform(this._datastoreCustomEndpoint),
            deployment_manager_custom_endpoint: cdktf.stringToTerraform(this._deploymentManagerCustomEndpoint),
            dialogflow_custom_endpoint: cdktf.stringToTerraform(this._dialogflowCustomEndpoint),
            dns_custom_endpoint: cdktf.stringToTerraform(this._dnsCustomEndpoint),
            eventarc_custom_endpoint: cdktf.stringToTerraform(this._eventarcCustomEndpoint),
            filestore_custom_endpoint: cdktf.stringToTerraform(this._filestoreCustomEndpoint),
            firestore_custom_endpoint: cdktf.stringToTerraform(this._firestoreCustomEndpoint),
            game_services_custom_endpoint: cdktf.stringToTerraform(this._gameServicesCustomEndpoint),
            healthcare_custom_endpoint: cdktf.stringToTerraform(this._healthcareCustomEndpoint),
            iam_credentials_custom_endpoint: cdktf.stringToTerraform(this._iamCredentialsCustomEndpoint),
            iam_custom_endpoint: cdktf.stringToTerraform(this._iamCustomEndpoint),
            iap_custom_endpoint: cdktf.stringToTerraform(this._iapCustomEndpoint),
            identity_platform_custom_endpoint: cdktf.stringToTerraform(this._identityPlatformCustomEndpoint),
            impersonate_service_account: cdktf.stringToTerraform(this._impersonateServiceAccount),
            impersonate_service_account_delegates: cdktf.listMapper(cdktf.stringToTerraform)(this._impersonateServiceAccountDelegates),
            kms_custom_endpoint: cdktf.stringToTerraform(this._kmsCustomEndpoint),
            logging_custom_endpoint: cdktf.stringToTerraform(this._loggingCustomEndpoint),
            memcache_custom_endpoint: cdktf.stringToTerraform(this._memcacheCustomEndpoint),
            ml_engine_custom_endpoint: cdktf.stringToTerraform(this._mlEngineCustomEndpoint),
            monitoring_custom_endpoint: cdktf.stringToTerraform(this._monitoringCustomEndpoint),
            network_management_custom_endpoint: cdktf.stringToTerraform(this._networkManagementCustomEndpoint),
            notebooks_custom_endpoint: cdktf.stringToTerraform(this._notebooksCustomEndpoint),
            os_config_custom_endpoint: cdktf.stringToTerraform(this._osConfigCustomEndpoint),
            os_login_custom_endpoint: cdktf.stringToTerraform(this._osLoginCustomEndpoint),
            project: cdktf.stringToTerraform(this._project),
            pubsub_custom_endpoint: cdktf.stringToTerraform(this._pubsubCustomEndpoint),
            pubsub_lite_custom_endpoint: cdktf.stringToTerraform(this._pubsubLiteCustomEndpoint),
            redis_custom_endpoint: cdktf.stringToTerraform(this._redisCustomEndpoint),
            region: cdktf.stringToTerraform(this._region),
            request_timeout: cdktf.stringToTerraform(this._requestTimeout),
            resource_manager_custom_endpoint: cdktf.stringToTerraform(this._resourceManagerCustomEndpoint),
            resource_manager_v2_custom_endpoint: cdktf.stringToTerraform(this._resourceManagerV2CustomEndpoint),
            runtime_config_custom_endpoint: cdktf.stringToTerraform(this._runtimeConfigCustomEndpoint),
            runtimeconfig_custom_endpoint: cdktf.stringToTerraform(this._runtimeconfigCustomEndpoint),
            scopes: cdktf.listMapper(cdktf.stringToTerraform)(this._scopes),
            secret_manager_custom_endpoint: cdktf.stringToTerraform(this._secretManagerCustomEndpoint),
            security_center_custom_endpoint: cdktf.stringToTerraform(this._securityCenterCustomEndpoint),
            service_management_custom_endpoint: cdktf.stringToTerraform(this._serviceManagementCustomEndpoint),
            service_networking_custom_endpoint: cdktf.stringToTerraform(this._serviceNetworkingCustomEndpoint),
            service_usage_custom_endpoint: cdktf.stringToTerraform(this._serviceUsageCustomEndpoint),
            source_repo_custom_endpoint: cdktf.stringToTerraform(this._sourceRepoCustomEndpoint),
            spanner_custom_endpoint: cdktf.stringToTerraform(this._spannerCustomEndpoint),
            sql_custom_endpoint: cdktf.stringToTerraform(this._sqlCustomEndpoint),
            storage_custom_endpoint: cdktf.stringToTerraform(this._storageCustomEndpoint),
            storage_transfer_custom_endpoint: cdktf.stringToTerraform(this._storageTransferCustomEndpoint),
            tags_custom_endpoint: cdktf.stringToTerraform(this._tagsCustomEndpoint),
            tpu_custom_endpoint: cdktf.stringToTerraform(this._tpuCustomEndpoint),
            user_project_override: cdktf.booleanToTerraform(this._userProjectOverride),
            vpc_access_custom_endpoint: cdktf.stringToTerraform(this._vpcAccessCustomEndpoint),
            workflows_custom_endpoint: cdktf.stringToTerraform(this._workflowsCustomEndpoint),
            zone: cdktf.stringToTerraform(this._zone),
            alias: cdktf.stringToTerraform(this._alias),
            batching: cdktf.listMapper(googleProviderBatchingToTerraform)(this._batching),
        };
    }
}
exports.GoogleProvider = GoogleProvider;
_a = JSII_RTTI_SYMBOL_1;
GoogleProvider[_a] = { fqn: "@cdktf/provider-google.GoogleProvider", version: "0.2.43" };
//# sourceMappingURL=data:application/json;base64,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