import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface HealthcareFhirStoreIamPolicyConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/healthcare_fhir_store_iam_policy.html#fhir_store_id HealthcareFhirStoreIamPolicy#fhir_store_id}.
     *
     * @stability stable
     */
    readonly fhirStoreId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/healthcare_fhir_store_iam_policy.html#policy_data HealthcareFhirStoreIamPolicy#policy_data}.
     *
     * @stability stable
     */
    readonly policyData: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/healthcare_fhir_store_iam_policy.html google_healthcare_fhir_store_iam_policy}.
 *
 * @stability stable
 */
export declare class HealthcareFhirStoreIamPolicy extends cdktf.TerraformResource {
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/healthcare_fhir_store_iam_policy.html google_healthcare_fhir_store_iam_policy} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: HealthcareFhirStoreIamPolicyConfig);
    /**
     * @stability stable
     */
    get etag(): string;
    private _fhirStoreId;
    /**
     * @stability stable
     */
    get fhirStoreId(): string;
    /**
     * @stability stable
     */
    set fhirStoreId(value: string);
    /**
     * @stability stable
     */
    get fhirStoreIdInput(): string;
    /**
     * @stability stable
     */
    get id(): string;
    private _policyData;
    /**
     * @stability stable
     */
    get policyData(): string;
    /**
     * @stability stable
     */
    set policyData(value: string);
    /**
     * @stability stable
     */
    get policyDataInput(): string;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
