import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface IapClientConfig extends cdktf.TerraformMetaArguments {
    /**
     * Identifier of the brand to which this client is attached to. The format is 'projects/{project_number}/brands/{brand_id}/identityAwareProxyClients/{client_id}'.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/iap_client.html#brand IapClient#brand}
     *
     * @stability stable
     */
    readonly brand: string;
    /**
     * Human-friendly name given to the OAuth client.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/iap_client.html#display_name IapClient#display_name}
     *
     * @stability stable
     */
    readonly displayName: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/iap_client.html#timeouts IapClient#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: IapClientTimeouts;
}
/**
 * @stability stable
 */
export interface IapClientTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/iap_client.html#create IapClient#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/iap_client.html#delete IapClient#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/iap_client.html google_iap_client}.
 *
 * @stability stable
 */
export declare class IapClient extends cdktf.TerraformResource {
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/iap_client.html google_iap_client} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: IapClientConfig);
    private _brand;
    /**
     * @stability stable
     */
    get brand(): string;
    /**
     * @stability stable
     */
    set brand(value: string);
    /**
     * @stability stable
     */
    get brandInput(): string;
    /**
     * @stability stable
     */
    get clientId(): string;
    private _displayName;
    /**
     * @stability stable
     */
    get displayName(): string;
    /**
     * @stability stable
     */
    set displayName(value: string);
    /**
     * @stability stable
     */
    get displayNameInput(): string;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get secret(): string;
    private _timeouts?;
    /**
     * @stability stable
     */
    get timeouts(): IapClientTimeouts;
    /**
     * @stability stable
     */
    set timeouts(value: IapClientTimeouts);
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): IapClientTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
