import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface IapTunnelInstanceIamMemberConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/iap_tunnel_instance_iam_member.html#instance IapTunnelInstanceIamMember#instance}.
     *
     * @stability stable
     */
    readonly instance: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/iap_tunnel_instance_iam_member.html#member IapTunnelInstanceIamMember#member}.
     *
     * @stability stable
     */
    readonly member: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/iap_tunnel_instance_iam_member.html#project IapTunnelInstanceIamMember#project}.
     *
     * @stability stable
     */
    readonly project?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/iap_tunnel_instance_iam_member.html#role IapTunnelInstanceIamMember#role}.
     *
     * @stability stable
     */
    readonly role: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/iap_tunnel_instance_iam_member.html#zone IapTunnelInstanceIamMember#zone}.
     *
     * @stability stable
     */
    readonly zone?: string;
    /**
     * condition block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/iap_tunnel_instance_iam_member.html#condition IapTunnelInstanceIamMember#condition}
     *
     * @stability stable
     */
    readonly condition?: IapTunnelInstanceIamMemberCondition[];
}
/**
 * @stability stable
 */
export interface IapTunnelInstanceIamMemberCondition {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/iap_tunnel_instance_iam_member.html#description IapTunnelInstanceIamMember#description}.
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/iap_tunnel_instance_iam_member.html#expression IapTunnelInstanceIamMember#expression}.
     *
     * @stability stable
     */
    readonly expression: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/iap_tunnel_instance_iam_member.html#title IapTunnelInstanceIamMember#title}.
     *
     * @stability stable
     */
    readonly title: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/iap_tunnel_instance_iam_member.html google_iap_tunnel_instance_iam_member}.
 *
 * @stability stable
 */
export declare class IapTunnelInstanceIamMember extends cdktf.TerraformResource {
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/iap_tunnel_instance_iam_member.html google_iap_tunnel_instance_iam_member} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: IapTunnelInstanceIamMemberConfig);
    /**
     * @stability stable
     */
    get etag(): string;
    /**
     * @stability stable
     */
    get id(): string;
    private _instance;
    /**
     * @stability stable
     */
    get instance(): string;
    /**
     * @stability stable
     */
    set instance(value: string);
    /**
     * @stability stable
     */
    get instanceInput(): string;
    private _member;
    /**
     * @stability stable
     */
    get member(): string;
    /**
     * @stability stable
     */
    set member(value: string);
    /**
     * @stability stable
     */
    get memberInput(): string;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string;
    /**
     * @stability stable
     */
    set project(value: string);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    private _role;
    /**
     * @stability stable
     */
    get role(): string;
    /**
     * @stability stable
     */
    set role(value: string);
    /**
     * @stability stable
     */
    get roleInput(): string;
    private _zone?;
    /**
     * @stability stable
     */
    get zone(): string;
    /**
     * @stability stable
     */
    set zone(value: string);
    /**
     * @stability stable
     */
    resetZone(): void;
    /**
     * @stability stable
     */
    get zoneInput(): string | undefined;
    private _condition?;
    /**
     * @stability stable
     */
    get condition(): IapTunnelInstanceIamMemberCondition[];
    /**
     * @stability stable
     */
    set condition(value: IapTunnelInstanceIamMemberCondition[]);
    /**
     * @stability stable
     */
    resetCondition(): void;
    /**
     * @stability stable
     */
    get conditionInput(): IapTunnelInstanceIamMemberCondition[] | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
