import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface IdentityPlatformDefaultSupportedIdpConfigConfig extends cdktf.TerraformMetaArguments {
    /**
     * OAuth client ID.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/identity_platform_default_supported_idp_config.html#client_id IdentityPlatformDefaultSupportedIdpConfig#client_id}
     *
     * @stability stable
     */
    readonly clientId: string;
    /**
     * OAuth client secret.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/identity_platform_default_supported_idp_config.html#client_secret IdentityPlatformDefaultSupportedIdpConfig#client_secret}
     *
     * @stability stable
     */
    readonly clientSecret: string;
    /**
     * If this IDP allows the user to sign in.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/identity_platform_default_supported_idp_config.html#enabled IdentityPlatformDefaultSupportedIdpConfig#enabled}
     *
     * @stability stable
     */
    readonly enabled?: boolean;
    /**
     * ID of the IDP. Possible values include:.
     *
     * 'apple.com'
     *
     * 'facebook.com'
     *
     * 'gc.apple.com'
     *
     * 'github.com'
     *
     * 'google.com'
     *
     * 'linkedin.com'
     *
     * 'microsoft.com'
     *
     * 'playgames.google.com'
     *
     * 'twitter.com'
     *
     * 'yahoo.com'
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/identity_platform_default_supported_idp_config.html#idp_id IdentityPlatformDefaultSupportedIdpConfig#idp_id}
     *
     * @stability stable
     */
    readonly idpId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/identity_platform_default_supported_idp_config.html#project IdentityPlatformDefaultSupportedIdpConfig#project}.
     *
     * @stability stable
     */
    readonly project?: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/identity_platform_default_supported_idp_config.html#timeouts IdentityPlatformDefaultSupportedIdpConfig#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: IdentityPlatformDefaultSupportedIdpConfigTimeouts;
}
/**
 * @stability stable
 */
export interface IdentityPlatformDefaultSupportedIdpConfigTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/identity_platform_default_supported_idp_config.html#create IdentityPlatformDefaultSupportedIdpConfig#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/identity_platform_default_supported_idp_config.html#delete IdentityPlatformDefaultSupportedIdpConfig#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/identity_platform_default_supported_idp_config.html#update IdentityPlatformDefaultSupportedIdpConfig#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/identity_platform_default_supported_idp_config.html google_identity_platform_default_supported_idp_config}.
 *
 * @stability stable
 */
export declare class IdentityPlatformDefaultSupportedIdpConfig extends cdktf.TerraformResource {
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/identity_platform_default_supported_idp_config.html google_identity_platform_default_supported_idp_config} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: IdentityPlatformDefaultSupportedIdpConfigConfig);
    private _clientId;
    /**
     * @stability stable
     */
    get clientId(): string;
    /**
     * @stability stable
     */
    set clientId(value: string);
    /**
     * @stability stable
     */
    get clientIdInput(): string;
    private _clientSecret;
    /**
     * @stability stable
     */
    get clientSecret(): string;
    /**
     * @stability stable
     */
    set clientSecret(value: string);
    /**
     * @stability stable
     */
    get clientSecretInput(): string;
    private _enabled?;
    /**
     * @stability stable
     */
    get enabled(): boolean;
    /**
     * @stability stable
     */
    set enabled(value: boolean);
    /**
     * @stability stable
     */
    resetEnabled(): void;
    /**
     * @stability stable
     */
    get enabledInput(): boolean | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _idpId;
    /**
     * @stability stable
     */
    get idpId(): string;
    /**
     * @stability stable
     */
    set idpId(value: string);
    /**
     * @stability stable
     */
    get idpIdInput(): string;
    /**
     * @stability stable
     */
    get name(): string;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string;
    /**
     * @stability stable
     */
    set project(value: string);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    private _timeouts?;
    /**
     * @stability stable
     */
    get timeouts(): IdentityPlatformDefaultSupportedIdpConfigTimeouts;
    /**
     * @stability stable
     */
    set timeouts(value: IdentityPlatformDefaultSupportedIdpConfigTimeouts);
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): IdentityPlatformDefaultSupportedIdpConfigTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
